// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: worker.proto

package moby_buildkit_v1_types

import (
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	pb "github.com/moby/buildkit/solver/pb"
	io "io"
	math "math"
	math_bits "math/bits"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type WorkerRecord struct {
	ID              string            `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	Labels          map[string]string `protobuf:"bytes,2,rep,name=Labels,proto3" json:"Labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Platforms       []pb.Platform     `protobuf:"bytes,3,rep,name=platforms,proto3" json:"platforms"`
	GCPolicy        []*GCPolicy       `protobuf:"bytes,4,rep,name=GCPolicy,proto3" json:"GCPolicy,omitempty"`
	BuildkitVersion *BuildkitVersion  `protobuf:"bytes,5,opt,name=BuildkitVersion,proto3" json:"BuildkitVersion,omitempty"`
	// Earthly-specific.
	ParallelismCurrent   int64        `protobuf:"varint,101,opt,name=parallelismCurrent,proto3" json:"parallelismCurrent,omitempty"`
	ParallelismMax       int64        `protobuf:"varint,102,opt,name=parallelismMax,proto3" json:"parallelismMax,omitempty"`
	ParallelismWaiting   int64        `protobuf:"varint,103,opt,name=parallelismWaiting,proto3" json:"parallelismWaiting,omitempty"`
	GCAnalytics          *GCAnalytics `protobuf:"bytes,104,opt,name=GCAnalytics,proto3" json:"GCAnalytics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *WorkerRecord) Reset()         { *m = WorkerRecord{} }
func (m *WorkerRecord) String() string { return proto.CompactTextString(m) }
func (*WorkerRecord) ProtoMessage()    {}
func (*WorkerRecord) Descriptor() ([]byte, []int) {
	return fileDescriptor_e4ff6184b07e587a, []int{0}
}
func (m *WorkerRecord) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *WorkerRecord) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_WorkerRecord.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *WorkerRecord) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WorkerRecord.Merge(m, src)
}
func (m *WorkerRecord) XXX_Size() int {
	return m.Size()
}
func (m *WorkerRecord) XXX_DiscardUnknown() {
	xxx_messageInfo_WorkerRecord.DiscardUnknown(m)
}

var xxx_messageInfo_WorkerRecord proto.InternalMessageInfo

func (m *WorkerRecord) GetID() string {
	if m != nil {
		return m.ID
	}
	return ""
}

func (m *WorkerRecord) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *WorkerRecord) GetPlatforms() []pb.Platform {
	if m != nil {
		return m.Platforms
	}
	return nil
}

func (m *WorkerRecord) GetGCPolicy() []*GCPolicy {
	if m != nil {
		return m.GCPolicy
	}
	return nil
}

func (m *WorkerRecord) GetBuildkitVersion() *BuildkitVersion {
	if m != nil {
		return m.BuildkitVersion
	}
	return nil
}

func (m *WorkerRecord) GetParallelismCurrent() int64 {
	if m != nil {
		return m.ParallelismCurrent
	}
	return 0
}

func (m *WorkerRecord) GetParallelismMax() int64 {
	if m != nil {
		return m.ParallelismMax
	}
	return 0
}

func (m *WorkerRecord) GetParallelismWaiting() int64 {
	if m != nil {
		return m.ParallelismWaiting
	}
	return 0
}

func (m *WorkerRecord) GetGCAnalytics() *GCAnalytics {
	if m != nil {
		return m.GCAnalytics
	}
	return nil
}

type GCAnalytics struct {
	// Summary of last numRuns.
	NumRuns           int64 `protobuf:"varint,1,opt,name=numRuns,proto3" json:"numRuns,omitempty"`
	NumFailures       int64 `protobuf:"varint,2,opt,name=numFailures,proto3" json:"numFailures,omitempty"`
	AvgDurationMs     int64 `protobuf:"varint,3,opt,name=avgDurationMs,proto3" json:"avgDurationMs,omitempty"`
	AvgRecordsCleared int64 `protobuf:"varint,4,opt,name=avgRecordsCleared,proto3" json:"avgRecordsCleared,omitempty"`
	AvgSizeCleared    int64 `protobuf:"varint,5,opt,name=avgSizeCleared,proto3" json:"avgSizeCleared,omitempty"`
	AvgRecordsBefore  int64 `protobuf:"varint,6,opt,name=avgRecordsBefore,proto3" json:"avgRecordsBefore,omitempty"`
	AvgSizeBefore     int64 `protobuf:"varint,7,opt,name=avgSizeBefore,proto3" json:"avgSizeBefore,omitempty"`
	// All-time summary.
	AllTimeRuns          int64 `protobuf:"varint,8,opt,name=allTimeRuns,proto3" json:"allTimeRuns,omitempty"`
	AllTimeMaxDurationMs int64 `protobuf:"varint,9,opt,name=allTimeMaxDurationMs,proto3" json:"allTimeMaxDurationMs,omitempty"`
	AllTimeDurationMs    int64 `protobuf:"varint,10,opt,name=allTimeDurationMs,proto3" json:"allTimeDurationMs,omitempty"`
	// Current run (if one is ongoing).
	CurrentStartTimeSecEpoch int64 `protobuf:"varint,11,opt,name=currentStartTimeSecEpoch,proto3" json:"currentStartTimeSecEpoch,omitempty"`
	CurrentNumRecordsBefore  int64 `protobuf:"varint,12,opt,name=currentNumRecordsBefore,proto3" json:"currentNumRecordsBefore,omitempty"`
	CurrentSizeBefore        int64 `protobuf:"varint,13,opt,name=currentSizeBefore,proto3" json:"currentSizeBefore,omitempty"`
	// Last run.
	LastStartTimeSecEpoch int64    `protobuf:"varint,14,opt,name=lastStartTimeSecEpoch,proto3" json:"lastStartTimeSecEpoch,omitempty"`
	LastEndTimeSecEpoch   int64    `protobuf:"varint,15,opt,name=lastEndTimeSecEpoch,proto3" json:"lastEndTimeSecEpoch,omitempty"`
	LastNumRecordsBefore  int64    `protobuf:"varint,16,opt,name=lastNumRecordsBefore,proto3" json:"lastNumRecordsBefore,omitempty"`
	LastSizeBefore        int64    `protobuf:"varint,17,opt,name=lastSizeBefore,proto3" json:"lastSizeBefore,omitempty"`
	LastNumRecordsCleared int64    `protobuf:"varint,18,opt,name=lastNumRecordsCleared,proto3" json:"lastNumRecordsCleared,omitempty"`
	LastSizeCleared       int64    `protobuf:"varint,19,opt,name=lastSizeCleared,proto3" json:"lastSizeCleared,omitempty"`
	LastSuccess           bool     `protobuf:"varint,20,opt,name=lastSuccess,proto3" json:"lastSuccess,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *GCAnalytics) Reset()         { *m = GCAnalytics{} }
func (m *GCAnalytics) String() string { return proto.CompactTextString(m) }
func (*GCAnalytics) ProtoMessage()    {}
func (*GCAnalytics) Descriptor() ([]byte, []int) {
	return fileDescriptor_e4ff6184b07e587a, []int{1}
}
func (m *GCAnalytics) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GCAnalytics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GCAnalytics.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GCAnalytics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GCAnalytics.Merge(m, src)
}
func (m *GCAnalytics) XXX_Size() int {
	return m.Size()
}
func (m *GCAnalytics) XXX_DiscardUnknown() {
	xxx_messageInfo_GCAnalytics.DiscardUnknown(m)
}

var xxx_messageInfo_GCAnalytics proto.InternalMessageInfo

func (m *GCAnalytics) GetNumRuns() int64 {
	if m != nil {
		return m.NumRuns
	}
	return 0
}

func (m *GCAnalytics) GetNumFailures() int64 {
	if m != nil {
		return m.NumFailures
	}
	return 0
}

func (m *GCAnalytics) GetAvgDurationMs() int64 {
	if m != nil {
		return m.AvgDurationMs
	}
	return 0
}

func (m *GCAnalytics) GetAvgRecordsCleared() int64 {
	if m != nil {
		return m.AvgRecordsCleared
	}
	return 0
}

func (m *GCAnalytics) GetAvgSizeCleared() int64 {
	if m != nil {
		return m.AvgSizeCleared
	}
	return 0
}

func (m *GCAnalytics) GetAvgRecordsBefore() int64 {
	if m != nil {
		return m.AvgRecordsBefore
	}
	return 0
}

func (m *GCAnalytics) GetAvgSizeBefore() int64 {
	if m != nil {
		return m.AvgSizeBefore
	}
	return 0
}

func (m *GCAnalytics) GetAllTimeRuns() int64 {
	if m != nil {
		return m.AllTimeRuns
	}
	return 0
}

func (m *GCAnalytics) GetAllTimeMaxDurationMs() int64 {
	if m != nil {
		return m.AllTimeMaxDurationMs
	}
	return 0
}

func (m *GCAnalytics) GetAllTimeDurationMs() int64 {
	if m != nil {
		return m.AllTimeDurationMs
	}
	return 0
}

func (m *GCAnalytics) GetCurrentStartTimeSecEpoch() int64 {
	if m != nil {
		return m.CurrentStartTimeSecEpoch
	}
	return 0
}

func (m *GCAnalytics) GetCurrentNumRecordsBefore() int64 {
	if m != nil {
		return m.CurrentNumRecordsBefore
	}
	return 0
}

func (m *GCAnalytics) GetCurrentSizeBefore() int64 {
	if m != nil {
		return m.CurrentSizeBefore
	}
	return 0
}

func (m *GCAnalytics) GetLastStartTimeSecEpoch() int64 {
	if m != nil {
		return m.LastStartTimeSecEpoch
	}
	return 0
}

func (m *GCAnalytics) GetLastEndTimeSecEpoch() int64 {
	if m != nil {
		return m.LastEndTimeSecEpoch
	}
	return 0
}

func (m *GCAnalytics) GetLastNumRecordsBefore() int64 {
	if m != nil {
		return m.LastNumRecordsBefore
	}
	return 0
}

func (m *GCAnalytics) GetLastSizeBefore() int64 {
	if m != nil {
		return m.LastSizeBefore
	}
	return 0
}

func (m *GCAnalytics) GetLastNumRecordsCleared() int64 {
	if m != nil {
		return m.LastNumRecordsCleared
	}
	return 0
}

func (m *GCAnalytics) GetLastSizeCleared() int64 {
	if m != nil {
		return m.LastSizeCleared
	}
	return 0
}

func (m *GCAnalytics) GetLastSuccess() bool {
	if m != nil {
		return m.LastSuccess
	}
	return false
}

type GCPolicy struct {
	All                  bool     `protobuf:"varint,1,opt,name=all,proto3" json:"all,omitempty"`
	KeepDuration         int64    `protobuf:"varint,2,opt,name=keepDuration,proto3" json:"keepDuration,omitempty"`
	KeepBytes            int64    `protobuf:"varint,3,opt,name=keepBytes,proto3" json:"keepBytes,omitempty"`
	Filters              []string `protobuf:"bytes,4,rep,name=filters,proto3" json:"filters,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GCPolicy) Reset()         { *m = GCPolicy{} }
func (m *GCPolicy) String() string { return proto.CompactTextString(m) }
func (*GCPolicy) ProtoMessage()    {}
func (*GCPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_e4ff6184b07e587a, []int{2}
}
func (m *GCPolicy) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GCPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GCPolicy.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GCPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GCPolicy.Merge(m, src)
}
func (m *GCPolicy) XXX_Size() int {
	return m.Size()
}
func (m *GCPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_GCPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_GCPolicy proto.InternalMessageInfo

func (m *GCPolicy) GetAll() bool {
	if m != nil {
		return m.All
	}
	return false
}

func (m *GCPolicy) GetKeepDuration() int64 {
	if m != nil {
		return m.KeepDuration
	}
	return 0
}

func (m *GCPolicy) GetKeepBytes() int64 {
	if m != nil {
		return m.KeepBytes
	}
	return 0
}

func (m *GCPolicy) GetFilters() []string {
	if m != nil {
		return m.Filters
	}
	return nil
}

type BuildkitVersion struct {
	Package              string   `protobuf:"bytes,1,opt,name=package,proto3" json:"package,omitempty"`
	Version              string   `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	Revision             string   `protobuf:"bytes,3,opt,name=revision,proto3" json:"revision,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BuildkitVersion) Reset()         { *m = BuildkitVersion{} }
func (m *BuildkitVersion) String() string { return proto.CompactTextString(m) }
func (*BuildkitVersion) ProtoMessage()    {}
func (*BuildkitVersion) Descriptor() ([]byte, []int) {
	return fileDescriptor_e4ff6184b07e587a, []int{3}
}
func (m *BuildkitVersion) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *BuildkitVersion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_BuildkitVersion.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *BuildkitVersion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BuildkitVersion.Merge(m, src)
}
func (m *BuildkitVersion) XXX_Size() int {
	return m.Size()
}
func (m *BuildkitVersion) XXX_DiscardUnknown() {
	xxx_messageInfo_BuildkitVersion.DiscardUnknown(m)
}

var xxx_messageInfo_BuildkitVersion proto.InternalMessageInfo

func (m *BuildkitVersion) GetPackage() string {
	if m != nil {
		return m.Package
	}
	return ""
}

func (m *BuildkitVersion) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *BuildkitVersion) GetRevision() string {
	if m != nil {
		return m.Revision
	}
	return ""
}

func init() {
	proto.RegisterType((*WorkerRecord)(nil), "moby.buildkit.v1.types.WorkerRecord")
	proto.RegisterMapType((map[string]string)(nil), "moby.buildkit.v1.types.WorkerRecord.LabelsEntry")
	proto.RegisterType((*GCAnalytics)(nil), "moby.buildkit.v1.types.GCAnalytics")
	proto.RegisterType((*GCPolicy)(nil), "moby.buildkit.v1.types.GCPolicy")
	proto.RegisterType((*BuildkitVersion)(nil), "moby.buildkit.v1.types.BuildkitVersion")
}

func init() { proto.RegisterFile("worker.proto", fileDescriptor_e4ff6184b07e587a) }

var fileDescriptor_e4ff6184b07e587a = []byte{
	// 775 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x74, 0x55, 0x5f, 0x6f, 0xd3, 0x3a,
	0x14, 0xbf, 0x69, 0xbb, 0xad, 0x75, 0xbb, 0x7f, 0xde, 0xee, 0xbd, 0x56, 0x75, 0xb5, 0x5b, 0x15,
	0x04, 0x15, 0x1a, 0xe9, 0x18, 0x3c, 0x8c, 0x89, 0x17, 0xda, 0x95, 0x31, 0x89, 0xa1, 0x91, 0x21,
	0xf6, 0xec, 0xa4, 0x6e, 0x66, 0xd5, 0x89, 0x23, 0x3b, 0x09, 0x2b, 0xef, 0x7c, 0x24, 0xbe, 0xc3,
	0x1e, 0xf9, 0x04, 0x08, 0xed, 0x93, 0x20, 0x3b, 0x49, 0x93, 0xfe, 0x7b, 0xf3, 0xf9, 0xfd, 0x39,
	0x3d, 0xe7, 0xe4, 0xd8, 0x05, 0x8d, 0xaf, 0x5c, 0x8c, 0x89, 0x30, 0x03, 0xc1, 0x43, 0x0e, 0xff,
	0xf1, 0xb8, 0x3d, 0x31, 0xed, 0x88, 0xb2, 0xe1, 0x98, 0x86, 0x66, 0xfc, 0xc2, 0x0c, 0x27, 0x01,
	0x91, 0xcd, 0xe7, 0x2e, 0x0d, 0x6f, 0x23, 0xdb, 0x74, 0xb8, 0xd7, 0x75, 0xb9, 0xcb, 0xbb, 0x5a,
	0x6e, 0x47, 0x23, 0x1d, 0xe9, 0x40, 0x9f, 0x92, 0x34, 0xcd, 0xc3, 0x82, 0x5c, 0x65, 0xec, 0x66,
	0x19, 0xbb, 0x92, 0xb3, 0x98, 0x88, 0x6e, 0x60, 0x77, 0x79, 0x20, 0x13, 0x75, 0xfb, 0x47, 0x05,
	0x34, 0x6e, 0x74, 0x15, 0x16, 0x71, 0xb8, 0x18, 0xc2, 0x2d, 0x50, 0xba, 0x38, 0x43, 0x46, 0xcb,
	0xe8, 0xd4, 0xac, 0xd2, 0xc5, 0x19, 0x7c, 0x0f, 0xd6, 0x3f, 0x60, 0x9b, 0x30, 0x89, 0x4a, 0xad,
	0x72, 0xa7, 0x7e, 0x7c, 0x64, 0x2e, 0x2f, 0xd3, 0x2c, 0x66, 0x31, 0x13, 0xcb, 0xc0, 0x0f, 0xc5,
	0xc4, 0x4a, 0xfd, 0xf0, 0x08, 0xd4, 0x02, 0x86, 0xc3, 0x11, 0x17, 0x9e, 0x44, 0x65, 0x9d, 0xac,
	0x61, 0x06, 0xb6, 0x79, 0x95, 0x82, 0xbd, 0xca, 0xfd, 0xaf, 0xff, 0xff, 0xb2, 0x72, 0x11, 0x7c,
	0x03, 0xaa, 0xe7, 0xfd, 0x2b, 0xce, 0xa8, 0x33, 0x41, 0x15, 0x6d, 0x68, 0xad, 0xfa, 0xf5, 0x4c,
	0x67, 0x4d, 0x1d, 0xf0, 0x13, 0xd8, 0xee, 0xa5, 0xba, 0x2f, 0x44, 0x48, 0xca, 0x7d, 0xb4, 0xd6,
	0x32, 0x3a, 0xf5, 0xe3, 0xa7, 0xab, 0x92, 0xcc, 0xc9, 0xad, 0x79, 0x3f, 0x34, 0x01, 0x0c, 0xb0,
	0xc0, 0x8c, 0x11, 0x46, 0xa5, 0xd7, 0x8f, 0x84, 0x20, 0x7e, 0x88, 0x48, 0xcb, 0xe8, 0x94, 0xad,
	0x25, 0x0c, 0x7c, 0x02, 0xb6, 0x0a, 0xe8, 0x25, 0xbe, 0x43, 0x23, 0xad, 0x9d, 0x43, 0xe7, 0xf2,
	0xde, 0x60, 0x1a, 0x52, 0xdf, 0x45, 0xee, 0x42, 0xde, 0x94, 0x81, 0x03, 0x50, 0x3f, 0xef, 0xbf,
	0xf5, 0x31, 0x9b, 0x84, 0xd4, 0x91, 0xe8, 0x56, 0xb7, 0xf5, 0x68, 0xf5, 0x6c, 0xa6, 0x52, 0xab,
	0xe8, 0x6b, 0xbe, 0x06, 0xf5, 0xc2, 0x87, 0x82, 0x3b, 0xa0, 0x3c, 0x26, 0x93, 0xf4, 0xdb, 0xab,
	0x23, 0xdc, 0x07, 0x6b, 0x31, 0x66, 0x11, 0x41, 0x25, 0x8d, 0x25, 0xc1, 0x69, 0xe9, 0xc4, 0x68,
	0x7f, 0xdf, 0x98, 0x29, 0x01, 0x22, 0xb0, 0xe1, 0x47, 0x9e, 0x15, 0xf9, 0x52, 0xfb, 0xcb, 0x56,
	0x16, 0xc2, 0x16, 0xa8, 0xfb, 0x91, 0xf7, 0x0e, 0x53, 0x16, 0x09, 0x22, 0x75, 0xa6, 0xb2, 0x55,
	0x84, 0xe0, 0x63, 0xb0, 0x89, 0x63, 0xf7, 0x2c, 0x12, 0x38, 0xa4, 0xdc, 0xbf, 0x54, 0xcb, 0xa1,
	0x34, 0xb3, 0x20, 0x3c, 0x04, 0xbb, 0x38, 0x76, 0x93, 0xfd, 0x92, 0x7d, 0x46, 0xb0, 0x20, 0x43,
	0x54, 0xd1, 0xca, 0x45, 0x42, 0x4d, 0x1e, 0xc7, 0xee, 0x35, 0xfd, 0x46, 0x32, 0xe9, 0x5a, 0x32,
	0xf9, 0x59, 0x14, 0x3e, 0x03, 0x3b, 0xb9, 0xb9, 0x47, 0x46, 0x5c, 0x10, 0xb4, 0xae, 0x95, 0x0b,
	0x78, 0x5a, 0xa7, 0x72, 0xa7, 0xc2, 0x8d, 0x69, 0x9d, 0x39, 0xa8, 0xfa, 0xc5, 0x8c, 0x7d, 0xa6,
	0x1e, 0xd1, 0xd3, 0xa8, 0x26, 0xfd, 0x16, 0x20, 0x78, 0x0c, 0xf6, 0xd3, 0xf0, 0x12, 0xdf, 0x15,
	0xda, 0xae, 0x69, 0xe9, 0x52, 0x4e, 0x77, 0x9f, 0xe0, 0x05, 0x03, 0x48, 0xbb, 0x9f, 0x27, 0xe0,
	0x29, 0x40, 0x4e, 0xb2, 0x82, 0xd7, 0x21, 0x16, 0xa1, 0x62, 0xaf, 0x89, 0x33, 0x08, 0xb8, 0x73,
	0x8b, 0xea, 0xda, 0xb4, 0x92, 0x87, 0x27, 0xe0, 0xdf, 0x94, 0xfb, 0x18, 0x79, 0xb3, 0x83, 0x69,
	0x68, 0xeb, 0x2a, 0x5a, 0xd5, 0x98, 0x65, 0xcd, 0x67, 0xb4, 0x99, 0xd4, 0xb8, 0x40, 0xc0, 0x57,
	0xe0, 0x6f, 0x86, 0xe5, 0x92, 0x02, 0xb7, 0xb4, 0x63, 0x39, 0x09, 0x8f, 0xc0, 0x9e, 0x22, 0x06,
	0xfe, 0x70, 0xc6, 0xb3, 0xad, 0x3d, 0xcb, 0x28, 0x35, 0x6d, 0x05, 0x2f, 0x34, 0xb3, 0x93, 0x4c,
	0x7b, 0x19, 0xa7, 0xb6, 0x47, 0xff, 0x7c, 0xde, 0xc6, 0x6e, 0xb2, 0x3d, 0xb3, 0x68, 0xd6, 0x43,
	0xee, 0xcf, 0x96, 0x0d, 0xe6, 0x3d, 0x2c, 0x90, 0xb0, 0x03, 0xb6, 0xb3, 0x3c, 0x99, 0x7e, 0x4f,
	0xeb, 0xe7, 0x61, 0xb5, 0x4b, 0x1a, 0x8a, 0x1c, 0x87, 0x48, 0x89, 0xf6, 0x5b, 0x46, 0xa7, 0x6a,
	0x15, 0xa1, 0xf6, 0x5d, 0xfe, 0x44, 0xaa, 0xfb, 0x8b, 0x19, 0xd3, 0xf7, 0xaf, 0x6a, 0xa9, 0x23,
	0x6c, 0x83, 0xc6, 0x98, 0x90, 0x20, 0xdb, 0x8c, 0xf4, 0xf2, 0xcd, 0x60, 0xf0, 0x3f, 0x50, 0x53,
	0x71, 0x6f, 0x12, 0x92, 0xec, 0xe6, 0xe5, 0x80, 0xba, 0xd7, 0x23, 0xca, 0x42, 0x22, 0xa4, 0x7e,
	0x81, 0x6b, 0x56, 0x16, 0xb6, 0xf1, 0xc2, 0xf3, 0xaa, 0xc4, 0x01, 0x76, 0xc6, 0xd8, 0x25, 0xe9,
	0x23, 0x92, 0x85, 0x8a, 0x89, 0xd3, 0x37, 0x38, 0x79, 0x4a, 0xb2, 0x10, 0x36, 0x41, 0x55, 0x90,
	0x98, 0x6a, 0xaa, 0xac, 0xa9, 0x69, 0xdc, 0x6b, 0xdc, 0x3f, 0x1c, 0x18, 0x3f, 0x1f, 0x0e, 0x8c,
	0xdf, 0x0f, 0x07, 0x86, 0xbd, 0xae, 0xff, 0xb1, 0x5e, 0xfe, 0x09, 0x00, 0x00, 0xff, 0xff, 0xac,
	0xc1, 0x45, 0x83, 0x36, 0x07, 0x00, 0x00,
}

func (m *WorkerRecord) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WorkerRecord) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *WorkerRecord) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.GCAnalytics != nil {
		{
			size, err := m.GCAnalytics.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintWorker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xc2
	}
	if m.ParallelismWaiting != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.ParallelismWaiting))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xb8
	}
	if m.ParallelismMax != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.ParallelismMax))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xb0
	}
	if m.ParallelismCurrent != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.ParallelismCurrent))
		i--
		dAtA[i] = 0x6
		i--
		dAtA[i] = 0xa8
	}
	if m.BuildkitVersion != nil {
		{
			size, err := m.BuildkitVersion.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintWorker(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x2a
	}
	if len(m.GCPolicy) > 0 {
		for iNdEx := len(m.GCPolicy) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.GCPolicy[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintWorker(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x22
		}
	}
	if len(m.Platforms) > 0 {
		for iNdEx := len(m.Platforms) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Platforms[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintWorker(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0x1a
		}
	}
	if len(m.Labels) > 0 {
		for k := range m.Labels {
			v := m.Labels[k]
			baseI := i
			i -= len(v)
			copy(dAtA[i:], v)
			i = encodeVarintWorker(dAtA, i, uint64(len(v)))
			i--
			dAtA[i] = 0x12
			i -= len(k)
			copy(dAtA[i:], k)
			i = encodeVarintWorker(dAtA, i, uint64(len(k)))
			i--
			dAtA[i] = 0xa
			i = encodeVarintWorker(dAtA, i, uint64(baseI-i))
			i--
			dAtA[i] = 0x12
		}
	}
	if len(m.ID) > 0 {
		i -= len(m.ID)
		copy(dAtA[i:], m.ID)
		i = encodeVarintWorker(dAtA, i, uint64(len(m.ID)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GCAnalytics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCAnalytics) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GCAnalytics) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.LastSuccess {
		i--
		if m.LastSuccess {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0xa0
	}
	if m.LastSizeCleared != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.LastSizeCleared))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x98
	}
	if m.LastNumRecordsCleared != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.LastNumRecordsCleared))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x90
	}
	if m.LastSizeBefore != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.LastSizeBefore))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x88
	}
	if m.LastNumRecordsBefore != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.LastNumRecordsBefore))
		i--
		dAtA[i] = 0x1
		i--
		dAtA[i] = 0x80
	}
	if m.LastEndTimeSecEpoch != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.LastEndTimeSecEpoch))
		i--
		dAtA[i] = 0x78
	}
	if m.LastStartTimeSecEpoch != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.LastStartTimeSecEpoch))
		i--
		dAtA[i] = 0x70
	}
	if m.CurrentSizeBefore != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.CurrentSizeBefore))
		i--
		dAtA[i] = 0x68
	}
	if m.CurrentNumRecordsBefore != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.CurrentNumRecordsBefore))
		i--
		dAtA[i] = 0x60
	}
	if m.CurrentStartTimeSecEpoch != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.CurrentStartTimeSecEpoch))
		i--
		dAtA[i] = 0x58
	}
	if m.AllTimeDurationMs != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.AllTimeDurationMs))
		i--
		dAtA[i] = 0x50
	}
	if m.AllTimeMaxDurationMs != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.AllTimeMaxDurationMs))
		i--
		dAtA[i] = 0x48
	}
	if m.AllTimeRuns != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.AllTimeRuns))
		i--
		dAtA[i] = 0x40
	}
	if m.AvgSizeBefore != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.AvgSizeBefore))
		i--
		dAtA[i] = 0x38
	}
	if m.AvgRecordsBefore != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.AvgRecordsBefore))
		i--
		dAtA[i] = 0x30
	}
	if m.AvgSizeCleared != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.AvgSizeCleared))
		i--
		dAtA[i] = 0x28
	}
	if m.AvgRecordsCleared != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.AvgRecordsCleared))
		i--
		dAtA[i] = 0x20
	}
	if m.AvgDurationMs != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.AvgDurationMs))
		i--
		dAtA[i] = 0x18
	}
	if m.NumFailures != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.NumFailures))
		i--
		dAtA[i] = 0x10
	}
	if m.NumRuns != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.NumRuns))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *GCPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCPolicy) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GCPolicy) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Filters) > 0 {
		for iNdEx := len(m.Filters) - 1; iNdEx >= 0; iNdEx-- {
			i -= len(m.Filters[iNdEx])
			copy(dAtA[i:], m.Filters[iNdEx])
			i = encodeVarintWorker(dAtA, i, uint64(len(m.Filters[iNdEx])))
			i--
			dAtA[i] = 0x22
		}
	}
	if m.KeepBytes != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.KeepBytes))
		i--
		dAtA[i] = 0x18
	}
	if m.KeepDuration != 0 {
		i = encodeVarintWorker(dAtA, i, uint64(m.KeepDuration))
		i--
		dAtA[i] = 0x10
	}
	if m.All {
		i--
		if m.All {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func (m *BuildkitVersion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BuildkitVersion) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *BuildkitVersion) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if len(m.Revision) > 0 {
		i -= len(m.Revision)
		copy(dAtA[i:], m.Revision)
		i = encodeVarintWorker(dAtA, i, uint64(len(m.Revision)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Version) > 0 {
		i -= len(m.Version)
		copy(dAtA[i:], m.Version)
		i = encodeVarintWorker(dAtA, i, uint64(len(m.Version)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Package) > 0 {
		i -= len(m.Package)
		copy(dAtA[i:], m.Package)
		i = encodeVarintWorker(dAtA, i, uint64(len(m.Package)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintWorker(dAtA []byte, offset int, v uint64) int {
	offset -= sovWorker(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *WorkerRecord) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.ID)
	if l > 0 {
		n += 1 + l + sovWorker(uint64(l))
	}
	if len(m.Labels) > 0 {
		for k, v := range m.Labels {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovWorker(uint64(len(k))) + 1 + len(v) + sovWorker(uint64(len(v)))
			n += mapEntrySize + 1 + sovWorker(uint64(mapEntrySize))
		}
	}
	if len(m.Platforms) > 0 {
		for _, e := range m.Platforms {
			l = e.Size()
			n += 1 + l + sovWorker(uint64(l))
		}
	}
	if len(m.GCPolicy) > 0 {
		for _, e := range m.GCPolicy {
			l = e.Size()
			n += 1 + l + sovWorker(uint64(l))
		}
	}
	if m.BuildkitVersion != nil {
		l = m.BuildkitVersion.Size()
		n += 1 + l + sovWorker(uint64(l))
	}
	if m.ParallelismCurrent != 0 {
		n += 2 + sovWorker(uint64(m.ParallelismCurrent))
	}
	if m.ParallelismMax != 0 {
		n += 2 + sovWorker(uint64(m.ParallelismMax))
	}
	if m.ParallelismWaiting != 0 {
		n += 2 + sovWorker(uint64(m.ParallelismWaiting))
	}
	if m.GCAnalytics != nil {
		l = m.GCAnalytics.Size()
		n += 2 + l + sovWorker(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GCAnalytics) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.NumRuns != 0 {
		n += 1 + sovWorker(uint64(m.NumRuns))
	}
	if m.NumFailures != 0 {
		n += 1 + sovWorker(uint64(m.NumFailures))
	}
	if m.AvgDurationMs != 0 {
		n += 1 + sovWorker(uint64(m.AvgDurationMs))
	}
	if m.AvgRecordsCleared != 0 {
		n += 1 + sovWorker(uint64(m.AvgRecordsCleared))
	}
	if m.AvgSizeCleared != 0 {
		n += 1 + sovWorker(uint64(m.AvgSizeCleared))
	}
	if m.AvgRecordsBefore != 0 {
		n += 1 + sovWorker(uint64(m.AvgRecordsBefore))
	}
	if m.AvgSizeBefore != 0 {
		n += 1 + sovWorker(uint64(m.AvgSizeBefore))
	}
	if m.AllTimeRuns != 0 {
		n += 1 + sovWorker(uint64(m.AllTimeRuns))
	}
	if m.AllTimeMaxDurationMs != 0 {
		n += 1 + sovWorker(uint64(m.AllTimeMaxDurationMs))
	}
	if m.AllTimeDurationMs != 0 {
		n += 1 + sovWorker(uint64(m.AllTimeDurationMs))
	}
	if m.CurrentStartTimeSecEpoch != 0 {
		n += 1 + sovWorker(uint64(m.CurrentStartTimeSecEpoch))
	}
	if m.CurrentNumRecordsBefore != 0 {
		n += 1 + sovWorker(uint64(m.CurrentNumRecordsBefore))
	}
	if m.CurrentSizeBefore != 0 {
		n += 1 + sovWorker(uint64(m.CurrentSizeBefore))
	}
	if m.LastStartTimeSecEpoch != 0 {
		n += 1 + sovWorker(uint64(m.LastStartTimeSecEpoch))
	}
	if m.LastEndTimeSecEpoch != 0 {
		n += 1 + sovWorker(uint64(m.LastEndTimeSecEpoch))
	}
	if m.LastNumRecordsBefore != 0 {
		n += 2 + sovWorker(uint64(m.LastNumRecordsBefore))
	}
	if m.LastSizeBefore != 0 {
		n += 2 + sovWorker(uint64(m.LastSizeBefore))
	}
	if m.LastNumRecordsCleared != 0 {
		n += 2 + sovWorker(uint64(m.LastNumRecordsCleared))
	}
	if m.LastSizeCleared != 0 {
		n += 2 + sovWorker(uint64(m.LastSizeCleared))
	}
	if m.LastSuccess {
		n += 3
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *GCPolicy) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.All {
		n += 2
	}
	if m.KeepDuration != 0 {
		n += 1 + sovWorker(uint64(m.KeepDuration))
	}
	if m.KeepBytes != 0 {
		n += 1 + sovWorker(uint64(m.KeepBytes))
	}
	if len(m.Filters) > 0 {
		for _, s := range m.Filters {
			l = len(s)
			n += 1 + l + sovWorker(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *BuildkitVersion) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Package)
	if l > 0 {
		n += 1 + l + sovWorker(uint64(l))
	}
	l = len(m.Version)
	if l > 0 {
		n += 1 + l + sovWorker(uint64(l))
	}
	l = len(m.Revision)
	if l > 0 {
		n += 1 + l + sovWorker(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovWorker(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozWorker(x uint64) (n int) {
	return sovWorker(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *WorkerRecord) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWorker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WorkerRecord: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WorkerRecord: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWorker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWorker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Labels", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Labels == nil {
				m.Labels = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowWorker
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= uint64(b&0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorker
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthWorker
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey < 0 {
						return ErrInvalidLengthWorker
					}
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowWorker
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= uint64(b&0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthWorker
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue < 0 {
						return ErrInvalidLengthWorker
					}
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipWorker(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if (skippy < 0) || (iNdEx+skippy) < 0 {
						return ErrInvalidLengthWorker
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Labels[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Platforms", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Platforms = append(m.Platforms, pb.Platform{})
			if err := m.Platforms[len(m.Platforms)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GCPolicy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GCPolicy = append(m.GCPolicy, &GCPolicy{})
			if err := m.GCPolicy[len(m.GCPolicy)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildkitVersion", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BuildkitVersion == nil {
				m.BuildkitVersion = &BuildkitVersion{}
			}
			if err := m.BuildkitVersion.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 101:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParallelismCurrent", wireType)
			}
			m.ParallelismCurrent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ParallelismCurrent |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 102:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParallelismMax", wireType)
			}
			m.ParallelismMax = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ParallelismMax |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 103:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParallelismWaiting", wireType)
			}
			m.ParallelismWaiting = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ParallelismWaiting |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 104:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GCAnalytics", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthWorker
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthWorker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GCAnalytics == nil {
				m.GCAnalytics = &GCAnalytics{}
			}
			if err := m.GCAnalytics.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWorker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthWorker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCAnalytics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWorker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCAnalytics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCAnalytics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumRuns", wireType)
			}
			m.NumRuns = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumRuns |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumFailures", wireType)
			}
			m.NumFailures = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumFailures |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvgDurationMs", wireType)
			}
			m.AvgDurationMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AvgDurationMs |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvgRecordsCleared", wireType)
			}
			m.AvgRecordsCleared = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AvgRecordsCleared |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvgSizeCleared", wireType)
			}
			m.AvgSizeCleared = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AvgSizeCleared |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvgRecordsBefore", wireType)
			}
			m.AvgRecordsBefore = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AvgRecordsBefore |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AvgSizeBefore", wireType)
			}
			m.AvgSizeBefore = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AvgSizeBefore |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllTimeRuns", wireType)
			}
			m.AllTimeRuns = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AllTimeRuns |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllTimeMaxDurationMs", wireType)
			}
			m.AllTimeMaxDurationMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AllTimeMaxDurationMs |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AllTimeDurationMs", wireType)
			}
			m.AllTimeDurationMs = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AllTimeDurationMs |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentStartTimeSecEpoch", wireType)
			}
			m.CurrentStartTimeSecEpoch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CurrentStartTimeSecEpoch |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentNumRecordsBefore", wireType)
			}
			m.CurrentNumRecordsBefore = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CurrentNumRecordsBefore |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CurrentSizeBefore", wireType)
			}
			m.CurrentSizeBefore = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CurrentSizeBefore |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastStartTimeSecEpoch", wireType)
			}
			m.LastStartTimeSecEpoch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastStartTimeSecEpoch |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 15:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastEndTimeSecEpoch", wireType)
			}
			m.LastEndTimeSecEpoch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastEndTimeSecEpoch |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastNumRecordsBefore", wireType)
			}
			m.LastNumRecordsBefore = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastNumRecordsBefore |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastSizeBefore", wireType)
			}
			m.LastSizeBefore = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastSizeBefore |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 18:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastNumRecordsCleared", wireType)
			}
			m.LastNumRecordsCleared = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastNumRecordsCleared |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastSizeCleared", wireType)
			}
			m.LastSizeCleared = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LastSizeCleared |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 20:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastSuccess", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LastSuccess = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipWorker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthWorker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWorker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field All", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.All = bool(v != 0)
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeepDuration", wireType)
			}
			m.KeepDuration = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeepDuration |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeepBytes", wireType)
			}
			m.KeepBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeepBytes |= int64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filters", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWorker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWorker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Filters = append(m.Filters, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWorker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthWorker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BuildkitVersion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowWorker
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BuildkitVersion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BuildkitVersion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Package", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWorker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWorker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Package = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWorker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWorker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Version = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Revision", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthWorker
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthWorker
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Revision = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipWorker(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthWorker
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipWorker(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowWorker
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowWorker
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthWorker
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupWorker
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthWorker
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthWorker        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowWorker          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupWorker = fmt.Errorf("proto: unexpected end of group")
)
