package alertsmanagements

import (
	"context"
	"fmt"
	"net/http"

	"github.com/hashicorp/go-azure-sdk/sdk/client"
	"github.com/hashicorp/go-azure-sdk/sdk/odata"
)

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See NOTICE.txt in the project root for license information.

type AlertsMetaDataOperationResponse struct {
	HttpResponse *http.Response
	OData        *odata.OData
	Model        *AlertsMetaData
}

type AlertsMetaDataOperationOptions struct {
	Identifier *Identifier
}

func DefaultAlertsMetaDataOperationOptions() AlertsMetaDataOperationOptions {
	return AlertsMetaDataOperationOptions{}
}

func (o AlertsMetaDataOperationOptions) ToHeaders() *client.Headers {
	out := client.Headers{}

	return &out
}

func (o AlertsMetaDataOperationOptions) ToOData() *odata.Query {
	out := odata.Query{}

	return &out
}

func (o AlertsMetaDataOperationOptions) ToQuery() *client.QueryParams {
	out := client.QueryParams{}
	if o.Identifier != nil {
		out.Append("identifier", fmt.Sprintf("%v", *o.Identifier))
	}
	return &out
}

// AlertsMetaData ...
func (c AlertsManagementsClient) AlertsMetaData(ctx context.Context, options AlertsMetaDataOperationOptions) (result AlertsMetaDataOperationResponse, err error) {
	opts := client.RequestOptions{
		ContentType: "application/json; charset=utf-8",
		ExpectedStatusCodes: []int{
			http.StatusOK,
		},
		HttpMethod:    http.MethodGet,
		OptionsObject: options,
		Path:          "/providers/Microsoft.AlertsManagement/alertsMetaData",
	}

	req, err := c.Client.NewRequest(ctx, opts)
	if err != nil {
		return
	}

	var resp *client.Response
	resp, err = req.Execute(ctx)
	if resp != nil {
		result.OData = resp.OData
		result.HttpResponse = resp.Response
	}
	if err != nil {
		return
	}

	var model AlertsMetaData
	result.Model = &model
	if err = resp.Unmarshal(result.Model); err != nil {
		return
	}

	return
}
