package testdata

import "time"

var RaftV116 = []SerializeTest{
	{"AppendEntriesRequest", "89a441646472a7636172746d616ea7456e74726965739186aa417070656e6465644174af01000000000000000000000000ffffa444617461c0aa457874656e73696f6e73c0a5496e64657865a45465726d04a45479706501a24944c0a64c6561646572c0b14c6561646572436f6d6d6974496e6465785aac507265764c6f67456e74727964ab507265764c6f675465726d04af50726f746f636f6c56657273696f6e00a45465726d0a", AppendEntriesRequest{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8{0x63, 0x61, 0x72, 0x74, 0x6d, 0x61, 0x6e}}, Term: 0xa, Leader: []uint8(nil), PrevLogEntry: 0x64, PrevLogTerm: 0x4, Entries: []*Log{{Index: 0x65, Term: 0x4, Type: 0x1, Data: []uint8(nil), Extensions: []uint8(nil), AppendedAt: time.Date(1, time.January, 1, 0, 0, 0, 0, time.UTC)}}, LeaderCommitIndex: 0x5a}},
	{"AppendEntriesRequest", "89a441646472a7636172746d616ea7456e7472696573c0a24944c0a64c6561646572a7636172746d616eb14c6561646572436f6d6d6974496e64657800ac507265764c6f67456e74727900ab507265764c6f675465726d00af50726f746f636f6c56657273696f6e03a45465726d0a", AppendEntriesRequest{RPCHeader: RPCHeader{ProtocolVersion: 3, ID: []uint8(nil), Addr: []uint8{0x63, 0x61, 0x72, 0x74, 0x6d, 0x61, 0x6e}}, Term: 0xa, Leader: []uint8{0x63, 0x61, 0x72, 0x74, 0x6d, 0x61, 0x6e}, PrevLogEntry: 0x0, PrevLogTerm: 0x0, Entries: []*Log(nil), LeaderCommitIndex: 0x0}},
	{"AppendEntriesResponse", "87a441646472c0a24944c0a74c6173744c6f675aae4e6f52657472794261636b6f6666c2af50726f746f636f6c56657273696f6e00a753756363657373c3a45465726d04", AppendEntriesResponse{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8(nil)}, Term: 0x4, LastLog: 0x5a, Success: true, NoRetryBackoff: false}},
	{"InstallSnapshotRequest", "8ca441646472a46b796c65ad436f6e66696775726174696f6ec0b2436f6e66696775726174696f6e496e64657800a24944c0ac4c6173744c6f67496e64657864ab4c6173744c6f675465726d09a64c6561646572c0a55065657273a9626c616820626c6168af50726f746f636f6c56657273696f6e00a453697a650aaf536e617073686f7456657273696f6e00a45465726d0a", InstallSnapshotRequest{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8{0x6b, 0x79, 0x6c, 0x65}}, SnapshotVersion: 0, Term: 0xa, Leader: []uint8(nil), LastLogIndex: 0x64, LastLogTerm: 0x9, Peers: []uint8{0x62, 0x6c, 0x61, 0x68, 0x20, 0x62, 0x6c, 0x61, 0x68}, Configuration: []uint8(nil), ConfigurationIndex: 0x0, Size: 10}},
	{"InstallSnapshotResponse", "85a441646472c0a24944c0af50726f746f636f6c56657273696f6e00a753756363657373c3a45465726d0a", InstallSnapshotResponse{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8(nil)}, Term: 0xa, Success: true}},
	{"RequestVoteRequest", "88a441646472a762757474657273a943616e646964617465c0a24944c0ac4c6173744c6f67496e64657864ab4c6173744c6f675465726d13b24c6561646572736869705472616e73666572c2af50726f746f636f6c56657273696f6e00a45465726d14", RequestVoteRequest{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8{0x62, 0x75, 0x74, 0x74, 0x65, 0x72, 0x73}}, Term: 0x14, Candidate: []uint8(nil), LastLogIndex: 0x64, LastLogTerm: 0x13, LeadershipTransfer: false}},
	{"RequestVoteResponse", "86a441646472c0a74772616e746564c2a24944c0a55065657273c0af50726f746f636f6c56657273696f6e00a45465726d64", RequestVoteResponse{RPCHeader: RPCHeader{ProtocolVersion: 0, ID: []uint8(nil), Addr: []uint8(nil)}, Term: 0x64, Peers: []uint8(nil), Granted: false}},
	{"[][]uint8", "91a96f7665722068657265", [][]uint8{{0x6f, 0x76, 0x65, 0x72, 0x20, 0x68, 0x65, 0x72, 0x65}}},
	{"[][]uint8", "91da002432383133306162382d646462642d346466342d386163642d616533626363656230393466", [][]uint8{{0x32, 0x38, 0x31, 0x33, 0x30, 0x61, 0x62, 0x38, 0x2d, 0x64, 0x64, 0x62, 0x64, 0x2d, 0x34, 0x64, 0x66, 0x34, 0x2d, 0x38, 0x61, 0x63, 0x64, 0x2d, 0x61, 0x65, 0x33, 0x62, 0x63, 0x63, 0x65, 0x62, 0x30, 0x39, 0x34, 0x66}}},
	{"[][]uint8", "91da002433633362323766612d626633362d303064332d303466632d353335613564663538653730", [][]uint8{{0x33, 0x63, 0x33, 0x62, 0x32, 0x37, 0x66, 0x61, 0x2d, 0x62, 0x66, 0x33, 0x36, 0x2d, 0x30, 0x30, 0x64, 0x33, 0x2d, 0x30, 0x34, 0x66, 0x63, 0x2d, 0x35, 0x33, 0x35, 0x61, 0x35, 0x64, 0x66, 0x35, 0x38, 0x65, 0x37, 0x30}}},
	{"[][]uint8", "91da002464306431313435352d656261352d633764372d373166352d323034313133353633633237", [][]uint8{{0x64, 0x30, 0x64, 0x31, 0x31, 0x34, 0x35, 0x35, 0x2d, 0x65, 0x62, 0x61, 0x35, 0x2d, 0x63, 0x37, 0x64, 0x37, 0x2d, 0x37, 0x31, 0x66, 0x35, 0x2d, 0x32, 0x30, 0x34, 0x31, 0x31, 0x33, 0x35, 0x36, 0x33, 0x63, 0x32, 0x37}}},
	{"[][]uint8", "91da002464656338346137322d386335352d316539642d343534382d666438656165393538363930", [][]uint8{{0x64, 0x65, 0x63, 0x38, 0x34, 0x61, 0x37, 0x32, 0x2d, 0x38, 0x63, 0x35, 0x35, 0x2d, 0x31, 0x65, 0x39, 0x64, 0x2d, 0x34, 0x35, 0x34, 0x38, 0x2d, 0x66, 0x64, 0x38, 0x65, 0x61, 0x65, 0x39, 0x35, 0x38, 0x36, 0x39, 0x30}}},
	{"[][]uint8", "91da002464656532396439332d363638342d386135342d373232632d396536643466376439666162", [][]uint8{{0x64, 0x65, 0x65, 0x32, 0x39, 0x64, 0x39, 0x33, 0x2d, 0x36, 0x36, 0x38, 0x34, 0x2d, 0x38, 0x61, 0x35, 0x34, 0x2d, 0x37, 0x32, 0x32, 0x63, 0x2d, 0x39, 0x65, 0x36, 0x64, 0x34, 0x66, 0x37, 0x64, 0x39, 0x66, 0x61, 0x62}}},
	{"[][]uint8", "92da002438613637636361352d643230312d633439632d313231302d303963373339313837613832da002439333933393839612d343032332d656434622d636233312d386662623264376262646334", [][]uint8{{0x38, 0x61, 0x36, 0x37, 0x63, 0x63, 0x61, 0x35, 0x2d, 0x64, 0x32, 0x30, 0x31, 0x2d, 0x63, 0x34, 0x39, 0x63, 0x2d, 0x31, 0x32, 0x31, 0x30, 0x2d, 0x30, 0x39, 0x63, 0x37, 0x33, 0x39, 0x31, 0x38, 0x37, 0x61, 0x38, 0x32}, {0x39, 0x33, 0x39, 0x33, 0x39, 0x38, 0x39, 0x61, 0x2d, 0x34, 0x30, 0x32, 0x33, 0x2d, 0x65, 0x64, 0x34, 0x62, 0x2d, 0x63, 0x62, 0x33, 0x31, 0x2d, 0x38, 0x66, 0x62, 0x62, 0x32, 0x64, 0x37, 0x62, 0x62, 0x64, 0x63, 0x34}}},
	{"[][]uint8", "92da002439323233666434392d356435612d626561362d356561382d306236336631303663396263da002462353662353432332d306661392d646438662d316536352d643765393165396662353362", [][]uint8{{0x39, 0x32, 0x32, 0x33, 0x66, 0x64, 0x34, 0x39, 0x2d, 0x35, 0x64, 0x35, 0x61, 0x2d, 0x62, 0x65, 0x61, 0x36, 0x2d, 0x35, 0x65, 0x61, 0x38, 0x2d, 0x30, 0x62, 0x36, 0x33, 0x66, 0x31, 0x30, 0x36, 0x63, 0x39, 0x62, 0x63}, {0x62, 0x35, 0x36, 0x62, 0x35, 0x34, 0x32, 0x33, 0x2d, 0x30, 0x66, 0x61, 0x39, 0x2d, 0x64, 0x64, 0x38, 0x66, 0x2d, 0x31, 0x65, 0x36, 0x35, 0x2d, 0x64, 0x37, 0x65, 0x39, 0x31, 0x65, 0x39, 0x66, 0x62, 0x35, 0x33, 0x62}}},
	{"[][]uint8", "93da002430313131383936652d636239302d326561342d643865342d363738393063353461613134da002437363461613735302d326363332d643233372d323336622d373235313534376433366532da002437656231383366332d313638362d323539312d376131632d333035396532643038303538", [][]uint8{{0x30, 0x31, 0x31, 0x31, 0x38, 0x39, 0x36, 0x65, 0x2d, 0x63, 0x62, 0x39, 0x30, 0x2d, 0x32, 0x65, 0x61, 0x34, 0x2d, 0x64, 0x38, 0x65, 0x34, 0x2d, 0x36, 0x37, 0x38, 0x39, 0x30, 0x63, 0x35, 0x34, 0x61, 0x61, 0x31, 0x34}, {0x37, 0x36, 0x34, 0x61, 0x61, 0x37, 0x35, 0x30, 0x2d, 0x32, 0x63, 0x63, 0x33, 0x2d, 0x64, 0x32, 0x33, 0x37, 0x2d, 0x32, 0x33, 0x36, 0x62, 0x2d, 0x37, 0x32, 0x35, 0x31, 0x35, 0x34, 0x37, 0x64, 0x33, 0x36, 0x65, 0x32}, {0x37, 0x65, 0x62, 0x31, 0x38, 0x33, 0x66, 0x33, 0x2d, 0x31, 0x36, 0x38, 0x36, 0x2d, 0x32, 0x35, 0x39, 0x31, 0x2d, 0x37, 0x61, 0x31, 0x63, 0x2d, 0x33, 0x30, 0x35, 0x39, 0x65, 0x32, 0x64, 0x30, 0x38, 0x30, 0x35, 0x38}}},
	{"[][]uint8", "93da002430333136386531642d663438642d346665622d636361302d313263373666653963616265da002461626566393063362d376635642d356263622d343132332d303361646130366430306564da002432663066356565622d663739352d376331372d646235352d393630306639383266613132", [][]uint8{{0x30, 0x33, 0x31, 0x36, 0x38, 0x65, 0x31, 0x64, 0x2d, 0x66, 0x34, 0x38, 0x64, 0x2d, 0x34, 0x66, 0x65, 0x62, 0x2d, 0x63, 0x63, 0x61, 0x30, 0x2d, 0x31, 0x32, 0x63, 0x37, 0x36, 0x66, 0x65, 0x39, 0x63, 0x61, 0x62, 0x65}, {0x61, 0x62, 0x65, 0x66, 0x39, 0x30, 0x63, 0x36, 0x2d, 0x37, 0x66, 0x35, 0x64, 0x2d, 0x35, 0x62, 0x63, 0x62, 0x2d, 0x34, 0x31, 0x32, 0x33, 0x2d, 0x30, 0x33, 0x61, 0x64, 0x61, 0x30, 0x36, 0x64, 0x30, 0x30, 0x65, 0x64}, {0x32, 0x66, 0x30, 0x66, 0x35, 0x65, 0x65, 0x62, 0x2d, 0x66, 0x37, 0x39, 0x35, 0x2d, 0x37, 0x63, 0x31, 0x37, 0x2d, 0x64, 0x62, 0x35, 0x35, 0x2d, 0x39, 0x36, 0x30, 0x30, 0x66, 0x39, 0x38, 0x32, 0x66, 0x61, 0x31, 0x32}}},
	{"[][]uint8", "93da002432316230623939642d323838662d633765632d643835612d653637663163393335666234da002434633330373662322d656364652d373764312d623464392d613163346532306163383438da002464383264313638332d323630322d323937332d653265322d386361333836386339326565", [][]uint8{{0x32, 0x31, 0x62, 0x30, 0x62, 0x39, 0x39, 0x64, 0x2d, 0x32, 0x38, 0x38, 0x66, 0x2d, 0x63, 0x37, 0x65, 0x63, 0x2d, 0x64, 0x38, 0x35, 0x61, 0x2d, 0x65, 0x36, 0x37, 0x66, 0x31, 0x63, 0x39, 0x33, 0x35, 0x66, 0x62, 0x34}, {0x34, 0x63, 0x33, 0x30, 0x37, 0x36, 0x62, 0x32, 0x2d, 0x65, 0x63, 0x64, 0x65, 0x2d, 0x37, 0x37, 0x64, 0x31, 0x2d, 0x62, 0x34, 0x64, 0x39, 0x2d, 0x61, 0x31, 0x63, 0x34, 0x65, 0x32, 0x30, 0x61, 0x63, 0x38, 0x34, 0x38}, {0x64, 0x38, 0x32, 0x64, 0x31, 0x36, 0x38, 0x33, 0x2d, 0x32, 0x36, 0x30, 0x32, 0x2d, 0x32, 0x39, 0x37, 0x33, 0x2d, 0x65, 0x32, 0x65, 0x32, 0x2d, 0x38, 0x63, 0x61, 0x33, 0x38, 0x36, 0x38, 0x63, 0x39, 0x32, 0x65, 0x65}}},
	{"[][]uint8", "93da002432333963613733632d313231352d643630382d326438372d326365346463623033316535da002461303834336634362d666331302d376133342d393335342d343032636261663465356532da002434386439663063642d656437312d363431642d633939632d636439366266323935346639", [][]uint8{{0x32, 0x33, 0x39, 0x63, 0x61, 0x37, 0x33, 0x63, 0x2d, 0x31, 0x32, 0x31, 0x35, 0x2d, 0x64, 0x36, 0x30, 0x38, 0x2d, 0x32, 0x64, 0x38, 0x37, 0x2d, 0x32, 0x63, 0x65, 0x34, 0x64, 0x63, 0x62, 0x30, 0x33, 0x31, 0x65, 0x35}, {0x61, 0x30, 0x38, 0x34, 0x33, 0x66, 0x34, 0x36, 0x2d, 0x66, 0x63, 0x31, 0x30, 0x2d, 0x37, 0x61, 0x33, 0x34, 0x2d, 0x39, 0x33, 0x35, 0x34, 0x2d, 0x34, 0x30, 0x32, 0x63, 0x62, 0x61, 0x66, 0x34, 0x65, 0x35, 0x65, 0x32}, {0x34, 0x38, 0x64, 0x39, 0x66, 0x30, 0x63, 0x64, 0x2d, 0x65, 0x64, 0x37, 0x31, 0x2d, 0x36, 0x34, 0x31, 0x64, 0x2d, 0x63, 0x39, 0x39, 0x63, 0x2d, 0x63, 0x64, 0x39, 0x36, 0x62, 0x66, 0x32, 0x39, 0x35, 0x34, 0x66, 0x39}}},
	{"[][]uint8", "93da002434373132653638322d376534662d353430612d386536362d336663396336666364343563da002431653736396163372d343936652d623265312d306261312d333031373036633464343061da002437656333643931622d363632392d303163392d353737662d616636303739386563306433", [][]uint8{{0x34, 0x37, 0x31, 0x32, 0x65, 0x36, 0x38, 0x32, 0x2d, 0x37, 0x65, 0x34, 0x66, 0x2d, 0x35, 0x34, 0x30, 0x61, 0x2d, 0x38, 0x65, 0x36, 0x36, 0x2d, 0x33, 0x66, 0x63, 0x39, 0x63, 0x36, 0x66, 0x63, 0x64, 0x34, 0x35, 0x63}, {0x31, 0x65, 0x37, 0x36, 0x39, 0x61, 0x63, 0x37, 0x2d, 0x34, 0x39, 0x36, 0x65, 0x2d, 0x62, 0x32, 0x65, 0x31, 0x2d, 0x30, 0x62, 0x61, 0x31, 0x2d, 0x33, 0x30, 0x31, 0x37, 0x30, 0x36, 0x63, 0x34, 0x64, 0x34, 0x30, 0x61}, {0x37, 0x65, 0x63, 0x33, 0x64, 0x39, 0x31, 0x62, 0x2d, 0x36, 0x36, 0x32, 0x39, 0x2d, 0x30, 0x31, 0x63, 0x39, 0x2d, 0x35, 0x37, 0x37, 0x66, 0x2d, 0x61, 0x66, 0x36, 0x30, 0x37, 0x39, 0x38, 0x65, 0x63, 0x30, 0x64, 0x33}}},
	{"[][]uint8", "93da002434646636333832622d663131382d333162372d383362662d376335303334356434643835da002439386363306261622d633739372d613962332d356139372d663134653430373061656134da002433626238303139622d363330342d306432642d643035392d366162313336346532363734", [][]uint8{{0x34, 0x64, 0x66, 0x36, 0x33, 0x38, 0x32, 0x62, 0x2d, 0x66, 0x31, 0x31, 0x38, 0x2d, 0x33, 0x31, 0x62, 0x37, 0x2d, 0x38, 0x33, 0x62, 0x66, 0x2d, 0x37, 0x63, 0x35, 0x30, 0x33, 0x34, 0x35, 0x64, 0x34, 0x64, 0x38, 0x35}, {0x39, 0x38, 0x63, 0x63, 0x30, 0x62, 0x61, 0x62, 0x2d, 0x63, 0x37, 0x39, 0x37, 0x2d, 0x61, 0x39, 0x62, 0x33, 0x2d, 0x35, 0x61, 0x39, 0x37, 0x2d, 0x66, 0x31, 0x34, 0x65, 0x34, 0x30, 0x37, 0x30, 0x61, 0x65, 0x61, 0x34}, {0x33, 0x62, 0x62, 0x38, 0x30, 0x31, 0x39, 0x62, 0x2d, 0x36, 0x33, 0x30, 0x34, 0x2d, 0x30, 0x64, 0x32, 0x64, 0x2d, 0x64, 0x30, 0x35, 0x39, 0x2d, 0x36, 0x61, 0x62, 0x31, 0x33, 0x36, 0x34, 0x65, 0x32, 0x36, 0x37, 0x34}}},
	{"[][]uint8", "93da002436313334316630652d383939612d353134372d326663342d633034313132376664336133da002435303165333137372d326662302d386638392d333938312d333163386661323730393866da002438643361363830662d366532302d363565662d316464332d363439643933633335363739", [][]uint8{{0x36, 0x31, 0x33, 0x34, 0x31, 0x66, 0x30, 0x65, 0x2d, 0x38, 0x39, 0x39, 0x61, 0x2d, 0x35, 0x31, 0x34, 0x37, 0x2d, 0x32, 0x66, 0x63, 0x34, 0x2d, 0x63, 0x30, 0x34, 0x31, 0x31, 0x32, 0x37, 0x66, 0x64, 0x33, 0x61, 0x33}, {0x35, 0x30, 0x31, 0x65, 0x33, 0x31, 0x37, 0x37, 0x2d, 0x32, 0x66, 0x62, 0x30, 0x2d, 0x38, 0x66, 0x38, 0x39, 0x2d, 0x33, 0x39, 0x38, 0x31, 0x2d, 0x33, 0x31, 0x63, 0x38, 0x66, 0x61, 0x32, 0x37, 0x30, 0x39, 0x38, 0x66}, {0x38, 0x64, 0x33, 0x61, 0x36, 0x38, 0x30, 0x66, 0x2d, 0x36, 0x65, 0x32, 0x30, 0x2d, 0x36, 0x35, 0x65, 0x66, 0x2d, 0x31, 0x64, 0x64, 0x33, 0x2d, 0x36, 0x34, 0x39, 0x64, 0x39, 0x33, 0x63, 0x33, 0x35, 0x36, 0x37, 0x39}}},
	{"[][]uint8", "93da002436333636366538642d613937342d613133302d333161332d646263656461343863333233da002462396361653734652d393561332d373331302d393232612d653664366431653635333066da002465333762653666642d366661322d653636612d646233612d656637386632346163383232", [][]uint8{{0x36, 0x33, 0x36, 0x36, 0x36, 0x65, 0x38, 0x64, 0x2d, 0x61, 0x39, 0x37, 0x34, 0x2d, 0x61, 0x31, 0x33, 0x30, 0x2d, 0x33, 0x31, 0x61, 0x33, 0x2d, 0x64, 0x62, 0x63, 0x65, 0x64, 0x61, 0x34, 0x38, 0x63, 0x33, 0x32, 0x33}, {0x62, 0x39, 0x63, 0x61, 0x65, 0x37, 0x34, 0x65, 0x2d, 0x39, 0x35, 0x61, 0x33, 0x2d, 0x37, 0x33, 0x31, 0x30, 0x2d, 0x39, 0x32, 0x32, 0x61, 0x2d, 0x65, 0x36, 0x64, 0x36, 0x64, 0x31, 0x65, 0x36, 0x35, 0x33, 0x30, 0x66}, {0x65, 0x33, 0x37, 0x62, 0x65, 0x36, 0x66, 0x64, 0x2d, 0x36, 0x66, 0x61, 0x32, 0x2d, 0x65, 0x36, 0x36, 0x61, 0x2d, 0x64, 0x62, 0x33, 0x61, 0x2d, 0x65, 0x66, 0x37, 0x38, 0x66, 0x32, 0x34, 0x61, 0x63, 0x38, 0x32, 0x32}}},
	{"[][]uint8", "93da002436343432623834332d386165622d363734612d626432312d633639363634643631383364da002464303862633632352d643135352d323334652d663134372d636630613862396133313637da002462376632353932332d343237652d313264372d633234652d353261363363323066653463", [][]uint8{{0x36, 0x34, 0x34, 0x32, 0x62, 0x38, 0x34, 0x33, 0x2d, 0x38, 0x61, 0x65, 0x62, 0x2d, 0x36, 0x37, 0x34, 0x61, 0x2d, 0x62, 0x64, 0x32, 0x31, 0x2d, 0x63, 0x36, 0x39, 0x36, 0x36, 0x34, 0x64, 0x36, 0x31, 0x38, 0x33, 0x64}, {0x64, 0x30, 0x38, 0x62, 0x63, 0x36, 0x32, 0x35, 0x2d, 0x64, 0x31, 0x35, 0x35, 0x2d, 0x32, 0x33, 0x34, 0x65, 0x2d, 0x66, 0x31, 0x34, 0x37, 0x2d, 0x63, 0x66, 0x30, 0x61, 0x38, 0x62, 0x39, 0x61, 0x33, 0x31, 0x36, 0x37}, {0x62, 0x37, 0x66, 0x32, 0x35, 0x39, 0x32, 0x33, 0x2d, 0x34, 0x32, 0x37, 0x65, 0x2d, 0x31, 0x32, 0x64, 0x37, 0x2d, 0x63, 0x32, 0x34, 0x65, 0x2d, 0x35, 0x32, 0x61, 0x36, 0x33, 0x63, 0x32, 0x30, 0x66, 0x65, 0x34, 0x63}}},
	{"[][]uint8", "93da002439303837333634312d306437622d323466302d396361392d656462396134386634376432da002433396261646636342d663433662d366638312d343366622d303530613463343434613361da002430343132396665312d666430612d613139312d393666652d643265626263636531663162", [][]uint8{{0x39, 0x30, 0x38, 0x37, 0x33, 0x36, 0x34, 0x31, 0x2d, 0x30, 0x64, 0x37, 0x62, 0x2d, 0x32, 0x34, 0x66, 0x30, 0x2d, 0x39, 0x63, 0x61, 0x39, 0x2d, 0x65, 0x64, 0x62, 0x39, 0x61, 0x34, 0x38, 0x66, 0x34, 0x37, 0x64, 0x32}, {0x33, 0x39, 0x62, 0x61, 0x64, 0x66, 0x36, 0x34, 0x2d, 0x66, 0x34, 0x33, 0x66, 0x2d, 0x36, 0x66, 0x38, 0x31, 0x2d, 0x34, 0x33, 0x66, 0x62, 0x2d, 0x30, 0x35, 0x30, 0x61, 0x34, 0x63, 0x34, 0x34, 0x34, 0x61, 0x33, 0x61}, {0x30, 0x34, 0x31, 0x32, 0x39, 0x66, 0x65, 0x31, 0x2d, 0x66, 0x64, 0x30, 0x61, 0x2d, 0x61, 0x31, 0x39, 0x31, 0x2d, 0x39, 0x36, 0x66, 0x65, 0x2d, 0x64, 0x32, 0x65, 0x62, 0x62, 0x63, 0x63, 0x65, 0x31, 0x66, 0x31, 0x62}}},
	{"[][]uint8", "93da002439323163383264662d663030392d666364642d343265302d343435333434393966646230da002464323436643666392d656164352d633637372d343331352d353732356262636631373062da002436613061313237332d656533322d643965392d396661362d356162346434373132376164", [][]uint8{{0x39, 0x32, 0x31, 0x63, 0x38, 0x32, 0x64, 0x66, 0x2d, 0x66, 0x30, 0x30, 0x39, 0x2d, 0x66, 0x63, 0x64, 0x64, 0x2d, 0x34, 0x32, 0x65, 0x30, 0x2d, 0x34, 0x34, 0x35, 0x33, 0x34, 0x34, 0x39, 0x39, 0x66, 0x64, 0x62, 0x30}, {0x64, 0x32, 0x34, 0x36, 0x64, 0x36, 0x66, 0x39, 0x2d, 0x65, 0x61, 0x64, 0x35, 0x2d, 0x63, 0x36, 0x37, 0x37, 0x2d, 0x34, 0x33, 0x31, 0x35, 0x2d, 0x35, 0x37, 0x32, 0x35, 0x62, 0x62, 0x63, 0x66, 0x31, 0x37, 0x30, 0x62}, {0x36, 0x61, 0x30, 0x61, 0x31, 0x32, 0x37, 0x33, 0x2d, 0x65, 0x65, 0x33, 0x32, 0x2d, 0x64, 0x39, 0x65, 0x39, 0x2d, 0x39, 0x66, 0x61, 0x36, 0x2d, 0x35, 0x61, 0x62, 0x34, 0x64, 0x34, 0x37, 0x31, 0x32, 0x37, 0x61, 0x64}}},
	{"[][]uint8", "93da002439323233666434392d356435612d626561362d356561382d306236336631303663396263da002462353662353432332d306661392d646438662d316536352d643765393165396662353362da002438633532313139382d326430632d623137372d643737392d636363636132323135346533", [][]uint8{{0x39, 0x32, 0x32, 0x33, 0x66, 0x64, 0x34, 0x39, 0x2d, 0x35, 0x64, 0x35, 0x61, 0x2d, 0x62, 0x65, 0x61, 0x36, 0x2d, 0x35, 0x65, 0x61, 0x38, 0x2d, 0x30, 0x62, 0x36, 0x33, 0x66, 0x31, 0x30, 0x36, 0x63, 0x39, 0x62, 0x63}, {0x62, 0x35, 0x36, 0x62, 0x35, 0x34, 0x32, 0x33, 0x2d, 0x30, 0x66, 0x61, 0x39, 0x2d, 0x64, 0x64, 0x38, 0x66, 0x2d, 0x31, 0x65, 0x36, 0x35, 0x2d, 0x64, 0x37, 0x65, 0x39, 0x31, 0x65, 0x39, 0x66, 0x62, 0x35, 0x33, 0x62}, {0x38, 0x63, 0x35, 0x32, 0x31, 0x31, 0x39, 0x38, 0x2d, 0x32, 0x64, 0x30, 0x63, 0x2d, 0x62, 0x31, 0x37, 0x37, 0x2d, 0x64, 0x37, 0x37, 0x39, 0x2d, 0x63, 0x63, 0x63, 0x63, 0x61, 0x32, 0x32, 0x31, 0x35, 0x34, 0x65, 0x33}}},
	{"[][]uint8", "93da002462323330346432632d373935322d646230662d373633342d323466636133636361353635da002464353930303766382d363036312d636462632d616330302d373061376233393065653362da002435336434306233652d396662332d396335362d636637372d636432323862376337363136", [][]uint8{{0x62, 0x32, 0x33, 0x30, 0x34, 0x64, 0x32, 0x63, 0x2d, 0x37, 0x39, 0x35, 0x32, 0x2d, 0x64, 0x62, 0x30, 0x66, 0x2d, 0x37, 0x36, 0x33, 0x34, 0x2d, 0x32, 0x34, 0x66, 0x63, 0x61, 0x33, 0x63, 0x63, 0x61, 0x35, 0x36, 0x35}, {0x64, 0x35, 0x39, 0x30, 0x30, 0x37, 0x66, 0x38, 0x2d, 0x36, 0x30, 0x36, 0x31, 0x2d, 0x63, 0x64, 0x62, 0x63, 0x2d, 0x61, 0x63, 0x30, 0x30, 0x2d, 0x37, 0x30, 0x61, 0x37, 0x62, 0x33, 0x39, 0x30, 0x65, 0x65, 0x33, 0x62}, {0x35, 0x33, 0x64, 0x34, 0x30, 0x62, 0x33, 0x65, 0x2d, 0x39, 0x66, 0x62, 0x33, 0x2d, 0x39, 0x63, 0x35, 0x36, 0x2d, 0x63, 0x66, 0x37, 0x37, 0x2d, 0x63, 0x64, 0x32, 0x32, 0x38, 0x62, 0x37, 0x63, 0x37, 0x36, 0x31, 0x36}}},
	{"[][]uint8", "93da002463633965666231312d646133632d363566322d363461662d363630613230383536623064da002431626438626436312d653632612d323866382d623931352d663465333738383832646361da002466666135316265382d623830332d623436642d633230372d326330363965346164633338", [][]uint8{{0x63, 0x63, 0x39, 0x65, 0x66, 0x62, 0x31, 0x31, 0x2d, 0x64, 0x61, 0x33, 0x63, 0x2d, 0x36, 0x35, 0x66, 0x32, 0x2d, 0x36, 0x34, 0x61, 0x66, 0x2d, 0x36, 0x36, 0x30, 0x61, 0x32, 0x30, 0x38, 0x35, 0x36, 0x62, 0x30, 0x64}, {0x31, 0x62, 0x64, 0x38, 0x62, 0x64, 0x36, 0x31, 0x2d, 0x65, 0x36, 0x32, 0x61, 0x2d, 0x32, 0x38, 0x66, 0x38, 0x2d, 0x62, 0x39, 0x31, 0x35, 0x2d, 0x66, 0x34, 0x65, 0x33, 0x37, 0x38, 0x38, 0x38, 0x32, 0x64, 0x63, 0x61}, {0x66, 0x66, 0x61, 0x35, 0x31, 0x62, 0x65, 0x38, 0x2d, 0x62, 0x38, 0x30, 0x33, 0x2d, 0x62, 0x34, 0x36, 0x64, 0x2d, 0x63, 0x32, 0x30, 0x37, 0x2d, 0x32, 0x63, 0x30, 0x36, 0x39, 0x65, 0x34, 0x61, 0x64, 0x63, 0x33, 0x38}}},
	{"[][]uint8", "93da002465636162643261372d303263352d656231632d653765362d363866393366326437353066da002462373431343035662d663131622d353434332d383064352d333032346637353863373532da002436343432623834332d386165622d363734612d626432312d633639363634643631383364", [][]uint8{{0x65, 0x63, 0x61, 0x62, 0x64, 0x32, 0x61, 0x37, 0x2d, 0x30, 0x32, 0x63, 0x35, 0x2d, 0x65, 0x62, 0x31, 0x63, 0x2d, 0x65, 0x37, 0x65, 0x36, 0x2d, 0x36, 0x38, 0x66, 0x39, 0x33, 0x66, 0x32, 0x64, 0x37, 0x35, 0x30, 0x66}, {0x62, 0x37, 0x34, 0x31, 0x34, 0x30, 0x35, 0x66, 0x2d, 0x66, 0x31, 0x31, 0x62, 0x2d, 0x35, 0x34, 0x34, 0x33, 0x2d, 0x38, 0x30, 0x64, 0x35, 0x2d, 0x33, 0x30, 0x32, 0x34, 0x66, 0x37, 0x35, 0x38, 0x63, 0x37, 0x35, 0x32}, {0x36, 0x34, 0x34, 0x32, 0x62, 0x38, 0x34, 0x33, 0x2d, 0x38, 0x61, 0x65, 0x62, 0x2d, 0x36, 0x37, 0x34, 0x61, 0x2d, 0x62, 0x64, 0x32, 0x31, 0x2d, 0x63, 0x36, 0x39, 0x36, 0x36, 0x34, 0x64, 0x36, 0x31, 0x38, 0x33, 0x64}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002431323732353061632d636139342d623639332d353766362d393235306631383739666531a24944da002b7365727665722d31323732353061632d636139342d623639332d353766362d393235306631383739666531a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-127250ac-ca94-b693-57f6-9250f1879fe1", Address: "127250ac-ca94-b693-57f6-9250f1879fe1"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002431623434656164362d663437662d343536372d393766652d323035393439303065633066a24944da002b7365727665722d31623434656164362d663437662d343536372d393766652d323035393439303065633066a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-1b44ead6-f47f-4567-97fe-20594900ec0f", Address: "1b44ead6-f47f-4567-97fe-20594900ec0f"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002432366430393865632d633831642d666434342d353831372d653465323030336362303164a24944da002b7365727665722d32366430393865632d633831642d666434342d353831372d653465323030336362303164a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-26d098ec-c81d-fd44-5817-e4e2003cb01d", Address: "26d098ec-c81d-fd44-5817-e4e2003cb01d"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002432383133306162382d646462642d346466342d386163642d616533626363656230393466a24944da002b7365727665722d32383133306162382d646462642d346466342d386163642d616533626363656230393466a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-28130ab8-ddbd-4df4-8acd-ae3bcceb094f", Address: "28130ab8-ddbd-4df4-8acd-ae3bcceb094f"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002433633362323766612d626633362d303064332d303466632d353335613564663538653730a24944da002b7365727665722d33633362323766612d626633362d303064332d303466632d353335613564663538653730a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-3c3b27fa-bf36-00d3-04fc-535a5df58e70", Address: "3c3b27fa-bf36-00d3-04fc-535a5df58e70"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002433663135326263622d316336342d323733332d346463362d613633326464393263656630a24944da002b7365727665722d33663135326263622d316336342d323733332d346463362d613633326464393263656630a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-3f152bcb-1c64-2733-4dc6-a632dd92cef0", Address: "3f152bcb-1c64-2733-4dc6-a632dd92cef0"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002436303161393966612d663138372d313761302d616335392d666136303437386336626464a24944da002b7365727665722d36303161393966612d663138372d313761302d616335392d666136303437386336626464a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-601a99fa-f187-17a0-ac59-fa60478c6bdd", Address: "601a99fa-f187-17a0-ac59-fa60478c6bdd"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002436353330376639382d383438312d363961652d306537652d633734326266616130356362a24944da002b7365727665722d36353330376639382d383438312d363961652d306537652d633734326266616130356362a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-65307f98-8481-69ae-0e7e-c742bfaa05cb", Address: "65307f98-8481-69ae-0e7e-c742bfaa05cb"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002439643533396536312d303631322d313062622d623331642d393339663238343764653761a24944da002b7365727665722d39643533396536312d303631322d313062622d623331642d393339663238343764653761a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-9d539e61-0612-10bb-b31d-939f2847de7a", Address: "9d539e61-0612-10bb-b31d-939f2847de7a"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002461356133353863342d613632392d313638322d396364662d316533636264396262623935a24944da002b7365727665722d61356133353863342d613632392d313638322d396364662d316533636264396262623935a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-a5a358c4-a629-1682-9cdf-1e3cbd9bbb95", Address: "a5a358c4-a629-1682-9cdf-1e3cbd9bbb95"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002462323665343734342d623534662d643064332d366237382d376334326134316537616638a24944da002b7365727665722d62323665343734342d623534662d643064332d366237382d376334326134316537616638a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-b26e4744-b54f-d0d3-6b78-7c42a41e7af8", Address: "b26e4744-b54f-d0d3-6b78-7c42a41e7af8"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002464306431313435352d656261352d633764372d373166352d323034313133353633633237a24944da002b7365727665722d64306431313435352d656261352d633764372d373166352d323034313133353633633237a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-d0d11455-eba5-c7d7-71f5-204113563c27", Address: "d0d11455-eba5-c7d7-71f5-204113563c27"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002464323039313162632d336664312d653136652d346230382d313439616531373664323534a24944da002b7365727665722d64323039313162632d336664312d653136652d346230382d313439616531373664323534a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-d20911bc-3fd1-e16e-4b08-149ae176d254", Address: "d20911bc-3fd1-e16e-4b08-149ae176d254"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002464656338346137322d386335352d316539642d343534382d666438656165393538363930a24944da002b7365727665722d64656338346137322d386335352d316539642d343534382d666438656165393538363930a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-dec84a72-8c55-1e9d-4548-fd8eae958690", Address: "dec84a72-8c55-1e9d-4548-fd8eae958690"}}}},
	{"Configuration", "81a7536572766572739183a741646472657373da002464656532396439332d363638342d386135342d373232632d396536643466376439666162a24944da002b7365727665722d64656532396439332d363638342d386135342d373232632d396536643466376439666162a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-dee29d93-6684-8a54-722c-9e6d4f7d9fab", Address: "dee29d93-6684-8a54-722c-9e6d4f7d9fab"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002430373366356632362d613033352d353337312d663637322d656431616564346134366431a24944da002b7365727665722d30373366356632362d613033352d353337312d663637322d656431616564346134366431a853756666726167650083a741646472657373da002466343633336563322d343063312d313538362d643264632d613562316165316364353465a24944da002b7365727665722d66343633336563322d343063312d313538362d643264632d613562316165316364353465a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-073f5f26-a035-5371-f672-ed1aed4a46d1", Address: "073f5f26-a035-5371-f672-ed1aed4a46d1"}, {Suffrage: 0, ID: "server-f4633ec2-40c1-1586-d2dc-a5b1ae1cd54e", Address: "f4633ec2-40c1-1586-d2dc-a5b1ae1cd54e"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002430373366356632362d613033352d353337312d663637322d656431616564346134366431a24944da002b7365727665722d30373366356632362d613033352d353337312d663637322d656431616564346134366431a853756666726167650183a741646472657373da002466343633336563322d343063312d313538362d643264632d613562316165316364353465a24944da002b7365727665722d66343633336563322d343063312d313538362d643264632d613562316165316364353465a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 1, ID: "server-073f5f26-a035-5371-f672-ed1aed4a46d1", Address: "073f5f26-a035-5371-f672-ed1aed4a46d1"}, {Suffrage: 0, ID: "server-f4633ec2-40c1-1586-d2dc-a5b1ae1cd54e", Address: "f4633ec2-40c1-1586-d2dc-a5b1ae1cd54e"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002432366465386561352d316439362d383637312d636166642d616563656265386631323534a24944da002b7365727665722d32366465386561352d316439362d383637312d636166642d616563656265386631323534a853756666726167650083a741646472657373da002433616437306261332d643236632d363935372d336366372d386166356663393133303736a24944da002b7365727665722d33616437306261332d643236632d363935372d336366372d386166356663393133303736a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-26de8ea5-1d96-8671-cafd-aecebe8f1254", Address: "26de8ea5-1d96-8671-cafd-aecebe8f1254"}, {Suffrage: 0, ID: "server-3ad70ba3-d26c-6957-3cf7-8af5fc913076", Address: "3ad70ba3-d26c-6957-3cf7-8af5fc913076"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002432636533363063392d623434312d616262322d353130342d613939323835366163373930a24944da002b7365727665722d32636533363063392d623434312d616262322d353130342d613939323835366163373930a853756666726167650083a741646472657373da002438333832666137312d623866662d313262312d323135352d663132323765643565393865a24944da002b7365727665722d38333832666137312d623866662d313262312d323135352d663132323765643565393865a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-2ce360c9-b441-abb2-5104-a992856ac790", Address: "2ce360c9-b441-abb2-5104-a992856ac790"}, {Suffrage: 0, ID: "server-8382fa71-b8ff-12b1-2155-f1227ed5e98e", Address: "8382fa71-b8ff-12b1-2155-f1227ed5e98e"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002433313534623830372d393731352d633530652d613131632d633537643034333837313837a24944da002b7365727665722d33313534623830372d393731352d633530652d613131632d633537643034333837313837a853756666726167650083a741646472657373da002437373361373232662d306232622d616530312d356565642d343930633434656364653338a24944da002b7365727665722d37373361373232662d306232622d616530312d356565642d343930633434656364653338a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-3154b807-9715-c50e-a11c-c57d04387187", Address: "3154b807-9715-c50e-a11c-c57d04387187"}, {Suffrage: 0, ID: "server-773a722f-0b2b-ae01-5eed-490c44ecde38", Address: "773a722f-0b2b-ae01-5eed-490c44ecde38"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002433376263323134622d313635342d396263342d336639332d373337396130666338373035a24944da002b7365727665722d33376263323134622d313635342d396263342d336639332d373337396130666338373035a853756666726167650083a741646472657373da002438383764356161622d666637612d666132302d353039382d363466663937313532613530a24944da002b7365727665722d38383764356161622d666637612d666132302d353039382d363466663937313532613530a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-37bc214b-1654-9bc4-3f93-7379a0fc8705", Address: "37bc214b-1654-9bc4-3f93-7379a0fc8705"}, {Suffrage: 0, ID: "server-887d5aab-ff7a-fa20-5098-64ff97152a50", Address: "887d5aab-ff7a-fa20-5098-64ff97152a50"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002434303365353739632d346565342d646337392d663839382d336136316666626138393434a24944da002b7365727665722d34303365353739632d346565342d646337392d663839382d336136316666626138393434a853756666726167650083a741646472657373da002431636466383532362d333338392d613564622d383730322d613562366161643938306633a24944da002b7365727665722d31636466383532362d333338392d613564622d383730322d613562366161643938306633a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-403e579c-4ee4-dc79-f898-3a61ffba8944", Address: "403e579c-4ee4-dc79-f898-3a61ffba8944"}, {Suffrage: 0, ID: "server-1cdf8526-3389-a5db-8702-a5b6aad980f3", Address: "1cdf8526-3389-a5db-8702-a5b6aad980f3"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002434373937383631392d613637372d326239662d366430312d633133366438356437626230a24944da002b7365727665722d34373937383631392d613637372d326239662d366430312d633133366438356437626230a853756666726167650083a741646472657373da002465346665323936392d366334332d613938662d313562362d653662396234623032353438a24944da002b7365727665722d65346665323936392d366334332d613938662d313562362d653662396234623032353438a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-47978619-a677-2b9f-6d01-c136d85d7bb0", Address: "47978619-a677-2b9f-6d01-c136d85d7bb0"}, {Suffrage: 0, ID: "server-e4fe2969-6c43-a98f-15b6-e6b9b4b02548", Address: "e4fe2969-6c43-a98f-15b6-e6b9b4b02548"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002435356237616435332d313661642d356465302d313330352d383737393837353630636133a24944da002b7365727665722d35356237616435332d313661642d356465302d313330352d383737393837353630636133a853756666726167650083a741646472657373da002436323065666366362d663037322d653432372d653937302d613464373566353030316434a24944da002b7365727665722d36323065666366362d663037322d653432372d653937302d613464373566353030316434a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-55b7ad53-16ad-5de0-1305-877987560ca3", Address: "55b7ad53-16ad-5de0-1305-877987560ca3"}, {Suffrage: 0, ID: "server-620efcf6-f072-e427-e970-a4d75f5001d4", Address: "620efcf6-f072-e427-e970-a4d75f5001d4"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002439333135643431322d346165342d656438372d363563392d646362646337653636626663a24944da002b7365727665722d39333135643431322d346165342d656438372d363563392d646362646337653636626663a853756666726167650083a741646472657373da002438373065633531622d363439312d343337352d633862322d376262303130336630376665a24944da002b7365727665722d38373065633531622d363439312d343337352d633862322d376262303130336630376665a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-9315d412-4ae4-ed87-65c9-dcbdc7e66bfc", Address: "9315d412-4ae4-ed87-65c9-dcbdc7e66bfc"}, {Suffrage: 0, ID: "server-870ec51b-6491-4375-c8b2-7bb0103f07fe", Address: "870ec51b-6491-4375-c8b2-7bb0103f07fe"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002439333933393839612d343032332d656434622d636233312d386662623264376262646334a24944da002439333933393839612d343032332d656434622d636233312d386662623264376262646334a853756666726167650083a741646472657373da002464316262393336322d613464632d623936362d353262322d366265616237323532626666a24944da002b7365727665722d64316262393336322d613464632d623936362d353262322d366265616237323532626666a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "9393989a-4023-ed4b-cb31-8fbb2d7bbdc4", Address: "9393989a-4023-ed4b-cb31-8fbb2d7bbdc4"}, {Suffrage: 0, ID: "server-d1bb9362-a4dc-b966-52b2-6beab7252bff", Address: "d1bb9362-a4dc-b966-52b2-6beab7252bff"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002439643533396536312d303631322d313062622d623331642d393339663238343764653761a24944da002b7365727665722d39643533396536312d303631322d313062622d623331642d393339663238343764653761a853756666726167650083a741646472657373da002462383864646231332d346363642d653663372d343236322d666431623333623635666664a24944da002b7365727665722d62383864646231332d346363642d653663372d343236322d666431623333623635666664a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-9d539e61-0612-10bb-b31d-939f2847de7a", Address: "9d539e61-0612-10bb-b31d-939f2847de7a"}, {Suffrage: 0, ID: "server-b88ddb13-4ccd-e6c7-4262-fd1b33b65ffd", Address: "b88ddb13-4ccd-e6c7-4262-fd1b33b65ffd"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002461633566366434332d636335362d306539642d323331632d653562656536626430363066a24944da002b7365727665722d61633566366434332d636335362d306539642d323331632d653562656536626430363066a853756666726167650083a741646472657373da002461626635626536352d373938642d643238632d653432372d653234366335653061316131a24944da002b7365727665722d61626635626536352d373938642d643238632d653432372d653234366335653061316131a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-ac5f6d43-cc56-0e9d-231c-e5bee6bd060f", Address: "ac5f6d43-cc56-0e9d-231c-e5bee6bd060f"}, {Suffrage: 0, ID: "server-abf5be65-798d-d28c-e427-e246c5e0a1a1", Address: "abf5be65-798d-d28c-e427-e246c5e0a1a1"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002464306364623931632d323736372d633536332d646563372d383665343761366663663639a24944da002b7365727665722d64306364623931632d323736372d633536332d646563372d383665343761366663663639a853756666726167650083a741646472657373da002439333561633064652d323335632d303439382d366131362d393066326562663363613737a24944da002b7365727665722d39333561633064652d323335632d303439382d366131362d393066326562663363613737a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-d0cdb91c-2767-c563-dec7-86e47a6fcf69", Address: "d0cdb91c-2767-c563-dec7-86e47a6fcf69"}, {Suffrage: 0, ID: "server-935ac0de-235c-0498-6a16-90f2ebf3ca77", Address: "935ac0de-235c-0498-6a16-90f2ebf3ca77"}}}},
	{"Configuration", "81a7536572766572739283a741646472657373da002464663435336632342d343531352d626166632d613835622d663038313536323337346465a24944da002b7365727665722d64663435336632342d343531352d626166632d613835622d663038313536323337346465a853756666726167650083a741646472657373da002438656438363762632d393265622d656332352d653430392d383434633461386530663637a24944da002b7365727665722d38656438363762632d393265622d656332352d653430392d383434633461386530663637a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-df453f24-4515-bafc-a85b-f081562374de", Address: "df453f24-4515-bafc-a85b-f081562374de"}, {Suffrage: 0, ID: "server-8ed867bc-92eb-ec25-e409-844c4a8e0f67", Address: "8ed867bc-92eb-ec25-e409-844c4a8e0f67"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373a56164647230a24944a3696430a853756666726167650183a741646472657373a56164647231a24944a3696431a853756666726167650083a741646472657373a56164647232a24944a3696432a8537566667261676502", Configuration{Servers: []Server{{Suffrage: 1, ID: "id0", Address: "addr0"}, {Suffrage: 0, ID: "id1", Address: "addr1"}, {Suffrage: 2, ID: "id2", Address: "addr2"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002430313131383936652d636239302d326561342d643865342d363738393063353461613134a24944da002b7365727665722d30313131383936652d636239302d326561342d643865342d363738393063353461613134a853756666726167650083a741646472657373da002437363461613735302d326363332d643233372d323336622d373235313534376433366532a24944da002b7365727665722d37363461613735302d326363332d643233372d323336622d373235313534376433366532a853756666726167650083a741646472657373da002437656231383366332d313638362d323539312d376131632d333035396532643038303538a24944da002b7365727665722d37656231383366332d313638362d323539312d376131632d333035396532643038303538a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-0111896e-cb90-2ea4-d8e4-67890c54aa14", Address: "0111896e-cb90-2ea4-d8e4-67890c54aa14"}, {Suffrage: 0, ID: "server-764aa750-2cc3-d237-236b-7251547d36e2", Address: "764aa750-2cc3-d237-236b-7251547d36e2"}, {Suffrage: 0, ID: "server-7eb183f3-1686-2591-7a1c-3059e2d08058", Address: "7eb183f3-1686-2591-7a1c-3059e2d08058"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002430383139313863302d393034382d656564622d623365352d303839326566333938636161a24944da002b7365727665722d30383139313863302d393034382d656564622d623365352d303839326566333938636161a853756666726167650083a741646472657373da002464663435336632342d343531352d626166632d613835622d663038313536323337346465a24944da002b7365727665722d64663435336632342d343531352d626166632d613835622d663038313536323337346465a853756666726167650083a741646472657373da002438656438363762632d393265622d656332352d653430392d383434633461386530663637a24944da002b7365727665722d38656438363762632d393265622d656332352d653430392d383434633461386530663637a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-081918c0-9048-eedb-b3e5-0892ef398caa", Address: "081918c0-9048-eedb-b3e5-0892ef398caa"}, {Suffrage: 0, ID: "server-df453f24-4515-bafc-a85b-f081562374de", Address: "df453f24-4515-bafc-a85b-f081562374de"}, {Suffrage: 0, ID: "server-8ed867bc-92eb-ec25-e409-844c4a8e0f67", Address: "8ed867bc-92eb-ec25-e409-844c4a8e0f67"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002431356666346563612d623733382d323832342d623933632d666336633533313831313236a24944da002b7365727665722d31356666346563612d623733382d323832342d623933632d666336633533313831313236a853756666726167650083a741646472657373da002463646330346335662d633661392d643332612d616361372d616566623832623065393032a24944da002b7365727665722d63646330346335662d633661392d643332612d616361372d616566623832623065393032a853756666726167650083a741646472657373da002431393731646234382d393061622d636134312d343339662d653162396332316134336639a24944da002b7365727665722d31393731646234382d393061622d636134312d343339662d653162396332316134336639a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-15ff4eca-b738-2824-b93c-fc6c53181126", Address: "15ff4eca-b738-2824-b93c-fc6c53181126"}, {Suffrage: 0, ID: "server-cdc04c5f-c6a9-d32a-aca7-aefb82b0e902", Address: "cdc04c5f-c6a9-d32a-aca7-aefb82b0e902"}, {Suffrage: 0, ID: "server-1971db48-90ab-ca41-439f-e1b9c21a43f9", Address: "1971db48-90ab-ca41-439f-e1b9c21a43f9"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002431663361383436652d323636392d336231372d666230322d393934663133646466306130a24944da002b7365727665722d31663361383436652d323636392d336231372d666230322d393934663133646466306130a853756666726167650083a741646472657373da002437343534356430392d626331662d353934382d636362302d366561393131313237623238a24944da002b7365727665722d37343534356430392d626331662d353934382d636362302d366561393131313237623238a853756666726167650083a741646472657373da002432373838663736372d626633352d346534332d306638322d666535303064616539613861a24944da002b7365727665722d32373838663736372d626633352d346534332d306638322d666535303064616539613861a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-1f3a846e-2669-3b17-fb02-994f13ddf0a0", Address: "1f3a846e-2669-3b17-fb02-994f13ddf0a0"}, {Suffrage: 0, ID: "server-74545d09-bc1f-5948-ccb0-6ea911127b28", Address: "74545d09-bc1f-5948-ccb0-6ea911127b28"}, {Suffrage: 0, ID: "server-2788f767-bf35-4e43-0f82-fe500dae9a8a", Address: "2788f767-bf35-4e43-0f82-fe500dae9a8a"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002432316230623939642d323838662d633765632d643835612d653637663163393335666234a24944da002b7365727665722d32316230623939642d323838662d633765632d643835612d653637663163393335666234a853756666726167650083a741646472657373da002434633330373662322d656364652d373764312d623464392d613163346532306163383438a24944da002b7365727665722d34633330373662322d656364652d373764312d623464392d613163346532306163383438a853756666726167650083a741646472657373da002464383264313638332d323630322d323937332d653265322d386361333836386339326565a24944da002b7365727665722d64383264313638332d323630322d323937332d653265322d386361333836386339326565a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-21b0b99d-288f-c7ec-d85a-e67f1c935fb4", Address: "21b0b99d-288f-c7ec-d85a-e67f1c935fb4"}, {Suffrage: 0, ID: "server-4c3076b2-ecde-77d1-b4d9-a1c4e20ac848", Address: "4c3076b2-ecde-77d1-b4d9-a1c4e20ac848"}, {Suffrage: 0, ID: "server-d82d1683-2602-2973-e2e2-8ca3868c92ee", Address: "d82d1683-2602-2973-e2e2-8ca3868c92ee"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002432333963613733632d313231352d643630382d326438372d326365346463623033316535a24944da002b7365727665722d32333963613733632d313231352d643630382d326438372d326365346463623033316535a853756666726167650083a741646472657373da002461303834336634362d666331302d376133342d393335342d343032636261663465356532a24944da002b7365727665722d61303834336634362d666331302d376133342d393335342d343032636261663465356532a853756666726167650083a741646472657373da002434386439663063642d656437312d363431642d633939632d636439366266323935346639a24944da002b7365727665722d34386439663063642d656437312d363431642d633939632d636439366266323935346639a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-239ca73c-1215-d608-2d87-2ce4dcb031e5", Address: "239ca73c-1215-d608-2d87-2ce4dcb031e5"}, {Suffrage: 0, ID: "server-a0843f46-fc10-7a34-9354-402cbaf4e5e2", Address: "a0843f46-fc10-7a34-9354-402cbaf4e5e2"}, {Suffrage: 0, ID: "server-48d9f0cd-ed71-641d-c99c-cd96bf2954f9", Address: "48d9f0cd-ed71-641d-c99c-cd96bf2954f9"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002432353534356661352d353364302d333339622d376238342d303938393232343136313833a24944da002b7365727665722d32353534356661352d353364302d333339622d376238342d303938393232343136313833a853756666726167650083a741646472657373da002439353966373730632d626262392d643936322d376638312d323230626136303165636134a24944da002b7365727665722d39353966373730632d626262392d643936322d376638312d323230626136303165636134a853756666726167650083a741646472657373da002430396532393638332d323761632d366465622d633231392d396266303763306565353735a24944da002b7365727665722d30396532393638332d323761632d366465622d633231392d396266303763306565353735a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-25545fa5-53d0-339b-7b84-098922416183", Address: "25545fa5-53d0-339b-7b84-098922416183"}, {Suffrage: 0, ID: "server-959f770c-bbb9-d962-7f81-220ba601eca4", Address: "959f770c-bbb9-d962-7f81-220ba601eca4"}, {Suffrage: 0, ID: "server-09e29683-27ac-6deb-c219-9bf07c0ee575", Address: "09e29683-27ac-6deb-c219-9bf07c0ee575"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002432613166656562652d323965632d333732612d323961362d383962383764366166653163a24944da002b7365727665722d32613166656562652d323965632d333732612d323961362d383962383764366166653163a853756666726167650083a741646472657373da002435373237353036392d626232662d613466352d613833352d643133613865393735363432a24944da002b7365727665722d35373237353036392d626232662d613466352d613833352d643133613865393735363432a853756666726167650083a741646472657373da002433633237306337632d366131312d383934612d666230342d383661653730356333653361a24944da002b7365727665722d33633237306337632d366131312d383934612d666230342d383661653730356333653361a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-2a1feebe-29ec-372a-29a6-89b87d6afe1c", Address: "2a1feebe-29ec-372a-29a6-89b87d6afe1c"}, {Suffrage: 0, ID: "server-57275069-bb2f-a4f5-a835-d13a8e975642", Address: "57275069-bb2f-a4f5-a835-d13a8e975642"}, {Suffrage: 0, ID: "server-3c270c7c-6a11-894a-fb04-86ae705c3e3a", Address: "3c270c7c-6a11-894a-fb04-86ae705c3e3a"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002432636533363063392d623434312d616262322d353130342d613939323835366163373930a24944da002b7365727665722d32636533363063392d623434312d616262322d353130342d613939323835366163373930a853756666726167650083a741646472657373da002438333832666137312d623866662d313262312d323135352d663132323765643565393865a24944da002b7365727665722d38333832666137312d623866662d313262312d323135352d663132323765643565393865a853756666726167650083a741646472657373da002466656338643234662d613230352d663365662d353661362d383332343962613430323864a24944da002b7365727665722d66656338643234662d613230352d663365662d353661362d383332343962613430323864a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-2ce360c9-b441-abb2-5104-a992856ac790", Address: "2ce360c9-b441-abb2-5104-a992856ac790"}, {Suffrage: 0, ID: "server-8382fa71-b8ff-12b1-2155-f1227ed5e98e", Address: "8382fa71-b8ff-12b1-2155-f1227ed5e98e"}, {Suffrage: 0, ID: "server-fec8d24f-a205-f3ef-56a6-83249ba4028d", Address: "fec8d24f-a205-f3ef-56a6-83249ba4028d"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002433333930393633612d653465622d613538342d313739332d333632306236303137306435a24944da002b7365727665722d33333930393633612d653465622d613538342d313739332d333632306236303137306435a853756666726167650083a741646472657373da002464366539336336342d666336302d633965622d656165652d623362306238623563333062a24944da002b7365727665722d64366539336336342d666336302d633965622d656165652d623362306238623563333062a853756666726167650083a741646472657373da002430353463343638652d643535342d393633652d643831382d386432653438393436303438a24944da002b7365727665722d30353463343638652d643535342d393633652d643831382d386432653438393436303438a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-3390963a-e4eb-a584-1793-3620b60170d5", Address: "3390963a-e4eb-a584-1793-3620b60170d5"}, {Suffrage: 0, ID: "server-d6e93c64-fc60-c9eb-eaee-b3b0b8b5c30b", Address: "d6e93c64-fc60-c9eb-eaee-b3b0b8b5c30b"}, {Suffrage: 0, ID: "server-054c468e-d554-963e-d818-8d2e48946048", Address: "054c468e-d554-963e-d818-8d2e48946048"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002433623832666639302d616634632d376231662d383032302d663830366135313561636566a24944da002b7365727665722d33623832666639302d616634632d376231662d383032302d663830366135313561636566a853756666726167650083a741646472657373da002464653434346439372d333231612d333839332d623136332d636635613036343530643638a24944da002b7365727665722d64653434346439372d333231612d333839332d623136332d636635613036343530643638a853756666726167650083a741646472657373da002431613139313238662d306439392d626431312d343433632d623065656538616264383363a24944da002b7365727665722d31613139313238662d306439392d626431312d343433632d623065656538616264383363a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-3b82ff90-af4c-7b1f-8020-f806a515acef", Address: "3b82ff90-af4c-7b1f-8020-f806a515acef"}, {Suffrage: 0, ID: "server-de444d97-321a-3893-b163-cf5a06450d68", Address: "de444d97-321a-3893-b163-cf5a06450d68"}, {Suffrage: 0, ID: "server-1a19128f-0d99-bd11-443c-b0eee8abd83c", Address: "1a19128f-0d99-bd11-443c-b0eee8abd83c"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002434303762333766362d313266332d613764362d363834622d366365616636373262303964a24944da002b7365727665722d34303762333766362d313266332d613764362d363834622d366365616636373262303964a853756666726167650083a741646472657373da002436353763663464392d313966332d396232662d353063312d313936373462646530616562a24944da002b7365727665722d36353763663464392d313966332d396232662d353063312d313936373462646530616562a853756666726167650083a741646472657373da002434653539626236392d656535612d613737652d643736362d383361613235636361396238a24944da002b7365727665722d34653539626236392d656535612d613737652d643736362d383361613235636361396238a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-407b37f6-12f3-a7d6-684b-6ceaf672b09d", Address: "407b37f6-12f3-a7d6-684b-6ceaf672b09d"}, {Suffrage: 0, ID: "server-657cf4d9-19f3-9b2f-50c1-19674bde0aeb", Address: "657cf4d9-19f3-9b2f-50c1-19674bde0aeb"}, {Suffrage: 0, ID: "server-4e59bb69-ee5a-a77e-d766-83aa25cca9b8", Address: "4e59bb69-ee5a-a77e-d766-83aa25cca9b8"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002434373132653638322d376534662d353430612d386536362d336663396336666364343563a24944da002b7365727665722d34373132653638322d376534662d353430612d386536362d336663396336666364343563a853756666726167650083a741646472657373da002431653736396163372d343936652d623265312d306261312d333031373036633464343061a24944da002b7365727665722d31653736396163372d343936652d623265312d306261312d333031373036633464343061a853756666726167650083a741646472657373da002437656333643931622d363632392d303163392d353737662d616636303739386563306433a24944da002b7365727665722d37656333643931622d363632392d303163392d353737662d616636303739386563306433a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-4712e682-7e4f-540a-8e66-3fc9c6fcd45c", Address: "4712e682-7e4f-540a-8e66-3fc9c6fcd45c"}, {Suffrage: 0, ID: "server-1e769ac7-496e-b2e1-0ba1-301706c4d40a", Address: "1e769ac7-496e-b2e1-0ba1-301706c4d40a"}, {Suffrage: 0, ID: "server-7ec3d91b-6629-01c9-577f-af60798ec0d3", Address: "7ec3d91b-6629-01c9-577f-af60798ec0d3"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002434373937383631392d613637372d326239662d366430312d633133366438356437626230a24944da002b7365727665722d34373937383631392d613637372d326239662d366430312d633133366438356437626230a853756666726167650083a741646472657373da002465346665323936392d366334332d613938662d313562362d653662396234623032353438a24944da002b7365727665722d65346665323936392d366334332d613938662d313562362d653662396234623032353438a853756666726167650083a741646472657373da002466363364366363632d353366612d623765342d643461662d383734356164396332316665a24944da002b7365727665722d66363364366363632d353366612d623765342d643461662d383734356164396332316665a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-47978619-a677-2b9f-6d01-c136d85d7bb0", Address: "47978619-a677-2b9f-6d01-c136d85d7bb0"}, {Suffrage: 0, ID: "server-e4fe2969-6c43-a98f-15b6-e6b9b4b02548", Address: "e4fe2969-6c43-a98f-15b6-e6b9b4b02548"}, {Suffrage: 0, ID: "server-f63d6ccc-53fa-b7e4-d4af-8745ad9c21fe", Address: "f63d6ccc-53fa-b7e4-d4af-8745ad9c21fe"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002434393131313736392d646162652d313435302d326434392d613834363564343236613639a24944da002b7365727665722d34393131313736392d646162652d313435302d326434392d613834363564343236613639a853756666726167650083a741646472657373da002436636630326530642d353966342d303835652d383066322d353865613766643033313637a24944da002b7365727665722d36636630326530642d353966342d303835652d383066322d353865613766643033313637a853756666726167650083a741646472657373da002464356539626566652d646133622d373265612d366565662d373430306465316465643336a24944da002b7365727665722d64356539626566652d646133622d373265612d366565662d373430306465316465643336a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-49111769-dabe-1450-2d49-a8465d426a69", Address: "49111769-dabe-1450-2d49-a8465d426a69"}, {Suffrage: 0, ID: "server-6cf02e0d-59f4-085e-80f2-58ea7fd03167", Address: "6cf02e0d-59f4-085e-80f2-58ea7fd03167"}, {Suffrage: 0, ID: "server-d5e9befe-da3b-72ea-6eef-7400de1ded36", Address: "d5e9befe-da3b-72ea-6eef-7400de1ded36"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002434623932383362302d336263652d343730632d336232622d623637336634303163393635a24944da002b7365727665722d34623932383362302d336263652d343730632d336232622d623637336634303163393635a853756666726167650083a741646472657373da002434303365353739632d346565342d646337392d663839382d336136316666626138393434a24944da002b7365727665722d34303365353739632d346565342d646337392d663839382d336136316666626138393434a853756666726167650083a741646472657373da002431636466383532362d333338392d613564622d383730322d613562366161643938306633a24944da002b7365727665722d31636466383532362d333338392d613564622d383730322d613562366161643938306633a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-4b9283b0-3bce-470c-3b2b-b673f401c965", Address: "4b9283b0-3bce-470c-3b2b-b673f401c965"}, {Suffrage: 0, ID: "server-403e579c-4ee4-dc79-f898-3a61ffba8944", Address: "403e579c-4ee4-dc79-f898-3a61ffba8944"}, {Suffrage: 0, ID: "server-1cdf8526-3389-a5db-8702-a5b6aad980f3", Address: "1cdf8526-3389-a5db-8702-a5b6aad980f3"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002434646636333832622d663131382d333162372d383362662d376335303334356434643835a24944da002b7365727665722d34646636333832622d663131382d333162372d383362662d376335303334356434643835a853756666726167650083a741646472657373da002439386363306261622d633739372d613962332d356139372d663134653430373061656134a24944da002b7365727665722d39386363306261622d633739372d613962332d356139372d663134653430373061656134a853756666726167650083a741646472657373da002433626238303139622d363330342d306432642d643035392d366162313336346532363734a24944da002b7365727665722d33626238303139622d363330342d306432642d643035392d366162313336346532363734a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-4df6382b-f118-31b7-83bf-7c50345d4d85", Address: "4df6382b-f118-31b7-83bf-7c50345d4d85"}, {Suffrage: 0, ID: "server-98cc0bab-c797-a9b3-5a97-f14e4070aea4", Address: "98cc0bab-c797-a9b3-5a97-f14e4070aea4"}, {Suffrage: 0, ID: "server-3bb8019b-6304-0d2d-d059-6ab1364e2674", Address: "3bb8019b-6304-0d2d-d059-6ab1364e2674"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436313233656264382d356435342d613664622d656338652d363164363562303037623735a24944da002b7365727665722d36313233656264382d356435342d613664622d656338652d363164363562303037623735a853756666726167650083a741646472657373da002437333462353463622d343662622d356133642d373464632d363038363936633535306462a24944da002b7365727665722d37333462353463622d343662622d356133642d373464632d363038363936633535306462a853756666726167650083a741646472657373da002439363032323766652d393739312d646663612d336532322d383361613265343966343436a24944da002b7365727665722d39363032323766652d393739312d646663612d336532322d383361613265343966343436a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-6123ebd8-5d54-a6db-ec8e-61d65b007b75", Address: "6123ebd8-5d54-a6db-ec8e-61d65b007b75"}, {Suffrage: 0, ID: "server-734b54cb-46bb-5a3d-74dc-608696c550db", Address: "734b54cb-46bb-5a3d-74dc-608696c550db"}, {Suffrage: 0, ID: "server-960227fe-9791-dfca-3e22-83aa2e49f446", Address: "960227fe-9791-dfca-3e22-83aa2e49f446"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436313334316630652d383939612d353134372d326663342d633034313132376664336133a24944da002b7365727665722d36313334316630652d383939612d353134372d326663342d633034313132376664336133a853756666726167650083a741646472657373da002435303165333137372d326662302d386638392d333938312d333163386661323730393866a24944da002b7365727665722d35303165333137372d326662302d386638392d333938312d333163386661323730393866a853756666726167650083a741646472657373da002438643361363830662d366532302d363565662d316464332d363439643933633335363739a24944da002b7365727665722d38643361363830662d366532302d363565662d316464332d363439643933633335363739a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-61341f0e-899a-5147-2fc4-c041127fd3a3", Address: "61341f0e-899a-5147-2fc4-c041127fd3a3"}, {Suffrage: 0, ID: "server-501e3177-2fb0-8f89-3981-31c8fa27098f", Address: "501e3177-2fb0-8f89-3981-31c8fa27098f"}, {Suffrage: 0, ID: "server-8d3a680f-6e20-65ef-1dd3-649d93c35679", Address: "8d3a680f-6e20-65ef-1dd3-649d93c35679"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436333636366538642d613937342d613133302d333161332d646263656461343863333233a24944da002b7365727665722d36333636366538642d613937342d613133302d333161332d646263656461343863333233a853756666726167650083a741646472657373da002462396361653734652d393561332d373331302d393232612d653664366431653635333066a24944da002b7365727665722d62396361653734652d393561332d373331302d393232612d653664366431653635333066a853756666726167650083a741646472657373da002465333762653666642d366661322d653636612d646233612d656637386632346163383232a24944da002b7365727665722d65333762653666642d366661322d653636612d646233612d656637386632346163383232a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-63666e8d-a974-a130-31a3-dbceda48c323", Address: "63666e8d-a974-a130-31a3-dbceda48c323"}, {Suffrage: 0, ID: "server-b9cae74e-95a3-7310-922a-e6d6d1e6530f", Address: "b9cae74e-95a3-7310-922a-e6d6d1e6530f"}, {Suffrage: 0, ID: "server-e37be6fd-6fa2-e66a-db3a-ef78f24ac822", Address: "e37be6fd-6fa2-e66a-db3a-ef78f24ac822"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002436343432623834332d386165622d363734612d626432312d633639363634643631383364a24944da002436343432623834332d386165622d363734612d626432312d633639363634643631383364a853756666726167650083a741646472657373da002464303862633632352d643135352d323334652d663134372d636630613862396133313637a24944da002464303862633632352d643135352d323334652d663134372d636630613862396133313637a853756666726167650083a741646472657373da002462376632353932332d343237652d313264372d633234652d353261363363323066653463a24944da002462376632353932332d343237652d313264372d633234652d353261363363323066653463a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "6442b843-8aeb-674a-bd21-c69664d6183d", Address: "6442b843-8aeb-674a-bd21-c69664d6183d"}, {Suffrage: 0, ID: "d08bc625-d155-234e-f147-cf0a8b9a3167", Address: "d08bc625-d155-234e-f147-cf0a8b9a3167"}, {Suffrage: 0, ID: "b7f25923-427e-12d7-c24e-52a63c20fe4c", Address: "b7f25923-427e-12d7-c24e-52a63c20fe4c"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002437383634623232332d653036612d646563642d623363302d323836643362363335633065a24944da002b7365727665722d37383634623232332d653036612d646563642d623363302d323836643362363335633065a853756666726167650083a741646472657373da002462633334376334632d383966662d633539322d343533632d336238313534396364656139a24944da002b7365727665722d62633334376334632d383966662d633539322d343533632d336238313534396364656139a853756666726167650083a741646472657373da002436313266326262342d363162362d343162382d343661342d346334343133306663303365a24944da002b7365727665722d36313266326262342d363162362d343162382d343661342d346334343133306663303365a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-7864b223-e06a-decd-b3c0-286d3b635c0e", Address: "7864b223-e06a-decd-b3c0-286d3b635c0e"}, {Suffrage: 0, ID: "server-bc347c4c-89ff-c592-453c-3b81549cdea9", Address: "bc347c4c-89ff-c592-453c-3b81549cdea9"}, {Suffrage: 0, ID: "server-612f2bb4-61b6-41b8-46a4-4c44130fc03e", Address: "612f2bb4-61b6-41b8-46a4-4c44130fc03e"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002437666630353237392d356131332d316561362d626339392d666261626537616233363762a24944da002b7365727665722d37666630353237392d356131332d316561362d626339392d666261626537616233363762a853756666726167650083a741646472657373da002439313466633133362d353532392d666336382d343939312d303231613834623364356130a24944da002b7365727665722d39313466633133362d353532392d666336382d343939312d303231613834623364356130a853756666726167650083a741646472657373da002434306464623864302d313633642d363337622d383034362d656264343335633565646563a24944da002b7365727665722d34306464623864302d313633642d363337622d383034362d656264343335633565646563a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-7ff05279-5a13-1ea6-bc99-fbabe7ab367b", Address: "7ff05279-5a13-1ea6-bc99-fbabe7ab367b"}, {Suffrage: 0, ID: "server-914fc136-5529-fc68-4991-021a84b3d5a0", Address: "914fc136-5529-fc68-4991-021a84b3d5a0"}, {Suffrage: 0, ID: "server-40ddb8d0-163d-637b-8046-ebd435c5edec", Address: "40ddb8d0-163d-637b-8046-ebd435c5edec"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438346664333563652d323839642d626538632d653035632d613563633737356637633137a24944da002b7365727665722d38346664333563652d323839642d626538632d653035632d613563633737356637633137a853756666726167650083a741646472657373da002464343336323662312d303138382d613233382d386333362d313238303032643530633433a24944da002b7365727665722d64343336323662312d303138382d613233382d386333362d313238303032643530633433a853756666726167650083a741646472657373da002432353134396435392d363366642d356435362d663537372d353561316461653633356366a24944da002b7365727665722d32353134396435392d363366642d356435362d663537372d353561316461653633356366a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-84fd35ce-289d-be8c-e05c-a5cc775f7c17", Address: "84fd35ce-289d-be8c-e05c-a5cc775f7c17"}, {Suffrage: 0, ID: "server-d43626b1-0188-a238-8c36-128002d50c43", Address: "d43626b1-0188-a238-8c36-128002d50c43"}, {Suffrage: 0, ID: "server-25149d59-63fd-5d56-f577-55a1dae635cf", Address: "25149d59-63fd-5d56-f577-55a1dae635cf"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438373765623337632d613732642d353533662d376566372d653136393765383937313864a24944da002b7365727665722d38373765623337632d613732642d353533662d376566372d653136393765383937313864a853756666726167650083a741646472657373da002434366462333164312d393934332d386537612d343134352d613131393461633465326232a24944da002b7365727665722d34366462333164312d393934332d386537612d343134352d613131393461633465326232a853756666726167650083a741646472657373da002438373564656364632d316439622d383233362d346461642d303330623334303366363732a24944da002b7365727665722d38373564656364632d316439622d383233362d346461642d303330623334303366363732a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-877eb37c-a72d-553f-7ef7-e1697e89718d", Address: "877eb37c-a72d-553f-7ef7-e1697e89718d"}, {Suffrage: 0, ID: "server-46db31d1-9943-8e7a-4145-a1194ac4e2b2", Address: "46db31d1-9943-8e7a-4145-a1194ac4e2b2"}, {Suffrage: 0, ID: "server-875decdc-1d9b-8236-4dad-030b3403f672", Address: "875decdc-1d9b-8236-4dad-030b3403f672"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438613637636361352d643230312d633439632d313231302d303963373339313837613832a24944da002438613637636361352d643230312d633439632d313231302d303963373339313837613832a853756666726167650083a741646472657373da002439333933393839612d343032332d656434622d636233312d386662623264376262646334a24944da002439333933393839612d343032332d656434622d636233312d386662623264376262646334a853756666726167650083a741646472657373da002464316262393336322d613464632d623936362d353262322d366265616237323532626666a24944da002b7365727665722d64316262393336322d613464632d623936362d353262322d366265616237323532626666a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "8a67cca5-d201-c49c-1210-09c739187a82", Address: "8a67cca5-d201-c49c-1210-09c739187a82"}, {Suffrage: 0, ID: "9393989a-4023-ed4b-cb31-8fbb2d7bbdc4", Address: "9393989a-4023-ed4b-cb31-8fbb2d7bbdc4"}, {Suffrage: 0, ID: "server-d1bb9362-a4dc-b966-52b2-6beab7252bff", Address: "d1bb9362-a4dc-b966-52b2-6beab7252bff"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002438653264613936362d656339382d636231652d383739612d326562383238643738373066a24944da002b7365727665722d38653264613936362d656339382d636231652d383739612d326562383238643738373066a853756666726167650083a741646472657373da002436636436663065612d356133632d663435392d323038362d353736613437633634333430a24944da002b7365727665722d36636436663065612d356133632d663435392d323038362d353736613437633634333430a853756666726167650083a741646472657373da002466663837303961652d666439632d666135612d633962652d393333383539643662626639a24944da002b7365727665722d66663837303961652d666439632d666135612d633962652d393333383539643662626639a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-8e2da966-ec98-cb1e-879a-2eb828d7870f", Address: "8e2da966-ec98-cb1e-879a-2eb828d7870f"}, {Suffrage: 0, ID: "server-6cd6f0ea-5a3c-f459-2086-576a47c64340", Address: "6cd6f0ea-5a3c-f459-2086-576a47c64340"}, {Suffrage: 0, ID: "server-ff8709ae-fd9c-fa5a-c9be-933859d6bbf9", Address: "ff8709ae-fd9c-fa5a-c9be-933859d6bbf9"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002439303837333634312d306437622d323466302d396361392d656462396134386634376432a24944da002b7365727665722d39303837333634312d306437622d323466302d396361392d656462396134386634376432a853756666726167650083a741646472657373da002433396261646636342d663433662d366638312d343366622d303530613463343434613361a24944da002b7365727665722d33396261646636342d663433662d366638312d343366622d303530613463343434613361a853756666726167650083a741646472657373da002430343132396665312d666430612d613139312d393666652d643265626263636531663162a24944da002b7365727665722d30343132396665312d666430612d613139312d393666652d643265626263636531663162a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-90873641-0d7b-24f0-9ca9-edb9a48f47d2", Address: "90873641-0d7b-24f0-9ca9-edb9a48f47d2"}, {Suffrage: 0, ID: "server-39badf64-f43f-6f81-43fb-050a4c444a3a", Address: "39badf64-f43f-6f81-43fb-050a4c444a3a"}, {Suffrage: 0, ID: "server-04129fe1-fd0a-a191-96fe-d2ebbcce1f1b", Address: "04129fe1-fd0a-a191-96fe-d2ebbcce1f1b"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002439323163383264662d663030392d666364642d343265302d343435333434393966646230a24944da002b7365727665722d39323163383264662d663030392d666364642d343265302d343435333434393966646230a853756666726167650083a741646472657373da002464323436643666392d656164352d633637372d343331352d353732356262636631373062a24944da002b7365727665722d64323436643666392d656164352d633637372d343331352d353732356262636631373062a853756666726167650083a741646472657373da002436613061313237332d656533322d643965392d396661362d356162346434373132376164a24944da002b7365727665722d36613061313237332d656533322d643965392d396661362d356162346434373132376164a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-921c82df-f009-fcdd-42e0-44534499fdb0", Address: "921c82df-f009-fcdd-42e0-44534499fdb0"}, {Suffrage: 0, ID: "server-d246d6f9-ead5-c677-4315-5725bbcf170b", Address: "d246d6f9-ead5-c677-4315-5725bbcf170b"}, {Suffrage: 0, ID: "server-6a0a1273-ee32-d9e9-9fa6-5ab4d47127ad", Address: "6a0a1273-ee32-d9e9-9fa6-5ab4d47127ad"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002439356337363737332d613830652d393537302d376661652d653963643263613161393633a24944da002b7365727665722d39356337363737332d613830652d393537302d376661652d653963643263613161393633a853756666726167650083a741646472657373da002465373331303638342d386262342d643266362d313135642d623839653135316362376534a24944da002b7365727665722d65373331303638342d386262342d643266362d313135642d623839653135316362376534a853756666726167650083a741646472657373da002465373362636532392d663237312d393135302d383839302d383038323939626436326436a24944da002b7365727665722d65373362636532392d663237312d393135302d383839302d383038323939626436326436a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-95c76773-a80e-9570-7fae-e9cd2ca1a963", Address: "95c76773-a80e-9570-7fae-e9cd2ca1a963"}, {Suffrage: 0, ID: "server-e7310684-8bb4-d2f6-115d-b89e151cb7e4", Address: "e7310684-8bb4-d2f6-115d-b89e151cb7e4"}, {Suffrage: 0, ID: "server-e73bce29-f271-9150-8890-808299bd62d6", Address: "e73bce29-f271-9150-8890-808299bd62d6"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002439643533396536312d303631322d313062622d623331642d393339663238343764653761a24944da002b7365727665722d39643533396536312d303631322d313062622d623331642d393339663238343764653761a853756666726167650083a741646472657373da002462383864646231332d346363642d653663372d343236322d666431623333623635666664a24944da002b7365727665722d62383864646231332d346363642d653663372d343236322d666431623333623635666664a853756666726167650083a741646472657373da002431613936396630652d633237362d346236622d633837652d306262616634643338393066a24944da002b7365727665722d31613936396630652d633237362d346236622d633837652d306262616634643338393066a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-9d539e61-0612-10bb-b31d-939f2847de7a", Address: "9d539e61-0612-10bb-b31d-939f2847de7a"}, {Suffrage: 0, ID: "server-b88ddb13-4ccd-e6c7-4262-fd1b33b65ffd", Address: "b88ddb13-4ccd-e6c7-4262-fd1b33b65ffd"}, {Suffrage: 0, ID: "server-1a969f0e-c276-4b6b-c87e-0bbaf4d3890f", Address: "1a969f0e-c276-4b6b-c87e-0bbaf4d3890f"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002461343962656137632d326236352d386164362d396337342d353931343730303937626163a24944da002b7365727665722d61343962656137632d326236352d386164362d396337342d353931343730303937626163a853756666726167650083a741646472657373da002437313963343339332d333934332d366163632d663934612d323234623535336564306331a24944da002b7365727665722d37313963343339332d333934332d366163632d663934612d323234623535336564306331a853756666726167650083a741646472657373da002466623264643831332d333430372d376331612d353936382d626661303431323763323036a24944da002b7365727665722d66623264643831332d333430372d376331612d353936382d626661303431323763323036a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-a49bea7c-2b65-8ad6-9c74-591470097bac", Address: "a49bea7c-2b65-8ad6-9c74-591470097bac"}, {Suffrage: 0, ID: "server-719c4393-3943-6acc-f94a-224b553ed0c1", Address: "719c4393-3943-6acc-f94a-224b553ed0c1"}, {Suffrage: 0, ID: "server-fb2dd813-3407-7c1a-5968-bfa04127c206", Address: "fb2dd813-3407-7c1a-5968-bfa04127c206"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002461396536666564392d366430302d353066312d313636612d626237316539393365373338a24944da002b7365727665722d61396536666564392d366430302d353066312d313636612d626237316539393365373338a853756666726167650083a741646472657373da002435326532393532652d303935302d656433662d303366302d376234393338613533616563a24944da002b7365727665722d35326532393532652d303935302d656433662d303366302d376234393338613533616563a853756666726167650083a741646472657373da002431666431633361352d616239382d326662382d333663322d313535316437383635316134a24944da002b7365727665722d31666431633361352d616239382d326662382d333663322d313535316437383635316134a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-a9e6fed9-6d00-50f1-166a-bb71e993e738", Address: "a9e6fed9-6d00-50f1-166a-bb71e993e738"}, {Suffrage: 0, ID: "server-52e2952e-0950-ed3f-03f0-7b4938a53aec", Address: "52e2952e-0950-ed3f-03f0-7b4938a53aec"}, {Suffrage: 0, ID: "server-1fd1c3a5-ab98-2fb8-36c2-1551d78651a4", Address: "1fd1c3a5-ab98-2fb8-36c2-1551d78651a4"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002462323330346432632d373935322d646230662d373633342d323466636133636361353635a24944da002b7365727665722d62323330346432632d373935322d646230662d373633342d323466636133636361353635a853756666726167650083a741646472657373da002464353930303766382d363036312d636462632d616330302d373061376233393065653362a24944da002b7365727665722d64353930303766382d363036312d636462632d616330302d373061376233393065653362a853756666726167650083a741646472657373da002435336434306233652d396662332d396335362d636637372d636432323862376337363136a24944da002b7365727665722d35336434306233652d396662332d396335362d636637372d636432323862376337363136a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-b2304d2c-7952-db0f-7634-24fca3cca565", Address: "b2304d2c-7952-db0f-7634-24fca3cca565"}, {Suffrage: 0, ID: "server-d59007f8-6061-cdbc-ac00-70a7b390ee3b", Address: "d59007f8-6061-cdbc-ac00-70a7b390ee3b"}, {Suffrage: 0, ID: "server-53d40b3e-9fb3-9c56-cf77-cd228b7c7616", Address: "53d40b3e-9fb3-9c56-cf77-cd228b7c7616"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002462323962663439352d306138642d353639332d623239322d346438363361653563303533a24944da002b7365727665722d62323962663439352d306138642d353639332d623239322d346438363361653563303533a853756666726167650083a741646472657373da002464353763313238352d346338352d396637372d343961302d663838373166363833323761a24944da002b7365727665722d64353763313238352d346338352d396637372d343961302d663838373166363833323761a853756666726167650083a741646472657373da002431376436363664372d333639322d633063352d373135342d326436343731623233616432a24944da002b7365727665722d31376436363664372d333639322d633063352d373135342d326436343731623233616432a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-b29bf495-0a8d-5693-b292-4d863ae5c053", Address: "b29bf495-0a8d-5693-b292-4d863ae5c053"}, {Suffrage: 0, ID: "server-d57c1285-4c85-9f77-49a0-f8871f68327a", Address: "d57c1285-4c85-9f77-49a0-f8871f68327a"}, {Suffrage: 0, ID: "server-17d666d7-3692-c0c5-7154-2d6471b23ad2", Address: "17d666d7-3692-c0c5-7154-2d6471b23ad2"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002462353732346562392d353063622d323639382d353239322d396562346433343031326234a24944da002b7365727665722d62353732346562392d353063622d323639382d353239322d396562346433343031326234a853756666726167650083a741646472657373da002435323533363163342d626435642d373739382d646661372d633365666662353266393533a24944da002b7365727665722d35323533363163342d626435642d373739382d646661372d633365666662353266393533a853756666726167650083a741646472657373da002466633736383766612d656234312d613764312d613366392d336362343238326662356263a24944da002b7365727665722d66633736383766612d656234312d613764312d613366392d336362343238326662356263a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-b5724eb9-50cb-2698-5292-9eb4d34012b4", Address: "b5724eb9-50cb-2698-5292-9eb4d34012b4"}, {Suffrage: 0, ID: "server-525361c4-bd5d-7798-dfa7-c3effb52f953", Address: "525361c4-bd5d-7798-dfa7-c3effb52f953"}, {Suffrage: 0, ID: "server-fc7687fa-eb41-a7d1-a3f9-3cb4282fb5bc", Address: "fc7687fa-eb41-a7d1-a3f9-3cb4282fb5bc"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002462623962353835642d616630362d306565342d636264382d626537626465623863396563a24944da002b7365727665722d62623962353835642d616630362d306565342d636264382d626537626465623863396563a853756666726167650083a741646472657373da002433313534623830372d393731352d633530652d613131632d633537643034333837313837a24944da002b7365727665722d33313534623830372d393731352d633530652d613131632d633537643034333837313837a853756666726167650083a741646472657373da002437373361373232662d306232622d616530312d356565642d343930633434656364653338a24944da002b7365727665722d37373361373232662d306232622d616530312d356565642d343930633434656364653338a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-bb9b585d-af06-0ee4-cbd8-be7bdeb8c9ec", Address: "bb9b585d-af06-0ee4-cbd8-be7bdeb8c9ec"}, {Suffrage: 0, ID: "server-3154b807-9715-c50e-a11c-c57d04387187", Address: "3154b807-9715-c50e-a11c-c57d04387187"}, {Suffrage: 0, ID: "server-773a722f-0b2b-ae01-5eed-490c44ecde38", Address: "773a722f-0b2b-ae01-5eed-490c44ecde38"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002463303262316430612d313036632d616535382d363033372d306463393830366237353632a24944da002b7365727665722d63303262316430612d313036632d616535382d363033372d306463393830366237353632a853756666726167650083a741646472657373da002461363035666639362d656633392d343833662d353337632d366166666537376161383839a24944da002b7365727665722d61363035666639362d656633392d343833662d353337632d366166666537376161383839a853756666726167650083a741646472657373da002437393731333836362d386533342d313935332d373762632d366366646338393535353336a24944da002b7365727665722d37393731333836362d386533342d313935332d373762632d366366646338393535353336a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-c02b1d0a-106c-ae58-6037-0dc9806b7562", Address: "c02b1d0a-106c-ae58-6037-0dc9806b7562"}, {Suffrage: 0, ID: "server-a605ff96-ef39-483f-537c-6affe77aa889", Address: "a605ff96-ef39-483f-537c-6affe77aa889"}, {Suffrage: 0, ID: "server-79713866-8e34-1953-77bc-6cfdc8955536", Address: "79713866-8e34-1953-77bc-6cfdc8955536"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002463633965666231312d646133632d363566322d363461662d363630613230383536623064a24944da002b7365727665722d63633965666231312d646133632d363566322d363461662d363630613230383536623064a853756666726167650083a741646472657373da002431626438626436312d653632612d323866382d623931352d663465333738383832646361a24944da002b7365727665722d31626438626436312d653632612d323866382d623931352d663465333738383832646361a853756666726167650083a741646472657373da002466666135316265382d623830332d623436642d633230372d326330363965346164633338a24944da002b7365727665722d66666135316265382d623830332d623436642d633230372d326330363965346164633338a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-cc9efb11-da3c-65f2-64af-660a20856b0d", Address: "cc9efb11-da3c-65f2-64af-660a20856b0d"}, {Suffrage: 0, ID: "server-1bd8bd61-e62a-28f8-b915-f4e378882dca", Address: "1bd8bd61-e62a-28f8-b915-f4e378882dca"}, {Suffrage: 0, ID: "server-ffa51be8-b803-b46d-c207-2c069e4adc38", Address: "ffa51be8-b803-b46d-c207-2c069e4adc38"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002464306364623931632d323736372d633536332d646563372d383665343761366663663639a24944da002b7365727665722d64306364623931632d323736372d633536332d646563372d383665343761366663663639a853756666726167650083a741646472657373da002439333561633064652d323335632d303439382d366131362d393066326562663363613737a24944da002b7365727665722d39333561633064652d323335632d303439382d366131362d393066326562663363613737a853756666726167650083a741646472657373da002463386639333463392d643765352d356534632d623937352d633764313936643235636132a24944da002b7365727665722d63386639333463392d643765352d356534632d623937352d633764313936643235636132a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-d0cdb91c-2767-c563-dec7-86e47a6fcf69", Address: "d0cdb91c-2767-c563-dec7-86e47a6fcf69"}, {Suffrage: 0, ID: "server-935ac0de-235c-0498-6a16-90f2ebf3ca77", Address: "935ac0de-235c-0498-6a16-90f2ebf3ca77"}, {Suffrage: 0, ID: "server-c8f934c9-d7e5-5e4c-b975-c7d196d25ca2", Address: "c8f934c9-d7e5-5e4c-b975-c7d196d25ca2"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002464663435336632342d343531352d626166632d613835622d663038313536323337346465a24944da002b7365727665722d64663435336632342d343531352d626166632d613835622d663038313536323337346465a853756666726167650083a741646472657373da002438656438363762632d393265622d656332352d653430392d383434633461386530663637a24944da002b7365727665722d38656438363762632d393265622d656332352d653430392d383434633461386530663637a853756666726167650083a741646472657373da002430383139313863302d393034382d656564622d623365352d303839326566333938636161a24944da002b7365727665722d30383139313863302d393034382d656564622d623365352d303839326566333938636161a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-df453f24-4515-bafc-a85b-f081562374de", Address: "df453f24-4515-bafc-a85b-f081562374de"}, {Suffrage: 0, ID: "server-8ed867bc-92eb-ec25-e409-844c4a8e0f67", Address: "8ed867bc-92eb-ec25-e409-844c4a8e0f67"}, {Suffrage: 0, ID: "server-081918c0-9048-eedb-b3e5-0892ef398caa", Address: "081918c0-9048-eedb-b3e5-0892ef398caa"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002464663964366432352d383439392d643433612d373434312d613336326332623833313131a24944da002b7365727665722d64663964366432352d383439392d643433612d373434312d613336326332623833313131a853756666726167650083a741646472657373da002463356464646630332d396362312d636337312d323336612d346437373034653633363139a24944da002b7365727665722d63356464646630332d396362312d636337312d323336612d346437373034653633363139a853756666726167650083a741646472657373da002462623362343966352d333437322d663164652d366662332d653466316637383766353735a24944da002b7365727665722d62623362343966352d333437322d663164652d366662332d653466316637383766353735a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-df9d6d25-8499-d43a-7441-a362c2b83111", Address: "df9d6d25-8499-d43a-7441-a362c2b83111"}, {Suffrage: 0, ID: "server-c5dddf03-9cb1-cc71-236a-4d7704e63619", Address: "c5dddf03-9cb1-cc71-236a-4d7704e63619"}, {Suffrage: 0, ID: "server-bb3b49f5-3472-f1de-6fb3-e4f1f787f575", Address: "bb3b49f5-3472-f1de-6fb3-e4f1f787f575"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002465306332663036632d373638322d343633392d613861382d623761333437353430623466a24944da002b7365727665722d65306332663036632d373638322d343633392d613861382d623761333437353430623466a853756666726167650083a741646472657373da002436643463313738342d376165352d376632632d346331352d346533616534386334623539a24944da002b7365727665722d36643463313738342d376165352d376632632d346331352d346533616534386334623539a853756666726167650083a741646472657373da002430626535613639392d353266352d373062642d333765632d633634316335363166616265a24944da002b7365727665722d30626535613639392d353266352d373062642d333765632d633634316335363166616265a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-e0c2f06c-7682-4639-a8a8-b7a347540b4f", Address: "e0c2f06c-7682-4639-a8a8-b7a347540b4f"}, {Suffrage: 0, ID: "server-6d4c1784-7ae5-7f2c-4c15-4e3ae48c4b59", Address: "6d4c1784-7ae5-7f2c-4c15-4e3ae48c4b59"}, {Suffrage: 0, ID: "server-0be5a699-52f5-70bd-37ec-c641c561fabe", Address: "0be5a699-52f5-70bd-37ec-c641c561fabe"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002465393966356534662d326464662d346136652d323563662d363064663465353434376639a24944da002b7365727665722d65393966356534662d326464662d346136652d323563662d363064663465353434376639a853756666726167650083a741646472657373da002435666364383934372d623265392d303362342d656563662d633631396564313039386635a24944da002b7365727665722d35666364383934372d623265392d303362342d656563662d633631396564313039386635a853756666726167650083a741646472657373da002439356565633766372d346130632d663731302d653339622d316535303138633866663063a24944da002b7365727665722d39356565633766372d346130632d663731302d653339622d316535303138633866663063a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-e99f5e4f-2ddf-4a6e-25cf-60df4e5447f9", Address: "e99f5e4f-2ddf-4a6e-25cf-60df4e5447f9"}, {Suffrage: 0, ID: "server-5fcd8947-b2e9-03b4-eecf-c619ed1098f5", Address: "5fcd8947-b2e9-03b4-eecf-c619ed1098f5"}, {Suffrage: 0, ID: "server-95eec7f7-4a0c-f710-e39b-1e5018c8ff0c", Address: "95eec7f7-4a0c-f710-e39b-1e5018c8ff0c"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002466333332633863372d366131352d663464302d646463322d633537616362373930633166a24944da002b7365727665722d66333332633863372d366131352d663464302d646463322d633537616362373930633166a853756666726167650083a741646472657373da002435643833663361662d623036332d376339302d396465362d343032373066643030653831a24944da002b7365727665722d35643833663361662d623036332d376339302d396465362d343032373066643030653831a853756666726167650083a741646472657373da002465366432666435392d663239632d623536642d313661662d343962663431316664393132a24944da002b7365727665722d65366432666435392d663239632d623536642d313661662d343962663431316664393132a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-f332c8c7-6a15-f4d0-ddc2-c57acb790c1f", Address: "f332c8c7-6a15-f4d0-ddc2-c57acb790c1f"}, {Suffrage: 0, ID: "server-5d83f3af-b063-7c90-9de6-40270fd00e81", Address: "5d83f3af-b063-7c90-9de6-40270fd00e81"}, {Suffrage: 0, ID: "server-e6d2fd59-f29c-b56d-16af-49bf411fd912", Address: "e6d2fd59-f29c-b56d-16af-49bf411fd912"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002466356331363137652d383038302d393237342d623030302d323262326664326635366163a24944da002b7365727665722d66356331363137652d383038302d393237342d623030302d323262326664326635366163a853756666726167650083a741646472657373da002461633566366434332d636335362d306539642d323331632d653562656536626430363066a24944da002b7365727665722d61633566366434332d636335362d306539642d323331632d653562656536626430363066a853756666726167650083a741646472657373da002461626635626536352d373938642d643238632d653432372d653234366335653061316131a24944da002b7365727665722d61626635626536352d373938642d643238632d653432372d653234366335653061316131a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-f5c1617e-8080-9274-b000-22b2fd2f56ac", Address: "f5c1617e-8080-9274-b000-22b2fd2f56ac"}, {Suffrage: 0, ID: "server-ac5f6d43-cc56-0e9d-231c-e5bee6bd060f", Address: "ac5f6d43-cc56-0e9d-231c-e5bee6bd060f"}, {Suffrage: 0, ID: "server-abf5be65-798d-d28c-e427-e246c5e0a1a1", Address: "abf5be65-798d-d28c-e427-e246c5e0a1a1"}}}},
	{"Configuration", "81a7536572766572739383a741646472657373da002466623165376532312d326230652d306662302d373166652d616536613466393238393564a24944da002b7365727665722d66623165376532312d326230652d306662302d373166652d616536613466393238393564a853756666726167650083a741646472657373da002461393563343664622d303266612d323530642d303037302d306339623537306466653837a24944da002b7365727665722d61393563343664622d303266612d323530642d303037302d306339623537306466653837a853756666726167650083a741646472657373da002432663437363836612d336638302d356533302d303563632d613033663163336533363166a24944da002b7365727665722d32663437363836612d336638302d356533302d303563632d613033663163336533363166a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-fb1e7e21-2b0e-0fb0-71fe-ae6a4f92895d", Address: "fb1e7e21-2b0e-0fb0-71fe-ae6a4f92895d"}, {Suffrage: 0, ID: "server-a95c46db-02fa-250d-0070-0c9b570dfe87", Address: "a95c46db-02fa-250d-0070-0c9b570dfe87"}, {Suffrage: 0, ID: "server-2f47686a-3f80-5e30-05cc-a03f1c3e361f", Address: "2f47686a-3f80-5e30-05cc-a03f1c3e361f"}}}},
	{"Configuration", "81a7536572766572739483a741646472657373da002462323962663439352d306138642d353639332d623239322d346438363361653563303533a24944da002b7365727665722d62323962663439352d306138642d353639332d623239322d346438363361653563303533a853756666726167650083a741646472657373da002464353763313238352d346338352d396637372d343961302d663838373166363833323761a24944da002b7365727665722d64353763313238352d346338352d396637372d343961302d663838373166363833323761a853756666726167650083a741646472657373da002430316335663235352d376338302d363362392d383837362d626532643966373066613734a24944da002b7365727665722d30316335663235352d376338302d363362392d383837362d626532643966373066613734a853756666726167650083a741646472657373da002431376436363664372d333639322d633063352d373135342d326436343731623233616432a24944da002b7365727665722d31376436363664372d333639322d633063352d373135342d326436343731623233616432a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-b29bf495-0a8d-5693-b292-4d863ae5c053", Address: "b29bf495-0a8d-5693-b292-4d863ae5c053"}, {Suffrage: 0, ID: "server-d57c1285-4c85-9f77-49a0-f8871f68327a", Address: "d57c1285-4c85-9f77-49a0-f8871f68327a"}, {Suffrage: 0, ID: "server-01c5f255-7c80-63b9-8876-be2d9f70fa74", Address: "01c5f255-7c80-63b9-8876-be2d9f70fa74"}, {Suffrage: 0, ID: "server-17d666d7-3692-c0c5-7154-2d6471b23ad2", Address: "17d666d7-3692-c0c5-7154-2d6471b23ad2"}}}},
	{"Configuration", "81a7536572766572739783a741646472657373da002439343563386233362d353962652d623965392d366332652d363261323865333862356335a24944da002b7365727665722d39343563386233362d353962652d623965392d366332652d363261323865333862356335a853756666726167650083a741646472657373da002466616131366562652d343238322d353162392d353239622d396662396362636662336362a24944da002b7365727665722d66616131366562652d343238322d353162392d353239622d396662396362636662336362a853756666726167650083a741646472657373da002439386437663336372d666164322d613762632d663666652d643966653133366239623533a24944da002b7365727665722d39386437663336372d666164322d613762632d663666652d643966653133366239623533a853756666726167650083a741646472657373da002435306664636432622d613136362d663830342d633233362d323335373236323039303664a24944da002b7365727665722d35306664636432622d613136362d663830342d633233362d323335373236323039303664a853756666726167650083a741646472657373da002438383133616632622d366433322d366638662d356265322d393833383431626266386337a24944da002b7365727665722d38383133616632622d366433322d366638662d356265322d393833383431626266386337a853756666726167650083a741646472657373da002434333261396232352d313839372d323937362d643162382d376361633732393061393763a24944da002b7365727665722d34333261396232352d313839372d323937362d643162382d376361633732393061393763a853756666726167650083a741646472657373da002464623932346164312d313265362d366438642d396632632d393764383731386361623737a24944da002b7365727665722d64623932346164312d313265362d366438642d396632632d393764383731386361623737a8537566667261676500", Configuration{Servers: []Server{{Suffrage: 0, ID: "server-945c8b36-59be-b9e9-6c2e-62a28e38b5c5", Address: "945c8b36-59be-b9e9-6c2e-62a28e38b5c5"}, {Suffrage: 0, ID: "server-faa16ebe-4282-51b9-529b-9fb9cbcfb3cb", Address: "faa16ebe-4282-51b9-529b-9fb9cbcfb3cb"}, {Suffrage: 0, ID: "server-98d7f367-fad2-a7bc-f6fe-d9fe136b9b53", Address: "98d7f367-fad2-a7bc-f6fe-d9fe136b9b53"}, {Suffrage: 0, ID: "server-50fdcd2b-a166-f804-c236-23572620906d", Address: "50fdcd2b-a166-f804-c236-23572620906d"}, {Suffrage: 0, ID: "server-8813af2b-6d32-6f8f-5be2-983841bbf8c7", Address: "8813af2b-6d32-6f8f-5be2-983841bbf8c7"}, {Suffrage: 0, ID: "server-432a9b25-1897-2976-d1b8-7cac7290a97c", Address: "432a9b25-1897-2976-d1b8-7cac7290a97c"}, {Suffrage: 0, ID: "server-db924ad1-12e6-6d8d-9f2c-97d8718cab77", Address: "db924ad1-12e6-6d8d-9f2c-97d8718cab77"}}}},
}
