package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DropTable invokes the openanalytics_open.DropTable API synchronously
func (client *Client) DropTable(request *DropTableRequest) (response *DropTableResponse, err error) {
	response = CreateDropTableResponse()
	err = client.DoAction(request, response)
	return
}

// DropTableWithChan invokes the openanalytics_open.DropTable API asynchronously
func (client *Client) DropTableWithChan(request *DropTableRequest) (<-chan *DropTableResponse, <-chan error) {
	responseChan := make(chan *DropTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DropTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DropTableWithCallback invokes the openanalytics_open.DropTable API asynchronously
func (client *Client) DropTableWithCallback(request *DropTableRequest, callback func(response *DropTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DropTableResponse
		var err error
		defer close(result)
		response, err = client.DropTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DropTableRequest is the request struct for api DropTable
type DropTableRequest struct {
	*requests.RpcRequest
	DbName    string `position:"Query" name:"DbName"`
	TableName string `position:"Query" name:"TableName"`
}

// DropTableResponse is the response struct for api DropTable
type DropTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Data      bool   `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDropTableRequest creates a request to invoke DropTable API
func CreateDropTableRequest() (request *DropTableRequest) {
	request = &DropTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2020-09-28", "DropTable", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDropTableResponse creates a response to parse from DropTable response
func CreateDropTableResponse() (response *DropTableResponse) {
	response = &DropTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
