package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyAntChainCertificateWithKeyAutoCreation invokes the baas.ApplyAntChainCertificateWithKeyAutoCreation API synchronously
// api document: https://help.aliyun.com/api/baas/applyantchaincertificatewithkeyautocreation.html
func (client *Client) ApplyAntChainCertificateWithKeyAutoCreation(request *ApplyAntChainCertificateWithKeyAutoCreationRequest) (response *ApplyAntChainCertificateWithKeyAutoCreationResponse, err error) {
	response = CreateApplyAntChainCertificateWithKeyAutoCreationResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyAntChainCertificateWithKeyAutoCreationWithChan invokes the baas.ApplyAntChainCertificateWithKeyAutoCreation API asynchronously
// api document: https://help.aliyun.com/api/baas/applyantchaincertificatewithkeyautocreation.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApplyAntChainCertificateWithKeyAutoCreationWithChan(request *ApplyAntChainCertificateWithKeyAutoCreationRequest) (<-chan *ApplyAntChainCertificateWithKeyAutoCreationResponse, <-chan error) {
	responseChan := make(chan *ApplyAntChainCertificateWithKeyAutoCreationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyAntChainCertificateWithKeyAutoCreation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyAntChainCertificateWithKeyAutoCreationWithCallback invokes the baas.ApplyAntChainCertificateWithKeyAutoCreation API asynchronously
// api document: https://help.aliyun.com/api/baas/applyantchaincertificatewithkeyautocreation.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ApplyAntChainCertificateWithKeyAutoCreationWithCallback(request *ApplyAntChainCertificateWithKeyAutoCreationRequest, callback func(response *ApplyAntChainCertificateWithKeyAutoCreationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyAntChainCertificateWithKeyAutoCreationResponse
		var err error
		defer close(result)
		response, err = client.ApplyAntChainCertificateWithKeyAutoCreation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyAntChainCertificateWithKeyAutoCreationRequest is the request struct for api ApplyAntChainCertificateWithKeyAutoCreation
type ApplyAntChainCertificateWithKeyAutoCreationRequest struct {
	*requests.RpcRequest
	OrganizationUnitName string `position:"Body" name:"OrganizationUnitName"`
	LocalityName         string `position:"Body" name:"LocalityName"`
	Password             string `position:"Body" name:"Password"`
	CommonName           string `position:"Body" name:"CommonName"`
	AntChainId           string `position:"Body" name:"AntChainId"`
	CountryName          string `position:"Body" name:"CountryName"`
	StateOrProvinceName  string `position:"Body" name:"StateOrProvinceName"`
	OrganizationName     string `position:"Body" name:"OrganizationName"`
	ConsortiumId         string `position:"Body" name:"ConsortiumId"`
}

// ApplyAntChainCertificateWithKeyAutoCreationResponse is the response struct for api ApplyAntChainCertificateWithKeyAutoCreation
type ApplyAntChainCertificateWithKeyAutoCreationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateApplyAntChainCertificateWithKeyAutoCreationRequest creates a request to invoke ApplyAntChainCertificateWithKeyAutoCreation API
func CreateApplyAntChainCertificateWithKeyAutoCreationRequest() (request *ApplyAntChainCertificateWithKeyAutoCreationRequest) {
	request = &ApplyAntChainCertificateWithKeyAutoCreationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "ApplyAntChainCertificateWithKeyAutoCreation", "baas", "openAPI")
	return
}

// CreateApplyAntChainCertificateWithKeyAutoCreationResponse creates a response to parse from ApplyAntChainCertificateWithKeyAutoCreation response
func CreateApplyAntChainCertificateWithKeyAutoCreationResponse() (response *ApplyAntChainCertificateWithKeyAutoCreationResponse) {
	response = &ApplyAntChainCertificateWithKeyAutoCreationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
