package webservicesapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/machinelearning/mgmt/2017-01-01/webservices"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result webservices.OperationEntityListResult, err error)
}

var _ OperationsClientAPI = (*webservices.OperationsClient)(nil)

// ClientAPI contains the set of methods on the Client type.
type ClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, webServiceName string, createOrUpdatePayload webservices.WebService) (result webservices.CreateOrUpdateFuture, err error)
	CreateRegionalProperties(ctx context.Context, resourceGroupName string, webServiceName string, region string) (result webservices.CreateRegionalPropertiesFuture, err error)
	Get(ctx context.Context, resourceGroupName string, webServiceName string, region string) (result webservices.WebService, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, skiptoken string) (result webservices.PaginatedWebServicesListPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, skiptoken string) (result webservices.PaginatedWebServicesListIterator, err error)
	ListBySubscriptionID(ctx context.Context, skiptoken string) (result webservices.PaginatedWebServicesListPage, err error)
	ListBySubscriptionIDComplete(ctx context.Context, skiptoken string) (result webservices.PaginatedWebServicesListIterator, err error)
	ListKeys(ctx context.Context, resourceGroupName string, webServiceName string) (result webservices.Keys, err error)
	Patch(ctx context.Context, resourceGroupName string, webServiceName string, patchPayload webservices.PatchedWebService) (result webservices.PatchFuture, err error)
	Remove(ctx context.Context, resourceGroupName string, webServiceName string) (result webservices.RemoveFuture, err error)
}

var _ ClientAPI = (*webservices.Client)(nil)
