package words_test

// generated by github.com/clipperhouse/uax29/v2
// from https://www.unicode.org/Public/15.0.0/ucd/auxiliary/WordBreakTest.txt

type unicodeTest struct {
	input    []byte
	expected [][]byte
	comment  string
}

var unicodeTests = [1823]unicodeTest{
	{
		input:    []byte{0x1, 0x1},
		expected: [][]byte{{0x1}, {0x1}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xd},
		expected: [][]byte{{0x1}, {0xd}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xa},
		expected: [][]byte{{0x1}, {0xa}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xb},
		expected: [][]byte{{0x1}, {0xb}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x1}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x41},
		expected: [][]byte{{0x1}, {0x41}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x3a},
		expected: [][]byte{{0x1}, {0x3a}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x2c},
		expected: [][]byte{{0x1}, {0x2c}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x2e},
		expected: [][]byte{{0x1}, {0x2e}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x30},
		expected: [][]byte{{0x1}, {0x30}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x5f},
		expected: [][]byte{{0x1}, {0x5f}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x1}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xd7, 0x90},
		expected: [][]byte{{0x1}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x22},
		expected: [][]byte{{0x1}, {0x22}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x27},
		expected: [][]byte{{0x1}, {0x27}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x1}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x20},
		expected: [][]byte{{0x1}, {0x20}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xc2, 0xad},
		expected: [][]byte{{0x1, 0xc2, 0xad}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x1, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x80},
		expected: [][]byte{{0x1, 0xcc, 0x80}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x1, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x1, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x1, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x1}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x61, 0x3a},
		expected: [][]byte{{0x1}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x61, 0x27},
		expected: [][]byte{{0x1}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x1}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x61, 0x2c},
		expected: [][]byte{{0x1}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x31, 0x3a},
		expected: [][]byte{{0x1}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x31, 0x27},
		expected: [][]byte{{0x1}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x31, 0x2c},
		expected: [][]byte{{0x1}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x1}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x1, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x1, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <START OF HEADING> (Other) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x1},
		expected: [][]byte{{0xd}, {0x1}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xd},
		expected: [][]byte{{0xd}, {0xd}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xa},
		expected: [][]byte{{0xd, 0xa}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xb},
		expected: [][]byte{{0xd}, {0xb}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xd}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x41},
		expected: [][]byte{{0xd}, {0x41}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x3a},
		expected: [][]byte{{0xd}, {0x3a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x2c},
		expected: [][]byte{{0xd}, {0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x2e},
		expected: [][]byte{{0xd}, {0x2e}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x30},
		expected: [][]byte{{0xd}, {0x30}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x5f},
		expected: [][]byte{{0xd}, {0x5f}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xd7, 0x90},
		expected: [][]byte{{0xd}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x22},
		expected: [][]byte{{0xd}, {0x22}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x27},
		expected: [][]byte{{0xd}, {0x27}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xd}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x20},
		expected: [][]byte{{0xd}, {0x20}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xc2, 0xad},
		expected: [][]byte{{0xd}, {0xc2, 0xad}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd}, {0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd}, {0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x61, 0x3a},
		expected: [][]byte{{0xd}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x61, 0x27},
		expected: [][]byte{{0xd}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x61, 0x2c},
		expected: [][]byte{{0xd}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x31, 0x3a},
		expected: [][]byte{{0xd}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x31, 0x27},
		expected: [][]byte{{0xd}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x31, 0x2c},
		expected: [][]byte{{0xd}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd}, {0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x1},
		expected: [][]byte{{0xa}, {0x1}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xd},
		expected: [][]byte{{0xa}, {0xd}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xa},
		expected: [][]byte{{0xa}, {0xa}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xb},
		expected: [][]byte{{0xa}, {0xb}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xa}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x41},
		expected: [][]byte{{0xa}, {0x41}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x3a},
		expected: [][]byte{{0xa}, {0x3a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x2c},
		expected: [][]byte{{0xa}, {0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x2e},
		expected: [][]byte{{0xa}, {0x2e}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x30},
		expected: [][]byte{{0xa}, {0x30}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x5f},
		expected: [][]byte{{0xa}, {0x5f}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xa}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xd7, 0x90},
		expected: [][]byte{{0xa}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x22},
		expected: [][]byte{{0xa}, {0x22}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x27},
		expected: [][]byte{{0xa}, {0x27}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xa}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x20},
		expected: [][]byte{{0xa}, {0x20}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xc2, 0xad},
		expected: [][]byte{{0xa}, {0xc2, 0xad}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xa}, {0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xa}, {0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xa}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x61, 0x3a},
		expected: [][]byte{{0xa}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x61, 0x27},
		expected: [][]byte{{0xa}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xa}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x61, 0x2c},
		expected: [][]byte{{0xa}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x31, 0x3a},
		expected: [][]byte{{0xa}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x31, 0x27},
		expected: [][]byte{{0xa}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x31, 0x2c},
		expected: [][]byte{{0xa}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xa}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xa, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xa}, {0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x1},
		expected: [][]byte{{0xb}, {0x1}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xd},
		expected: [][]byte{{0xb}, {0xd}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xa},
		expected: [][]byte{{0xb}, {0xa}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xb},
		expected: [][]byte{{0xb}, {0xb}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xb}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x41},
		expected: [][]byte{{0xb}, {0x41}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x3a},
		expected: [][]byte{{0xb}, {0x3a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x2c},
		expected: [][]byte{{0xb}, {0x2c}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x2e},
		expected: [][]byte{{0xb}, {0x2e}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x30},
		expected: [][]byte{{0xb}, {0x30}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x5f},
		expected: [][]byte{{0xb}, {0x5f}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xb}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xd7, 0x90},
		expected: [][]byte{{0xb}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x22},
		expected: [][]byte{{0xb}, {0x22}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x27},
		expected: [][]byte{{0xb}, {0x27}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xb}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x20},
		expected: [][]byte{{0xb}, {0x20}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xc2, 0xad},
		expected: [][]byte{{0xb}, {0xc2, 0xad}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xb}, {0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x80},
		expected: [][]byte{{0xb}, {0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xb}, {0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xb}, {0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xb}, {0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xb}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x61, 0x3a},
		expected: [][]byte{{0xb}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x61, 0x27},
		expected: [][]byte{{0xb}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xb}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x61, 0x2c},
		expected: [][]byte{{0xb}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x31, 0x3a},
		expected: [][]byte{{0xb}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x31, 0x27},
		expected: [][]byte{{0xb}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x31, 0x2c},
		expected: [][]byte{{0xb}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xb}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xb, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xb}, {0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] <LINE TABULATION> (Newline) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x1},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x1}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xd},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0xd}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xa},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0xa}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xb},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0xb}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x41},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x41}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x3a},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x3a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x2c},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x2c}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x2e},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x2e}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x30},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x30}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x5f},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0x5f}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x5f}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xd7, 0x90},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0xd7, 0x90}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x22},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x22}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x27},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x27}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x20},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x20}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xc2, 0xad},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xc2, 0xad}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x80},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x80}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x61, 0x3a},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x61, 0x27},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x61}, {0x27}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x61, 0x2c},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x31, 0x3a},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x31, 0x27},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x31}, {0x27}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x31, 0x2c},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe3, 0x80, 0xb1}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x1},
		expected: [][]byte{{0x41}, {0x1}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xd},
		expected: [][]byte{{0x41}, {0xd}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xa},
		expected: [][]byte{{0x41}, {0xa}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xb},
		expected: [][]byte{{0x41}, {0xb}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x41}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x41},
		expected: [][]byte{{0x41, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x3a},
		expected: [][]byte{{0x41}, {0x3a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x2c},
		expected: [][]byte{{0x41}, {0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x2e},
		expected: [][]byte{{0x41}, {0x2e}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x30},
		expected: [][]byte{{0x41, 0x30}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x5f},
		expected: [][]byte{{0x41, 0x5f}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x5f}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x41}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xd7, 0x90},
		expected: [][]byte{{0x41, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x22},
		expected: [][]byte{{0x41}, {0x22}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x27},
		expected: [][]byte{{0x41}, {0x27}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x41}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x20},
		expected: [][]byte{{0x41}, {0x20}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x41, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xc2, 0xad},
		expected: [][]byte{{0x41, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x80},
		expected: [][]byte{{0x41, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x41, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x41, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x61, 0x3a},
		expected: [][]byte{{0x41, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x61, 0x27},
		expected: [][]byte{{0x41, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x41, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x61, 0x2c},
		expected: [][]byte{{0x41, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x31, 0x3a},
		expected: [][]byte{{0x41, 0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x31, 0x27},
		expected: [][]byte{{0x41, 0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x31, 0x2c},
		expected: [][]byte{{0x41, 0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x41, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x41, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x1},
		expected: [][]byte{{0x3a}, {0x1}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xd},
		expected: [][]byte{{0x3a}, {0xd}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xa},
		expected: [][]byte{{0x3a}, {0xa}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xb},
		expected: [][]byte{{0x3a}, {0xb}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x3a}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x41},
		expected: [][]byte{{0x3a}, {0x41}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x3a},
		expected: [][]byte{{0x3a}, {0x3a}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x2c},
		expected: [][]byte{{0x3a}, {0x2c}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x2e},
		expected: [][]byte{{0x3a}, {0x2e}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x30},
		expected: [][]byte{{0x3a}, {0x30}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x5f},
		expected: [][]byte{{0x3a}, {0x5f}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x3a}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xd7, 0x90},
		expected: [][]byte{{0x3a}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x22},
		expected: [][]byte{{0x3a}, {0x22}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x27},
		expected: [][]byte{{0x3a}, {0x27}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x3a}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x20},
		expected: [][]byte{{0x3a}, {0x20}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xc2, 0xad},
		expected: [][]byte{{0x3a, 0xc2, 0xad}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x3a, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x80},
		expected: [][]byte{{0x3a, 0xcc, 0x80}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x3a, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x3a, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x3a, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x3a}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x61, 0x3a},
		expected: [][]byte{{0x3a}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x61, 0x27},
		expected: [][]byte{{0x3a}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x3a}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x61, 0x2c},
		expected: [][]byte{{0x3a}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x31, 0x3a},
		expected: [][]byte{{0x3a}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x31, 0x27},
		expected: [][]byte{{0x3a}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x31, 0x2c},
		expected: [][]byte{{0x3a}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x3a}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x3a, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x3a, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x1},
		expected: [][]byte{{0x2c}, {0x1}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xd},
		expected: [][]byte{{0x2c}, {0xd}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xa},
		expected: [][]byte{{0x2c}, {0xa}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xb},
		expected: [][]byte{{0x2c}, {0xb}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x2c}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x41},
		expected: [][]byte{{0x2c}, {0x41}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x3a},
		expected: [][]byte{{0x2c}, {0x3a}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x2c},
		expected: [][]byte{{0x2c}, {0x2c}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x2e},
		expected: [][]byte{{0x2c}, {0x2e}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x30},
		expected: [][]byte{{0x2c}, {0x30}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x5f},
		expected: [][]byte{{0x2c}, {0x5f}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x2c}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xd7, 0x90},
		expected: [][]byte{{0x2c}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x22},
		expected: [][]byte{{0x2c}, {0x22}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x27},
		expected: [][]byte{{0x2c}, {0x27}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x2c}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x20},
		expected: [][]byte{{0x2c}, {0x20}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xc2, 0xad},
		expected: [][]byte{{0x2c, 0xc2, 0xad}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x80},
		expected: [][]byte{{0x2c, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x2c, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x2c, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2c}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x61, 0x3a},
		expected: [][]byte{{0x2c}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x61, 0x27},
		expected: [][]byte{{0x2c}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2c}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x61, 0x2c},
		expected: [][]byte{{0x2c}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x31, 0x3a},
		expected: [][]byte{{0x2c}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x31, 0x27},
		expected: [][]byte{{0x2c}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x31, 0x2c},
		expected: [][]byte{{0x2c}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2c}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2c, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2c, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x1},
		expected: [][]byte{{0x2e}, {0x1}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xd},
		expected: [][]byte{{0x2e}, {0xd}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xa},
		expected: [][]byte{{0x2e}, {0xa}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xb},
		expected: [][]byte{{0x2e}, {0xb}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x2e}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x41},
		expected: [][]byte{{0x2e}, {0x41}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x3a},
		expected: [][]byte{{0x2e}, {0x3a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x2c},
		expected: [][]byte{{0x2e}, {0x2c}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x2e},
		expected: [][]byte{{0x2e}, {0x2e}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x30},
		expected: [][]byte{{0x2e}, {0x30}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x5f},
		expected: [][]byte{{0x2e}, {0x5f}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x2e}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xd7, 0x90},
		expected: [][]byte{{0x2e}, {0xd7, 0x90}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x22},
		expected: [][]byte{{0x2e}, {0x22}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x27},
		expected: [][]byte{{0x2e}, {0x27}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x2e}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x20},
		expected: [][]byte{{0x2e}, {0x20}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xc2, 0xad},
		expected: [][]byte{{0x2e, 0xc2, 0xad}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x80},
		expected: [][]byte{{0x2e, 0xcc, 0x80}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x2e, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x2e, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2e}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x61, 0x3a},
		expected: [][]byte{{0x2e}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x61, 0x27},
		expected: [][]byte{{0x2e}, {0x61}, {0x27}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2e}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x61, 0x2c},
		expected: [][]byte{{0x2e}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x31, 0x3a},
		expected: [][]byte{{0x2e}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x31, 0x27},
		expected: [][]byte{{0x2e}, {0x31}, {0x27}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x31, 0x2c},
		expected: [][]byte{{0x2e}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2e}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x2e, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x2e, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] FULL STOP (MidNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x1},
		expected: [][]byte{{0x30}, {0x1}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xd},
		expected: [][]byte{{0x30}, {0xd}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xa},
		expected: [][]byte{{0x30}, {0xa}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xb},
		expected: [][]byte{{0x30}, {0xb}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x30}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x41},
		expected: [][]byte{{0x30, 0x41}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x3a},
		expected: [][]byte{{0x30}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x2c},
		expected: [][]byte{{0x30}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x2e},
		expected: [][]byte{{0x30}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x30},
		expected: [][]byte{{0x30, 0x30}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x5f},
		expected: [][]byte{{0x30, 0x5f}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x5f}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x30}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xd7, 0x90},
		expected: [][]byte{{0x30, 0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x22},
		expected: [][]byte{{0x30}, {0x22}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x27},
		expected: [][]byte{{0x30}, {0x27}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x30}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x20},
		expected: [][]byte{{0x30}, {0x20}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x30, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xc2, 0xad},
		expected: [][]byte{{0x30, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x80},
		expected: [][]byte{{0x30, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x30, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x30, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x61, 0x3a},
		expected: [][]byte{{0x30, 0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x61, 0x27},
		expected: [][]byte{{0x30, 0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x30, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x61, 0x2c},
		expected: [][]byte{{0x30, 0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [10.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x31, 0x3a},
		expected: [][]byte{{0x30, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x31, 0x27},
		expected: [][]byte{{0x30, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x31, 0x2c},
		expected: [][]byte{{0x30, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x30, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x30, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [4.0] COMBINING DIAERESIS (Extend_FE) × [8.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x1},
		expected: [][]byte{{0x5f}, {0x1}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xd},
		expected: [][]byte{{0x5f}, {0xd}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xa},
		expected: [][]byte{{0x5f}, {0xa}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xb},
		expected: [][]byte{{0x5f}, {0xb}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x5f, 0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x41},
		expected: [][]byte{{0x5f, 0x41}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x3a},
		expected: [][]byte{{0x5f}, {0x3a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x2c},
		expected: [][]byte{{0x5f}, {0x2c}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x2e},
		expected: [][]byte{{0x5f}, {0x2e}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x30},
		expected: [][]byte{{0x5f, 0x30}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x5f},
		expected: [][]byte{{0x5f, 0x5f}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x5f}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x5f}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xd7, 0x90},
		expected: [][]byte{{0x5f, 0xd7, 0x90}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x22},
		expected: [][]byte{{0x5f}, {0x22}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x27},
		expected: [][]byte{{0x5f}, {0x27}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x5f}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x20},
		expected: [][]byte{{0x5f}, {0x20}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x5f, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xc2, 0xad},
		expected: [][]byte{{0x5f, 0xc2, 0xad}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x80},
		expected: [][]byte{{0x5f, 0xcc, 0x80}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x5f, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x5f, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x61, 0x3a},
		expected: [][]byte{{0x5f, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x61, 0x27},
		expected: [][]byte{{0x5f, 0x61}, {0x27}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x5f, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x61, 0x2c},
		expected: [][]byte{{0x5f, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x31, 0x3a},
		expected: [][]byte{{0x5f, 0x31}, {0x3a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x31, 0x27},
		expected: [][]byte{{0x5f, 0x31}, {0x27}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x31, 0x2c},
		expected: [][]byte{{0x5f, 0x31}, {0x2c}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x5f, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x5f, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x5f, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LOW LINE (ExtendNumLet) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x1},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x1}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xd},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xd}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xa},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xa}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xb},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xb}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x41},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x41}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x3a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x3a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x2c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x2c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x2e},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x2e}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x30},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x30}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x5f},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x5f}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [15.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) × [15.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xd7, 0x90},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xd7, 0x90}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x22},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x22}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x27},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x27}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x20},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x20}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xc2, 0xad},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xc2, 0xad}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0x3a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0x27},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x61}, {0x27}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x61, 0x2c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x31, 0x3a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x31, 0x27},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x31}, {0x27}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x31, 0x2c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x1},
		expected: [][]byte{{0xd7, 0x90}, {0x1}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xd},
		expected: [][]byte{{0xd7, 0x90}, {0xd}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xa},
		expected: [][]byte{{0xd7, 0x90}, {0xa}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xb},
		expected: [][]byte{{0xd7, 0x90}, {0xb}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xd7, 0x90}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x41},
		expected: [][]byte{{0xd7, 0x90, 0x41}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x3a},
		expected: [][]byte{{0xd7, 0x90}, {0x3a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x2c},
		expected: [][]byte{{0xd7, 0x90}, {0x2c}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x2e},
		expected: [][]byte{{0xd7, 0x90}, {0x2e}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x30},
		expected: [][]byte{{0xd7, 0x90, 0x30}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x5f},
		expected: [][]byte{{0xd7, 0x90, 0x5f}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x5f}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd7, 0x90}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xd7, 0x90},
		expected: [][]byte{{0xd7, 0x90, 0xd7, 0x90}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x22},
		expected: [][]byte{{0xd7, 0x90}, {0x22}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [7.1] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.1] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xd7, 0x90}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x20},
		expected: [][]byte{{0xd7, 0x90}, {0x20}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xc2, 0xad},
		expected: [][]byte{{0xd7, 0x90, 0xc2, 0xad}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x80},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x80}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd7, 0x90, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd7, 0x90, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x61, 0x3a},
		expected: [][]byte{{0xd7, 0x90, 0x61}, {0x3a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x61, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0x61}, {0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd7, 0x90, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x61, 0x2c},
		expected: [][]byte{{0xd7, 0x90, 0x61}, {0x2c}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x31, 0x3a},
		expected: [][]byte{{0xd7, 0x90, 0x31}, {0x3a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x31, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0x31}, {0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x31, 0x2c},
		expected: [][]byte{{0xd7, 0x90, 0x31}, {0x2c}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd7, 0x90, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xd7, 0x90, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x1},
		expected: [][]byte{{0x22}, {0x1}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xd},
		expected: [][]byte{{0x22}, {0xd}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xa},
		expected: [][]byte{{0x22}, {0xa}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xb},
		expected: [][]byte{{0x22}, {0xb}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x22}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x41},
		expected: [][]byte{{0x22}, {0x41}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x3a},
		expected: [][]byte{{0x22}, {0x3a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x2c},
		expected: [][]byte{{0x22}, {0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x2e},
		expected: [][]byte{{0x22}, {0x2e}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x30},
		expected: [][]byte{{0x22}, {0x30}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x5f},
		expected: [][]byte{{0x22}, {0x5f}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x22}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xd7, 0x90},
		expected: [][]byte{{0x22}, {0xd7, 0x90}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x22},
		expected: [][]byte{{0x22}, {0x22}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x27},
		expected: [][]byte{{0x22}, {0x27}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x22}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x20},
		expected: [][]byte{{0x22}, {0x20}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xc2, 0xad},
		expected: [][]byte{{0x22, 0xc2, 0xad}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x80},
		expected: [][]byte{{0x22, 0xcc, 0x80}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x22, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x22, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x22}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x61, 0x3a},
		expected: [][]byte{{0x22}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x61, 0x27},
		expected: [][]byte{{0x22}, {0x61}, {0x27}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x22}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x61, 0x2c},
		expected: [][]byte{{0x22}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x31, 0x3a},
		expected: [][]byte{{0x22}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x31, 0x27},
		expected: [][]byte{{0x22}, {0x31}, {0x27}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x31, 0x2c},
		expected: [][]byte{{0x22}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x22}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x22, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x22, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] QUOTATION MARK (Double_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x1},
		expected: [][]byte{{0x27}, {0x1}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xd},
		expected: [][]byte{{0x27}, {0xd}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xa},
		expected: [][]byte{{0x27}, {0xa}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xb},
		expected: [][]byte{{0x27}, {0xb}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x27}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x41},
		expected: [][]byte{{0x27}, {0x41}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x3a},
		expected: [][]byte{{0x27}, {0x3a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x2c},
		expected: [][]byte{{0x27}, {0x2c}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x2e},
		expected: [][]byte{{0x27}, {0x2e}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x30},
		expected: [][]byte{{0x27}, {0x30}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x5f},
		expected: [][]byte{{0x27}, {0x5f}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x27}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xd7, 0x90},
		expected: [][]byte{{0x27}, {0xd7, 0x90}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x22},
		expected: [][]byte{{0x27}, {0x22}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x27},
		expected: [][]byte{{0x27}, {0x27}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x27}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x20},
		expected: [][]byte{{0x27}, {0x20}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xc2, 0xad},
		expected: [][]byte{{0x27, 0xc2, 0xad}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x27, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x80},
		expected: [][]byte{{0x27, 0xcc, 0x80}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x27, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x27, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x27, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x27}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x61, 0x3a},
		expected: [][]byte{{0x27}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x61, 0x27},
		expected: [][]byte{{0x27}, {0x61}, {0x27}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x27}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x61, 0x2c},
		expected: [][]byte{{0x27}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x31, 0x3a},
		expected: [][]byte{{0x27}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x31, 0x27},
		expected: [][]byte{{0x27}, {0x31}, {0x27}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x31, 0x2c},
		expected: [][]byte{{0x27}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x27}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x27, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x27, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x1},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x1}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xd},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xd}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xa},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xa}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xb},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xb}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x41},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x41}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x3a},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x3a}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x2c},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x2c}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x2e},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x2e}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x30},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x30}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x5f},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x5f}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xd7, 0x90},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xd7, 0x90}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x22},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x22}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x27},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x27}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x20},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x20}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xc2, 0xad},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xc2, 0xad}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x80}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x61, 0x3a},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x61, 0x27},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x61}, {0x27}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x61, 0x2c},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x31, 0x3a},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x31, 0x27},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x31}, {0x27}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x31, 0x2c},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x8c, 0x9a}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WATCH (ExtPict) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x8c, 0x9a, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x8c, 0x9a, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] WATCH (ExtPict) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x1},
		expected: [][]byte{{0x20}, {0x1}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xd},
		expected: [][]byte{{0x20}, {0xd}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xa},
		expected: [][]byte{{0x20}, {0xa}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xb},
		expected: [][]byte{{0x20}, {0xb}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x20}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x41},
		expected: [][]byte{{0x20}, {0x41}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x3a},
		expected: [][]byte{{0x20}, {0x3a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x2c},
		expected: [][]byte{{0x20}, {0x2c}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x2e},
		expected: [][]byte{{0x20}, {0x2e}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x30},
		expected: [][]byte{{0x20}, {0x30}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x5f},
		expected: [][]byte{{0x20}, {0x5f}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x20}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xd7, 0x90},
		expected: [][]byte{{0x20}, {0xd7, 0x90}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x22},
		expected: [][]byte{{0x20}, {0x22}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x27},
		expected: [][]byte{{0x20}, {0x27}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x20}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x20},
		expected: [][]byte{{0x20, 0x20}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [3.4] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xc2, 0xad},
		expected: [][]byte{{0x20, 0xc2, 0xad}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x80},
		expected: [][]byte{{0x20, 0xcc, 0x80}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x20, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x20, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x20}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x61, 0x3a},
		expected: [][]byte{{0x20}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x61, 0x27},
		expected: [][]byte{{0x20}, {0x61}, {0x27}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x20}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x61, 0x2c},
		expected: [][]byte{{0x20}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x31, 0x3a},
		expected: [][]byte{{0x20}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x31, 0x27},
		expected: [][]byte{{0x20}, {0x31}, {0x27}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x31, 0x2c},
		expected: [][]byte{{0x20}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x20}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x20, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x1},
		expected: [][]byte{{0xc2, 0xad}, {0x1}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xd},
		expected: [][]byte{{0xc2, 0xad}, {0xd}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xa},
		expected: [][]byte{{0xc2, 0xad}, {0xa}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xb},
		expected: [][]byte{{0xc2, 0xad}, {0xb}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xc2, 0xad}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x41},
		expected: [][]byte{{0xc2, 0xad}, {0x41}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x3a},
		expected: [][]byte{{0xc2, 0xad}, {0x3a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x2c},
		expected: [][]byte{{0xc2, 0xad}, {0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x2e},
		expected: [][]byte{{0xc2, 0xad}, {0x2e}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x30},
		expected: [][]byte{{0xc2, 0xad}, {0x30}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x5f},
		expected: [][]byte{{0xc2, 0xad}, {0x5f}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xc2, 0xad}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xd7, 0x90},
		expected: [][]byte{{0xc2, 0xad}, {0xd7, 0x90}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x22},
		expected: [][]byte{{0xc2, 0xad}, {0x22}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x27},
		expected: [][]byte{{0xc2, 0xad}, {0x27}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xc2, 0xad}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x20},
		expected: [][]byte{{0xc2, 0xad}, {0x20}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xc2, 0xad},
		expected: [][]byte{{0xc2, 0xad, 0xc2, 0xad}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x80},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x80}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xc2, 0xad, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xad}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x61, 0x3a},
		expected: [][]byte{{0xc2, 0xad}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x61, 0x27},
		expected: [][]byte{{0xc2, 0xad}, {0x61}, {0x27}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xad}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x61, 0x2c},
		expected: [][]byte{{0xc2, 0xad}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x31, 0x3a},
		expected: [][]byte{{0xc2, 0xad}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x31, 0x27},
		expected: [][]byte{{0xc2, 0xad}, {0x31}, {0x27}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x31, 0x2c},
		expected: [][]byte{{0xc2, 0xad}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xad}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xc2, 0xad, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xc2, 0xad, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] SOFT HYPHEN (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x1},
		expected: [][]byte{{0xcc, 0x80}, {0x1}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xd},
		expected: [][]byte{{0xcc, 0x80}, {0xd}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xa},
		expected: [][]byte{{0xcc, 0x80}, {0xa}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xb},
		expected: [][]byte{{0xcc, 0x80}, {0xb}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xcc, 0x80}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x41},
		expected: [][]byte{{0xcc, 0x80}, {0x41}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x3a},
		expected: [][]byte{{0xcc, 0x80}, {0x3a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x2c},
		expected: [][]byte{{0xcc, 0x80}, {0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x2e},
		expected: [][]byte{{0xcc, 0x80}, {0x2e}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x30},
		expected: [][]byte{{0xcc, 0x80}, {0x30}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x5f},
		expected: [][]byte{{0xcc, 0x80}, {0x5f}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcc, 0x80}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xd7, 0x90},
		expected: [][]byte{{0xcc, 0x80}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x22},
		expected: [][]byte{{0xcc, 0x80}, {0x22}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x27},
		expected: [][]byte{{0xcc, 0x80}, {0x27}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xcc, 0x80}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x20},
		expected: [][]byte{{0xcc, 0x80}, {0x20}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xc2, 0xad},
		expected: [][]byte{{0xcc, 0x80, 0xc2, 0xad}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcc, 0x80, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xcc, 0x80}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x61, 0x3a},
		expected: [][]byte{{0xcc, 0x80}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x61, 0x27},
		expected: [][]byte{{0xcc, 0x80}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xcc, 0x80}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x61, 0x2c},
		expected: [][]byte{{0xcc, 0x80}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x31, 0x3a},
		expected: [][]byte{{0xcc, 0x80}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x31, 0x27},
		expected: [][]byte{{0xcc, 0x80}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x31, 0x2c},
		expected: [][]byte{{0xcc, 0x80}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xcc, 0x80}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xcc, 0x80, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xcc, 0x80, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] COMBINING GRAVE ACCENT (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x1},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x1}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xd},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xd}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xa},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xa}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xb},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xb}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x41},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x41}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x3a},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x3a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x2c},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x2c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x2e},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x2e}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x30},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x30}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x5f},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x5f}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xd7, 0x90},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0xd7, 0x90}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x22},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x22}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x27},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x27}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x20},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x20}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xc2, 0xad},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xc2, 0xad}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x61, 0x3a},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x61, 0x27},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x61}, {0x27}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x61, 0x2c},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x31, 0x3a},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x31, 0x27},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x31}, {0x27}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x31, 0x2c},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x1},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xd},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xa},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xb},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x41},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x3a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x2c},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x2e},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x30},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x5f},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x22},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x27},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x20},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xc2, 0xad},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x80},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0x27},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x31, 0x3a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x31, 0x27},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x31, 0x2c},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [9.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x1},
		expected: [][]byte{{0x61}, {0x3a}, {0x1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xd},
		expected: [][]byte{{0x61}, {0x3a}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xa},
		expected: [][]byte{{0x61}, {0x3a}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xb},
		expected: [][]byte{{0x61}, {0x3a}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x3a}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x41},
		expected: [][]byte{{0x61, 0x3a, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x3a},
		expected: [][]byte{{0x61}, {0x3a}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x2c},
		expected: [][]byte{{0x61}, {0x3a}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x2e},
		expected: [][]byte{{0x61}, {0x3a}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x30},
		expected: [][]byte{{0x61}, {0x3a}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x5f},
		expected: [][]byte{{0x61}, {0x3a}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x3a}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0x3a, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x22},
		expected: [][]byte{{0x61}, {0x3a}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x27},
		expected: [][]byte{{0x61}, {0x3a}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x61}, {0x3a}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x20},
		expected: [][]byte{{0x61}, {0x3a}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x3a, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x3a, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x3a, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0x3a, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x61, 0x27},
		expected: [][]byte{{0x61, 0x3a, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x3a, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0x3a, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0x3a, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x3a}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x3a}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x3a}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x3a}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x3a, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x1},
		expected: [][]byte{{0x61}, {0x27}, {0x1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xd},
		expected: [][]byte{{0x61}, {0x27}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xa},
		expected: [][]byte{{0x61}, {0x27}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xb},
		expected: [][]byte{{0x61}, {0x27}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x27}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x41},
		expected: [][]byte{{0x61, 0x27, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x3a},
		expected: [][]byte{{0x61}, {0x27}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x2c},
		expected: [][]byte{{0x61}, {0x27}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x2e},
		expected: [][]byte{{0x61}, {0x27}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x30},
		expected: [][]byte{{0x61}, {0x27}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x5f},
		expected: [][]byte{{0x61}, {0x27}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x27}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0x27, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x22},
		expected: [][]byte{{0x61}, {0x27}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x27},
		expected: [][]byte{{0x61}, {0x27}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x61}, {0x27}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x20},
		expected: [][]byte{{0x61}, {0x27}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x27, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0x27, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x61, 0x27},
		expected: [][]byte{{0x61, 0x27, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0x27, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0x27, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x27}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x27}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x27}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x27}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x27, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x1},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xd},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xa},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xb},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x41},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x3a},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x2c},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x2e},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x30},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x5f},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x22},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x27},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x20},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0x27},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [6.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [7.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x27, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x1},
		expected: [][]byte{{0x61}, {0x2c}, {0x1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xd},
		expected: [][]byte{{0x61}, {0x2c}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xa},
		expected: [][]byte{{0x61}, {0x2c}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xb},
		expected: [][]byte{{0x61}, {0x2c}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x2c}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x41},
		expected: [][]byte{{0x61}, {0x2c}, {0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x3a},
		expected: [][]byte{{0x61}, {0x2c}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x2c},
		expected: [][]byte{{0x61}, {0x2c}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x2e},
		expected: [][]byte{{0x61}, {0x2c}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x30},
		expected: [][]byte{{0x61}, {0x2c}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x5f},
		expected: [][]byte{{0x61}, {0x2c}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x2c}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xd7, 0x90},
		expected: [][]byte{{0x61}, {0x2c}, {0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x22},
		expected: [][]byte{{0x61}, {0x2c}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x27},
		expected: [][]byte{{0x61}, {0x2c}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x61}, {0x2c}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x20},
		expected: [][]byte{{0x61}, {0x2c}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x2c, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x2c, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x2c}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x61, 0x3a},
		expected: [][]byte{{0x61}, {0x2c}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x61, 0x27},
		expected: [][]byte{{0x61}, {0x2c}, {0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x2c}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x61, 0x2c},
		expected: [][]byte{{0x61}, {0x2c}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x2c}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x2c}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x2c}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x2c}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x61}, {0x2c, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x1},
		expected: [][]byte{{0x31}, {0x3a}, {0x1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xd},
		expected: [][]byte{{0x31}, {0x3a}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xa},
		expected: [][]byte{{0x31}, {0x3a}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xb},
		expected: [][]byte{{0x31}, {0x3a}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x3a}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x41},
		expected: [][]byte{{0x31}, {0x3a}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x3a},
		expected: [][]byte{{0x31}, {0x3a}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x2c},
		expected: [][]byte{{0x31}, {0x3a}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x2e},
		expected: [][]byte{{0x31}, {0x3a}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x30},
		expected: [][]byte{{0x31}, {0x3a}, {0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x5f},
		expected: [][]byte{{0x31}, {0x3a}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x3a}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x3a}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x22},
		expected: [][]byte{{0x31}, {0x3a}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x27},
		expected: [][]byte{{0x31}, {0x3a}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x31}, {0x3a}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x20},
		expected: [][]byte{{0x31}, {0x3a}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x3a, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x3a, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x3a}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x3a}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x3a}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x3a}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x3a}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x31, 0x3a},
		expected: [][]byte{{0x31}, {0x3a}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x31, 0x27},
		expected: [][]byte{{0x31}, {0x3a}, {0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x31, 0x2c},
		expected: [][]byte{{0x31}, {0x3a}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x3a}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x3a, 0xcc, 0x88}, {0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x1},
		expected: [][]byte{{0x31}, {0x27}, {0x1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xd},
		expected: [][]byte{{0x31}, {0x27}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xa},
		expected: [][]byte{{0x31}, {0x27}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xb},
		expected: [][]byte{{0x31}, {0x27}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x27}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x41},
		expected: [][]byte{{0x31}, {0x27}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x3a},
		expected: [][]byte{{0x31}, {0x27}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x2c},
		expected: [][]byte{{0x31}, {0x27}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x2e},
		expected: [][]byte{{0x31}, {0x27}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x30},
		expected: [][]byte{{0x31, 0x27, 0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x31, 0x27, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x5f},
		expected: [][]byte{{0x31}, {0x27}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x27}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x27}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x22},
		expected: [][]byte{{0x31}, {0x27}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x27},
		expected: [][]byte{{0x31}, {0x27}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x31}, {0x27}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x20},
		expected: [][]byte{{0x31}, {0x27}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x27, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x27, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x27}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x27}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x27}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x27}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x27}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x27, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x31, 0x3a},
		expected: [][]byte{{0x31, 0x27, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x31, 0x27, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x31, 0x27},
		expected: [][]byte{{0x31, 0x27, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x31, 0x27, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x31, 0x2c},
		expected: [][]byte{{0x31, 0x27, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x31, 0x27, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31, 0x27, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x27, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31, 0x27, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] APOSTROPHE (Single_Quote) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x1},
		expected: [][]byte{{0x31}, {0x2c}, {0x1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xd},
		expected: [][]byte{{0x31}, {0x2c}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xa},
		expected: [][]byte{{0x31}, {0x2c}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xb},
		expected: [][]byte{{0x31}, {0x2c}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x2c}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x41},
		expected: [][]byte{{0x31}, {0x2c}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x3a},
		expected: [][]byte{{0x31}, {0x2c}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x2c},
		expected: [][]byte{{0x31}, {0x2c}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x2e},
		expected: [][]byte{{0x31}, {0x2c}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x30},
		expected: [][]byte{{0x31, 0x2c, 0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x31, 0x2c, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x5f},
		expected: [][]byte{{0x31}, {0x2c}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x2c}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x2c}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x22},
		expected: [][]byte{{0x31}, {0x2c}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x27},
		expected: [][]byte{{0x31}, {0x2c}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x31}, {0x2c}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x20},
		expected: [][]byte{{0x31}, {0x2c}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x2c, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x2c, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2c}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x2c}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x2c}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2c}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x2c}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x2c, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x31, 0x3a},
		expected: [][]byte{{0x31, 0x2c, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x31, 0x2c, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x31, 0x27},
		expected: [][]byte{{0x31, 0x2c, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x31, 0x2c, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x31, 0x2c},
		expected: [][]byte{{0x31, 0x2c, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x31, 0x2c, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31, 0x2c, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31, 0x2c, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] COMMA (MidNum) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x1},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x1},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] <START OF HEADING> (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xd},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xd}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <CARRIAGE RETURN (CR)> (CR) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xa},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xa},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xa}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xb},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xb},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xb}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [3.2] <LINE TABULATION> (Newline) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x41},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x41},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x41}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x3a},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x3a},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x2c},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2c},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x2e},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x2e},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x2e}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] FULL STOP (MidNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x30},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x30}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x5f},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x5f},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x5f}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xf0, 0x9f, 0x87, 0xa6},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xf0, 0x9f, 0x87, 0xa6}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xd7, 0x90},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xd7, 0x90}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x22},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x22},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x22}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] QUOTATION MARK (Double_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x27},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x27},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x8c, 0x9a},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0xe2, 0x8c, 0x9a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] WATCH (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x20},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x20},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x20}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xc2, 0xad}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] SOFT HYPHEN (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xcc, 0x80}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] COMBINING GRAVE ACCENT (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0xe2, 0x80, 0x8d}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x61, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x3a},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x61}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x61}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x27, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x61}, {0x27, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] APOSTROPHE (Single_Quote) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x61, 0x2c},
		expected: [][]byte{{0x31}, {0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88}, {0x61}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0x3a},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x3a},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x3a}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0x27},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x27},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x27}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0x2c},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2c},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x2c}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31, 0x2e, 0xe2, 0x81, 0xa0},
		expected: [][]byte{{0x31, 0x2e, 0xe2, 0x81, 0xa0, 0xcc, 0x88, 0x31}, {0x2e, 0xe2, 0x81, 0xa0}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [12.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [11.0] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) × [4.0] WORD JOINER (Format_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xd, 0xa, 0x61, 0xa, 0xcc, 0x88},
		expected: [][]byte{{0xd, 0xa}, {0x61}, {0xa}, {0xcc, 0x88}},
		comment:  "÷ [0.2] <CARRIAGE RETURN (CR)> (CR) × [3.0] <LINE FEED (LF)> (LF) ÷ [3.1] LATIN SMALL LETTER A (ALetter) ÷ [3.2] <LINE FEED (LF)> (LF) ÷ [3.1] COMBINING DIAERESIS (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88},
		expected: [][]byte{{0x61, 0xcc, 0x88}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0x20, 0xe2, 0x80, 0x8d, 0xd9, 0x86},
		expected: [][]byte{{0x20, 0xe2, 0x80, 0x8d}, {0xd9, 0x86}},
		comment:  "÷ [0.2] SPACE (WSegSpace) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] ARABIC LETTER NOON (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd9, 0x86, 0xe2, 0x80, 0x8d, 0x20},
		expected: [][]byte{{0xd9, 0x86, 0xe2, 0x80, 0x8d}, {0x20}},
		comment:  "÷ [0.2] ARABIC LETTER NOON (ALetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] SPACE (WSegSpace) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x41, 0x41},
		expected: [][]byte{{0x41, 0x41, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN CAPITAL LETTER A (ALetter) × [5.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x3a, 0x41},
		expected: [][]byte{{0x41, 0x3a, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [6.0] COLON (MidLetter) × [7.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x3a, 0x3a, 0x41},
		expected: [][]byte{{0x41}, {0x3a}, {0x3a}, {0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x27},
		expected: [][]byte{{0xd7, 0x90, 0x27}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [7.1] APOSTROPHE (Single_Quote) ÷ [0.3]",
	},
	{
		input:    []byte{0xd7, 0x90, 0x22, 0xd7, 0x90},
		expected: [][]byte{{0xd7, 0x90, 0x22, 0xd7, 0x90}},
		comment:  "÷ [0.2] HEBREW LETTER ALEF (Hebrew_Letter) × [7.2] QUOTATION MARK (Double_Quote) × [7.3] HEBREW LETTER ALEF (Hebrew_Letter) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x30, 0x30, 0x41},
		expected: [][]byte{{0x41, 0x30, 0x30, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [9.0] DIGIT ZERO (Numeric) × [8.0] DIGIT ZERO (Numeric) × [10.0] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x2c, 0x30},
		expected: [][]byte{{0x30, 0x2c, 0x30}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) × [12.0] COMMA (MidNum) × [11.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x30, 0x2c, 0x2c, 0x30},
		expected: [][]byte{{0x30}, {0x2c}, {0x2c}, {0x30}},
		comment:  "÷ [0.2] DIGIT ZERO (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ZERO (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0xe3, 0x80, 0xb1, 0xe3, 0x80, 0xb1},
		expected: [][]byte{{0xe3, 0x80, 0xb1, 0xe3, 0x80, 0xb1}},
		comment:  "÷ [0.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.0] VERTICAL KANA REPEAT MARK (Katakana) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x5f, 0x30, 0x5f, 0xe3, 0x80, 0xb1, 0x5f},
		expected: [][]byte{{0x41, 0x5f, 0x30, 0x5f, 0xe3, 0x80, 0xb1, 0x5f}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ZERO (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] VERTICAL KANA REPEAT MARK (Katakana) × [13.1] LOW LINE (ExtendNumLet) ÷ [0.3]",
	},
	{
		input:    []byte{0x41, 0x5f, 0x5f, 0x41},
		expected: [][]byte{{0x41, 0x5f, 0x5f, 0x41}},
		comment:  "÷ [0.2] LATIN CAPITAL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN CAPITAL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [15.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [16.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xe2, 0x80, 0x8d}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [16.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [16.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7, 0xf0, 0x9f, 0x87, 0xa8, 0xf0, 0x9f, 0x87, 0xa9, 0x62},
		expected: [][]byte{{0x61}, {0xf0, 0x9f, 0x87, 0xa6, 0xf0, 0x9f, 0x87, 0xa7}, {0xf0, 0x9f, 0x87, 0xa8, 0xf0, 0x9f, 0x87, 0xa9}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER A (RI) × [16.0] REGIONAL INDICATOR SYMBOL LETTER B (RI) ÷ [999.0] REGIONAL INDICATOR SYMBOL LETTER C (RI) × [16.0] REGIONAL INDICATOR SYMBOL LETTER D (RI) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf, 0xf0, 0x9f, 0x91, 0xb6},
		expected: [][]byte{{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf}, {0xf0, 0x9f, 0x91, 0xb6}},
		comment:  "÷ [0.2] BABY (ExtPict) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_FE) ÷ [999.0] BABY (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x9b, 0x91, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0xf0, 0x9f, 0x9b, 0x91, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] OCTAGONAL SIGN (ExtPict) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] OCTAGONAL SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0x61, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] OCTAGONAL SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x9c, 0x81, 0xe2, 0x80, 0x8d, 0xe2, 0x9c, 0x81},
		expected: [][]byte{{0xe2, 0x9c, 0x81, 0xe2, 0x80, 0x8d, 0xe2, 0x9c, 0x81}},
		comment:  "÷ [0.2] UPPER BLADE SCISSORS (Other) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] UPPER BLADE SCISSORS (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xe2, 0x80, 0x8d, 0xe2, 0x9c, 0x81},
		expected: [][]byte{{0x61, 0xe2, 0x80, 0x8d, 0xe2, 0x9c, 0x81}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] UPPER BLADE SCISSORS (Other) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf, 0xcc, 0x88, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf},
		expected: [][]byte{{0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf, 0xcc, 0x88, 0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x91, 0xb6, 0xf0, 0x9f, 0x8f, 0xbf}},
		comment:  "÷ [0.2] BABY (ExtPict) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] BABY (ExtPict) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x9b, 0x91, 0xf0, 0x9f, 0x8f, 0xbf},
		expected: [][]byte{{0xf0, 0x9f, 0x9b, 0x91, 0xf0, 0x9f, 0x8f, 0xbf}},
		comment:  "÷ [0.2] OCTAGONAL SIGN (ExtPict) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91, 0xf0, 0x9f, 0x8f, 0xbf},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91, 0xf0, 0x9f, 0x8f, 0xbf}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] OCTAGONAL SIGN (ExtPict) × [4.0] EMOJI MODIFIER FITZPATRICK TYPE-6 (Extend_FE) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] OCTAGONAL SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0xe2, 0x80, 0x8d, 0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] ZERO WIDTH JOINER (ZWJ_FE) × [3.3] OCTAGONAL SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0xf0, 0x9f, 0x9b, 0x91, 0xf0, 0x9f, 0x9b, 0x91},
		expected: [][]byte{{0xf0, 0x9f, 0x9b, 0x91}, {0xf0, 0x9f, 0x9b, 0x91}},
		comment:  "÷ [0.2] OCTAGONAL SIGN (ExtPict) ÷ [999.0] OCTAGONAL SIGN (ExtPict) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0xcc, 0x88, 0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x62},
		expected: [][]byte{{0x61, 0xcc, 0x88, 0xe2, 0x80, 0x8d, 0xcc, 0x88, 0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [4.0] COMBINING DIAERESIS (Extend_FE) × [4.0] ZERO WIDTH JOINER (ZWJ_FE) × [4.0] COMBINING DIAERESIS (Extend_FE) × [5.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x20, 0x20, 0x62},
		expected: [][]byte{{0x61}, {0x20, 0x20}, {0x62}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] SPACE (WSegSpace) × [3.4] SPACE (WSegSpace) ÷ [999.0] LATIN SMALL LETTER B (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x3a, 0x31},
		expected: [][]byte{{0x31}, {0x3a}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x3a, 0x3a, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x3a}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x3a, 0x3a, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x3a}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x3a, 0x61},
		expected: [][]byte{{0x31}, {0x3a}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x3a, 0x3a, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x3a}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x3a, 0x3a, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x3a}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x2e, 0x31},
		expected: [][]byte{{0x31}, {0x3a}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x3a, 0x2e, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x3a}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x3a, 0x2e, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x3a}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x2e, 0x61},
		expected: [][]byte{{0x31}, {0x3a}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x3a, 0x2e, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x3a}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x3a, 0x2e, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x3a}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x2c, 0x31},
		expected: [][]byte{{0x31}, {0x3a}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x3a, 0x2c, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x3a}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x3a, 0x2c, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x3a}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x3a, 0x2c, 0x61},
		expected: [][]byte{{0x31}, {0x3a}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x3a, 0x2c, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x3a}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x3a, 0x2c, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x3a}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0x3a, 0x31},
		expected: [][]byte{{0x31}, {0x2e}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2e, 0x3a, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2e}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2e, 0x3a, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2e}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0x3a, 0x61},
		expected: [][]byte{{0x31}, {0x2e}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2e, 0x3a, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2e}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2e, 0x3a, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2e}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0x2e, 0x31},
		expected: [][]byte{{0x31}, {0x2e}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2e, 0x2e, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2e}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2e, 0x2e, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2e}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0x2e, 0x61},
		expected: [][]byte{{0x31}, {0x2e}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2e, 0x2e, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2e}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2e, 0x2e, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2e}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0x2c, 0x31},
		expected: [][]byte{{0x31}, {0x2e}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2e, 0x2c, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2e}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2e, 0x2c, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2e}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2e, 0x2c, 0x61},
		expected: [][]byte{{0x31}, {0x2e}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2e, 0x2c, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2e}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2e, 0x2c, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2e}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x3a, 0x31},
		expected: [][]byte{{0x31}, {0x2c}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2c, 0x3a, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2c}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2c, 0x3a, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2c}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x3a, 0x61},
		expected: [][]byte{{0x31}, {0x2c}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2c, 0x3a, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2c}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2c, 0x3a, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2c}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x2e, 0x31},
		expected: [][]byte{{0x31}, {0x2c}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2c, 0x2e, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2c}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2c, 0x2e, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2c}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x2e, 0x61},
		expected: [][]byte{{0x31}, {0x2c}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2c, 0x2e, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2c}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2c, 0x2e, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2c}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x2c, 0x31},
		expected: [][]byte{{0x31}, {0x2c}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2c, 0x2c, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2c}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2c, 0x2c, 0x31},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2c}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x2c, 0x2c, 0x61},
		expected: [][]byte{{0x31}, {0x2c}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x31, 0x2c, 0x2c, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x31}, {0x2c}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x31, 0x5f, 0x61, 0x2c, 0x2c, 0x61},
		expected: [][]byte{{0x31, 0x5f, 0x61}, {0x2c}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] DIGIT ONE (Numeric) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x3a, 0x31},
		expected: [][]byte{{0x61}, {0x3a}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x3a, 0x3a, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x3a}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x3a, 0x3a, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x3a}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x3a, 0x61},
		expected: [][]byte{{0x61}, {0x3a}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x3a, 0x3a, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x3a}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x3a, 0x3a, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x3a}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x2e, 0x31},
		expected: [][]byte{{0x61}, {0x3a}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x3a, 0x2e, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x3a}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x3a, 0x2e, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x3a}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x2e, 0x61},
		expected: [][]byte{{0x61}, {0x3a}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x3a, 0x2e, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x3a}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x3a, 0x2e, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x3a}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x2c, 0x31},
		expected: [][]byte{{0x61}, {0x3a}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x3a, 0x2c, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x3a}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x3a, 0x2c, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x3a}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x3a, 0x2c, 0x61},
		expected: [][]byte{{0x61}, {0x3a}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x3a, 0x2c, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x3a}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x3a, 0x2c, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x3a}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COLON (MidLetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0x3a, 0x31},
		expected: [][]byte{{0x61}, {0x2e}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2e, 0x3a, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2e}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2e, 0x3a, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2e}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0x3a, 0x61},
		expected: [][]byte{{0x61}, {0x2e}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2e, 0x3a, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2e}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2e, 0x3a, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2e}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0x2e, 0x31},
		expected: [][]byte{{0x61}, {0x2e}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2e, 0x2e, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2e}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2e, 0x2e, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2e}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0x2e, 0x61},
		expected: [][]byte{{0x61}, {0x2e}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2e, 0x2e, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2e}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2e, 0x2e, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2e}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0x2c, 0x31},
		expected: [][]byte{{0x61}, {0x2e}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2e, 0x2c, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2e}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2e, 0x2c, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2e}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2e, 0x2c, 0x61},
		expected: [][]byte{{0x61}, {0x2e}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2e, 0x2c, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2e}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2e, 0x2c, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2e}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x3a, 0x31},
		expected: [][]byte{{0x61}, {0x2c}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2c, 0x3a, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2c}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2c, 0x3a, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2c}, {0x3a}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x3a, 0x61},
		expected: [][]byte{{0x61}, {0x2c}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2c, 0x3a, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2c}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2c, 0x3a, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2c}, {0x3a}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COLON (MidLetter) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x2e, 0x31},
		expected: [][]byte{{0x61}, {0x2c}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2c, 0x2e, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2c}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2c, 0x2e, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2c}, {0x2e}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x2e, 0x61},
		expected: [][]byte{{0x61}, {0x2c}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2c, 0x2e, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2c}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2c, 0x2e, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2c}, {0x2e}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] FULL STOP (MidNumLet) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x2c, 0x31},
		expected: [][]byte{{0x61}, {0x2c}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2c, 0x2c, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2c}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2c, 0x2c, 0x31},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2c}, {0x2c}, {0x31}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] DIGIT ONE (Numeric) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x2c, 0x2c, 0x61},
		expected: [][]byte{{0x61}, {0x2c}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x31, 0x2c, 0x2c, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x31}, {0x2c}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] DIGIT ONE (Numeric) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
	{
		input:    []byte{0x61, 0x5f, 0x61, 0x2c, 0x2c, 0x61},
		expected: [][]byte{{0x61, 0x5f, 0x61}, {0x2c}, {0x2c}, {0x61}},
		comment:  "÷ [0.2] LATIN SMALL LETTER A (ALetter) × [13.1] LOW LINE (ExtendNumLet) × [13.2] LATIN SMALL LETTER A (ALetter) ÷ [999.0] COMMA (MidNum) ÷ [999.0] COMMA (MidNum) ÷ [999.0] LATIN SMALL LETTER A (ALetter) ÷ [0.3]",
	},
}
