-- Generated by grype/db/v6/schema
-- DO NOT EDIT: This file is auto-generated. Run 'task generate-db-schema' to update.
-- Schema version: 6.1.1

CREATE TABLE `affected_cpe_handles` (`id` integer PRIMARY KEY AUTOINCREMENT,`vulnerability_id` integer NOT NULL,`cpe_id` integer,`blob_id` integer,CONSTRAINT `fk_affected_cpe_handles_cpe` FOREIGN KEY (`cpe_id`) REFERENCES `cpes`(`id`,CONSTRAINT `fk_affected_cpe_handles_vulnerability` FOREIGN KEY (`vulnerability_id`) REFERENCES `vulnerability_handles`(`id`);

CREATE TABLE `affected_package_handles` (`id` integer PRIMARY KEY AUTOINCREMENT,`vulnerability_id` integer NOT NULL,`operating_system_id` integer,`package_id` integer,`blob_id` integer,CONSTRAINT `fk_affected_package_handles_operating_system` FOREIGN KEY (`operating_system_id`) REFERENCES `operating_systems`(`id`,CONSTRAINT `fk_affected_package_handles_package` FOREIGN KEY (`package_id`) REFERENCES `packages`(`id`,CONSTRAINT `fk_affected_package_handles_vulnerability` FOREIGN KEY (`vulnerability_id`) REFERENCES `vulnerability_handles`(`id`);

CREATE TABLE `blobs` (`id` integer PRIMARY KEY AUTOINCREMENT,`value` text NOT NULL);

CREATE TABLE `cpes` (`id` integer PRIMARY KEY AUTOINCREMENT,`part` text NOT NULL,`vendor` text,`product` text NOT NULL,`edition` text,`language` text,`software_edition` text,`target_hardware` text,`target_software` text,`other` text);

CREATE TABLE `db_metadata` (`build_timestamp` datetime NOT NULL,`model` integer NOT NULL,`revision` integer NOT NULL,`addition` integer NOT NULL);

CREATE TABLE `epss_handles` (`id` integer PRIMARY KEY AUTOINCREMENT,`cve` text NOT NULL,`epss` real NOT NULL,`percentile` real NOT NULL);

CREATE TABLE `epss_metadata` (`date` datetime NOT NULL);

CREATE TABLE `known_exploited_vulnerability_handles` (`id` integer PRIMARY KEY AUTOINCREMENT,`cve` text NOT NULL,`blob_id` integer);

CREATE TABLE `operating_system_specifier_overrides` (`alias` text,`version` text,`version_pattern` text,`codename` text,`channel` text,`replacement` text,`replacement_major_version` text,`replacement_minor_version` text,`replacement_label_version` text,`replacement_channel` text,`rolling` numeric,`applicable_client_db_schemas` text,PRIMARY KEY (`alias`,`version`,`version_pattern`,`replacement`,`replacement_major_version`,`replacement_minor_version`,`replacement_label_version`,`replacement_channel`,`rolling`));

CREATE TABLE `operating_systems` (`id` integer PRIMARY KEY AUTOINCREMENT,`name` text,`release_id` text,`major_version` text,`minor_version` text,`label_version` text,`codename` text,`channel` text);

CREATE TABLE `package_cpes` (`cpe_id` integer,`package_id` integer,PRIMARY KEY (`cpe_id`,`package_id`),CONSTRAINT `fk_package_cpes_cpe` FOREIGN KEY (`cpe_id`) REFERENCES `cpes`(`id`,CONSTRAINT `fk_package_cpes_package` FOREIGN KEY (`package_id`) REFERENCES `packages`(`id`);

CREATE TABLE `package_specifier_overrides` (`ecosystem` text,`replacement_ecosystem` text,PRIMARY KEY (`ecosystem`,`replacement_ecosystem`));

CREATE TABLE `packages` (`id` integer PRIMARY KEY AUTOINCREMENT,`ecosystem` text,`name` text);

CREATE TABLE `providers` (`id` text,`version` text,`processor` text,`date_captured` datetime,`input_digest` text,PRIMARY KEY (`id`));

CREATE TABLE `unaffected_cpe_handles` (`id` integer PRIMARY KEY AUTOINCREMENT,`vulnerability_id` integer NOT NULL,`cpe_id` integer,`blob_id` integer,CONSTRAINT `fk_unaffected_cpe_handles_cpe` FOREIGN KEY (`cpe_id`) REFERENCES `cpes`(`id`,CONSTRAINT `fk_unaffected_cpe_handles_vulnerability` FOREIGN KEY (`vulnerability_id`) REFERENCES `vulnerability_handles`(`id`);

CREATE TABLE `unaffected_package_handles` (`id` integer PRIMARY KEY AUTOINCREMENT,`vulnerability_id` integer NOT NULL,`operating_system_id` integer,`package_id` integer,`blob_id` integer,CONSTRAINT `fk_unaffected_package_handles_operating_system` FOREIGN KEY (`operating_system_id`) REFERENCES `operating_systems`(`id`,CONSTRAINT `fk_unaffected_package_handles_package` FOREIGN KEY (`package_id`) REFERENCES `packages`(`id`,CONSTRAINT `fk_unaffected_package_handles_vulnerability` FOREIGN KEY (`vulnerability_id`) REFERENCES `vulnerability_handles`(`id`);

CREATE TABLE `vulnerability_aliases` (`name` text,`alias` text NOT NULL,PRIMARY KEY (`name`,`alias`));

CREATE TABLE `vulnerability_handles` (`id` integer PRIMARY KEY AUTOINCREMENT,`name` text NOT NULL,`status` text NOT NULL,`published_date` datetime,`modified_date` datetime,`withdrawn_date` datetime,`provider_id` text NOT NULL,`blob_id` integer,CONSTRAINT `fk_vulnerability_handles_provider` FOREIGN KEY (`provider_id`) REFERENCES `providers`(`id`);

-- Indexes
CREATE INDEX `epss_cve_idx` ON `epss_handles`(`cve` COLLATE NOCASE);

CREATE INDEX `idx_affected_cpe_handles_cpe_id` ON `affected_cpe_handles`(`cpe_id`);

CREATE INDEX `idx_affected_package_handles_operating_system_id` ON `affected_package_handles`(`operating_system_id`);

CREATE INDEX `idx_affected_package_handles_package_id` ON `affected_package_handles`(`package_id`);

CREATE INDEX `idx_affected_package_handles_vulnerability_id` ON `affected_package_handles`(`vulnerability_id`);

CREATE INDEX `idx_cpe_product` ON `cpes`(`product` COLLATE NOCASE);

CREATE INDEX `idx_cpe_vendor` ON `cpes`(`vendor` COLLATE NOCASE);

CREATE INDEX `idx_operating_systems_major_version` ON `operating_systems`(`major_version`);

CREATE INDEX `idx_operating_systems_minor_version` ON `operating_systems`(`minor_version`);

CREATE INDEX `idx_package_name` ON `packages`(`name` COLLATE NOCASE);

CREATE INDEX `idx_unaffected_cpe_handles_cpe_id` ON `unaffected_cpe_handles`(`cpe_id`);

CREATE INDEX `idx_unaffected_package_handles_operating_system_id` ON `unaffected_package_handles`(`operating_system_id`);

CREATE INDEX `idx_unaffected_package_handles_package_id` ON `unaffected_package_handles`(`package_id`);

CREATE INDEX `idx_unaffected_package_handles_vulnerability_id` ON `unaffected_package_handles`(`vulnerability_id`);

CREATE INDEX `idx_vuln_provider_id` ON `vulnerability_handles`(`name` COLLATE NOCASE,`provider_id` COLLATE NOCASE);

CREATE INDEX `idx_vulnerability_handles_modified_date` ON `vulnerability_handles`(`modified_date`);

CREATE INDEX `idx_vulnerability_handles_provider_id` ON `vulnerability_handles`(`provider_id`);

CREATE INDEX `idx_vulnerability_handles_published_date` ON `vulnerability_handles`(`published_date`);

CREATE INDEX `idx_vulnerability_handles_withdrawn_date` ON `vulnerability_handles`(`withdrawn_date`);

CREATE INDEX `kev_cve_idx` ON `known_exploited_vulnerability_handles`(`cve` COLLATE NOCASE);

CREATE INDEX `os_alias_idx` ON `operating_system_specifier_overrides`(`alias` COLLATE NOCASE);

CREATE INDEX `pkg_ecosystem_idx` ON `package_specifier_overrides`(`ecosystem` COLLATE NOCASE);

CREATE UNIQUE INDEX `idx_cpe` ON `cpes`(`part` COLLATE NOCASE,`vendor` COLLATE NOCASE,`product` COLLATE NOCASE,`edition` COLLATE NOCASE,`language` COLLATE NOCASE,`software_edition` COLLATE NOCASE,`target_hardware` COLLATE NOCASE,`target_software` COLLATE NOCASE,`other` COLLATE NOCASE);

CREATE UNIQUE INDEX `idx_package` ON `packages`(`ecosystem` COLLATE NOCASE,`name` COLLATE NOCASE);

CREATE UNIQUE INDEX `os_idx` ON `operating_systems`(`name`,`release_id`,`major_version`,`minor_version`,`label_version`,`channel`);

