// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package managedblockchainquery

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opBatchGetTokenBalance = "BatchGetTokenBalance"

// BatchGetTokenBalanceRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetTokenBalance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetTokenBalance for more information on using the BatchGetTokenBalance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetTokenBalanceRequest method.
//	req, resp := client.BatchGetTokenBalanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/BatchGetTokenBalance
func (c *ManagedBlockchainQuery) BatchGetTokenBalanceRequest(input *BatchGetTokenBalanceInput) (req *request.Request, output *BatchGetTokenBalanceOutput) {
	op := &request.Operation{
		Name:       opBatchGetTokenBalance,
		HTTPMethod: "POST",
		HTTPPath:   "/batch-get-token-balance",
	}

	if input == nil {
		input = &BatchGetTokenBalanceInput{}
	}

	output = &BatchGetTokenBalanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchGetTokenBalance API operation for Amazon Managed Blockchain Query.
//
// Gets the token balance for a batch of tokens by using the BatchGetTokenBalance
// action for every token in the request.
//
// Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155
// token standards are supported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain Query's
// API operation BatchGetTokenBalance for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request or operation couldn't be performed because a service is throttling
//     requests. The most common source of throttling errors is when you create
//     resources that exceed your service limit for this resource type. Request
//     a limit increase or delete unused resources, if possible.
//
//   - ValidationException
//     The resource passed is invalid.
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - AccessDeniedException
//     The Amazon Web Services account doesn’t have access to this resource.
//
//   - InternalServerException
//     The request processing has failed because of an internal error in the service.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded for this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/BatchGetTokenBalance
func (c *ManagedBlockchainQuery) BatchGetTokenBalance(input *BatchGetTokenBalanceInput) (*BatchGetTokenBalanceOutput, error) {
	req, out := c.BatchGetTokenBalanceRequest(input)
	return out, req.Send()
}

// BatchGetTokenBalanceWithContext is the same as BatchGetTokenBalance with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetTokenBalance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) BatchGetTokenBalanceWithContext(ctx aws.Context, input *BatchGetTokenBalanceInput, opts ...request.Option) (*BatchGetTokenBalanceOutput, error) {
	req, out := c.BatchGetTokenBalanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssetContract = "GetAssetContract"

// GetAssetContractRequest generates a "aws/request.Request" representing the
// client's request for the GetAssetContract operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssetContract for more information on using the GetAssetContract
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetAssetContractRequest method.
//	req, resp := client.GetAssetContractRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/GetAssetContract
func (c *ManagedBlockchainQuery) GetAssetContractRequest(input *GetAssetContractInput) (req *request.Request, output *GetAssetContractOutput) {
	op := &request.Operation{
		Name:       opGetAssetContract,
		HTTPMethod: "POST",
		HTTPPath:   "/get-asset-contract",
	}

	if input == nil {
		input = &GetAssetContractInput{}
	}

	output = &GetAssetContractOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssetContract API operation for Amazon Managed Blockchain Query.
//
// Gets the information about a specific contract deployed on the blockchain.
//
//   - The Bitcoin blockchain networks do not support this operation.
//
//   - Metadata is currently only available for some ERC-20 contracts. Metadata
//     will be available for additional contracts in the future.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain Query's
// API operation GetAssetContract for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request or operation couldn't be performed because a service is throttling
//     requests. The most common source of throttling errors is when you create
//     resources that exceed your service limit for this resource type. Request
//     a limit increase or delete unused resources, if possible.
//
//   - ValidationException
//     The resource passed is invalid.
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - AccessDeniedException
//     The Amazon Web Services account doesn’t have access to this resource.
//
//   - InternalServerException
//     The request processing has failed because of an internal error in the service.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded for this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/GetAssetContract
func (c *ManagedBlockchainQuery) GetAssetContract(input *GetAssetContractInput) (*GetAssetContractOutput, error) {
	req, out := c.GetAssetContractRequest(input)
	return out, req.Send()
}

// GetAssetContractWithContext is the same as GetAssetContract with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssetContract for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) GetAssetContractWithContext(ctx aws.Context, input *GetAssetContractInput, opts ...request.Option) (*GetAssetContractOutput, error) {
	req, out := c.GetAssetContractRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTokenBalance = "GetTokenBalance"

// GetTokenBalanceRequest generates a "aws/request.Request" representing the
// client's request for the GetTokenBalance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTokenBalance for more information on using the GetTokenBalance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTokenBalanceRequest method.
//	req, resp := client.GetTokenBalanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/GetTokenBalance
func (c *ManagedBlockchainQuery) GetTokenBalanceRequest(input *GetTokenBalanceInput) (req *request.Request, output *GetTokenBalanceOutput) {
	op := &request.Operation{
		Name:       opGetTokenBalance,
		HTTPMethod: "POST",
		HTTPPath:   "/get-token-balance",
	}

	if input == nil {
		input = &GetTokenBalanceInput{}
	}

	output = &GetTokenBalanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTokenBalance API operation for Amazon Managed Blockchain Query.
//
// Gets the balance of a specific token, including native tokens, for a given
// address (wallet or contract) on the blockchain.
//
// Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155
// token standards are supported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain Query's
// API operation GetTokenBalance for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request or operation couldn't be performed because a service is throttling
//     requests. The most common source of throttling errors is when you create
//     resources that exceed your service limit for this resource type. Request
//     a limit increase or delete unused resources, if possible.
//
//   - ValidationException
//     The resource passed is invalid.
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - AccessDeniedException
//     The Amazon Web Services account doesn’t have access to this resource.
//
//   - InternalServerException
//     The request processing has failed because of an internal error in the service.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded for this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/GetTokenBalance
func (c *ManagedBlockchainQuery) GetTokenBalance(input *GetTokenBalanceInput) (*GetTokenBalanceOutput, error) {
	req, out := c.GetTokenBalanceRequest(input)
	return out, req.Send()
}

// GetTokenBalanceWithContext is the same as GetTokenBalance with the addition of
// the ability to pass a context and additional request options.
//
// See GetTokenBalance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) GetTokenBalanceWithContext(ctx aws.Context, input *GetTokenBalanceInput, opts ...request.Option) (*GetTokenBalanceOutput, error) {
	req, out := c.GetTokenBalanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTransaction = "GetTransaction"

// GetTransactionRequest generates a "aws/request.Request" representing the
// client's request for the GetTransaction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTransaction for more information on using the GetTransaction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTransactionRequest method.
//	req, resp := client.GetTransactionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/GetTransaction
func (c *ManagedBlockchainQuery) GetTransactionRequest(input *GetTransactionInput) (req *request.Request, output *GetTransactionOutput) {
	op := &request.Operation{
		Name:       opGetTransaction,
		HTTPMethod: "POST",
		HTTPPath:   "/get-transaction",
	}

	if input == nil {
		input = &GetTransactionInput{}
	}

	output = &GetTransactionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTransaction API operation for Amazon Managed Blockchain Query.
//
// Gets the details of a transaction.
//
// This action will return transaction details for all transactions that are
// confirmed on the blockchain, even if they have not reached finality (https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain Query's
// API operation GetTransaction for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request or operation couldn't be performed because a service is throttling
//     requests. The most common source of throttling errors is when you create
//     resources that exceed your service limit for this resource type. Request
//     a limit increase or delete unused resources, if possible.
//
//   - ValidationException
//     The resource passed is invalid.
//
//   - ResourceNotFoundException
//     The resource was not found.
//
//   - AccessDeniedException
//     The Amazon Web Services account doesn’t have access to this resource.
//
//   - InternalServerException
//     The request processing has failed because of an internal error in the service.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded for this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/GetTransaction
func (c *ManagedBlockchainQuery) GetTransaction(input *GetTransactionInput) (*GetTransactionOutput, error) {
	req, out := c.GetTransactionRequest(input)
	return out, req.Send()
}

// GetTransactionWithContext is the same as GetTransaction with the addition of
// the ability to pass a context and additional request options.
//
// See GetTransaction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) GetTransactionWithContext(ctx aws.Context, input *GetTransactionInput, opts ...request.Option) (*GetTransactionOutput, error) {
	req, out := c.GetTransactionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAssetContracts = "ListAssetContracts"

// ListAssetContractsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssetContracts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssetContracts for more information on using the ListAssetContracts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAssetContractsRequest method.
//	req, resp := client.ListAssetContractsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListAssetContracts
func (c *ManagedBlockchainQuery) ListAssetContractsRequest(input *ListAssetContractsInput) (req *request.Request, output *ListAssetContractsOutput) {
	op := &request.Operation{
		Name:       opListAssetContracts,
		HTTPMethod: "POST",
		HTTPPath:   "/list-asset-contracts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssetContractsInput{}
	}

	output = &ListAssetContractsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssetContracts API operation for Amazon Managed Blockchain Query.
//
// Lists all the contracts for a given contract type deployed by an address
// (either a contract address or a wallet address).
//
// The Bitcoin blockchain networks do not support this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain Query's
// API operation ListAssetContracts for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request or operation couldn't be performed because a service is throttling
//     requests. The most common source of throttling errors is when you create
//     resources that exceed your service limit for this resource type. Request
//     a limit increase or delete unused resources, if possible.
//
//   - ValidationException
//     The resource passed is invalid.
//
//   - AccessDeniedException
//     The Amazon Web Services account doesn’t have access to this resource.
//
//   - InternalServerException
//     The request processing has failed because of an internal error in the service.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded for this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListAssetContracts
func (c *ManagedBlockchainQuery) ListAssetContracts(input *ListAssetContractsInput) (*ListAssetContractsOutput, error) {
	req, out := c.ListAssetContractsRequest(input)
	return out, req.Send()
}

// ListAssetContractsWithContext is the same as ListAssetContracts with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssetContracts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) ListAssetContractsWithContext(ctx aws.Context, input *ListAssetContractsInput, opts ...request.Option) (*ListAssetContractsOutput, error) {
	req, out := c.ListAssetContractsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssetContractsPages iterates over the pages of a ListAssetContracts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssetContracts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAssetContracts operation.
//	pageNum := 0
//	err := client.ListAssetContractsPages(params,
//	    func(page *managedblockchainquery.ListAssetContractsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ManagedBlockchainQuery) ListAssetContractsPages(input *ListAssetContractsInput, fn func(*ListAssetContractsOutput, bool) bool) error {
	return c.ListAssetContractsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssetContractsPagesWithContext same as ListAssetContractsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) ListAssetContractsPagesWithContext(ctx aws.Context, input *ListAssetContractsInput, fn func(*ListAssetContractsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssetContractsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssetContractsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssetContractsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFilteredTransactionEvents = "ListFilteredTransactionEvents"

// ListFilteredTransactionEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListFilteredTransactionEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFilteredTransactionEvents for more information on using the ListFilteredTransactionEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFilteredTransactionEventsRequest method.
//	req, resp := client.ListFilteredTransactionEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListFilteredTransactionEvents
func (c *ManagedBlockchainQuery) ListFilteredTransactionEventsRequest(input *ListFilteredTransactionEventsInput) (req *request.Request, output *ListFilteredTransactionEventsOutput) {
	op := &request.Operation{
		Name:       opListFilteredTransactionEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/list-filtered-transaction-events",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFilteredTransactionEventsInput{}
	}

	output = &ListFilteredTransactionEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFilteredTransactionEvents API operation for Amazon Managed Blockchain Query.
//
// Lists all the transaction events for an address on the blockchain.
//
// This operation is only supported on the Bitcoin networks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain Query's
// API operation ListFilteredTransactionEvents for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request or operation couldn't be performed because a service is throttling
//     requests. The most common source of throttling errors is when you create
//     resources that exceed your service limit for this resource type. Request
//     a limit increase or delete unused resources, if possible.
//
//   - ValidationException
//     The resource passed is invalid.
//
//   - AccessDeniedException
//     The Amazon Web Services account doesn’t have access to this resource.
//
//   - InternalServerException
//     The request processing has failed because of an internal error in the service.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded for this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListFilteredTransactionEvents
func (c *ManagedBlockchainQuery) ListFilteredTransactionEvents(input *ListFilteredTransactionEventsInput) (*ListFilteredTransactionEventsOutput, error) {
	req, out := c.ListFilteredTransactionEventsRequest(input)
	return out, req.Send()
}

// ListFilteredTransactionEventsWithContext is the same as ListFilteredTransactionEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListFilteredTransactionEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) ListFilteredTransactionEventsWithContext(ctx aws.Context, input *ListFilteredTransactionEventsInput, opts ...request.Option) (*ListFilteredTransactionEventsOutput, error) {
	req, out := c.ListFilteredTransactionEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFilteredTransactionEventsPages iterates over the pages of a ListFilteredTransactionEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFilteredTransactionEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFilteredTransactionEvents operation.
//	pageNum := 0
//	err := client.ListFilteredTransactionEventsPages(params,
//	    func(page *managedblockchainquery.ListFilteredTransactionEventsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ManagedBlockchainQuery) ListFilteredTransactionEventsPages(input *ListFilteredTransactionEventsInput, fn func(*ListFilteredTransactionEventsOutput, bool) bool) error {
	return c.ListFilteredTransactionEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFilteredTransactionEventsPagesWithContext same as ListFilteredTransactionEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) ListFilteredTransactionEventsPagesWithContext(ctx aws.Context, input *ListFilteredTransactionEventsInput, fn func(*ListFilteredTransactionEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFilteredTransactionEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFilteredTransactionEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFilteredTransactionEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTokenBalances = "ListTokenBalances"

// ListTokenBalancesRequest generates a "aws/request.Request" representing the
// client's request for the ListTokenBalances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTokenBalances for more information on using the ListTokenBalances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTokenBalancesRequest method.
//	req, resp := client.ListTokenBalancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTokenBalances
func (c *ManagedBlockchainQuery) ListTokenBalancesRequest(input *ListTokenBalancesInput) (req *request.Request, output *ListTokenBalancesOutput) {
	op := &request.Operation{
		Name:       opListTokenBalances,
		HTTPMethod: "POST",
		HTTPPath:   "/list-token-balances",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTokenBalancesInput{}
	}

	output = &ListTokenBalancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTokenBalances API operation for Amazon Managed Blockchain Query.
//
// This action returns the following for a given blockchain network:
//
//   - Lists all token balances owned by an address (either a contract address
//     or a wallet address).
//
//   - Lists all token balances for all tokens created by a contract.
//
//   - Lists all token balances for a given token.
//
// You must always specify the network property of the tokenFilter when using
// this operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain Query's
// API operation ListTokenBalances for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request or operation couldn't be performed because a service is throttling
//     requests. The most common source of throttling errors is when you create
//     resources that exceed your service limit for this resource type. Request
//     a limit increase or delete unused resources, if possible.
//
//   - ValidationException
//     The resource passed is invalid.
//
//   - AccessDeniedException
//     The Amazon Web Services account doesn’t have access to this resource.
//
//   - InternalServerException
//     The request processing has failed because of an internal error in the service.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded for this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTokenBalances
func (c *ManagedBlockchainQuery) ListTokenBalances(input *ListTokenBalancesInput) (*ListTokenBalancesOutput, error) {
	req, out := c.ListTokenBalancesRequest(input)
	return out, req.Send()
}

// ListTokenBalancesWithContext is the same as ListTokenBalances with the addition of
// the ability to pass a context and additional request options.
//
// See ListTokenBalances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) ListTokenBalancesWithContext(ctx aws.Context, input *ListTokenBalancesInput, opts ...request.Option) (*ListTokenBalancesOutput, error) {
	req, out := c.ListTokenBalancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTokenBalancesPages iterates over the pages of a ListTokenBalances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTokenBalances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTokenBalances operation.
//	pageNum := 0
//	err := client.ListTokenBalancesPages(params,
//	    func(page *managedblockchainquery.ListTokenBalancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ManagedBlockchainQuery) ListTokenBalancesPages(input *ListTokenBalancesInput, fn func(*ListTokenBalancesOutput, bool) bool) error {
	return c.ListTokenBalancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTokenBalancesPagesWithContext same as ListTokenBalancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) ListTokenBalancesPagesWithContext(ctx aws.Context, input *ListTokenBalancesInput, fn func(*ListTokenBalancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTokenBalancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTokenBalancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTokenBalancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTransactionEvents = "ListTransactionEvents"

// ListTransactionEventsRequest generates a "aws/request.Request" representing the
// client's request for the ListTransactionEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTransactionEvents for more information on using the ListTransactionEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTransactionEventsRequest method.
//	req, resp := client.ListTransactionEventsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTransactionEvents
func (c *ManagedBlockchainQuery) ListTransactionEventsRequest(input *ListTransactionEventsInput) (req *request.Request, output *ListTransactionEventsOutput) {
	op := &request.Operation{
		Name:       opListTransactionEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/list-transaction-events",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTransactionEventsInput{}
	}

	output = &ListTransactionEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTransactionEvents API operation for Amazon Managed Blockchain Query.
//
// # Lists all the transaction events for a transaction
//
// This action will return transaction details for all transactions that are
// confirmed on the blockchain, even if they have not reached finality (https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain Query's
// API operation ListTransactionEvents for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request or operation couldn't be performed because a service is throttling
//     requests. The most common source of throttling errors is when you create
//     resources that exceed your service limit for this resource type. Request
//     a limit increase or delete unused resources, if possible.
//
//   - ValidationException
//     The resource passed is invalid.
//
//   - AccessDeniedException
//     The Amazon Web Services account doesn’t have access to this resource.
//
//   - InternalServerException
//     The request processing has failed because of an internal error in the service.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded for this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTransactionEvents
func (c *ManagedBlockchainQuery) ListTransactionEvents(input *ListTransactionEventsInput) (*ListTransactionEventsOutput, error) {
	req, out := c.ListTransactionEventsRequest(input)
	return out, req.Send()
}

// ListTransactionEventsWithContext is the same as ListTransactionEvents with the addition of
// the ability to pass a context and additional request options.
//
// See ListTransactionEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) ListTransactionEventsWithContext(ctx aws.Context, input *ListTransactionEventsInput, opts ...request.Option) (*ListTransactionEventsOutput, error) {
	req, out := c.ListTransactionEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTransactionEventsPages iterates over the pages of a ListTransactionEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTransactionEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTransactionEvents operation.
//	pageNum := 0
//	err := client.ListTransactionEventsPages(params,
//	    func(page *managedblockchainquery.ListTransactionEventsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ManagedBlockchainQuery) ListTransactionEventsPages(input *ListTransactionEventsInput, fn func(*ListTransactionEventsOutput, bool) bool) error {
	return c.ListTransactionEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTransactionEventsPagesWithContext same as ListTransactionEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) ListTransactionEventsPagesWithContext(ctx aws.Context, input *ListTransactionEventsInput, fn func(*ListTransactionEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTransactionEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTransactionEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTransactionEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTransactions = "ListTransactions"

// ListTransactionsRequest generates a "aws/request.Request" representing the
// client's request for the ListTransactions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTransactions for more information on using the ListTransactions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTransactionsRequest method.
//	req, resp := client.ListTransactionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTransactions
func (c *ManagedBlockchainQuery) ListTransactionsRequest(input *ListTransactionsInput) (req *request.Request, output *ListTransactionsOutput) {
	op := &request.Operation{
		Name:       opListTransactions,
		HTTPMethod: "POST",
		HTTPPath:   "/list-transactions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTransactionsInput{}
	}

	output = &ListTransactionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTransactions API operation for Amazon Managed Blockchain Query.
//
// Lists all the transaction events for a transaction.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Managed Blockchain Query's
// API operation ListTransactions for usage and error information.
//
// Returned Error Types:
//
//   - ThrottlingException
//     The request or operation couldn't be performed because a service is throttling
//     requests. The most common source of throttling errors is when you create
//     resources that exceed your service limit for this resource type. Request
//     a limit increase or delete unused resources, if possible.
//
//   - ValidationException
//     The resource passed is invalid.
//
//   - AccessDeniedException
//     The Amazon Web Services account doesn’t have access to this resource.
//
//   - InternalServerException
//     The request processing has failed because of an internal error in the service.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded for this resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTransactions
func (c *ManagedBlockchainQuery) ListTransactions(input *ListTransactionsInput) (*ListTransactionsOutput, error) {
	req, out := c.ListTransactionsRequest(input)
	return out, req.Send()
}

// ListTransactionsWithContext is the same as ListTransactions with the addition of
// the ability to pass a context and additional request options.
//
// See ListTransactions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) ListTransactionsWithContext(ctx aws.Context, input *ListTransactionsInput, opts ...request.Option) (*ListTransactionsOutput, error) {
	req, out := c.ListTransactionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTransactionsPages iterates over the pages of a ListTransactions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTransactions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTransactions operation.
//	pageNum := 0
//	err := client.ListTransactionsPages(params,
//	    func(page *managedblockchainquery.ListTransactionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *ManagedBlockchainQuery) ListTransactionsPages(input *ListTransactionsInput, fn func(*ListTransactionsOutput, bool) bool) error {
	return c.ListTransactionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTransactionsPagesWithContext same as ListTransactionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ManagedBlockchainQuery) ListTransactionsPagesWithContext(ctx aws.Context, input *ListTransactionsInput, fn func(*ListTransactionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTransactionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTransactionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTransactionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

// The Amazon Web Services account doesn’t have access to this resource.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The container for the exception message.
	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This is the container for the unique public address on the blockchain.
type AddressIdentifierFilter struct {
	_ struct{} `type:"structure"`

	// The container for the recipient address of the transaction.
	//
	// TransactionEventToAddress is a required field
	TransactionEventToAddress []*string `locationName:"transactionEventToAddress" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddressIdentifierFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddressIdentifierFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddressIdentifierFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddressIdentifierFilter"}
	if s.TransactionEventToAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("TransactionEventToAddress"))
	}
	if s.TransactionEventToAddress != nil && len(s.TransactionEventToAddress) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TransactionEventToAddress", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTransactionEventToAddress sets the TransactionEventToAddress field's value.
func (s *AddressIdentifierFilter) SetTransactionEventToAddress(v []*string) *AddressIdentifierFilter {
	s.TransactionEventToAddress = v
	return s
}

// This container contains information about an contract.
type AssetContract struct {
	_ struct{} `type:"structure"`

	// The container for the contract identifier containing its blockchain network
	// and address.
	//
	// ContractIdentifier is a required field
	ContractIdentifier *ContractIdentifier `locationName:"contractIdentifier" type:"structure" required:"true"`

	// The address of the contract deployer.
	//
	// DeployerAddress is a required field
	DeployerAddress *string `locationName:"deployerAddress" type:"string" required:"true"`

	// The token standard of the contract.
	//
	// TokenStandard is a required field
	TokenStandard *string `locationName:"tokenStandard" type:"string" required:"true" enum:"QueryTokenStandard"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetContract) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssetContract) GoString() string {
	return s.String()
}

// SetContractIdentifier sets the ContractIdentifier field's value.
func (s *AssetContract) SetContractIdentifier(v *ContractIdentifier) *AssetContract {
	s.ContractIdentifier = v
	return s
}

// SetDeployerAddress sets the DeployerAddress field's value.
func (s *AssetContract) SetDeployerAddress(v string) *AssetContract {
	s.DeployerAddress = &v
	return s
}

// SetTokenStandard sets the TokenStandard field's value.
func (s *AssetContract) SetTokenStandard(v string) *AssetContract {
	s.TokenStandard = &v
	return s
}

// Error generated from a failed BatchGetTokenBalance request.
type BatchGetTokenBalanceErrorItem struct {
	_ struct{} `type:"structure"`

	// The container for time.
	AtBlockchainInstant *BlockchainInstant `locationName:"atBlockchainInstant" type:"structure"`

	// The error code associated with the error.
	//
	// ErrorCode is a required field
	ErrorCode *string `locationName:"errorCode" type:"string" required:"true"`

	// The message associated with the error.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `locationName:"errorMessage" type:"string" required:"true"`

	// The type of error.
	//
	// ErrorType is a required field
	ErrorType *string `locationName:"errorType" type:"string" required:"true" enum:"ErrorType"`

	// The container for the owner identifier.
	OwnerIdentifier *OwnerIdentifier `locationName:"ownerIdentifier" type:"structure"`

	// The container for the identifier for the token including the unique token
	// ID and its blockchain network.
	//
	// Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155
	// token standards are supported.
	TokenIdentifier *TokenIdentifier `locationName:"tokenIdentifier" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTokenBalanceErrorItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTokenBalanceErrorItem) GoString() string {
	return s.String()
}

// SetAtBlockchainInstant sets the AtBlockchainInstant field's value.
func (s *BatchGetTokenBalanceErrorItem) SetAtBlockchainInstant(v *BlockchainInstant) *BatchGetTokenBalanceErrorItem {
	s.AtBlockchainInstant = v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *BatchGetTokenBalanceErrorItem) SetErrorCode(v string) *BatchGetTokenBalanceErrorItem {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *BatchGetTokenBalanceErrorItem) SetErrorMessage(v string) *BatchGetTokenBalanceErrorItem {
	s.ErrorMessage = &v
	return s
}

// SetErrorType sets the ErrorType field's value.
func (s *BatchGetTokenBalanceErrorItem) SetErrorType(v string) *BatchGetTokenBalanceErrorItem {
	s.ErrorType = &v
	return s
}

// SetOwnerIdentifier sets the OwnerIdentifier field's value.
func (s *BatchGetTokenBalanceErrorItem) SetOwnerIdentifier(v *OwnerIdentifier) *BatchGetTokenBalanceErrorItem {
	s.OwnerIdentifier = v
	return s
}

// SetTokenIdentifier sets the TokenIdentifier field's value.
func (s *BatchGetTokenBalanceErrorItem) SetTokenIdentifier(v *TokenIdentifier) *BatchGetTokenBalanceErrorItem {
	s.TokenIdentifier = v
	return s
}

type BatchGetTokenBalanceInput struct {
	_ struct{} `type:"structure"`

	// An array of BatchGetTokenBalanceInputItem objects whose balance is being
	// requested.
	GetTokenBalanceInputs []*BatchGetTokenBalanceInputItem `locationName:"getTokenBalanceInputs" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTokenBalanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTokenBalanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetTokenBalanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetTokenBalanceInput"}
	if s.GetTokenBalanceInputs != nil && len(s.GetTokenBalanceInputs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GetTokenBalanceInputs", 1))
	}
	if s.GetTokenBalanceInputs != nil {
		for i, v := range s.GetTokenBalanceInputs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "GetTokenBalanceInputs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGetTokenBalanceInputs sets the GetTokenBalanceInputs field's value.
func (s *BatchGetTokenBalanceInput) SetGetTokenBalanceInputs(v []*BatchGetTokenBalanceInputItem) *BatchGetTokenBalanceInput {
	s.GetTokenBalanceInputs = v
	return s
}

// The container for the input for getting a token balance.
type BatchGetTokenBalanceInputItem struct {
	_ struct{} `type:"structure"`

	// The container for time.
	AtBlockchainInstant *BlockchainInstant `locationName:"atBlockchainInstant" type:"structure"`

	// The container for the owner identifier.
	//
	// OwnerIdentifier is a required field
	OwnerIdentifier *OwnerIdentifier `locationName:"ownerIdentifier" type:"structure" required:"true"`

	// The container for the identifier for the token including the unique token
	// ID and its blockchain network.
	//
	// Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155
	// token standards are supported.
	//
	// TokenIdentifier is a required field
	TokenIdentifier *TokenIdentifier `locationName:"tokenIdentifier" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTokenBalanceInputItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTokenBalanceInputItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetTokenBalanceInputItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetTokenBalanceInputItem"}
	if s.OwnerIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerIdentifier"))
	}
	if s.TokenIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TokenIdentifier"))
	}
	if s.OwnerIdentifier != nil {
		if err := s.OwnerIdentifier.Validate(); err != nil {
			invalidParams.AddNested("OwnerIdentifier", err.(request.ErrInvalidParams))
		}
	}
	if s.TokenIdentifier != nil {
		if err := s.TokenIdentifier.Validate(); err != nil {
			invalidParams.AddNested("TokenIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAtBlockchainInstant sets the AtBlockchainInstant field's value.
func (s *BatchGetTokenBalanceInputItem) SetAtBlockchainInstant(v *BlockchainInstant) *BatchGetTokenBalanceInputItem {
	s.AtBlockchainInstant = v
	return s
}

// SetOwnerIdentifier sets the OwnerIdentifier field's value.
func (s *BatchGetTokenBalanceInputItem) SetOwnerIdentifier(v *OwnerIdentifier) *BatchGetTokenBalanceInputItem {
	s.OwnerIdentifier = v
	return s
}

// SetTokenIdentifier sets the TokenIdentifier field's value.
func (s *BatchGetTokenBalanceInputItem) SetTokenIdentifier(v *TokenIdentifier) *BatchGetTokenBalanceInputItem {
	s.TokenIdentifier = v
	return s
}

type BatchGetTokenBalanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of BatchGetTokenBalanceErrorItem objects returned from the request.
	//
	// Errors is a required field
	Errors []*BatchGetTokenBalanceErrorItem `locationName:"errors" type:"list" required:"true"`

	// An array of BatchGetTokenBalanceOutputItem objects returned by the response.
	//
	// TokenBalances is a required field
	TokenBalances []*BatchGetTokenBalanceOutputItem `locationName:"tokenBalances" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTokenBalanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTokenBalanceOutput) GoString() string {
	return s.String()
}

// SetErrors sets the Errors field's value.
func (s *BatchGetTokenBalanceOutput) SetErrors(v []*BatchGetTokenBalanceErrorItem) *BatchGetTokenBalanceOutput {
	s.Errors = v
	return s
}

// SetTokenBalances sets the TokenBalances field's value.
func (s *BatchGetTokenBalanceOutput) SetTokenBalances(v []*BatchGetTokenBalanceOutputItem) *BatchGetTokenBalanceOutput {
	s.TokenBalances = v
	return s
}

// The container for the properties of a token balance output.
type BatchGetTokenBalanceOutputItem struct {
	_ struct{} `type:"structure"`

	// The container for time.
	//
	// AtBlockchainInstant is a required field
	AtBlockchainInstant *BlockchainInstant `locationName:"atBlockchainInstant" type:"structure" required:"true"`

	// The container for the token balance.
	//
	// Balance is a required field
	Balance *string `locationName:"balance" type:"string" required:"true"`

	// The container for time.
	LastUpdatedTime *BlockchainInstant `locationName:"lastUpdatedTime" type:"structure"`

	// The container for the owner identifier.
	OwnerIdentifier *OwnerIdentifier `locationName:"ownerIdentifier" type:"structure"`

	// The container for the identifier for the token including the unique token
	// ID and its blockchain network.
	//
	// Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155
	// token standards are supported.
	TokenIdentifier *TokenIdentifier `locationName:"tokenIdentifier" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTokenBalanceOutputItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetTokenBalanceOutputItem) GoString() string {
	return s.String()
}

// SetAtBlockchainInstant sets the AtBlockchainInstant field's value.
func (s *BatchGetTokenBalanceOutputItem) SetAtBlockchainInstant(v *BlockchainInstant) *BatchGetTokenBalanceOutputItem {
	s.AtBlockchainInstant = v
	return s
}

// SetBalance sets the Balance field's value.
func (s *BatchGetTokenBalanceOutputItem) SetBalance(v string) *BatchGetTokenBalanceOutputItem {
	s.Balance = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *BatchGetTokenBalanceOutputItem) SetLastUpdatedTime(v *BlockchainInstant) *BatchGetTokenBalanceOutputItem {
	s.LastUpdatedTime = v
	return s
}

// SetOwnerIdentifier sets the OwnerIdentifier field's value.
func (s *BatchGetTokenBalanceOutputItem) SetOwnerIdentifier(v *OwnerIdentifier) *BatchGetTokenBalanceOutputItem {
	s.OwnerIdentifier = v
	return s
}

// SetTokenIdentifier sets the TokenIdentifier field's value.
func (s *BatchGetTokenBalanceOutputItem) SetTokenIdentifier(v *TokenIdentifier) *BatchGetTokenBalanceOutputItem {
	s.TokenIdentifier = v
	return s
}

// The container for time.
type BlockchainInstant struct {
	_ struct{} `type:"structure"`

	// The container of the Timestamp of the blockchain instant.
	//
	// This timestamp will only be recorded up to the second.
	Time *time.Time `locationName:"time" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockchainInstant) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BlockchainInstant) GoString() string {
	return s.String()
}

// SetTime sets the Time field's value.
func (s *BlockchainInstant) SetTime(v time.Time) *BlockchainInstant {
	s.Time = &v
	return s
}

// The container for the ConfirmationStatusFilter that filters for the finality
// (https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality)
// of the results.
type ConfirmationStatusFilter struct {
	_ struct{} `type:"structure"`

	// The container to determine whether to list results that have only reached
	// finality (https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality).
	// Transactions that have reached finality are always part of the response.
	//
	// Include is a required field
	Include []*string `locationName:"include" min:"1" type:"list" required:"true" enum:"ConfirmationStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmationStatusFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfirmationStatusFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfirmationStatusFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConfirmationStatusFilter"}
	if s.Include == nil {
		invalidParams.Add(request.NewErrParamRequired("Include"))
	}
	if s.Include != nil && len(s.Include) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Include", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInclude sets the Include field's value.
func (s *ConfirmationStatusFilter) SetInclude(v []*string) *ConfirmationStatusFilter {
	s.Include = v
	return s
}

// The contract or wallet address by which to filter the request.
type ContractFilter struct {
	_ struct{} `type:"structure"`

	// The network address of the deployer.
	//
	// DeployerAddress is a required field
	DeployerAddress *string `locationName:"deployerAddress" type:"string" required:"true"`

	// The blockchain network of the contract.
	//
	// Network is a required field
	Network *string `locationName:"network" type:"string" required:"true" enum:"QueryNetwork"`

	// The container for the token standard.
	//
	// TokenStandard is a required field
	TokenStandard *string `locationName:"tokenStandard" type:"string" required:"true" enum:"QueryTokenStandard"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContractFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContractFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContractFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContractFilter"}
	if s.DeployerAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("DeployerAddress"))
	}
	if s.Network == nil {
		invalidParams.Add(request.NewErrParamRequired("Network"))
	}
	if s.TokenStandard == nil {
		invalidParams.Add(request.NewErrParamRequired("TokenStandard"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeployerAddress sets the DeployerAddress field's value.
func (s *ContractFilter) SetDeployerAddress(v string) *ContractFilter {
	s.DeployerAddress = &v
	return s
}

// SetNetwork sets the Network field's value.
func (s *ContractFilter) SetNetwork(v string) *ContractFilter {
	s.Network = &v
	return s
}

// SetTokenStandard sets the TokenStandard field's value.
func (s *ContractFilter) SetTokenStandard(v string) *ContractFilter {
	s.TokenStandard = &v
	return s
}

// Container for the blockchain address and network information about a contract.
type ContractIdentifier struct {
	_ struct{} `type:"structure"`

	// Container for the blockchain address about a contract.
	//
	// ContractAddress is a required field
	ContractAddress *string `locationName:"contractAddress" type:"string" required:"true"`

	// The blockchain network of the contract.
	//
	// Network is a required field
	Network *string `locationName:"network" type:"string" required:"true" enum:"QueryNetwork"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContractIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContractIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ContractIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ContractIdentifier"}
	if s.ContractAddress == nil {
		invalidParams.Add(request.NewErrParamRequired("ContractAddress"))
	}
	if s.Network == nil {
		invalidParams.Add(request.NewErrParamRequired("Network"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContractAddress sets the ContractAddress field's value.
func (s *ContractIdentifier) SetContractAddress(v string) *ContractIdentifier {
	s.ContractAddress = &v
	return s
}

// SetNetwork sets the Network field's value.
func (s *ContractIdentifier) SetNetwork(v string) *ContractIdentifier {
	s.Network = &v
	return s
}

// The metadata of the contract.
type ContractMetadata struct {
	_ struct{} `type:"structure"`

	// The decimals used by the token contract.
	Decimals *int64 `locationName:"decimals" type:"integer"`

	// The name of the token contract.
	Name *string `locationName:"name" type:"string"`

	// The symbol of the token contract.
	Symbol *string `locationName:"symbol" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContractMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContractMetadata) GoString() string {
	return s.String()
}

// SetDecimals sets the Decimals field's value.
func (s *ContractMetadata) SetDecimals(v int64) *ContractMetadata {
	s.Decimals = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContractMetadata) SetName(v string) *ContractMetadata {
	s.Name = &v
	return s
}

// SetSymbol sets the Symbol field's value.
func (s *ContractMetadata) SetSymbol(v string) *ContractMetadata {
	s.Symbol = &v
	return s
}

type GetAssetContractInput struct {
	_ struct{} `type:"structure"`

	// Contains the blockchain address and network information about the contract.
	//
	// ContractIdentifier is a required field
	ContractIdentifier *ContractIdentifier `locationName:"contractIdentifier" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetContractInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetContractInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssetContractInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssetContractInput"}
	if s.ContractIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ContractIdentifier"))
	}
	if s.ContractIdentifier != nil {
		if err := s.ContractIdentifier.Validate(); err != nil {
			invalidParams.AddNested("ContractIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContractIdentifier sets the ContractIdentifier field's value.
func (s *GetAssetContractInput) SetContractIdentifier(v *ContractIdentifier) *GetAssetContractInput {
	s.ContractIdentifier = v
	return s
}

type GetAssetContractOutput struct {
	_ struct{} `type:"structure"`

	// Contains the blockchain address and network information about the contract.
	//
	// ContractIdentifier is a required field
	ContractIdentifier *ContractIdentifier `locationName:"contractIdentifier" type:"structure" required:"true"`

	// The address of the deployer of contract.
	//
	// DeployerAddress is a required field
	DeployerAddress *string `locationName:"deployerAddress" type:"string" required:"true"`

	// The metadata of the contract.
	Metadata *ContractMetadata `locationName:"metadata" type:"structure"`

	// The token standard of the contract requested.
	//
	// TokenStandard is a required field
	TokenStandard *string `locationName:"tokenStandard" type:"string" required:"true" enum:"QueryTokenStandard"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetContractOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssetContractOutput) GoString() string {
	return s.String()
}

// SetContractIdentifier sets the ContractIdentifier field's value.
func (s *GetAssetContractOutput) SetContractIdentifier(v *ContractIdentifier) *GetAssetContractOutput {
	s.ContractIdentifier = v
	return s
}

// SetDeployerAddress sets the DeployerAddress field's value.
func (s *GetAssetContractOutput) SetDeployerAddress(v string) *GetAssetContractOutput {
	s.DeployerAddress = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *GetAssetContractOutput) SetMetadata(v *ContractMetadata) *GetAssetContractOutput {
	s.Metadata = v
	return s
}

// SetTokenStandard sets the TokenStandard field's value.
func (s *GetAssetContractOutput) SetTokenStandard(v string) *GetAssetContractOutput {
	s.TokenStandard = &v
	return s
}

type GetTokenBalanceInput struct {
	_ struct{} `type:"structure"`

	// The time for when the TokenBalance is requested or the current time if a
	// time is not provided in the request.
	//
	// This time will only be recorded up to the second.
	AtBlockchainInstant *BlockchainInstant `locationName:"atBlockchainInstant" type:"structure"`

	// The container for the identifier for the owner.
	//
	// OwnerIdentifier is a required field
	OwnerIdentifier *OwnerIdentifier `locationName:"ownerIdentifier" type:"structure" required:"true"`

	// The container for the identifier for the token, including the unique token
	// ID and its blockchain network.
	//
	// TokenIdentifier is a required field
	TokenIdentifier *TokenIdentifier `locationName:"tokenIdentifier" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTokenBalanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTokenBalanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTokenBalanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTokenBalanceInput"}
	if s.OwnerIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("OwnerIdentifier"))
	}
	if s.TokenIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("TokenIdentifier"))
	}
	if s.OwnerIdentifier != nil {
		if err := s.OwnerIdentifier.Validate(); err != nil {
			invalidParams.AddNested("OwnerIdentifier", err.(request.ErrInvalidParams))
		}
	}
	if s.TokenIdentifier != nil {
		if err := s.TokenIdentifier.Validate(); err != nil {
			invalidParams.AddNested("TokenIdentifier", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAtBlockchainInstant sets the AtBlockchainInstant field's value.
func (s *GetTokenBalanceInput) SetAtBlockchainInstant(v *BlockchainInstant) *GetTokenBalanceInput {
	s.AtBlockchainInstant = v
	return s
}

// SetOwnerIdentifier sets the OwnerIdentifier field's value.
func (s *GetTokenBalanceInput) SetOwnerIdentifier(v *OwnerIdentifier) *GetTokenBalanceInput {
	s.OwnerIdentifier = v
	return s
}

// SetTokenIdentifier sets the TokenIdentifier field's value.
func (s *GetTokenBalanceInput) SetTokenIdentifier(v *TokenIdentifier) *GetTokenBalanceInput {
	s.TokenIdentifier = v
	return s
}

type GetTokenBalanceOutput struct {
	_ struct{} `type:"structure"`

	// The container for time.
	//
	// AtBlockchainInstant is a required field
	AtBlockchainInstant *BlockchainInstant `locationName:"atBlockchainInstant" type:"structure" required:"true"`

	// The container for the token balance.
	//
	// Balance is a required field
	Balance *string `locationName:"balance" type:"string" required:"true"`

	// The container for time.
	LastUpdatedTime *BlockchainInstant `locationName:"lastUpdatedTime" type:"structure"`

	// The container for the owner identifier.
	OwnerIdentifier *OwnerIdentifier `locationName:"ownerIdentifier" type:"structure"`

	// The container for the identifier for the token including the unique token
	// ID and its blockchain network.
	//
	// Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155
	// token standards are supported.
	TokenIdentifier *TokenIdentifier `locationName:"tokenIdentifier" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTokenBalanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTokenBalanceOutput) GoString() string {
	return s.String()
}

// SetAtBlockchainInstant sets the AtBlockchainInstant field's value.
func (s *GetTokenBalanceOutput) SetAtBlockchainInstant(v *BlockchainInstant) *GetTokenBalanceOutput {
	s.AtBlockchainInstant = v
	return s
}

// SetBalance sets the Balance field's value.
func (s *GetTokenBalanceOutput) SetBalance(v string) *GetTokenBalanceOutput {
	s.Balance = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *GetTokenBalanceOutput) SetLastUpdatedTime(v *BlockchainInstant) *GetTokenBalanceOutput {
	s.LastUpdatedTime = v
	return s
}

// SetOwnerIdentifier sets the OwnerIdentifier field's value.
func (s *GetTokenBalanceOutput) SetOwnerIdentifier(v *OwnerIdentifier) *GetTokenBalanceOutput {
	s.OwnerIdentifier = v
	return s
}

// SetTokenIdentifier sets the TokenIdentifier field's value.
func (s *GetTokenBalanceOutput) SetTokenIdentifier(v *TokenIdentifier) *GetTokenBalanceOutput {
	s.TokenIdentifier = v
	return s
}

type GetTransactionInput struct {
	_ struct{} `type:"structure"`

	// The blockchain network where the transaction occurred.
	//
	// Network is a required field
	Network *string `locationName:"network" type:"string" required:"true" enum:"QueryNetwork"`

	// The hash of a transaction. It is generated when a transaction is created.
	TransactionHash *string `locationName:"transactionHash" type:"string"`

	// The identifier of a Bitcoin transaction. It is generated when a transaction
	// is created.
	//
	// transactionId is only supported on the Bitcoin networks.
	TransactionId *string `locationName:"transactionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTransactionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTransactionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTransactionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTransactionInput"}
	if s.Network == nil {
		invalidParams.Add(request.NewErrParamRequired("Network"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNetwork sets the Network field's value.
func (s *GetTransactionInput) SetNetwork(v string) *GetTransactionInput {
	s.Network = &v
	return s
}

// SetTransactionHash sets the TransactionHash field's value.
func (s *GetTransactionInput) SetTransactionHash(v string) *GetTransactionInput {
	s.TransactionHash = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *GetTransactionInput) SetTransactionId(v string) *GetTransactionInput {
	s.TransactionId = &v
	return s
}

type GetTransactionOutput struct {
	_ struct{} `type:"structure"`

	// Contains the details of the transaction.
	//
	// Transaction is a required field
	Transaction *Transaction `locationName:"transaction" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTransactionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTransactionOutput) GoString() string {
	return s.String()
}

// SetTransaction sets the Transaction field's value.
func (s *GetTransactionOutput) SetTransaction(v *Transaction) *GetTransactionOutput {
	s.Transaction = v
	return s
}

// The request processing has failed because of an internal error in the service.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The container for the exception message.
	Message_ *string `locationName:"message" min:"1" type:"string"`

	// Specifies the retryAfterSeconds value.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListAssetContractsInput struct {
	_ struct{} `type:"structure"`

	// Contains the filter parameter for the request.
	//
	// ContractFilter is a required field
	ContractFilter *ContractFilter `locationName:"contractFilter" type:"structure" required:"true"`

	// The maximum number of contracts to list.
	//
	// Default: 100
	//
	// Even if additional results can be retrieved, the request can return less
	// results than maxResults or an empty array of results.
	//
	// To retrieve the next set of results, make another request with the returned
	// nextToken value. The value of nextToken is null when there are no more results
	// to return
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetContractsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetContractsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssetContractsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssetContractsInput"}
	if s.ContractFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("ContractFilter"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ContractFilter != nil {
		if err := s.ContractFilter.Validate(); err != nil {
			invalidParams.AddNested("ContractFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContractFilter sets the ContractFilter field's value.
func (s *ListAssetContractsInput) SetContractFilter(v *ContractFilter) *ListAssetContractsInput {
	s.ContractFilter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssetContractsInput) SetMaxResults(v int64) *ListAssetContractsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetContractsInput) SetNextToken(v string) *ListAssetContractsInput {
	s.NextToken = &v
	return s
}

type ListAssetContractsOutput struct {
	_ struct{} `type:"structure"`

	// An array of contract objects that contain the properties for each contract.
	//
	// Contracts is a required field
	Contracts []*AssetContract `locationName:"contracts" type:"list" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetContractsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssetContractsOutput) GoString() string {
	return s.String()
}

// SetContracts sets the Contracts field's value.
func (s *ListAssetContractsOutput) SetContracts(v []*AssetContract) *ListAssetContractsOutput {
	s.Contracts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssetContractsOutput) SetNextToken(v string) *ListAssetContractsOutput {
	s.NextToken = &v
	return s
}

type ListFilteredTransactionEventsInput struct {
	_ struct{} `type:"structure"`

	// This is the unique public address on the blockchain for which the transaction
	// events are being requested.
	//
	// AddressIdentifierFilter is a required field
	AddressIdentifierFilter *AddressIdentifierFilter `locationName:"addressIdentifierFilter" type:"structure" required:"true"`

	// The container for the ConfirmationStatusFilter that filters for the finality
	// (https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality)
	// of the results.
	ConfirmationStatusFilter *ConfirmationStatusFilter `locationName:"confirmationStatusFilter" type:"structure"`

	// The maximum number of transaction events to list.
	//
	// Default: 100
	//
	// Even if additional results can be retrieved, the request can return less
	// results than maxResults or an empty array of results.
	//
	// To retrieve the next set of results, make another request with the returned
	// nextToken value. The value of nextToken is null when there are no more results
	// to return
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The blockchain network where the transaction occurred.
	//
	// Valid Values: BITCOIN_MAINNET | BITCOIN_TESTNET
	//
	// Network is a required field
	Network *string `locationName:"network" type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The order by which the results will be sorted.
	Sort *ListFilteredTransactionEventsSort `locationName:"sort" type:"structure"`

	// This container specifies the time frame for the transaction events returned
	// in the response.
	TimeFilter *TimeFilter `locationName:"timeFilter" type:"structure"`

	// This container specifies filtering attributes related to BITCOIN_VOUT event
	// types
	VoutFilter *VoutFilter `locationName:"voutFilter" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFilteredTransactionEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFilteredTransactionEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFilteredTransactionEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFilteredTransactionEventsInput"}
	if s.AddressIdentifierFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("AddressIdentifierFilter"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Network == nil {
		invalidParams.Add(request.NewErrParamRequired("Network"))
	}
	if s.AddressIdentifierFilter != nil {
		if err := s.AddressIdentifierFilter.Validate(); err != nil {
			invalidParams.AddNested("AddressIdentifierFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.ConfirmationStatusFilter != nil {
		if err := s.ConfirmationStatusFilter.Validate(); err != nil {
			invalidParams.AddNested("ConfirmationStatusFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.VoutFilter != nil {
		if err := s.VoutFilter.Validate(); err != nil {
			invalidParams.AddNested("VoutFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddressIdentifierFilter sets the AddressIdentifierFilter field's value.
func (s *ListFilteredTransactionEventsInput) SetAddressIdentifierFilter(v *AddressIdentifierFilter) *ListFilteredTransactionEventsInput {
	s.AddressIdentifierFilter = v
	return s
}

// SetConfirmationStatusFilter sets the ConfirmationStatusFilter field's value.
func (s *ListFilteredTransactionEventsInput) SetConfirmationStatusFilter(v *ConfirmationStatusFilter) *ListFilteredTransactionEventsInput {
	s.ConfirmationStatusFilter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFilteredTransactionEventsInput) SetMaxResults(v int64) *ListFilteredTransactionEventsInput {
	s.MaxResults = &v
	return s
}

// SetNetwork sets the Network field's value.
func (s *ListFilteredTransactionEventsInput) SetNetwork(v string) *ListFilteredTransactionEventsInput {
	s.Network = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFilteredTransactionEventsInput) SetNextToken(v string) *ListFilteredTransactionEventsInput {
	s.NextToken = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *ListFilteredTransactionEventsInput) SetSort(v *ListFilteredTransactionEventsSort) *ListFilteredTransactionEventsInput {
	s.Sort = v
	return s
}

// SetTimeFilter sets the TimeFilter field's value.
func (s *ListFilteredTransactionEventsInput) SetTimeFilter(v *TimeFilter) *ListFilteredTransactionEventsInput {
	s.TimeFilter = v
	return s
}

// SetVoutFilter sets the VoutFilter field's value.
func (s *ListFilteredTransactionEventsInput) SetVoutFilter(v *VoutFilter) *ListFilteredTransactionEventsInput {
	s.VoutFilter = v
	return s
}

type ListFilteredTransactionEventsOutput struct {
	_ struct{} `type:"structure"`

	// The transaction events returned by the request.
	//
	// Events is a required field
	Events []*TransactionEvent `locationName:"events" type:"list" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFilteredTransactionEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFilteredTransactionEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *ListFilteredTransactionEventsOutput) SetEvents(v []*TransactionEvent) *ListFilteredTransactionEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFilteredTransactionEventsOutput) SetNextToken(v string) *ListFilteredTransactionEventsOutput {
	s.NextToken = &v
	return s
}

// Lists all the transaction events for an address on the blockchain.
//
// This operation is only supported on the Bitcoin blockchain networks.
type ListFilteredTransactionEventsSort struct {
	_ struct{} `type:"structure"`

	// Container on how the results will be sorted by?
	SortBy *string `locationName:"sortBy" type:"string" enum:"ListFilteredTransactionEventsSortBy"`

	// The container for the sort order for ListFilteredTransactionEvents. The SortOrder
	// field only accepts the values ASCENDING and DESCENDING. Not providing SortOrder
	// will default to ASCENDING.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFilteredTransactionEventsSort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFilteredTransactionEventsSort) GoString() string {
	return s.String()
}

// SetSortBy sets the SortBy field's value.
func (s *ListFilteredTransactionEventsSort) SetSortBy(v string) *ListFilteredTransactionEventsSort {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListFilteredTransactionEventsSort) SetSortOrder(v string) *ListFilteredTransactionEventsSort {
	s.SortOrder = &v
	return s
}

type ListTokenBalancesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of token balances to return.
	//
	// Default: 100
	//
	// Even if additional results can be retrieved, the request can return less
	// results than maxResults or an empty array of results.
	//
	// To retrieve the next set of results, make another request with the returned
	// nextToken value. The value of nextToken is null when there are no more results
	// to return
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The contract or wallet address on the blockchain network by which to filter
	// the request. You must specify the address property of the ownerFilter when
	// listing balances of tokens owned by the address.
	OwnerFilter *OwnerFilter `locationName:"ownerFilter" type:"structure"`

	// The contract address or a token identifier on the blockchain network by which
	// to filter the request. You must specify the contractAddress property of this
	// container when listing tokens minted by a contract.
	//
	// You must always specify the network property of this container when using
	// this operation.
	//
	// TokenFilter is a required field
	TokenFilter *TokenFilter `locationName:"tokenFilter" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTokenBalancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTokenBalancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTokenBalancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTokenBalancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.TokenFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("TokenFilter"))
	}
	if s.OwnerFilter != nil {
		if err := s.OwnerFilter.Validate(); err != nil {
			invalidParams.AddNested("OwnerFilter", err.(request.ErrInvalidParams))
		}
	}
	if s.TokenFilter != nil {
		if err := s.TokenFilter.Validate(); err != nil {
			invalidParams.AddNested("TokenFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTokenBalancesInput) SetMaxResults(v int64) *ListTokenBalancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTokenBalancesInput) SetNextToken(v string) *ListTokenBalancesInput {
	s.NextToken = &v
	return s
}

// SetOwnerFilter sets the OwnerFilter field's value.
func (s *ListTokenBalancesInput) SetOwnerFilter(v *OwnerFilter) *ListTokenBalancesInput {
	s.OwnerFilter = v
	return s
}

// SetTokenFilter sets the TokenFilter field's value.
func (s *ListTokenBalancesInput) SetTokenFilter(v *TokenFilter) *ListTokenBalancesInput {
	s.TokenFilter = v
	return s
}

type ListTokenBalancesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of TokenBalance objects. Each object contains details about the
	// token balance.
	//
	// TokenBalances is a required field
	TokenBalances []*TokenBalance `locationName:"tokenBalances" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTokenBalancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTokenBalancesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTokenBalancesOutput) SetNextToken(v string) *ListTokenBalancesOutput {
	s.NextToken = &v
	return s
}

// SetTokenBalances sets the TokenBalances field's value.
func (s *ListTokenBalancesOutput) SetTokenBalances(v []*TokenBalance) *ListTokenBalancesOutput {
	s.TokenBalances = v
	return s
}

type ListTransactionEventsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of transaction events to list.
	//
	// Default: 100
	//
	// Even if additional results can be retrieved, the request can return less
	// results than maxResults or an empty array of results.
	//
	// To retrieve the next set of results, make another request with the returned
	// nextToken value. The value of nextToken is null when there are no more results
	// to return
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The blockchain network where the transaction events occurred.
	//
	// Network is a required field
	Network *string `locationName:"network" type:"string" required:"true" enum:"QueryNetwork"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The hash of a transaction. It is generated when a transaction is created.
	TransactionHash *string `locationName:"transactionHash" type:"string"`

	// The identifier of a Bitcoin transaction. It is generated when a transaction
	// is created.
	//
	// transactionId is only supported on the Bitcoin networks.
	TransactionId *string `locationName:"transactionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTransactionEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTransactionEventsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Network == nil {
		invalidParams.Add(request.NewErrParamRequired("Network"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTransactionEventsInput) SetMaxResults(v int64) *ListTransactionEventsInput {
	s.MaxResults = &v
	return s
}

// SetNetwork sets the Network field's value.
func (s *ListTransactionEventsInput) SetNetwork(v string) *ListTransactionEventsInput {
	s.Network = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTransactionEventsInput) SetNextToken(v string) *ListTransactionEventsInput {
	s.NextToken = &v
	return s
}

// SetTransactionHash sets the TransactionHash field's value.
func (s *ListTransactionEventsInput) SetTransactionHash(v string) *ListTransactionEventsInput {
	s.TransactionHash = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *ListTransactionEventsInput) SetTransactionId(v string) *ListTransactionEventsInput {
	s.TransactionId = &v
	return s
}

type ListTransactionEventsOutput struct {
	_ struct{} `type:"structure"`

	// An array of TransactionEvent objects. Each object contains details about
	// the transaction events.
	//
	// Events is a required field
	Events []*TransactionEvent `locationName:"events" type:"list" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *ListTransactionEventsOutput) SetEvents(v []*TransactionEvent) *ListTransactionEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTransactionEventsOutput) SetNextToken(v string) *ListTransactionEventsOutput {
	s.NextToken = &v
	return s
}

type ListTransactionsInput struct {
	_ struct{} `type:"structure"`

	// The address (either a contract or wallet), whose transactions are being requested.
	//
	// Address is a required field
	Address *string `locationName:"address" type:"string" required:"true"`

	// This filter is used to include transactions in the response that haven't
	// reached finality (https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality).
	// Transactions that have reached finality are always part of the response.
	ConfirmationStatusFilter *ConfirmationStatusFilter `locationName:"confirmationStatusFilter" type:"structure"`

	// The container for time.
	FromBlockchainInstant *BlockchainInstant `locationName:"fromBlockchainInstant" type:"structure"`

	// The maximum number of transactions to list.
	//
	// Default: 100
	//
	// Even if additional results can be retrieved, the request can return less
	// results than maxResults or an empty array of results.
	//
	// To retrieve the next set of results, make another request with the returned
	// nextToken value. The value of nextToken is null when there are no more results
	// to return
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The blockchain network where the transactions occurred.
	//
	// Network is a required field
	Network *string `locationName:"network" type:"string" required:"true" enum:"QueryNetwork"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The order by which the results will be sorted.
	Sort *ListTransactionsSort `locationName:"sort" type:"structure"`

	// The container for time.
	ToBlockchainInstant *BlockchainInstant `locationName:"toBlockchainInstant" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTransactionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTransactionsInput"}
	if s.Address == nil {
		invalidParams.Add(request.NewErrParamRequired("Address"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Network == nil {
		invalidParams.Add(request.NewErrParamRequired("Network"))
	}
	if s.ConfirmationStatusFilter != nil {
		if err := s.ConfirmationStatusFilter.Validate(); err != nil {
			invalidParams.AddNested("ConfirmationStatusFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *ListTransactionsInput) SetAddress(v string) *ListTransactionsInput {
	s.Address = &v
	return s
}

// SetConfirmationStatusFilter sets the ConfirmationStatusFilter field's value.
func (s *ListTransactionsInput) SetConfirmationStatusFilter(v *ConfirmationStatusFilter) *ListTransactionsInput {
	s.ConfirmationStatusFilter = v
	return s
}

// SetFromBlockchainInstant sets the FromBlockchainInstant field's value.
func (s *ListTransactionsInput) SetFromBlockchainInstant(v *BlockchainInstant) *ListTransactionsInput {
	s.FromBlockchainInstant = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTransactionsInput) SetMaxResults(v int64) *ListTransactionsInput {
	s.MaxResults = &v
	return s
}

// SetNetwork sets the Network field's value.
func (s *ListTransactionsInput) SetNetwork(v string) *ListTransactionsInput {
	s.Network = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTransactionsInput) SetNextToken(v string) *ListTransactionsInput {
	s.NextToken = &v
	return s
}

// SetSort sets the Sort field's value.
func (s *ListTransactionsInput) SetSort(v *ListTransactionsSort) *ListTransactionsInput {
	s.Sort = v
	return s
}

// SetToBlockchainInstant sets the ToBlockchainInstant field's value.
func (s *ListTransactionsInput) SetToBlockchainInstant(v *BlockchainInstant) *ListTransactionsInput {
	s.ToBlockchainInstant = v
	return s
}

type ListTransactionsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The array of transactions returned by the request.
	//
	// Transactions is a required field
	Transactions []*TransactionOutputItem `locationName:"transactions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTransactionsOutput) SetNextToken(v string) *ListTransactionsOutput {
	s.NextToken = &v
	return s
}

// SetTransactions sets the Transactions field's value.
func (s *ListTransactionsOutput) SetTransactions(v []*TransactionOutputItem) *ListTransactionsOutput {
	s.Transactions = v
	return s
}

// The container for determining how the list transaction result will be sorted.
type ListTransactionsSort struct {
	_ struct{} `type:"structure"`

	// Defaults to the value TRANSACTION_TIMESTAMP.
	SortBy *string `locationName:"sortBy" type:"string" enum:"ListTransactionsSortBy"`

	// The container for the sort order for ListTransactions. The SortOrder field
	// only accepts the values ASCENDING and DESCENDING. Not providing SortOrder
	// will default to ASCENDING.
	SortOrder *string `locationName:"sortOrder" type:"string" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionsSort) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTransactionsSort) GoString() string {
	return s.String()
}

// SetSortBy sets the SortBy field's value.
func (s *ListTransactionsSort) SetSortBy(v string) *ListTransactionsSort {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListTransactionsSort) SetSortOrder(v string) *ListTransactionsSort {
	s.SortOrder = &v
	return s
}

// The container for the owner information to filter by.
type OwnerFilter struct {
	_ struct{} `type:"structure"`

	// The contract or wallet address.
	//
	// Address is a required field
	Address *string `locationName:"address" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OwnerFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OwnerFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OwnerFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OwnerFilter"}
	if s.Address == nil {
		invalidParams.Add(request.NewErrParamRequired("Address"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *OwnerFilter) SetAddress(v string) *OwnerFilter {
	s.Address = &v
	return s
}

// The container for the owner identifier.
type OwnerIdentifier struct {
	_ struct{} `type:"structure"`

	// The contract or wallet address for the owner.
	//
	// Address is a required field
	Address *string `locationName:"address" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OwnerIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OwnerIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OwnerIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OwnerIdentifier"}
	if s.Address == nil {
		invalidParams.Add(request.NewErrParamRequired("Address"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *OwnerIdentifier) SetAddress(v string) *OwnerIdentifier {
	s.Address = &v
	return s
}

// The resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The container for the exception message.
	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The resourceId of the resource that caused the exception.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resourceType of the resource that caused the exception.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service quota has been exceeded for this resource.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The container for the exception message.
	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The container for the quotaCode.
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// The resourceId of the resource that caused the exception.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The resourceType of the resource that caused the exception.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`

	// The container for the serviceCode.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request or operation couldn't be performed because a service is throttling
// requests. The most common source of throttling errors is when you create
// resources that exceed your service limit for this resource type. Request
// a limit increase or delete unused resources, if possible.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The container for the exception message.
	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The container for the quotaCode.
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// The container of the retryAfterSeconds value.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The container for the serviceCode.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This container is used to specify a time frame.
type TimeFilter struct {
	_ struct{} `type:"structure"`

	// The container for time.
	From *BlockchainInstant `locationName:"from" type:"structure"`

	// The container for time.
	To *BlockchainInstant `locationName:"to" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TimeFilter) GoString() string {
	return s.String()
}

// SetFrom sets the From field's value.
func (s *TimeFilter) SetFrom(v *BlockchainInstant) *TimeFilter {
	s.From = v
	return s
}

// SetTo sets the To field's value.
func (s *TimeFilter) SetTo(v *BlockchainInstant) *TimeFilter {
	s.To = v
	return s
}

// The balance of the token.
type TokenBalance struct {
	_ struct{} `type:"structure"`

	// The time for when the TokenBalance is requested or the current time if a
	// time is not provided in the request.
	//
	// This time will only be recorded up to the second.
	//
	// AtBlockchainInstant is a required field
	AtBlockchainInstant *BlockchainInstant `locationName:"atBlockchainInstant" type:"structure" required:"true"`

	// The container of the token balance.
	//
	// Balance is a required field
	Balance *string `locationName:"balance" type:"string" required:"true"`

	// The Timestamp of the last transaction at which the balance for the token
	// in the wallet was updated.
	LastUpdatedTime *BlockchainInstant `locationName:"lastUpdatedTime" type:"structure"`

	// The container for the identifier of the owner.
	OwnerIdentifier *OwnerIdentifier `locationName:"ownerIdentifier" type:"structure"`

	// The identifier for the token, including the unique token ID and its blockchain
	// network.
	TokenIdentifier *TokenIdentifier `locationName:"tokenIdentifier" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TokenBalance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TokenBalance) GoString() string {
	return s.String()
}

// SetAtBlockchainInstant sets the AtBlockchainInstant field's value.
func (s *TokenBalance) SetAtBlockchainInstant(v *BlockchainInstant) *TokenBalance {
	s.AtBlockchainInstant = v
	return s
}

// SetBalance sets the Balance field's value.
func (s *TokenBalance) SetBalance(v string) *TokenBalance {
	s.Balance = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *TokenBalance) SetLastUpdatedTime(v *BlockchainInstant) *TokenBalance {
	s.LastUpdatedTime = v
	return s
}

// SetOwnerIdentifier sets the OwnerIdentifier field's value.
func (s *TokenBalance) SetOwnerIdentifier(v *OwnerIdentifier) *TokenBalance {
	s.OwnerIdentifier = v
	return s
}

// SetTokenIdentifier sets the TokenIdentifier field's value.
func (s *TokenBalance) SetTokenIdentifier(v *TokenIdentifier) *TokenBalance {
	s.TokenIdentifier = v
	return s
}

// The container of the token filter like the contract address on a given blockchain
// network or a unique token identifier on a given blockchain network.
//
// You must always specify the network property of this container when using
// this operation.
type TokenFilter struct {
	_ struct{} `type:"structure"`

	// This is the address of the contract.
	ContractAddress *string `locationName:"contractAddress" type:"string"`

	// The blockchain network of the token.
	//
	// Network is a required field
	Network *string `locationName:"network" type:"string" required:"true" enum:"QueryNetwork"`

	// The unique identifier of the token.
	TokenId *string `locationName:"tokenId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TokenFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TokenFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TokenFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TokenFilter"}
	if s.Network == nil {
		invalidParams.Add(request.NewErrParamRequired("Network"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContractAddress sets the ContractAddress field's value.
func (s *TokenFilter) SetContractAddress(v string) *TokenFilter {
	s.ContractAddress = &v
	return s
}

// SetNetwork sets the Network field's value.
func (s *TokenFilter) SetNetwork(v string) *TokenFilter {
	s.Network = &v
	return s
}

// SetTokenId sets the TokenId field's value.
func (s *TokenFilter) SetTokenId(v string) *TokenFilter {
	s.TokenId = &v
	return s
}

// The container for the identifier for the token including the unique token
// ID and its blockchain network.
//
// Only the native tokens BTC and ETH, and the ERC-20, ERC-721, and ERC 1155
// token standards are supported.
type TokenIdentifier struct {
	_ struct{} `type:"structure"`

	// This is the token's contract address.
	ContractAddress *string `locationName:"contractAddress" type:"string"`

	// The blockchain network of the token.
	//
	// Network is a required field
	Network *string `locationName:"network" type:"string" required:"true" enum:"QueryNetwork"`

	// The unique identifier of the token.
	//
	// For native tokens, use the 3 character abbreviation that best matches your
	// token. For example, btc for Bitcoin, eth for Ether, etc. For all other token
	// types you must specify the tokenId in the 64 character hexadecimal tokenid
	// format.
	TokenId *string `locationName:"tokenId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TokenIdentifier) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TokenIdentifier) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TokenIdentifier) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TokenIdentifier"}
	if s.Network == nil {
		invalidParams.Add(request.NewErrParamRequired("Network"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContractAddress sets the ContractAddress field's value.
func (s *TokenIdentifier) SetContractAddress(v string) *TokenIdentifier {
	s.ContractAddress = &v
	return s
}

// SetNetwork sets the Network field's value.
func (s *TokenIdentifier) SetNetwork(v string) *TokenIdentifier {
	s.Network = &v
	return s
}

// SetTokenId sets the TokenId field's value.
func (s *TokenIdentifier) SetTokenId(v string) *TokenIdentifier {
	s.TokenId = &v
	return s
}

// There are two possible types of transactions used for this data type:
//
//   - A Bitcoin transaction is a movement of BTC from one address to another.
//
//   - An Ethereum transaction refers to an action initiated by an externally
//     owned account, which is an account managed by a human, not a contract.
//     For example, if Bob sends Alice 1 ETH, Bob's account must be debited and
//     Alice's must be credited. This state-changing action occurs within a transaction.
type Transaction struct {
	_ struct{} `type:"structure"`

	// The block hash is a unique identifier for a block. It is a fixed-size string
	// that is calculated by using the information in the block. The block hash
	// is used to verify the integrity of the data in the block.
	BlockHash *string `locationName:"blockHash" type:"string"`

	// The block number in which the transaction is recorded.
	BlockNumber *string `locationName:"blockNumber" type:"string"`

	// Specifies whether the transaction has reached Finality.
	ConfirmationStatus *string `locationName:"confirmationStatus" type:"string" enum:"ConfirmationStatus"`

	// The blockchain address for the contract.
	ContractAddress *string `locationName:"contractAddress" type:"string"`

	// The amount of gas used up to the specified point in the block.
	CumulativeGasUsed *string `locationName:"cumulativeGasUsed" type:"string"`

	// The effective gas price.
	EffectiveGasPrice *string `locationName:"effectiveGasPrice" type:"string"`

	// Identifies whether the transaction has succeeded or failed.
	ExecutionStatus *string `locationName:"executionStatus" type:"string" enum:"ExecutionStatus"`

	// The initiator of the transaction. It is either in the form a public key or
	// a contract address.
	From *string `locationName:"from" type:"string"`

	// The amount of gas used for the transaction.
	GasUsed *string `locationName:"gasUsed" type:"string"`

	// The blockchain network where the transaction occurred.
	//
	// Network is a required field
	Network *string `locationName:"network" type:"string" required:"true" enum:"QueryNetwork"`

	// The number of transactions in the block.
	//
	// NumberOfTransactions is a required field
	NumberOfTransactions *int64 `locationName:"numberOfTransactions" type:"long" required:"true"`

	// The signature of the transaction. The X coordinate of a point R.
	SignatureR *string `locationName:"signatureR" type:"string"`

	// The signature of the transaction. The Y coordinate of a point S.
	SignatureS *string `locationName:"signatureS" type:"string"`

	// The signature of the transaction. The Z coordinate of a point V.
	SignatureV *int64 `locationName:"signatureV" type:"integer"`

	// The identifier of the transaction. It is generated whenever a transaction
	// is verified and added to the blockchain.
	//
	// To is a required field
	To *string `locationName:"to" type:"string" required:"true"`

	// The transaction fee.
	TransactionFee *string `locationName:"transactionFee" type:"string"`

	// The hash of a transaction. It is generated when a transaction is created.
	//
	// TransactionHash is a required field
	TransactionHash *string `locationName:"transactionHash" type:"string" required:"true"`

	// The identifier of a Bitcoin transaction. It is generated when a transaction
	// is created.
	TransactionId *string `locationName:"transactionId" type:"string"`

	// The index of the transaction within a blockchain.
	//
	// TransactionIndex is a required field
	TransactionIndex *int64 `locationName:"transactionIndex" type:"long" required:"true"`

	// The Timestamp of the transaction.
	//
	// TransactionTimestamp is a required field
	TransactionTimestamp *time.Time `locationName:"transactionTimestamp" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transaction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Transaction) GoString() string {
	return s.String()
}

// SetBlockHash sets the BlockHash field's value.
func (s *Transaction) SetBlockHash(v string) *Transaction {
	s.BlockHash = &v
	return s
}

// SetBlockNumber sets the BlockNumber field's value.
func (s *Transaction) SetBlockNumber(v string) *Transaction {
	s.BlockNumber = &v
	return s
}

// SetConfirmationStatus sets the ConfirmationStatus field's value.
func (s *Transaction) SetConfirmationStatus(v string) *Transaction {
	s.ConfirmationStatus = &v
	return s
}

// SetContractAddress sets the ContractAddress field's value.
func (s *Transaction) SetContractAddress(v string) *Transaction {
	s.ContractAddress = &v
	return s
}

// SetCumulativeGasUsed sets the CumulativeGasUsed field's value.
func (s *Transaction) SetCumulativeGasUsed(v string) *Transaction {
	s.CumulativeGasUsed = &v
	return s
}

// SetEffectiveGasPrice sets the EffectiveGasPrice field's value.
func (s *Transaction) SetEffectiveGasPrice(v string) *Transaction {
	s.EffectiveGasPrice = &v
	return s
}

// SetExecutionStatus sets the ExecutionStatus field's value.
func (s *Transaction) SetExecutionStatus(v string) *Transaction {
	s.ExecutionStatus = &v
	return s
}

// SetFrom sets the From field's value.
func (s *Transaction) SetFrom(v string) *Transaction {
	s.From = &v
	return s
}

// SetGasUsed sets the GasUsed field's value.
func (s *Transaction) SetGasUsed(v string) *Transaction {
	s.GasUsed = &v
	return s
}

// SetNetwork sets the Network field's value.
func (s *Transaction) SetNetwork(v string) *Transaction {
	s.Network = &v
	return s
}

// SetNumberOfTransactions sets the NumberOfTransactions field's value.
func (s *Transaction) SetNumberOfTransactions(v int64) *Transaction {
	s.NumberOfTransactions = &v
	return s
}

// SetSignatureR sets the SignatureR field's value.
func (s *Transaction) SetSignatureR(v string) *Transaction {
	s.SignatureR = &v
	return s
}

// SetSignatureS sets the SignatureS field's value.
func (s *Transaction) SetSignatureS(v string) *Transaction {
	s.SignatureS = &v
	return s
}

// SetSignatureV sets the SignatureV field's value.
func (s *Transaction) SetSignatureV(v int64) *Transaction {
	s.SignatureV = &v
	return s
}

// SetTo sets the To field's value.
func (s *Transaction) SetTo(v string) *Transaction {
	s.To = &v
	return s
}

// SetTransactionFee sets the TransactionFee field's value.
func (s *Transaction) SetTransactionFee(v string) *Transaction {
	s.TransactionFee = &v
	return s
}

// SetTransactionHash sets the TransactionHash field's value.
func (s *Transaction) SetTransactionHash(v string) *Transaction {
	s.TransactionHash = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *Transaction) SetTransactionId(v string) *Transaction {
	s.TransactionId = &v
	return s
}

// SetTransactionIndex sets the TransactionIndex field's value.
func (s *Transaction) SetTransactionIndex(v int64) *Transaction {
	s.TransactionIndex = &v
	return s
}

// SetTransactionTimestamp sets the TransactionTimestamp field's value.
func (s *Transaction) SetTransactionTimestamp(v time.Time) *Transaction {
	s.TransactionTimestamp = &v
	return s
}

// The container for the properties of a transaction event.
type TransactionEvent struct {
	_ struct{} `type:"structure"`

	// The container for time.
	BlockchainInstant *BlockchainInstant `locationName:"blockchainInstant" type:"structure"`

	// This container specifies whether the transaction has reached Finality.
	ConfirmationStatus *string `locationName:"confirmationStatus" type:"string" enum:"ConfirmationStatus"`

	// The blockchain address for the contract
	ContractAddress *string `locationName:"contractAddress" type:"string"`

	// The type of transaction event.
	//
	// EventType is a required field
	EventType *string `locationName:"eventType" type:"string" required:"true" enum:"QueryTransactionEventType"`

	// The wallet address initiating the transaction. It can either be a public
	// key or a contract.
	From *string `locationName:"from" type:"string"`

	// The blockchain network where the transaction occurred.
	//
	// Network is a required field
	Network *string `locationName:"network" type:"string" required:"true" enum:"QueryNetwork"`

	// The position of the spent transaction output in the output list of the creating
	// transaction.
	//
	// This is only returned for BITCOIN_VIN event types.
	SpentVoutIndex *int64 `locationName:"spentVoutIndex" type:"integer"`

	// The transactionHash that created the spent transaction output.
	//
	// This is only returned for BITCOIN_VIN event types.
	SpentVoutTransactionHash *string `locationName:"spentVoutTransactionHash" type:"string"`

	// The transactionId that created the spent transaction output.
	//
	// This is only returned for BITCOIN_VIN event types.
	SpentVoutTransactionId *string `locationName:"spentVoutTransactionId" type:"string"`

	// The wallet address receiving the transaction. It can either be a public key
	// or a contract.
	To *string `locationName:"to" type:"string"`

	// The unique identifier for the token involved in the transaction.
	TokenId *string `locationName:"tokenId" type:"string"`

	// The hash of a transaction. It is generated when a transaction is created.
	//
	// TransactionHash is a required field
	TransactionHash *string `locationName:"transactionHash" type:"string" required:"true"`

	// The identifier of a Bitcoin transaction. It is generated when a transaction
	// is created.
	TransactionId *string `locationName:"transactionId" type:"string"`

	// The value that was transacted.
	Value *string `locationName:"value" type:"string"`

	// The position of the transaction output in the transaction output list.
	VoutIndex *int64 `locationName:"voutIndex" type:"integer"`

	// Specifies if the transaction output is spent or unspent. This is only returned
	// for BITCOIN_VOUT event types.
	//
	// This is only returned for BITCOIN_VOUT event types.
	VoutSpent *bool `locationName:"voutSpent" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionEvent) GoString() string {
	return s.String()
}

// SetBlockchainInstant sets the BlockchainInstant field's value.
func (s *TransactionEvent) SetBlockchainInstant(v *BlockchainInstant) *TransactionEvent {
	s.BlockchainInstant = v
	return s
}

// SetConfirmationStatus sets the ConfirmationStatus field's value.
func (s *TransactionEvent) SetConfirmationStatus(v string) *TransactionEvent {
	s.ConfirmationStatus = &v
	return s
}

// SetContractAddress sets the ContractAddress field's value.
func (s *TransactionEvent) SetContractAddress(v string) *TransactionEvent {
	s.ContractAddress = &v
	return s
}

// SetEventType sets the EventType field's value.
func (s *TransactionEvent) SetEventType(v string) *TransactionEvent {
	s.EventType = &v
	return s
}

// SetFrom sets the From field's value.
func (s *TransactionEvent) SetFrom(v string) *TransactionEvent {
	s.From = &v
	return s
}

// SetNetwork sets the Network field's value.
func (s *TransactionEvent) SetNetwork(v string) *TransactionEvent {
	s.Network = &v
	return s
}

// SetSpentVoutIndex sets the SpentVoutIndex field's value.
func (s *TransactionEvent) SetSpentVoutIndex(v int64) *TransactionEvent {
	s.SpentVoutIndex = &v
	return s
}

// SetSpentVoutTransactionHash sets the SpentVoutTransactionHash field's value.
func (s *TransactionEvent) SetSpentVoutTransactionHash(v string) *TransactionEvent {
	s.SpentVoutTransactionHash = &v
	return s
}

// SetSpentVoutTransactionId sets the SpentVoutTransactionId field's value.
func (s *TransactionEvent) SetSpentVoutTransactionId(v string) *TransactionEvent {
	s.SpentVoutTransactionId = &v
	return s
}

// SetTo sets the To field's value.
func (s *TransactionEvent) SetTo(v string) *TransactionEvent {
	s.To = &v
	return s
}

// SetTokenId sets the TokenId field's value.
func (s *TransactionEvent) SetTokenId(v string) *TransactionEvent {
	s.TokenId = &v
	return s
}

// SetTransactionHash sets the TransactionHash field's value.
func (s *TransactionEvent) SetTransactionHash(v string) *TransactionEvent {
	s.TransactionHash = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *TransactionEvent) SetTransactionId(v string) *TransactionEvent {
	s.TransactionId = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TransactionEvent) SetValue(v string) *TransactionEvent {
	s.Value = &v
	return s
}

// SetVoutIndex sets the VoutIndex field's value.
func (s *TransactionEvent) SetVoutIndex(v int64) *TransactionEvent {
	s.VoutIndex = &v
	return s
}

// SetVoutSpent sets the VoutSpent field's value.
func (s *TransactionEvent) SetVoutSpent(v bool) *TransactionEvent {
	s.VoutSpent = &v
	return s
}

// The container of the transaction output.
type TransactionOutputItem struct {
	_ struct{} `type:"structure"`

	// Specifies whether to list transactions that have not reached Finality.
	ConfirmationStatus *string `locationName:"confirmationStatus" type:"string" enum:"ConfirmationStatus"`

	// The blockchain network where the transaction occurred.
	//
	// Network is a required field
	Network *string `locationName:"network" type:"string" required:"true" enum:"QueryNetwork"`

	// The hash of a transaction. It is generated when a transaction is created.
	//
	// TransactionHash is a required field
	TransactionHash *string `locationName:"transactionHash" type:"string" required:"true"`

	// The identifier of a Bitcoin transaction. It is generated when a transaction
	// is created.
	TransactionId *string `locationName:"transactionId" type:"string"`

	// The time when the transaction occurred.
	//
	// TransactionTimestamp is a required field
	TransactionTimestamp *time.Time `locationName:"transactionTimestamp" type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionOutputItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TransactionOutputItem) GoString() string {
	return s.String()
}

// SetConfirmationStatus sets the ConfirmationStatus field's value.
func (s *TransactionOutputItem) SetConfirmationStatus(v string) *TransactionOutputItem {
	s.ConfirmationStatus = &v
	return s
}

// SetNetwork sets the Network field's value.
func (s *TransactionOutputItem) SetNetwork(v string) *TransactionOutputItem {
	s.Network = &v
	return s
}

// SetTransactionHash sets the TransactionHash field's value.
func (s *TransactionOutputItem) SetTransactionHash(v string) *TransactionOutputItem {
	s.TransactionHash = &v
	return s
}

// SetTransactionId sets the TransactionId field's value.
func (s *TransactionOutputItem) SetTransactionId(v string) *TransactionOutputItem {
	s.TransactionId = &v
	return s
}

// SetTransactionTimestamp sets the TransactionTimestamp field's value.
func (s *TransactionOutputItem) SetTransactionTimestamp(v time.Time) *TransactionOutputItem {
	s.TransactionTimestamp = &v
	return s
}

// The resource passed is invalid.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The container for the fieldList of the exception.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	// The container for the exception message.
	Message_ *string `locationName:"message" min:"1" type:"string"`

	// The container for the reason for the exception
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource passed is invalid.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The ValidationException message.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the field that triggered the ValidationException.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// This container specifies filtering attributes related to BITCOIN_VOUT event
// types
type VoutFilter struct {
	_ struct{} `type:"structure"`

	// Specifies if the transaction output is spent or unspent.
	//
	// VoutSpent is a required field
	VoutSpent *bool `locationName:"voutSpent" type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoutFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VoutFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VoutFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VoutFilter"}
	if s.VoutSpent == nil {
		invalidParams.Add(request.NewErrParamRequired("VoutSpent"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVoutSpent sets the VoutSpent field's value.
func (s *VoutFilter) SetVoutSpent(v bool) *VoutFilter {
	s.VoutSpent = &v
	return s
}

const (
	// ConfirmationStatusFinal is a ConfirmationStatus enum value
	ConfirmationStatusFinal = "FINAL"

	// ConfirmationStatusNonfinal is a ConfirmationStatus enum value
	ConfirmationStatusNonfinal = "NONFINAL"
)

// ConfirmationStatus_Values returns all elements of the ConfirmationStatus enum
func ConfirmationStatus_Values() []string {
	return []string{
		ConfirmationStatusFinal,
		ConfirmationStatusNonfinal,
	}
}

const (
	// ErrorTypeValidationException is a ErrorType enum value
	ErrorTypeValidationException = "VALIDATION_EXCEPTION"

	// ErrorTypeResourceNotFoundException is a ErrorType enum value
	ErrorTypeResourceNotFoundException = "RESOURCE_NOT_FOUND_EXCEPTION"
)

// ErrorType_Values returns all elements of the ErrorType enum
func ErrorType_Values() []string {
	return []string{
		ErrorTypeValidationException,
		ErrorTypeResourceNotFoundException,
	}
}

const (
	// ExecutionStatusFailed is a ExecutionStatus enum value
	ExecutionStatusFailed = "FAILED"

	// ExecutionStatusSucceeded is a ExecutionStatus enum value
	ExecutionStatusSucceeded = "SUCCEEDED"
)

// ExecutionStatus_Values returns all elements of the ExecutionStatus enum
func ExecutionStatus_Values() []string {
	return []string{
		ExecutionStatusFailed,
		ExecutionStatusSucceeded,
	}
}

const (
	// ListFilteredTransactionEventsSortByBlockchainInstant is a ListFilteredTransactionEventsSortBy enum value
	ListFilteredTransactionEventsSortByBlockchainInstant = "blockchainInstant"
)

// ListFilteredTransactionEventsSortBy_Values returns all elements of the ListFilteredTransactionEventsSortBy enum
func ListFilteredTransactionEventsSortBy_Values() []string {
	return []string{
		ListFilteredTransactionEventsSortByBlockchainInstant,
	}
}

const (
	// ListTransactionsSortByTransactionTimestamp is a ListTransactionsSortBy enum value
	ListTransactionsSortByTransactionTimestamp = "TRANSACTION_TIMESTAMP"
)

// ListTransactionsSortBy_Values returns all elements of the ListTransactionsSortBy enum
func ListTransactionsSortBy_Values() []string {
	return []string{
		ListTransactionsSortByTransactionTimestamp,
	}
}

const (
	// QueryNetworkEthereumMainnet is a QueryNetwork enum value
	QueryNetworkEthereumMainnet = "ETHEREUM_MAINNET"

	// QueryNetworkEthereumSepoliaTestnet is a QueryNetwork enum value
	QueryNetworkEthereumSepoliaTestnet = "ETHEREUM_SEPOLIA_TESTNET"

	// QueryNetworkBitcoinMainnet is a QueryNetwork enum value
	QueryNetworkBitcoinMainnet = "BITCOIN_MAINNET"

	// QueryNetworkBitcoinTestnet is a QueryNetwork enum value
	QueryNetworkBitcoinTestnet = "BITCOIN_TESTNET"
)

// QueryNetwork_Values returns all elements of the QueryNetwork enum
func QueryNetwork_Values() []string {
	return []string{
		QueryNetworkEthereumMainnet,
		QueryNetworkEthereumSepoliaTestnet,
		QueryNetworkBitcoinMainnet,
		QueryNetworkBitcoinTestnet,
	}
}

const (
	// QueryTokenStandardErc20 is a QueryTokenStandard enum value
	QueryTokenStandardErc20 = "ERC20"

	// QueryTokenStandardErc721 is a QueryTokenStandard enum value
	QueryTokenStandardErc721 = "ERC721"

	// QueryTokenStandardErc1155 is a QueryTokenStandard enum value
	QueryTokenStandardErc1155 = "ERC1155"
)

// QueryTokenStandard_Values returns all elements of the QueryTokenStandard enum
func QueryTokenStandard_Values() []string {
	return []string{
		QueryTokenStandardErc20,
		QueryTokenStandardErc721,
		QueryTokenStandardErc1155,
	}
}

const (
	// QueryTransactionEventTypeErc20Transfer is a QueryTransactionEventType enum value
	QueryTransactionEventTypeErc20Transfer = "ERC20_TRANSFER"

	// QueryTransactionEventTypeErc20Mint is a QueryTransactionEventType enum value
	QueryTransactionEventTypeErc20Mint = "ERC20_MINT"

	// QueryTransactionEventTypeErc20Burn is a QueryTransactionEventType enum value
	QueryTransactionEventTypeErc20Burn = "ERC20_BURN"

	// QueryTransactionEventTypeErc20Deposit is a QueryTransactionEventType enum value
	QueryTransactionEventTypeErc20Deposit = "ERC20_DEPOSIT"

	// QueryTransactionEventTypeErc20Withdrawal is a QueryTransactionEventType enum value
	QueryTransactionEventTypeErc20Withdrawal = "ERC20_WITHDRAWAL"

	// QueryTransactionEventTypeErc721Transfer is a QueryTransactionEventType enum value
	QueryTransactionEventTypeErc721Transfer = "ERC721_TRANSFER"

	// QueryTransactionEventTypeErc1155Transfer is a QueryTransactionEventType enum value
	QueryTransactionEventTypeErc1155Transfer = "ERC1155_TRANSFER"

	// QueryTransactionEventTypeBitcoinVin is a QueryTransactionEventType enum value
	QueryTransactionEventTypeBitcoinVin = "BITCOIN_VIN"

	// QueryTransactionEventTypeBitcoinVout is a QueryTransactionEventType enum value
	QueryTransactionEventTypeBitcoinVout = "BITCOIN_VOUT"

	// QueryTransactionEventTypeInternalEthTransfer is a QueryTransactionEventType enum value
	QueryTransactionEventTypeInternalEthTransfer = "INTERNAL_ETH_TRANSFER"

	// QueryTransactionEventTypeEthTransfer is a QueryTransactionEventType enum value
	QueryTransactionEventTypeEthTransfer = "ETH_TRANSFER"
)

// QueryTransactionEventType_Values returns all elements of the QueryTransactionEventType enum
func QueryTransactionEventType_Values() []string {
	return []string{
		QueryTransactionEventTypeErc20Transfer,
		QueryTransactionEventTypeErc20Mint,
		QueryTransactionEventTypeErc20Burn,
		QueryTransactionEventTypeErc20Deposit,
		QueryTransactionEventTypeErc20Withdrawal,
		QueryTransactionEventTypeErc721Transfer,
		QueryTransactionEventTypeErc1155Transfer,
		QueryTransactionEventTypeBitcoinVin,
		QueryTransactionEventTypeBitcoinVout,
		QueryTransactionEventTypeInternalEthTransfer,
		QueryTransactionEventTypeEthTransfer,
	}
}

const (
	// ResourceTypeCollection is a ResourceType enum value
	ResourceTypeCollection = "collection"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeCollection,
	}
}

const (
	// SortOrderAscending is a SortOrder enum value
	SortOrderAscending = "ASCENDING"

	// SortOrderDescending is a SortOrder enum value
	SortOrderDescending = "DESCENDING"
)

// SortOrder_Values returns all elements of the SortOrder enum
func SortOrder_Values() []string {
	return []string{
		SortOrderAscending,
		SortOrderDescending,
	}
}

const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "unknownOperation"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "cannotParse"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "fieldValidationFailed"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "other"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}
