package bldr

import (
	"bytes"
	"testing"

	"gitlab.com/gitlab-org/step-runner/pkg/runner"
)

type GlobalContextBuilder struct {
	jobVars runner.JobVariables
}

func GlobalContext(t *testing.T) *GlobalContextBuilder {
	return &GlobalContextBuilder{
		jobVars: JobVars(t).Build(),
	}
}

func (b *GlobalContextBuilder) WithJobVars(jobVars runner.JobVariables) *GlobalContextBuilder {
	b.jobVars = jobVars
	return b
}

func (b *GlobalContextBuilder) Build() *runner.GlobalContext {
	return runner.NewGlobalContext(".", b.jobVars, runner.NewEmptyEnvironment(), &bytes.Buffer{}, &bytes.Buffer{})
}
