/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UpdateSalesforceTarget updateSalesforceTarget is a command that updates a new target. [Deprecated: Use target-update-salesforce command]
type UpdateSalesforceTarget struct {
	// Base64 encoded PEM of the connected app private key (relevant for JWT auth only)
	AppPrivateKeyData *string `json:"app-private-key-data,omitempty"`
	// type of the auth flow ('jwt' / 'user-password')
	AuthFlow string `json:"auth-flow"`
	// Base64 encoded PEM cert to use when uploading a new key to Salesforce
	CaCertData *string `json:"ca-cert-data,omitempty"`
	// name of the certificate in Salesforce tenant to use when uploading new key
	CaCertName *string `json:"ca-cert-name,omitempty"`
	// Client ID of the oauth2 app to use for connecting to Salesforce
	ClientId string `json:"client-id"`
	// Client secret of the oauth2 app to use for connecting to Salesforce (required for password flow)
	ClientSecret *string `json:"client-secret,omitempty"`
	// Deprecated - use description
	Comment *string `json:"comment,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// The email of the user attached to the oauth2 app used for connecting to Salesforce
	Email string `json:"email"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Whether to keep previous version [true/false]. If not set, use default according to account settings
	KeepPrevVersion *string `json:"keep-prev-version,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// New target name
	NewName *string `json:"new-name,omitempty"`
	// The password of the user attached to the oauth2 app used for connecting to Salesforce (required for user-password flow)
	Password *string `json:"password,omitempty"`
	// The security token of the user attached to the oauth2 app used for connecting to Salesforce  (required for user-password flow)
	SecurityToken *string `json:"security-token,omitempty"`
	// Url of the Salesforce tenant
	TenantUrl string `json:"tenant-url"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Deprecated
	UpdateVersion *bool `json:"update-version,omitempty"`
}

// NewUpdateSalesforceTarget instantiates a new UpdateSalesforceTarget object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateSalesforceTarget(authFlow string, clientId string, email string, name string, tenantUrl string, ) *UpdateSalesforceTarget {
	this := UpdateSalesforceTarget{}
	this.AuthFlow = authFlow
	this.ClientId = clientId
	this.Email = email
	var json bool = false
	this.Json = &json
	this.Name = name
	this.TenantUrl = tenantUrl
	return &this
}

// NewUpdateSalesforceTargetWithDefaults instantiates a new UpdateSalesforceTarget object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateSalesforceTargetWithDefaults() *UpdateSalesforceTarget {
	this := UpdateSalesforceTarget{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetAppPrivateKeyData returns the AppPrivateKeyData field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetAppPrivateKeyData() string {
	if o == nil || o.AppPrivateKeyData == nil {
		var ret string
		return ret
	}
	return *o.AppPrivateKeyData
}

// GetAppPrivateKeyDataOk returns a tuple with the AppPrivateKeyData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetAppPrivateKeyDataOk() (*string, bool) {
	if o == nil || o.AppPrivateKeyData == nil {
		return nil, false
	}
	return o.AppPrivateKeyData, true
}

// HasAppPrivateKeyData returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasAppPrivateKeyData() bool {
	if o != nil && o.AppPrivateKeyData != nil {
		return true
	}

	return false
}

// SetAppPrivateKeyData gets a reference to the given string and assigns it to the AppPrivateKeyData field.
func (o *UpdateSalesforceTarget) SetAppPrivateKeyData(v string) {
	o.AppPrivateKeyData = &v
}

// GetAuthFlow returns the AuthFlow field value
func (o *UpdateSalesforceTarget) GetAuthFlow() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.AuthFlow
}

// GetAuthFlowOk returns a tuple with the AuthFlow field value
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetAuthFlowOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.AuthFlow, true
}

// SetAuthFlow sets field value
func (o *UpdateSalesforceTarget) SetAuthFlow(v string) {
	o.AuthFlow = v
}

// GetCaCertData returns the CaCertData field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetCaCertData() string {
	if o == nil || o.CaCertData == nil {
		var ret string
		return ret
	}
	return *o.CaCertData
}

// GetCaCertDataOk returns a tuple with the CaCertData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetCaCertDataOk() (*string, bool) {
	if o == nil || o.CaCertData == nil {
		return nil, false
	}
	return o.CaCertData, true
}

// HasCaCertData returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasCaCertData() bool {
	if o != nil && o.CaCertData != nil {
		return true
	}

	return false
}

// SetCaCertData gets a reference to the given string and assigns it to the CaCertData field.
func (o *UpdateSalesforceTarget) SetCaCertData(v string) {
	o.CaCertData = &v
}

// GetCaCertName returns the CaCertName field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetCaCertName() string {
	if o == nil || o.CaCertName == nil {
		var ret string
		return ret
	}
	return *o.CaCertName
}

// GetCaCertNameOk returns a tuple with the CaCertName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetCaCertNameOk() (*string, bool) {
	if o == nil || o.CaCertName == nil {
		return nil, false
	}
	return o.CaCertName, true
}

// HasCaCertName returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasCaCertName() bool {
	if o != nil && o.CaCertName != nil {
		return true
	}

	return false
}

// SetCaCertName gets a reference to the given string and assigns it to the CaCertName field.
func (o *UpdateSalesforceTarget) SetCaCertName(v string) {
	o.CaCertName = &v
}

// GetClientId returns the ClientId field value
func (o *UpdateSalesforceTarget) GetClientId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ClientId
}

// GetClientIdOk returns a tuple with the ClientId field value
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetClientIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ClientId, true
}

// SetClientId sets field value
func (o *UpdateSalesforceTarget) SetClientId(v string) {
	o.ClientId = v
}

// GetClientSecret returns the ClientSecret field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetClientSecret() string {
	if o == nil || o.ClientSecret == nil {
		var ret string
		return ret
	}
	return *o.ClientSecret
}

// GetClientSecretOk returns a tuple with the ClientSecret field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetClientSecretOk() (*string, bool) {
	if o == nil || o.ClientSecret == nil {
		return nil, false
	}
	return o.ClientSecret, true
}

// HasClientSecret returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasClientSecret() bool {
	if o != nil && o.ClientSecret != nil {
		return true
	}

	return false
}

// SetClientSecret gets a reference to the given string and assigns it to the ClientSecret field.
func (o *UpdateSalesforceTarget) SetClientSecret(v string) {
	o.ClientSecret = &v
}

// GetComment returns the Comment field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetComment() string {
	if o == nil || o.Comment == nil {
		var ret string
		return ret
	}
	return *o.Comment
}

// GetCommentOk returns a tuple with the Comment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetCommentOk() (*string, bool) {
	if o == nil || o.Comment == nil {
		return nil, false
	}
	return o.Comment, true
}

// HasComment returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasComment() bool {
	if o != nil && o.Comment != nil {
		return true
	}

	return false
}

// SetComment gets a reference to the given string and assigns it to the Comment field.
func (o *UpdateSalesforceTarget) SetComment(v string) {
	o.Comment = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *UpdateSalesforceTarget) SetDescription(v string) {
	o.Description = &v
}

// GetEmail returns the Email field value
func (o *UpdateSalesforceTarget) GetEmail() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Email
}

// GetEmailOk returns a tuple with the Email field value
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetEmailOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Email, true
}

// SetEmail sets field value
func (o *UpdateSalesforceTarget) SetEmail(v string) {
	o.Email = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *UpdateSalesforceTarget) SetJson(v bool) {
	o.Json = &v
}

// GetKeepPrevVersion returns the KeepPrevVersion field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetKeepPrevVersion() string {
	if o == nil || o.KeepPrevVersion == nil {
		var ret string
		return ret
	}
	return *o.KeepPrevVersion
}

// GetKeepPrevVersionOk returns a tuple with the KeepPrevVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetKeepPrevVersionOk() (*string, bool) {
	if o == nil || o.KeepPrevVersion == nil {
		return nil, false
	}
	return o.KeepPrevVersion, true
}

// HasKeepPrevVersion returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasKeepPrevVersion() bool {
	if o != nil && o.KeepPrevVersion != nil {
		return true
	}

	return false
}

// SetKeepPrevVersion gets a reference to the given string and assigns it to the KeepPrevVersion field.
func (o *UpdateSalesforceTarget) SetKeepPrevVersion(v string) {
	o.KeepPrevVersion = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *UpdateSalesforceTarget) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *UpdateSalesforceTarget) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *UpdateSalesforceTarget) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *UpdateSalesforceTarget) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *UpdateSalesforceTarget) SetNewName(v string) {
	o.NewName = &v
}

// GetPassword returns the Password field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetPassword() string {
	if o == nil || o.Password == nil {
		var ret string
		return ret
	}
	return *o.Password
}

// GetPasswordOk returns a tuple with the Password field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetPasswordOk() (*string, bool) {
	if o == nil || o.Password == nil {
		return nil, false
	}
	return o.Password, true
}

// HasPassword returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasPassword() bool {
	if o != nil && o.Password != nil {
		return true
	}

	return false
}

// SetPassword gets a reference to the given string and assigns it to the Password field.
func (o *UpdateSalesforceTarget) SetPassword(v string) {
	o.Password = &v
}

// GetSecurityToken returns the SecurityToken field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetSecurityToken() string {
	if o == nil || o.SecurityToken == nil {
		var ret string
		return ret
	}
	return *o.SecurityToken
}

// GetSecurityTokenOk returns a tuple with the SecurityToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetSecurityTokenOk() (*string, bool) {
	if o == nil || o.SecurityToken == nil {
		return nil, false
	}
	return o.SecurityToken, true
}

// HasSecurityToken returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasSecurityToken() bool {
	if o != nil && o.SecurityToken != nil {
		return true
	}

	return false
}

// SetSecurityToken gets a reference to the given string and assigns it to the SecurityToken field.
func (o *UpdateSalesforceTarget) SetSecurityToken(v string) {
	o.SecurityToken = &v
}

// GetTenantUrl returns the TenantUrl field value
func (o *UpdateSalesforceTarget) GetTenantUrl() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.TenantUrl
}

// GetTenantUrlOk returns a tuple with the TenantUrl field value
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetTenantUrlOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.TenantUrl, true
}

// SetTenantUrl sets field value
func (o *UpdateSalesforceTarget) SetTenantUrl(v string) {
	o.TenantUrl = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *UpdateSalesforceTarget) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UpdateSalesforceTarget) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUpdateVersion returns the UpdateVersion field value if set, zero value otherwise.
func (o *UpdateSalesforceTarget) GetUpdateVersion() bool {
	if o == nil || o.UpdateVersion == nil {
		var ret bool
		return ret
	}
	return *o.UpdateVersion
}

// GetUpdateVersionOk returns a tuple with the UpdateVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateSalesforceTarget) GetUpdateVersionOk() (*bool, bool) {
	if o == nil || o.UpdateVersion == nil {
		return nil, false
	}
	return o.UpdateVersion, true
}

// HasUpdateVersion returns a boolean if a field has been set.
func (o *UpdateSalesforceTarget) HasUpdateVersion() bool {
	if o != nil && o.UpdateVersion != nil {
		return true
	}

	return false
}

// SetUpdateVersion gets a reference to the given bool and assigns it to the UpdateVersion field.
func (o *UpdateSalesforceTarget) SetUpdateVersion(v bool) {
	o.UpdateVersion = &v
}

func (o UpdateSalesforceTarget) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AppPrivateKeyData != nil {
		toSerialize["app-private-key-data"] = o.AppPrivateKeyData
	}
	if true {
		toSerialize["auth-flow"] = o.AuthFlow
	}
	if o.CaCertData != nil {
		toSerialize["ca-cert-data"] = o.CaCertData
	}
	if o.CaCertName != nil {
		toSerialize["ca-cert-name"] = o.CaCertName
	}
	if true {
		toSerialize["client-id"] = o.ClientId
	}
	if o.ClientSecret != nil {
		toSerialize["client-secret"] = o.ClientSecret
	}
	if o.Comment != nil {
		toSerialize["comment"] = o.Comment
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if true {
		toSerialize["email"] = o.Email
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.KeepPrevVersion != nil {
		toSerialize["keep-prev-version"] = o.KeepPrevVersion
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.Password != nil {
		toSerialize["password"] = o.Password
	}
	if o.SecurityToken != nil {
		toSerialize["security-token"] = o.SecurityToken
	}
	if true {
		toSerialize["tenant-url"] = o.TenantUrl
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UpdateVersion != nil {
		toSerialize["update-version"] = o.UpdateVersion
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateSalesforceTarget struct {
	value *UpdateSalesforceTarget
	isSet bool
}

func (v NullableUpdateSalesforceTarget) Get() *UpdateSalesforceTarget {
	return v.value
}

func (v *NullableUpdateSalesforceTarget) Set(val *UpdateSalesforceTarget) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateSalesforceTarget) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateSalesforceTarget) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateSalesforceTarget(val *UpdateSalesforceTarget) *NullableUpdateSalesforceTarget {
	return &NullableUpdateSalesforceTarget{value: val, isSet: true}
}

func (v NullableUpdateSalesforceTarget) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateSalesforceTarget) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


