/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UpdateOidcApp struct for UpdateOidcApp
type UpdateOidcApp struct {
	// A comma separated list of allowed audiences
	Audience *string `json:"audience,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the OIDC application (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// OIDC application name
	Name string `json:"name"`
	// A json string defining the access permission assignment for this app
	PermissionAssignment *string `json:"permission-assignment,omitempty"`
	// Set to true if the app is public (cannot keep secrets)
	Public *bool `json:"public,omitempty"`
	// A comma separated list of allowed redirect uris
	RedirectUris *string `json:"redirect-uris,omitempty"`
	// A comma separated list of allowed scopes
	Scopes *string `json:"scopes,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewUpdateOidcApp instantiates a new UpdateOidcApp object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUpdateOidcApp(name string, ) *UpdateOidcApp {
	this := UpdateOidcApp{}
	var json bool = false
	this.Json = &json
	this.Name = name
	var scopes string = "openid"
	this.Scopes = &scopes
	return &this
}

// NewUpdateOidcAppWithDefaults instantiates a new UpdateOidcApp object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUpdateOidcAppWithDefaults() *UpdateOidcApp {
	this := UpdateOidcApp{}
	var json bool = false
	this.Json = &json
	var scopes string = "openid"
	this.Scopes = &scopes
	return &this
}

// GetAudience returns the Audience field value if set, zero value otherwise.
func (o *UpdateOidcApp) GetAudience() string {
	if o == nil || o.Audience == nil {
		var ret string
		return ret
	}
	return *o.Audience
}

// GetAudienceOk returns a tuple with the Audience field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateOidcApp) GetAudienceOk() (*string, bool) {
	if o == nil || o.Audience == nil {
		return nil, false
	}
	return o.Audience, true
}

// HasAudience returns a boolean if a field has been set.
func (o *UpdateOidcApp) HasAudience() bool {
	if o != nil && o.Audience != nil {
		return true
	}

	return false
}

// SetAudience gets a reference to the given string and assigns it to the Audience field.
func (o *UpdateOidcApp) SetAudience(v string) {
	o.Audience = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *UpdateOidcApp) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateOidcApp) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *UpdateOidcApp) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *UpdateOidcApp) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *UpdateOidcApp) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateOidcApp) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *UpdateOidcApp) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *UpdateOidcApp) SetKey(v string) {
	o.Key = &v
}

// GetName returns the Name field value
func (o *UpdateOidcApp) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *UpdateOidcApp) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *UpdateOidcApp) SetName(v string) {
	o.Name = v
}

// GetPermissionAssignment returns the PermissionAssignment field value if set, zero value otherwise.
func (o *UpdateOidcApp) GetPermissionAssignment() string {
	if o == nil || o.PermissionAssignment == nil {
		var ret string
		return ret
	}
	return *o.PermissionAssignment
}

// GetPermissionAssignmentOk returns a tuple with the PermissionAssignment field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateOidcApp) GetPermissionAssignmentOk() (*string, bool) {
	if o == nil || o.PermissionAssignment == nil {
		return nil, false
	}
	return o.PermissionAssignment, true
}

// HasPermissionAssignment returns a boolean if a field has been set.
func (o *UpdateOidcApp) HasPermissionAssignment() bool {
	if o != nil && o.PermissionAssignment != nil {
		return true
	}

	return false
}

// SetPermissionAssignment gets a reference to the given string and assigns it to the PermissionAssignment field.
func (o *UpdateOidcApp) SetPermissionAssignment(v string) {
	o.PermissionAssignment = &v
}

// GetPublic returns the Public field value if set, zero value otherwise.
func (o *UpdateOidcApp) GetPublic() bool {
	if o == nil || o.Public == nil {
		var ret bool
		return ret
	}
	return *o.Public
}

// GetPublicOk returns a tuple with the Public field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateOidcApp) GetPublicOk() (*bool, bool) {
	if o == nil || o.Public == nil {
		return nil, false
	}
	return o.Public, true
}

// HasPublic returns a boolean if a field has been set.
func (o *UpdateOidcApp) HasPublic() bool {
	if o != nil && o.Public != nil {
		return true
	}

	return false
}

// SetPublic gets a reference to the given bool and assigns it to the Public field.
func (o *UpdateOidcApp) SetPublic(v bool) {
	o.Public = &v
}

// GetRedirectUris returns the RedirectUris field value if set, zero value otherwise.
func (o *UpdateOidcApp) GetRedirectUris() string {
	if o == nil || o.RedirectUris == nil {
		var ret string
		return ret
	}
	return *o.RedirectUris
}

// GetRedirectUrisOk returns a tuple with the RedirectUris field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateOidcApp) GetRedirectUrisOk() (*string, bool) {
	if o == nil || o.RedirectUris == nil {
		return nil, false
	}
	return o.RedirectUris, true
}

// HasRedirectUris returns a boolean if a field has been set.
func (o *UpdateOidcApp) HasRedirectUris() bool {
	if o != nil && o.RedirectUris != nil {
		return true
	}

	return false
}

// SetRedirectUris gets a reference to the given string and assigns it to the RedirectUris field.
func (o *UpdateOidcApp) SetRedirectUris(v string) {
	o.RedirectUris = &v
}

// GetScopes returns the Scopes field value if set, zero value otherwise.
func (o *UpdateOidcApp) GetScopes() string {
	if o == nil || o.Scopes == nil {
		var ret string
		return ret
	}
	return *o.Scopes
}

// GetScopesOk returns a tuple with the Scopes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateOidcApp) GetScopesOk() (*string, bool) {
	if o == nil || o.Scopes == nil {
		return nil, false
	}
	return o.Scopes, true
}

// HasScopes returns a boolean if a field has been set.
func (o *UpdateOidcApp) HasScopes() bool {
	if o != nil && o.Scopes != nil {
		return true
	}

	return false
}

// SetScopes gets a reference to the given string and assigns it to the Scopes field.
func (o *UpdateOidcApp) SetScopes(v string) {
	o.Scopes = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *UpdateOidcApp) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateOidcApp) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *UpdateOidcApp) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *UpdateOidcApp) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UpdateOidcApp) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UpdateOidcApp) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UpdateOidcApp) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UpdateOidcApp) SetUidToken(v string) {
	o.UidToken = &v
}

func (o UpdateOidcApp) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Audience != nil {
		toSerialize["audience"] = o.Audience
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.PermissionAssignment != nil {
		toSerialize["permission-assignment"] = o.PermissionAssignment
	}
	if o.Public != nil {
		toSerialize["public"] = o.Public
	}
	if o.RedirectUris != nil {
		toSerialize["redirect-uris"] = o.RedirectUris
	}
	if o.Scopes != nil {
		toSerialize["scopes"] = o.Scopes
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableUpdateOidcApp struct {
	value *UpdateOidcApp
	isSet bool
}

func (v NullableUpdateOidcApp) Get() *UpdateOidcApp {
	return v.value
}

func (v *NullableUpdateOidcApp) Set(val *UpdateOidcApp) {
	v.value = val
	v.isSet = true
}

func (v NullableUpdateOidcApp) IsSet() bool {
	return v.isSet
}

func (v *NullableUpdateOidcApp) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUpdateOidcApp(val *UpdateOidcApp) *NullableUpdateOidcApp {
	return &NullableUpdateOidcApp{value: val, isSet: true}
}

func (v NullableUpdateOidcApp) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUpdateOidcApp) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


