/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// UidRotateToken uidRotateToken is a command that rotates an Akeyless Universal Identity token.
type UidRotateToken struct {
	// Create a new child token with default parameters
	Fork *bool `json:"fork,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The new rotated token to send manual ack for (with uid-token=the-orig-token)
	SendManualAckToken *string `json:"send-manual-ack-token,omitempty"`
	// The Universal identity token
	UidToken *string `json:"uid-token,omitempty"`
	// Disable automatic ack
	WithManualAck *bool `json:"with-manual-ack,omitempty"`
}

// NewUidRotateToken instantiates a new UidRotateToken object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewUidRotateToken() *UidRotateToken {
	this := UidRotateToken{}
	var json bool = false
	this.Json = &json
	return &this
}

// NewUidRotateTokenWithDefaults instantiates a new UidRotateToken object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewUidRotateTokenWithDefaults() *UidRotateToken {
	this := UidRotateToken{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetFork returns the Fork field value if set, zero value otherwise.
func (o *UidRotateToken) GetFork() bool {
	if o == nil || o.Fork == nil {
		var ret bool
		return ret
	}
	return *o.Fork
}

// GetForkOk returns a tuple with the Fork field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidRotateToken) GetForkOk() (*bool, bool) {
	if o == nil || o.Fork == nil {
		return nil, false
	}
	return o.Fork, true
}

// HasFork returns a boolean if a field has been set.
func (o *UidRotateToken) HasFork() bool {
	if o != nil && o.Fork != nil {
		return true
	}

	return false
}

// SetFork gets a reference to the given bool and assigns it to the Fork field.
func (o *UidRotateToken) SetFork(v bool) {
	o.Fork = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *UidRotateToken) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidRotateToken) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *UidRotateToken) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *UidRotateToken) SetJson(v bool) {
	o.Json = &v
}

// GetSendManualAckToken returns the SendManualAckToken field value if set, zero value otherwise.
func (o *UidRotateToken) GetSendManualAckToken() string {
	if o == nil || o.SendManualAckToken == nil {
		var ret string
		return ret
	}
	return *o.SendManualAckToken
}

// GetSendManualAckTokenOk returns a tuple with the SendManualAckToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidRotateToken) GetSendManualAckTokenOk() (*string, bool) {
	if o == nil || o.SendManualAckToken == nil {
		return nil, false
	}
	return o.SendManualAckToken, true
}

// HasSendManualAckToken returns a boolean if a field has been set.
func (o *UidRotateToken) HasSendManualAckToken() bool {
	if o != nil && o.SendManualAckToken != nil {
		return true
	}

	return false
}

// SetSendManualAckToken gets a reference to the given string and assigns it to the SendManualAckToken field.
func (o *UidRotateToken) SetSendManualAckToken(v string) {
	o.SendManualAckToken = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *UidRotateToken) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidRotateToken) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *UidRotateToken) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *UidRotateToken) SetUidToken(v string) {
	o.UidToken = &v
}

// GetWithManualAck returns the WithManualAck field value if set, zero value otherwise.
func (o *UidRotateToken) GetWithManualAck() bool {
	if o == nil || o.WithManualAck == nil {
		var ret bool
		return ret
	}
	return *o.WithManualAck
}

// GetWithManualAckOk returns a tuple with the WithManualAck field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *UidRotateToken) GetWithManualAckOk() (*bool, bool) {
	if o == nil || o.WithManualAck == nil {
		return nil, false
	}
	return o.WithManualAck, true
}

// HasWithManualAck returns a boolean if a field has been set.
func (o *UidRotateToken) HasWithManualAck() bool {
	if o != nil && o.WithManualAck != nil {
		return true
	}

	return false
}

// SetWithManualAck gets a reference to the given bool and assigns it to the WithManualAck field.
func (o *UidRotateToken) SetWithManualAck(v bool) {
	o.WithManualAck = &v
}

func (o UidRotateToken) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Fork != nil {
		toSerialize["fork"] = o.Fork
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.SendManualAckToken != nil {
		toSerialize["send-manual-ack-token"] = o.SendManualAckToken
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.WithManualAck != nil {
		toSerialize["with-manual-ack"] = o.WithManualAck
	}
	return json.Marshal(toSerialize)
}

type NullableUidRotateToken struct {
	value *UidRotateToken
	isSet bool
}

func (v NullableUidRotateToken) Get() *UidRotateToken {
	return v.value
}

func (v *NullableUidRotateToken) Set(val *UidRotateToken) {
	v.value = val
	v.isSet = true
}

func (v NullableUidRotateToken) IsSet() bool {
	return v.isSet
}

func (v *NullableUidRotateToken) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUidRotateToken(val *UidRotateToken) *NullableUidRotateToken {
	return &NullableUidRotateToken{value: val, isSet: true}
}

func (v NullableUidRotateToken) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUidRotateToken) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


