/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// RotatedSecretUpdateSsh struct for RotatedSecretUpdateSsh
type RotatedSecretUpdateSsh struct {
	// List of the new tags that will be attached to this item
	AddTag *[]string `json:"add-tag,omitempty"`
	// The credentials to connect with use-user-creds/use-target-creds
	AuthenticationCredentials *string `json:"authentication-credentials,omitempty"`
	// Whether to automatically rotate every --rotation-interval days, or disable existing automatic rotation [true/false]
	AutoRotate *string `json:"auto-rotate,omitempty"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Whether to keep previous version [true/false]. If not set, use default according to account settings
	KeepPrevVersion *string `json:"keep-prev-version,omitempty"`
	// The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Rotated secret name
	Name string `json:"name"`
	// New item name
	NewName *string `json:"new-name,omitempty"`
	// The length of the password to be generated
	PasswordLength *string `json:"password-length,omitempty"`
	// List of the existent tags that will be removed from this item
	RmTag *[]string `json:"rm-tag,omitempty"`
	// Rotate the value of the secret after SRA session ends [true/false]
	RotateAfterDisconnect *string `json:"rotate-after-disconnect,omitempty"`
	// rotated-username password (relevant only for rotator-type=password)
	RotatedPassword *string `json:"rotated-password,omitempty"`
	// username to be rotated, if selected use-self-creds at rotator-creds-type, this username will try to rotate it's own password, if use-target-creds is selected, target credentials will be use to rotate the rotated-password (relevant only for rotator-type=password)
	RotatedUsername *string `json:"rotated-username,omitempty"`
	// How many days before the rotation of the item would you like to be notified
	RotationEventIn *[]string `json:"rotation-event-in,omitempty"`
	// The Hour of the rotation in UTC
	RotationHour *int32 `json:"rotation-hour,omitempty"`
	// The number of days to wait between every automatic key rotation (1-365)
	RotationInterval *string `json:"rotation-interval,omitempty"`
	// Custom rotation command
	RotatorCustomCmd *string `json:"rotator-custom-cmd,omitempty"`
	// The rotator type. options: [target/password]
	RotatorType string `json:"rotator-type"`
	// Rotate same password for each host from the Linked Target (relevant only for Linked Target)
	SamePassword *string `json:"same-password,omitempty"`
	// Allow providing external user for a domain users
	SecureAccessAllowExternalUser *bool `json:"secure-access-allow-external-user,omitempty"`
	// Path to the SSH Certificate Issuer for your Akeyless Bastion
	SecureAccessBastionIssuer *string `json:"secure-access-bastion-issuer,omitempty"`
	// Enable/Disable secure remote access [true/false]
	SecureAccessEnable *string `json:"secure-access-enable,omitempty"`
	// Target servers for connections (In case of Linked Target association, host(s) will inherit Linked Target hosts - Relevant only for Dynamic Secrets/producers)
	SecureAccessHost *[]string `json:"secure-access-host,omitempty"`
	// Default domain name server. i.e. microsoft.com
	SecureAccessRdpDomain *string `json:"secure-access-rdp-domain,omitempty"`
	// Override the RDP Domain username
	SecureAccessRdpUser *string `json:"secure-access-rdp-user,omitempty"`
	// Override the SSH username as indicated in SSH Certificate Issuer
	SecureAccessSshUser *string `json:"secure-access-ssh-user,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewRotatedSecretUpdateSsh instantiates a new RotatedSecretUpdateSsh object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewRotatedSecretUpdateSsh(name string, rotatorType string, ) *RotatedSecretUpdateSsh {
	this := RotatedSecretUpdateSsh{}
	var authenticationCredentials string = "use-user-creds"
	this.AuthenticationCredentials = &authenticationCredentials
	var description string = "default_metadata"
	this.Description = &description
	var json bool = false
	this.Json = &json
	this.Name = name
	var rotateAfterDisconnect string = "false"
	this.RotateAfterDisconnect = &rotateAfterDisconnect
	this.RotatorType = rotatorType
	var secureAccessAllowExternalUser bool = false
	this.SecureAccessAllowExternalUser = &secureAccessAllowExternalUser
	return &this
}

// NewRotatedSecretUpdateSshWithDefaults instantiates a new RotatedSecretUpdateSsh object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewRotatedSecretUpdateSshWithDefaults() *RotatedSecretUpdateSsh {
	this := RotatedSecretUpdateSsh{}
	var authenticationCredentials string = "use-user-creds"
	this.AuthenticationCredentials = &authenticationCredentials
	var description string = "default_metadata"
	this.Description = &description
	var json bool = false
	this.Json = &json
	var rotateAfterDisconnect string = "false"
	this.RotateAfterDisconnect = &rotateAfterDisconnect
	var secureAccessAllowExternalUser bool = false
	this.SecureAccessAllowExternalUser = &secureAccessAllowExternalUser
	return &this
}

// GetAddTag returns the AddTag field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetAddTag() []string {
	if o == nil || o.AddTag == nil {
		var ret []string
		return ret
	}
	return *o.AddTag
}

// GetAddTagOk returns a tuple with the AddTag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetAddTagOk() (*[]string, bool) {
	if o == nil || o.AddTag == nil {
		return nil, false
	}
	return o.AddTag, true
}

// HasAddTag returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasAddTag() bool {
	if o != nil && o.AddTag != nil {
		return true
	}

	return false
}

// SetAddTag gets a reference to the given []string and assigns it to the AddTag field.
func (o *RotatedSecretUpdateSsh) SetAddTag(v []string) {
	o.AddTag = &v
}

// GetAuthenticationCredentials returns the AuthenticationCredentials field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetAuthenticationCredentials() string {
	if o == nil || o.AuthenticationCredentials == nil {
		var ret string
		return ret
	}
	return *o.AuthenticationCredentials
}

// GetAuthenticationCredentialsOk returns a tuple with the AuthenticationCredentials field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetAuthenticationCredentialsOk() (*string, bool) {
	if o == nil || o.AuthenticationCredentials == nil {
		return nil, false
	}
	return o.AuthenticationCredentials, true
}

// HasAuthenticationCredentials returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasAuthenticationCredentials() bool {
	if o != nil && o.AuthenticationCredentials != nil {
		return true
	}

	return false
}

// SetAuthenticationCredentials gets a reference to the given string and assigns it to the AuthenticationCredentials field.
func (o *RotatedSecretUpdateSsh) SetAuthenticationCredentials(v string) {
	o.AuthenticationCredentials = &v
}

// GetAutoRotate returns the AutoRotate field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetAutoRotate() string {
	if o == nil || o.AutoRotate == nil {
		var ret string
		return ret
	}
	return *o.AutoRotate
}

// GetAutoRotateOk returns a tuple with the AutoRotate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetAutoRotateOk() (*string, bool) {
	if o == nil || o.AutoRotate == nil {
		return nil, false
	}
	return o.AutoRotate, true
}

// HasAutoRotate returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasAutoRotate() bool {
	if o != nil && o.AutoRotate != nil {
		return true
	}

	return false
}

// SetAutoRotate gets a reference to the given string and assigns it to the AutoRotate field.
func (o *RotatedSecretUpdateSsh) SetAutoRotate(v string) {
	o.AutoRotate = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *RotatedSecretUpdateSsh) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *RotatedSecretUpdateSsh) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *RotatedSecretUpdateSsh) SetJson(v bool) {
	o.Json = &v
}

// GetKeepPrevVersion returns the KeepPrevVersion field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetKeepPrevVersion() string {
	if o == nil || o.KeepPrevVersion == nil {
		var ret string
		return ret
	}
	return *o.KeepPrevVersion
}

// GetKeepPrevVersionOk returns a tuple with the KeepPrevVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetKeepPrevVersionOk() (*string, bool) {
	if o == nil || o.KeepPrevVersion == nil {
		return nil, false
	}
	return o.KeepPrevVersion, true
}

// HasKeepPrevVersion returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasKeepPrevVersion() bool {
	if o != nil && o.KeepPrevVersion != nil {
		return true
	}

	return false
}

// SetKeepPrevVersion gets a reference to the given string and assigns it to the KeepPrevVersion field.
func (o *RotatedSecretUpdateSsh) SetKeepPrevVersion(v string) {
	o.KeepPrevVersion = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *RotatedSecretUpdateSsh) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *RotatedSecretUpdateSsh) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *RotatedSecretUpdateSsh) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *RotatedSecretUpdateSsh) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *RotatedSecretUpdateSsh) SetNewName(v string) {
	o.NewName = &v
}

// GetPasswordLength returns the PasswordLength field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetPasswordLength() string {
	if o == nil || o.PasswordLength == nil {
		var ret string
		return ret
	}
	return *o.PasswordLength
}

// GetPasswordLengthOk returns a tuple with the PasswordLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetPasswordLengthOk() (*string, bool) {
	if o == nil || o.PasswordLength == nil {
		return nil, false
	}
	return o.PasswordLength, true
}

// HasPasswordLength returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasPasswordLength() bool {
	if o != nil && o.PasswordLength != nil {
		return true
	}

	return false
}

// SetPasswordLength gets a reference to the given string and assigns it to the PasswordLength field.
func (o *RotatedSecretUpdateSsh) SetPasswordLength(v string) {
	o.PasswordLength = &v
}

// GetRmTag returns the RmTag field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetRmTag() []string {
	if o == nil || o.RmTag == nil {
		var ret []string
		return ret
	}
	return *o.RmTag
}

// GetRmTagOk returns a tuple with the RmTag field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetRmTagOk() (*[]string, bool) {
	if o == nil || o.RmTag == nil {
		return nil, false
	}
	return o.RmTag, true
}

// HasRmTag returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasRmTag() bool {
	if o != nil && o.RmTag != nil {
		return true
	}

	return false
}

// SetRmTag gets a reference to the given []string and assigns it to the RmTag field.
func (o *RotatedSecretUpdateSsh) SetRmTag(v []string) {
	o.RmTag = &v
}

// GetRotateAfterDisconnect returns the RotateAfterDisconnect field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetRotateAfterDisconnect() string {
	if o == nil || o.RotateAfterDisconnect == nil {
		var ret string
		return ret
	}
	return *o.RotateAfterDisconnect
}

// GetRotateAfterDisconnectOk returns a tuple with the RotateAfterDisconnect field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetRotateAfterDisconnectOk() (*string, bool) {
	if o == nil || o.RotateAfterDisconnect == nil {
		return nil, false
	}
	return o.RotateAfterDisconnect, true
}

// HasRotateAfterDisconnect returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasRotateAfterDisconnect() bool {
	if o != nil && o.RotateAfterDisconnect != nil {
		return true
	}

	return false
}

// SetRotateAfterDisconnect gets a reference to the given string and assigns it to the RotateAfterDisconnect field.
func (o *RotatedSecretUpdateSsh) SetRotateAfterDisconnect(v string) {
	o.RotateAfterDisconnect = &v
}

// GetRotatedPassword returns the RotatedPassword field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetRotatedPassword() string {
	if o == nil || o.RotatedPassword == nil {
		var ret string
		return ret
	}
	return *o.RotatedPassword
}

// GetRotatedPasswordOk returns a tuple with the RotatedPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetRotatedPasswordOk() (*string, bool) {
	if o == nil || o.RotatedPassword == nil {
		return nil, false
	}
	return o.RotatedPassword, true
}

// HasRotatedPassword returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasRotatedPassword() bool {
	if o != nil && o.RotatedPassword != nil {
		return true
	}

	return false
}

// SetRotatedPassword gets a reference to the given string and assigns it to the RotatedPassword field.
func (o *RotatedSecretUpdateSsh) SetRotatedPassword(v string) {
	o.RotatedPassword = &v
}

// GetRotatedUsername returns the RotatedUsername field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetRotatedUsername() string {
	if o == nil || o.RotatedUsername == nil {
		var ret string
		return ret
	}
	return *o.RotatedUsername
}

// GetRotatedUsernameOk returns a tuple with the RotatedUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetRotatedUsernameOk() (*string, bool) {
	if o == nil || o.RotatedUsername == nil {
		return nil, false
	}
	return o.RotatedUsername, true
}

// HasRotatedUsername returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasRotatedUsername() bool {
	if o != nil && o.RotatedUsername != nil {
		return true
	}

	return false
}

// SetRotatedUsername gets a reference to the given string and assigns it to the RotatedUsername field.
func (o *RotatedSecretUpdateSsh) SetRotatedUsername(v string) {
	o.RotatedUsername = &v
}

// GetRotationEventIn returns the RotationEventIn field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetRotationEventIn() []string {
	if o == nil || o.RotationEventIn == nil {
		var ret []string
		return ret
	}
	return *o.RotationEventIn
}

// GetRotationEventInOk returns a tuple with the RotationEventIn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetRotationEventInOk() (*[]string, bool) {
	if o == nil || o.RotationEventIn == nil {
		return nil, false
	}
	return o.RotationEventIn, true
}

// HasRotationEventIn returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasRotationEventIn() bool {
	if o != nil && o.RotationEventIn != nil {
		return true
	}

	return false
}

// SetRotationEventIn gets a reference to the given []string and assigns it to the RotationEventIn field.
func (o *RotatedSecretUpdateSsh) SetRotationEventIn(v []string) {
	o.RotationEventIn = &v
}

// GetRotationHour returns the RotationHour field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetRotationHour() int32 {
	if o == nil || o.RotationHour == nil {
		var ret int32
		return ret
	}
	return *o.RotationHour
}

// GetRotationHourOk returns a tuple with the RotationHour field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetRotationHourOk() (*int32, bool) {
	if o == nil || o.RotationHour == nil {
		return nil, false
	}
	return o.RotationHour, true
}

// HasRotationHour returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasRotationHour() bool {
	if o != nil && o.RotationHour != nil {
		return true
	}

	return false
}

// SetRotationHour gets a reference to the given int32 and assigns it to the RotationHour field.
func (o *RotatedSecretUpdateSsh) SetRotationHour(v int32) {
	o.RotationHour = &v
}

// GetRotationInterval returns the RotationInterval field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetRotationInterval() string {
	if o == nil || o.RotationInterval == nil {
		var ret string
		return ret
	}
	return *o.RotationInterval
}

// GetRotationIntervalOk returns a tuple with the RotationInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetRotationIntervalOk() (*string, bool) {
	if o == nil || o.RotationInterval == nil {
		return nil, false
	}
	return o.RotationInterval, true
}

// HasRotationInterval returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasRotationInterval() bool {
	if o != nil && o.RotationInterval != nil {
		return true
	}

	return false
}

// SetRotationInterval gets a reference to the given string and assigns it to the RotationInterval field.
func (o *RotatedSecretUpdateSsh) SetRotationInterval(v string) {
	o.RotationInterval = &v
}

// GetRotatorCustomCmd returns the RotatorCustomCmd field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetRotatorCustomCmd() string {
	if o == nil || o.RotatorCustomCmd == nil {
		var ret string
		return ret
	}
	return *o.RotatorCustomCmd
}

// GetRotatorCustomCmdOk returns a tuple with the RotatorCustomCmd field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetRotatorCustomCmdOk() (*string, bool) {
	if o == nil || o.RotatorCustomCmd == nil {
		return nil, false
	}
	return o.RotatorCustomCmd, true
}

// HasRotatorCustomCmd returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasRotatorCustomCmd() bool {
	if o != nil && o.RotatorCustomCmd != nil {
		return true
	}

	return false
}

// SetRotatorCustomCmd gets a reference to the given string and assigns it to the RotatorCustomCmd field.
func (o *RotatedSecretUpdateSsh) SetRotatorCustomCmd(v string) {
	o.RotatorCustomCmd = &v
}

// GetRotatorType returns the RotatorType field value
func (o *RotatedSecretUpdateSsh) GetRotatorType() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.RotatorType
}

// GetRotatorTypeOk returns a tuple with the RotatorType field value
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetRotatorTypeOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.RotatorType, true
}

// SetRotatorType sets field value
func (o *RotatedSecretUpdateSsh) SetRotatorType(v string) {
	o.RotatorType = v
}

// GetSamePassword returns the SamePassword field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetSamePassword() string {
	if o == nil || o.SamePassword == nil {
		var ret string
		return ret
	}
	return *o.SamePassword
}

// GetSamePasswordOk returns a tuple with the SamePassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetSamePasswordOk() (*string, bool) {
	if o == nil || o.SamePassword == nil {
		return nil, false
	}
	return o.SamePassword, true
}

// HasSamePassword returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasSamePassword() bool {
	if o != nil && o.SamePassword != nil {
		return true
	}

	return false
}

// SetSamePassword gets a reference to the given string and assigns it to the SamePassword field.
func (o *RotatedSecretUpdateSsh) SetSamePassword(v string) {
	o.SamePassword = &v
}

// GetSecureAccessAllowExternalUser returns the SecureAccessAllowExternalUser field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetSecureAccessAllowExternalUser() bool {
	if o == nil || o.SecureAccessAllowExternalUser == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessAllowExternalUser
}

// GetSecureAccessAllowExternalUserOk returns a tuple with the SecureAccessAllowExternalUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetSecureAccessAllowExternalUserOk() (*bool, bool) {
	if o == nil || o.SecureAccessAllowExternalUser == nil {
		return nil, false
	}
	return o.SecureAccessAllowExternalUser, true
}

// HasSecureAccessAllowExternalUser returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasSecureAccessAllowExternalUser() bool {
	if o != nil && o.SecureAccessAllowExternalUser != nil {
		return true
	}

	return false
}

// SetSecureAccessAllowExternalUser gets a reference to the given bool and assigns it to the SecureAccessAllowExternalUser field.
func (o *RotatedSecretUpdateSsh) SetSecureAccessAllowExternalUser(v bool) {
	o.SecureAccessAllowExternalUser = &v
}

// GetSecureAccessBastionIssuer returns the SecureAccessBastionIssuer field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetSecureAccessBastionIssuer() string {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessBastionIssuer
}

// GetSecureAccessBastionIssuerOk returns a tuple with the SecureAccessBastionIssuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetSecureAccessBastionIssuerOk() (*string, bool) {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		return nil, false
	}
	return o.SecureAccessBastionIssuer, true
}

// HasSecureAccessBastionIssuer returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasSecureAccessBastionIssuer() bool {
	if o != nil && o.SecureAccessBastionIssuer != nil {
		return true
	}

	return false
}

// SetSecureAccessBastionIssuer gets a reference to the given string and assigns it to the SecureAccessBastionIssuer field.
func (o *RotatedSecretUpdateSsh) SetSecureAccessBastionIssuer(v string) {
	o.SecureAccessBastionIssuer = &v
}

// GetSecureAccessEnable returns the SecureAccessEnable field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetSecureAccessEnable() string {
	if o == nil || o.SecureAccessEnable == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessEnable
}

// GetSecureAccessEnableOk returns a tuple with the SecureAccessEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetSecureAccessEnableOk() (*string, bool) {
	if o == nil || o.SecureAccessEnable == nil {
		return nil, false
	}
	return o.SecureAccessEnable, true
}

// HasSecureAccessEnable returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasSecureAccessEnable() bool {
	if o != nil && o.SecureAccessEnable != nil {
		return true
	}

	return false
}

// SetSecureAccessEnable gets a reference to the given string and assigns it to the SecureAccessEnable field.
func (o *RotatedSecretUpdateSsh) SetSecureAccessEnable(v string) {
	o.SecureAccessEnable = &v
}

// GetSecureAccessHost returns the SecureAccessHost field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetSecureAccessHost() []string {
	if o == nil || o.SecureAccessHost == nil {
		var ret []string
		return ret
	}
	return *o.SecureAccessHost
}

// GetSecureAccessHostOk returns a tuple with the SecureAccessHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetSecureAccessHostOk() (*[]string, bool) {
	if o == nil || o.SecureAccessHost == nil {
		return nil, false
	}
	return o.SecureAccessHost, true
}

// HasSecureAccessHost returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasSecureAccessHost() bool {
	if o != nil && o.SecureAccessHost != nil {
		return true
	}

	return false
}

// SetSecureAccessHost gets a reference to the given []string and assigns it to the SecureAccessHost field.
func (o *RotatedSecretUpdateSsh) SetSecureAccessHost(v []string) {
	o.SecureAccessHost = &v
}

// GetSecureAccessRdpDomain returns the SecureAccessRdpDomain field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetSecureAccessRdpDomain() string {
	if o == nil || o.SecureAccessRdpDomain == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessRdpDomain
}

// GetSecureAccessRdpDomainOk returns a tuple with the SecureAccessRdpDomain field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetSecureAccessRdpDomainOk() (*string, bool) {
	if o == nil || o.SecureAccessRdpDomain == nil {
		return nil, false
	}
	return o.SecureAccessRdpDomain, true
}

// HasSecureAccessRdpDomain returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasSecureAccessRdpDomain() bool {
	if o != nil && o.SecureAccessRdpDomain != nil {
		return true
	}

	return false
}

// SetSecureAccessRdpDomain gets a reference to the given string and assigns it to the SecureAccessRdpDomain field.
func (o *RotatedSecretUpdateSsh) SetSecureAccessRdpDomain(v string) {
	o.SecureAccessRdpDomain = &v
}

// GetSecureAccessRdpUser returns the SecureAccessRdpUser field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetSecureAccessRdpUser() string {
	if o == nil || o.SecureAccessRdpUser == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessRdpUser
}

// GetSecureAccessRdpUserOk returns a tuple with the SecureAccessRdpUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetSecureAccessRdpUserOk() (*string, bool) {
	if o == nil || o.SecureAccessRdpUser == nil {
		return nil, false
	}
	return o.SecureAccessRdpUser, true
}

// HasSecureAccessRdpUser returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasSecureAccessRdpUser() bool {
	if o != nil && o.SecureAccessRdpUser != nil {
		return true
	}

	return false
}

// SetSecureAccessRdpUser gets a reference to the given string and assigns it to the SecureAccessRdpUser field.
func (o *RotatedSecretUpdateSsh) SetSecureAccessRdpUser(v string) {
	o.SecureAccessRdpUser = &v
}

// GetSecureAccessSshUser returns the SecureAccessSshUser field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetSecureAccessSshUser() string {
	if o == nil || o.SecureAccessSshUser == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessSshUser
}

// GetSecureAccessSshUserOk returns a tuple with the SecureAccessSshUser field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetSecureAccessSshUserOk() (*string, bool) {
	if o == nil || o.SecureAccessSshUser == nil {
		return nil, false
	}
	return o.SecureAccessSshUser, true
}

// HasSecureAccessSshUser returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasSecureAccessSshUser() bool {
	if o != nil && o.SecureAccessSshUser != nil {
		return true
	}

	return false
}

// SetSecureAccessSshUser gets a reference to the given string and assigns it to the SecureAccessSshUser field.
func (o *RotatedSecretUpdateSsh) SetSecureAccessSshUser(v string) {
	o.SecureAccessSshUser = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *RotatedSecretUpdateSsh) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *RotatedSecretUpdateSsh) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *RotatedSecretUpdateSsh) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *RotatedSecretUpdateSsh) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *RotatedSecretUpdateSsh) SetUidToken(v string) {
	o.UidToken = &v
}

func (o RotatedSecretUpdateSsh) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AddTag != nil {
		toSerialize["add-tag"] = o.AddTag
	}
	if o.AuthenticationCredentials != nil {
		toSerialize["authentication-credentials"] = o.AuthenticationCredentials
	}
	if o.AutoRotate != nil {
		toSerialize["auto-rotate"] = o.AutoRotate
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.KeepPrevVersion != nil {
		toSerialize["keep-prev-version"] = o.KeepPrevVersion
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.PasswordLength != nil {
		toSerialize["password-length"] = o.PasswordLength
	}
	if o.RmTag != nil {
		toSerialize["rm-tag"] = o.RmTag
	}
	if o.RotateAfterDisconnect != nil {
		toSerialize["rotate-after-disconnect"] = o.RotateAfterDisconnect
	}
	if o.RotatedPassword != nil {
		toSerialize["rotated-password"] = o.RotatedPassword
	}
	if o.RotatedUsername != nil {
		toSerialize["rotated-username"] = o.RotatedUsername
	}
	if o.RotationEventIn != nil {
		toSerialize["rotation-event-in"] = o.RotationEventIn
	}
	if o.RotationHour != nil {
		toSerialize["rotation-hour"] = o.RotationHour
	}
	if o.RotationInterval != nil {
		toSerialize["rotation-interval"] = o.RotationInterval
	}
	if o.RotatorCustomCmd != nil {
		toSerialize["rotator-custom-cmd"] = o.RotatorCustomCmd
	}
	if true {
		toSerialize["rotator-type"] = o.RotatorType
	}
	if o.SamePassword != nil {
		toSerialize["same-password"] = o.SamePassword
	}
	if o.SecureAccessAllowExternalUser != nil {
		toSerialize["secure-access-allow-external-user"] = o.SecureAccessAllowExternalUser
	}
	if o.SecureAccessBastionIssuer != nil {
		toSerialize["secure-access-bastion-issuer"] = o.SecureAccessBastionIssuer
	}
	if o.SecureAccessEnable != nil {
		toSerialize["secure-access-enable"] = o.SecureAccessEnable
	}
	if o.SecureAccessHost != nil {
		toSerialize["secure-access-host"] = o.SecureAccessHost
	}
	if o.SecureAccessRdpDomain != nil {
		toSerialize["secure-access-rdp-domain"] = o.SecureAccessRdpDomain
	}
	if o.SecureAccessRdpUser != nil {
		toSerialize["secure-access-rdp-user"] = o.SecureAccessRdpUser
	}
	if o.SecureAccessSshUser != nil {
		toSerialize["secure-access-ssh-user"] = o.SecureAccessSshUser
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableRotatedSecretUpdateSsh struct {
	value *RotatedSecretUpdateSsh
	isSet bool
}

func (v NullableRotatedSecretUpdateSsh) Get() *RotatedSecretUpdateSsh {
	return v.value
}

func (v *NullableRotatedSecretUpdateSsh) Set(val *RotatedSecretUpdateSsh) {
	v.value = val
	v.isSet = true
}

func (v NullableRotatedSecretUpdateSsh) IsSet() bool {
	return v.isSet
}

func (v *NullableRotatedSecretUpdateSsh) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableRotatedSecretUpdateSsh(val *RotatedSecretUpdateSsh) *NullableRotatedSecretUpdateSsh {
	return &NullableRotatedSecretUpdateSsh{value: val, isSet: true}
}

func (v NullableRotatedSecretUpdateSsh) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableRotatedSecretUpdateSsh) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


