/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// KubeConfigValue struct for KubeConfigValue
type KubeConfigValue struct {
	ApiVersion *string `json:"apiVersion,omitempty"`
	Clusters *[]KubeconfigNamedCluster `json:"clusters,omitempty"`
	Contexts *[]KubeconfigNamedContext `json:"contexts,omitempty"`
	CurrentContext *string `json:"current-context,omitempty"`
	Kind *string `json:"kind,omitempty"`
	Users *[]KubeconfigUser `json:"users,omitempty"`
}

// NewKubeConfigValue instantiates a new KubeConfigValue object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewKubeConfigValue() *KubeConfigValue {
	this := KubeConfigValue{}
	return &this
}

// NewKubeConfigValueWithDefaults instantiates a new KubeConfigValue object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewKubeConfigValueWithDefaults() *KubeConfigValue {
	this := KubeConfigValue{}
	return &this
}

// GetApiVersion returns the ApiVersion field value if set, zero value otherwise.
func (o *KubeConfigValue) GetApiVersion() string {
	if o == nil || o.ApiVersion == nil {
		var ret string
		return ret
	}
	return *o.ApiVersion
}

// GetApiVersionOk returns a tuple with the ApiVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KubeConfigValue) GetApiVersionOk() (*string, bool) {
	if o == nil || o.ApiVersion == nil {
		return nil, false
	}
	return o.ApiVersion, true
}

// HasApiVersion returns a boolean if a field has been set.
func (o *KubeConfigValue) HasApiVersion() bool {
	if o != nil && o.ApiVersion != nil {
		return true
	}

	return false
}

// SetApiVersion gets a reference to the given string and assigns it to the ApiVersion field.
func (o *KubeConfigValue) SetApiVersion(v string) {
	o.ApiVersion = &v
}

// GetClusters returns the Clusters field value if set, zero value otherwise.
func (o *KubeConfigValue) GetClusters() []KubeconfigNamedCluster {
	if o == nil || o.Clusters == nil {
		var ret []KubeconfigNamedCluster
		return ret
	}
	return *o.Clusters
}

// GetClustersOk returns a tuple with the Clusters field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KubeConfigValue) GetClustersOk() (*[]KubeconfigNamedCluster, bool) {
	if o == nil || o.Clusters == nil {
		return nil, false
	}
	return o.Clusters, true
}

// HasClusters returns a boolean if a field has been set.
func (o *KubeConfigValue) HasClusters() bool {
	if o != nil && o.Clusters != nil {
		return true
	}

	return false
}

// SetClusters gets a reference to the given []KubeconfigNamedCluster and assigns it to the Clusters field.
func (o *KubeConfigValue) SetClusters(v []KubeconfigNamedCluster) {
	o.Clusters = &v
}

// GetContexts returns the Contexts field value if set, zero value otherwise.
func (o *KubeConfigValue) GetContexts() []KubeconfigNamedContext {
	if o == nil || o.Contexts == nil {
		var ret []KubeconfigNamedContext
		return ret
	}
	return *o.Contexts
}

// GetContextsOk returns a tuple with the Contexts field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KubeConfigValue) GetContextsOk() (*[]KubeconfigNamedContext, bool) {
	if o == nil || o.Contexts == nil {
		return nil, false
	}
	return o.Contexts, true
}

// HasContexts returns a boolean if a field has been set.
func (o *KubeConfigValue) HasContexts() bool {
	if o != nil && o.Contexts != nil {
		return true
	}

	return false
}

// SetContexts gets a reference to the given []KubeconfigNamedContext and assigns it to the Contexts field.
func (o *KubeConfigValue) SetContexts(v []KubeconfigNamedContext) {
	o.Contexts = &v
}

// GetCurrentContext returns the CurrentContext field value if set, zero value otherwise.
func (o *KubeConfigValue) GetCurrentContext() string {
	if o == nil || o.CurrentContext == nil {
		var ret string
		return ret
	}
	return *o.CurrentContext
}

// GetCurrentContextOk returns a tuple with the CurrentContext field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KubeConfigValue) GetCurrentContextOk() (*string, bool) {
	if o == nil || o.CurrentContext == nil {
		return nil, false
	}
	return o.CurrentContext, true
}

// HasCurrentContext returns a boolean if a field has been set.
func (o *KubeConfigValue) HasCurrentContext() bool {
	if o != nil && o.CurrentContext != nil {
		return true
	}

	return false
}

// SetCurrentContext gets a reference to the given string and assigns it to the CurrentContext field.
func (o *KubeConfigValue) SetCurrentContext(v string) {
	o.CurrentContext = &v
}

// GetKind returns the Kind field value if set, zero value otherwise.
func (o *KubeConfigValue) GetKind() string {
	if o == nil || o.Kind == nil {
		var ret string
		return ret
	}
	return *o.Kind
}

// GetKindOk returns a tuple with the Kind field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KubeConfigValue) GetKindOk() (*string, bool) {
	if o == nil || o.Kind == nil {
		return nil, false
	}
	return o.Kind, true
}

// HasKind returns a boolean if a field has been set.
func (o *KubeConfigValue) HasKind() bool {
	if o != nil && o.Kind != nil {
		return true
	}

	return false
}

// SetKind gets a reference to the given string and assigns it to the Kind field.
func (o *KubeConfigValue) SetKind(v string) {
	o.Kind = &v
}

// GetUsers returns the Users field value if set, zero value otherwise.
func (o *KubeConfigValue) GetUsers() []KubeconfigUser {
	if o == nil || o.Users == nil {
		var ret []KubeconfigUser
		return ret
	}
	return *o.Users
}

// GetUsersOk returns a tuple with the Users field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *KubeConfigValue) GetUsersOk() (*[]KubeconfigUser, bool) {
	if o == nil || o.Users == nil {
		return nil, false
	}
	return o.Users, true
}

// HasUsers returns a boolean if a field has been set.
func (o *KubeConfigValue) HasUsers() bool {
	if o != nil && o.Users != nil {
		return true
	}

	return false
}

// SetUsers gets a reference to the given []KubeconfigUser and assigns it to the Users field.
func (o *KubeConfigValue) SetUsers(v []KubeconfigUser) {
	o.Users = &v
}

func (o KubeConfigValue) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.ApiVersion != nil {
		toSerialize["apiVersion"] = o.ApiVersion
	}
	if o.Clusters != nil {
		toSerialize["clusters"] = o.Clusters
	}
	if o.Contexts != nil {
		toSerialize["contexts"] = o.Contexts
	}
	if o.CurrentContext != nil {
		toSerialize["current-context"] = o.CurrentContext
	}
	if o.Kind != nil {
		toSerialize["kind"] = o.Kind
	}
	if o.Users != nil {
		toSerialize["users"] = o.Users
	}
	return json.Marshal(toSerialize)
}

type NullableKubeConfigValue struct {
	value *KubeConfigValue
	isSet bool
}

func (v NullableKubeConfigValue) Get() *KubeConfigValue {
	return v.value
}

func (v *NullableKubeConfigValue) Set(val *KubeConfigValue) {
	v.value = val
	v.isSet = true
}

func (v NullableKubeConfigValue) IsSet() bool {
	return v.isSet
}

func (v *NullableKubeConfigValue) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableKubeConfigValue(val *KubeConfigValue) *NullableKubeConfigValue {
	return &NullableKubeConfigValue{value: val, isSet: true}
}

func (v NullableKubeConfigValue) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableKubeConfigValue) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


