/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CreatePasskey CreatePasskey is a command that creates a new passkey
type CreatePasskey struct {
	// for personal password manager
	Accessibility *string `json:"accessibility,omitempty"`
	// Passkey type; options: [EC256, EC384, EC512]
	Alg string `json:"alg"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// ClassicKey name
	Name string `json:"name"`
	// Originating websites for this passkey
	OriginUrl *[]string `json:"origin-url,omitempty"`
	// The name of a key that used to encrypt the secret value (if empty, the account default protectionKey key will be used)
	ProtectionKeyName *string `json:"protection-key-name,omitempty"`
	// Add tags attached to this object
	Tags *[]string `json:"tags,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// For Password Management use
	Username *string `json:"username,omitempty"`
}

// NewCreatePasskey instantiates a new CreatePasskey object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreatePasskey(alg string, name string, ) *CreatePasskey {
	this := CreatePasskey{}
	var accessibility string = "regular"
	this.Accessibility = &accessibility
	this.Alg = alg
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewCreatePasskeyWithDefaults instantiates a new CreatePasskey object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreatePasskeyWithDefaults() *CreatePasskey {
	this := CreatePasskey{}
	var accessibility string = "regular"
	this.Accessibility = &accessibility
	var alg string = "EC256"
	this.Alg = alg
	var json bool = false
	this.Json = &json
	return &this
}

// GetAccessibility returns the Accessibility field value if set, zero value otherwise.
func (o *CreatePasskey) GetAccessibility() string {
	if o == nil || o.Accessibility == nil {
		var ret string
		return ret
	}
	return *o.Accessibility
}

// GetAccessibilityOk returns a tuple with the Accessibility field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreatePasskey) GetAccessibilityOk() (*string, bool) {
	if o == nil || o.Accessibility == nil {
		return nil, false
	}
	return o.Accessibility, true
}

// HasAccessibility returns a boolean if a field has been set.
func (o *CreatePasskey) HasAccessibility() bool {
	if o != nil && o.Accessibility != nil {
		return true
	}

	return false
}

// SetAccessibility gets a reference to the given string and assigns it to the Accessibility field.
func (o *CreatePasskey) SetAccessibility(v string) {
	o.Accessibility = &v
}

// GetAlg returns the Alg field value
func (o *CreatePasskey) GetAlg() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Alg
}

// GetAlgOk returns a tuple with the Alg field value
// and a boolean to check if the value has been set.
func (o *CreatePasskey) GetAlgOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Alg, true
}

// SetAlg sets field value
func (o *CreatePasskey) SetAlg(v string) {
	o.Alg = v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *CreatePasskey) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreatePasskey) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *CreatePasskey) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *CreatePasskey) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *CreatePasskey) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreatePasskey) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *CreatePasskey) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *CreatePasskey) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *CreatePasskey) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreatePasskey) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *CreatePasskey) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *CreatePasskey) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *CreatePasskey) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *CreatePasskey) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *CreatePasskey) SetName(v string) {
	o.Name = v
}

// GetOriginUrl returns the OriginUrl field value if set, zero value otherwise.
func (o *CreatePasskey) GetOriginUrl() []string {
	if o == nil || o.OriginUrl == nil {
		var ret []string
		return ret
	}
	return *o.OriginUrl
}

// GetOriginUrlOk returns a tuple with the OriginUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreatePasskey) GetOriginUrlOk() (*[]string, bool) {
	if o == nil || o.OriginUrl == nil {
		return nil, false
	}
	return o.OriginUrl, true
}

// HasOriginUrl returns a boolean if a field has been set.
func (o *CreatePasskey) HasOriginUrl() bool {
	if o != nil && o.OriginUrl != nil {
		return true
	}

	return false
}

// SetOriginUrl gets a reference to the given []string and assigns it to the OriginUrl field.
func (o *CreatePasskey) SetOriginUrl(v []string) {
	o.OriginUrl = &v
}

// GetProtectionKeyName returns the ProtectionKeyName field value if set, zero value otherwise.
func (o *CreatePasskey) GetProtectionKeyName() string {
	if o == nil || o.ProtectionKeyName == nil {
		var ret string
		return ret
	}
	return *o.ProtectionKeyName
}

// GetProtectionKeyNameOk returns a tuple with the ProtectionKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreatePasskey) GetProtectionKeyNameOk() (*string, bool) {
	if o == nil || o.ProtectionKeyName == nil {
		return nil, false
	}
	return o.ProtectionKeyName, true
}

// HasProtectionKeyName returns a boolean if a field has been set.
func (o *CreatePasskey) HasProtectionKeyName() bool {
	if o != nil && o.ProtectionKeyName != nil {
		return true
	}

	return false
}

// SetProtectionKeyName gets a reference to the given string and assigns it to the ProtectionKeyName field.
func (o *CreatePasskey) SetProtectionKeyName(v string) {
	o.ProtectionKeyName = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *CreatePasskey) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreatePasskey) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *CreatePasskey) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *CreatePasskey) SetTags(v []string) {
	o.Tags = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *CreatePasskey) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreatePasskey) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *CreatePasskey) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *CreatePasskey) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *CreatePasskey) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreatePasskey) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *CreatePasskey) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *CreatePasskey) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUsername returns the Username field value if set, zero value otherwise.
func (o *CreatePasskey) GetUsername() string {
	if o == nil || o.Username == nil {
		var ret string
		return ret
	}
	return *o.Username
}

// GetUsernameOk returns a tuple with the Username field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreatePasskey) GetUsernameOk() (*string, bool) {
	if o == nil || o.Username == nil {
		return nil, false
	}
	return o.Username, true
}

// HasUsername returns a boolean if a field has been set.
func (o *CreatePasskey) HasUsername() bool {
	if o != nil && o.Username != nil {
		return true
	}

	return false
}

// SetUsername gets a reference to the given string and assigns it to the Username field.
func (o *CreatePasskey) SetUsername(v string) {
	o.Username = &v
}

func (o CreatePasskey) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Accessibility != nil {
		toSerialize["accessibility"] = o.Accessibility
	}
	if true {
		toSerialize["alg"] = o.Alg
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.OriginUrl != nil {
		toSerialize["origin-url"] = o.OriginUrl
	}
	if o.ProtectionKeyName != nil {
		toSerialize["protection-key-name"] = o.ProtectionKeyName
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.Username != nil {
		toSerialize["username"] = o.Username
	}
	return json.Marshal(toSerialize)
}

type NullableCreatePasskey struct {
	value *CreatePasskey
	isSet bool
}

func (v NullableCreatePasskey) Get() *CreatePasskey {
	return v.value
}

func (v *NullableCreatePasskey) Set(val *CreatePasskey) {
	v.value = val
	v.isSet = true
}

func (v NullableCreatePasskey) IsSet() bool {
	return v.isSet
}

func (v *NullableCreatePasskey) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreatePasskey(val *CreatePasskey) *NullableCreatePasskey {
	return &NullableCreatePasskey{value: val, isSet: true}
}

func (v NullableCreatePasskey) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreatePasskey) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


