/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// TargetUpdateArtifactory struct for TargetUpdateArtifactory
type TargetUpdateArtifactory struct {
	// Artifactory Admin Name
	ArtifactoryAdminName string `json:"artifactory-admin-name"`
	// Artifactory Admin password
	ArtifactoryAdminPwd string `json:"artifactory-admin-pwd"`
	// Base URL
	BaseUrl string `json:"base-url"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Whether to keep previous version [true/false]. If not set, use default according to account settings
	KeepPrevVersion *string `json:"keep-prev-version,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// New target name
	NewName *string `json:"new-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewTargetUpdateArtifactory instantiates a new TargetUpdateArtifactory object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetUpdateArtifactory(artifactoryAdminName string, artifactoryAdminPwd string, baseUrl string, name string, ) *TargetUpdateArtifactory {
	this := TargetUpdateArtifactory{}
	this.ArtifactoryAdminName = artifactoryAdminName
	this.ArtifactoryAdminPwd = artifactoryAdminPwd
	this.BaseUrl = baseUrl
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewTargetUpdateArtifactoryWithDefaults instantiates a new TargetUpdateArtifactory object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetUpdateArtifactoryWithDefaults() *TargetUpdateArtifactory {
	this := TargetUpdateArtifactory{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetArtifactoryAdminName returns the ArtifactoryAdminName field value
func (o *TargetUpdateArtifactory) GetArtifactoryAdminName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ArtifactoryAdminName
}

// GetArtifactoryAdminNameOk returns a tuple with the ArtifactoryAdminName field value
// and a boolean to check if the value has been set.
func (o *TargetUpdateArtifactory) GetArtifactoryAdminNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ArtifactoryAdminName, true
}

// SetArtifactoryAdminName sets field value
func (o *TargetUpdateArtifactory) SetArtifactoryAdminName(v string) {
	o.ArtifactoryAdminName = v
}

// GetArtifactoryAdminPwd returns the ArtifactoryAdminPwd field value
func (o *TargetUpdateArtifactory) GetArtifactoryAdminPwd() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ArtifactoryAdminPwd
}

// GetArtifactoryAdminPwdOk returns a tuple with the ArtifactoryAdminPwd field value
// and a boolean to check if the value has been set.
func (o *TargetUpdateArtifactory) GetArtifactoryAdminPwdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ArtifactoryAdminPwd, true
}

// SetArtifactoryAdminPwd sets field value
func (o *TargetUpdateArtifactory) SetArtifactoryAdminPwd(v string) {
	o.ArtifactoryAdminPwd = v
}

// GetBaseUrl returns the BaseUrl field value
func (o *TargetUpdateArtifactory) GetBaseUrl() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.BaseUrl
}

// GetBaseUrlOk returns a tuple with the BaseUrl field value
// and a boolean to check if the value has been set.
func (o *TargetUpdateArtifactory) GetBaseUrlOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.BaseUrl, true
}

// SetBaseUrl sets field value
func (o *TargetUpdateArtifactory) SetBaseUrl(v string) {
	o.BaseUrl = v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *TargetUpdateArtifactory) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateArtifactory) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *TargetUpdateArtifactory) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *TargetUpdateArtifactory) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *TargetUpdateArtifactory) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateArtifactory) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *TargetUpdateArtifactory) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *TargetUpdateArtifactory) SetJson(v bool) {
	o.Json = &v
}

// GetKeepPrevVersion returns the KeepPrevVersion field value if set, zero value otherwise.
func (o *TargetUpdateArtifactory) GetKeepPrevVersion() string {
	if o == nil || o.KeepPrevVersion == nil {
		var ret string
		return ret
	}
	return *o.KeepPrevVersion
}

// GetKeepPrevVersionOk returns a tuple with the KeepPrevVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateArtifactory) GetKeepPrevVersionOk() (*string, bool) {
	if o == nil || o.KeepPrevVersion == nil {
		return nil, false
	}
	return o.KeepPrevVersion, true
}

// HasKeepPrevVersion returns a boolean if a field has been set.
func (o *TargetUpdateArtifactory) HasKeepPrevVersion() bool {
	if o != nil && o.KeepPrevVersion != nil {
		return true
	}

	return false
}

// SetKeepPrevVersion gets a reference to the given string and assigns it to the KeepPrevVersion field.
func (o *TargetUpdateArtifactory) SetKeepPrevVersion(v string) {
	o.KeepPrevVersion = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *TargetUpdateArtifactory) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateArtifactory) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *TargetUpdateArtifactory) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *TargetUpdateArtifactory) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *TargetUpdateArtifactory) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateArtifactory) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *TargetUpdateArtifactory) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *TargetUpdateArtifactory) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *TargetUpdateArtifactory) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *TargetUpdateArtifactory) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *TargetUpdateArtifactory) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *TargetUpdateArtifactory) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateArtifactory) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *TargetUpdateArtifactory) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *TargetUpdateArtifactory) SetNewName(v string) {
	o.NewName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *TargetUpdateArtifactory) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateArtifactory) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *TargetUpdateArtifactory) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *TargetUpdateArtifactory) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *TargetUpdateArtifactory) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetUpdateArtifactory) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *TargetUpdateArtifactory) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *TargetUpdateArtifactory) SetUidToken(v string) {
	o.UidToken = &v
}

func (o TargetUpdateArtifactory) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["artifactory-admin-name"] = o.ArtifactoryAdminName
	}
	if true {
		toSerialize["artifactory-admin-pwd"] = o.ArtifactoryAdminPwd
	}
	if true {
		toSerialize["base-url"] = o.BaseUrl
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.KeepPrevVersion != nil {
		toSerialize["keep-prev-version"] = o.KeepPrevVersion
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableTargetUpdateArtifactory struct {
	value *TargetUpdateArtifactory
	isSet bool
}

func (v NullableTargetUpdateArtifactory) Get() *TargetUpdateArtifactory {
	return v.value
}

func (v *NullableTargetUpdateArtifactory) Set(val *TargetUpdateArtifactory) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetUpdateArtifactory) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetUpdateArtifactory) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetUpdateArtifactory(val *TargetUpdateArtifactory) *NullableTargetUpdateArtifactory {
	return &NullableTargetUpdateArtifactory{value: val, isSet: true}
}

func (v NullableTargetUpdateArtifactory) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetUpdateArtifactory) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


