/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// TargetCreateGlobalSign struct for TargetCreateGlobalSign
type TargetCreateGlobalSign struct {
	// Email of the GlobalSign GCC account contact
	ContactEmail string `json:"contact-email"`
	// First name of the GlobalSign GCC account contact
	ContactFirstName string `json:"contact-first-name"`
	// Last name of the GlobalSign GCC account contact
	ContactLastName string `json:"contact-last-name"`
	// Telephone of the GlobalSign GCC account contact
	ContactPhone string `json:"contact-phone"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of a key that used to encrypt the target secret value (if empty, the account default protectionKey key will be used)
	Key *string `json:"key,omitempty"`
	// Set the maximum number of versions, limited by the account settings defaults.
	MaxVersions *string `json:"max-versions,omitempty"`
	// Target name
	Name string `json:"name"`
	// Password of the GlobalSign GCC account
	Password string `json:"password"`
	// Profile ID of the GlobalSign GCC account
	ProfileId string `json:"profile-id"`
	// Timeout waiting for certificate validation in Duration format (1h - 1 Hour, 20m - 20 Minutes, 33m3s - 33 Minutes and 3 Seconds), maximum 1h.
	Timeout *string `json:"timeout,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// Username of the GlobalSign GCC account
	Username string `json:"username"`
}

// NewTargetCreateGlobalSign instantiates a new TargetCreateGlobalSign object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTargetCreateGlobalSign(contactEmail string, contactFirstName string, contactLastName string, contactPhone string, name string, password string, profileId string, username string, ) *TargetCreateGlobalSign {
	this := TargetCreateGlobalSign{}
	this.ContactEmail = contactEmail
	this.ContactFirstName = contactFirstName
	this.ContactLastName = contactLastName
	this.ContactPhone = contactPhone
	var json bool = false
	this.Json = &json
	this.Name = name
	this.Password = password
	this.ProfileId = profileId
	var timeout string = "5m"
	this.Timeout = &timeout
	this.Username = username
	return &this
}

// NewTargetCreateGlobalSignWithDefaults instantiates a new TargetCreateGlobalSign object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTargetCreateGlobalSignWithDefaults() *TargetCreateGlobalSign {
	this := TargetCreateGlobalSign{}
	var json bool = false
	this.Json = &json
	var timeout string = "5m"
	this.Timeout = &timeout
	return &this
}

// GetContactEmail returns the ContactEmail field value
func (o *TargetCreateGlobalSign) GetContactEmail() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ContactEmail
}

// GetContactEmailOk returns a tuple with the ContactEmail field value
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetContactEmailOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ContactEmail, true
}

// SetContactEmail sets field value
func (o *TargetCreateGlobalSign) SetContactEmail(v string) {
	o.ContactEmail = v
}

// GetContactFirstName returns the ContactFirstName field value
func (o *TargetCreateGlobalSign) GetContactFirstName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ContactFirstName
}

// GetContactFirstNameOk returns a tuple with the ContactFirstName field value
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetContactFirstNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ContactFirstName, true
}

// SetContactFirstName sets field value
func (o *TargetCreateGlobalSign) SetContactFirstName(v string) {
	o.ContactFirstName = v
}

// GetContactLastName returns the ContactLastName field value
func (o *TargetCreateGlobalSign) GetContactLastName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ContactLastName
}

// GetContactLastNameOk returns a tuple with the ContactLastName field value
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetContactLastNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ContactLastName, true
}

// SetContactLastName sets field value
func (o *TargetCreateGlobalSign) SetContactLastName(v string) {
	o.ContactLastName = v
}

// GetContactPhone returns the ContactPhone field value
func (o *TargetCreateGlobalSign) GetContactPhone() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ContactPhone
}

// GetContactPhoneOk returns a tuple with the ContactPhone field value
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetContactPhoneOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ContactPhone, true
}

// SetContactPhone sets field value
func (o *TargetCreateGlobalSign) SetContactPhone(v string) {
	o.ContactPhone = v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *TargetCreateGlobalSign) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *TargetCreateGlobalSign) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *TargetCreateGlobalSign) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *TargetCreateGlobalSign) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *TargetCreateGlobalSign) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *TargetCreateGlobalSign) SetJson(v bool) {
	o.Json = &v
}

// GetKey returns the Key field value if set, zero value otherwise.
func (o *TargetCreateGlobalSign) GetKey() string {
	if o == nil || o.Key == nil {
		var ret string
		return ret
	}
	return *o.Key
}

// GetKeyOk returns a tuple with the Key field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetKeyOk() (*string, bool) {
	if o == nil || o.Key == nil {
		return nil, false
	}
	return o.Key, true
}

// HasKey returns a boolean if a field has been set.
func (o *TargetCreateGlobalSign) HasKey() bool {
	if o != nil && o.Key != nil {
		return true
	}

	return false
}

// SetKey gets a reference to the given string and assigns it to the Key field.
func (o *TargetCreateGlobalSign) SetKey(v string) {
	o.Key = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *TargetCreateGlobalSign) GetMaxVersions() string {
	if o == nil || o.MaxVersions == nil {
		var ret string
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetMaxVersionsOk() (*string, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *TargetCreateGlobalSign) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given string and assigns it to the MaxVersions field.
func (o *TargetCreateGlobalSign) SetMaxVersions(v string) {
	o.MaxVersions = &v
}

// GetName returns the Name field value
func (o *TargetCreateGlobalSign) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *TargetCreateGlobalSign) SetName(v string) {
	o.Name = v
}

// GetPassword returns the Password field value
func (o *TargetCreateGlobalSign) GetPassword() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Password
}

// GetPasswordOk returns a tuple with the Password field value
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetPasswordOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Password, true
}

// SetPassword sets field value
func (o *TargetCreateGlobalSign) SetPassword(v string) {
	o.Password = v
}

// GetProfileId returns the ProfileId field value
func (o *TargetCreateGlobalSign) GetProfileId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ProfileId
}

// GetProfileIdOk returns a tuple with the ProfileId field value
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetProfileIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ProfileId, true
}

// SetProfileId sets field value
func (o *TargetCreateGlobalSign) SetProfileId(v string) {
	o.ProfileId = v
}

// GetTimeout returns the Timeout field value if set, zero value otherwise.
func (o *TargetCreateGlobalSign) GetTimeout() string {
	if o == nil || o.Timeout == nil {
		var ret string
		return ret
	}
	return *o.Timeout
}

// GetTimeoutOk returns a tuple with the Timeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetTimeoutOk() (*string, bool) {
	if o == nil || o.Timeout == nil {
		return nil, false
	}
	return o.Timeout, true
}

// HasTimeout returns a boolean if a field has been set.
func (o *TargetCreateGlobalSign) HasTimeout() bool {
	if o != nil && o.Timeout != nil {
		return true
	}

	return false
}

// SetTimeout gets a reference to the given string and assigns it to the Timeout field.
func (o *TargetCreateGlobalSign) SetTimeout(v string) {
	o.Timeout = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *TargetCreateGlobalSign) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *TargetCreateGlobalSign) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *TargetCreateGlobalSign) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *TargetCreateGlobalSign) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *TargetCreateGlobalSign) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *TargetCreateGlobalSign) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUsername returns the Username field value
func (o *TargetCreateGlobalSign) GetUsername() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Username
}

// GetUsernameOk returns a tuple with the Username field value
// and a boolean to check if the value has been set.
func (o *TargetCreateGlobalSign) GetUsernameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Username, true
}

// SetUsername sets field value
func (o *TargetCreateGlobalSign) SetUsername(v string) {
	o.Username = v
}

func (o TargetCreateGlobalSign) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["contact-email"] = o.ContactEmail
	}
	if true {
		toSerialize["contact-first-name"] = o.ContactFirstName
	}
	if true {
		toSerialize["contact-last-name"] = o.ContactLastName
	}
	if true {
		toSerialize["contact-phone"] = o.ContactPhone
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.Key != nil {
		toSerialize["key"] = o.Key
	}
	if o.MaxVersions != nil {
		toSerialize["max-versions"] = o.MaxVersions
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if true {
		toSerialize["password"] = o.Password
	}
	if true {
		toSerialize["profile-id"] = o.ProfileId
	}
	if o.Timeout != nil {
		toSerialize["timeout"] = o.Timeout
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if true {
		toSerialize["username"] = o.Username
	}
	return json.Marshal(toSerialize)
}

type NullableTargetCreateGlobalSign struct {
	value *TargetCreateGlobalSign
	isSet bool
}

func (v NullableTargetCreateGlobalSign) Get() *TargetCreateGlobalSign {
	return v.value
}

func (v *NullableTargetCreateGlobalSign) Set(val *TargetCreateGlobalSign) {
	v.value = val
	v.isSet = true
}

func (v NullableTargetCreateGlobalSign) IsSet() bool {
	return v.isSet
}

func (v *NullableTargetCreateGlobalSign) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTargetCreateGlobalSign(val *TargetCreateGlobalSign) *NullableTargetCreateGlobalSign {
	return &NullableTargetCreateGlobalSign{value: val, isSet: true}
}

func (v NullableTargetCreateGlobalSign) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTargetCreateGlobalSign) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


