/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// StaticSecretDetailsInfo struct for StaticSecretDetailsInfo
type StaticSecretDetailsInfo struct {
	// StaticSecretFormat defines the format of static secret (e.g. Text)
	Format *string `json:"format,omitempty"`
	MaxVersions *int64 `json:"max_versions,omitempty"`
	NotifyOnChangeEvent *bool `json:"notify_on_change_event,omitempty"`
	Username *string `json:"username,omitempty"`
	// deprecated
	Website *string `json:"website,omitempty"`
	Websites *[]string `json:"websites,omitempty"`
}

// NewStaticSecretDetailsInfo instantiates a new StaticSecretDetailsInfo object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewStaticSecretDetailsInfo() *StaticSecretDetailsInfo {
	this := StaticSecretDetailsInfo{}
	return &this
}

// NewStaticSecretDetailsInfoWithDefaults instantiates a new StaticSecretDetailsInfo object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewStaticSecretDetailsInfoWithDefaults() *StaticSecretDetailsInfo {
	this := StaticSecretDetailsInfo{}
	return &this
}

// GetFormat returns the Format field value if set, zero value otherwise.
func (o *StaticSecretDetailsInfo) GetFormat() string {
	if o == nil || o.Format == nil {
		var ret string
		return ret
	}
	return *o.Format
}

// GetFormatOk returns a tuple with the Format field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *StaticSecretDetailsInfo) GetFormatOk() (*string, bool) {
	if o == nil || o.Format == nil {
		return nil, false
	}
	return o.Format, true
}

// HasFormat returns a boolean if a field has been set.
func (o *StaticSecretDetailsInfo) HasFormat() bool {
	if o != nil && o.Format != nil {
		return true
	}

	return false
}

// SetFormat gets a reference to the given string and assigns it to the Format field.
func (o *StaticSecretDetailsInfo) SetFormat(v string) {
	o.Format = &v
}

// GetMaxVersions returns the MaxVersions field value if set, zero value otherwise.
func (o *StaticSecretDetailsInfo) GetMaxVersions() int64 {
	if o == nil || o.MaxVersions == nil {
		var ret int64
		return ret
	}
	return *o.MaxVersions
}

// GetMaxVersionsOk returns a tuple with the MaxVersions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *StaticSecretDetailsInfo) GetMaxVersionsOk() (*int64, bool) {
	if o == nil || o.MaxVersions == nil {
		return nil, false
	}
	return o.MaxVersions, true
}

// HasMaxVersions returns a boolean if a field has been set.
func (o *StaticSecretDetailsInfo) HasMaxVersions() bool {
	if o != nil && o.MaxVersions != nil {
		return true
	}

	return false
}

// SetMaxVersions gets a reference to the given int64 and assigns it to the MaxVersions field.
func (o *StaticSecretDetailsInfo) SetMaxVersions(v int64) {
	o.MaxVersions = &v
}

// GetNotifyOnChangeEvent returns the NotifyOnChangeEvent field value if set, zero value otherwise.
func (o *StaticSecretDetailsInfo) GetNotifyOnChangeEvent() bool {
	if o == nil || o.NotifyOnChangeEvent == nil {
		var ret bool
		return ret
	}
	return *o.NotifyOnChangeEvent
}

// GetNotifyOnChangeEventOk returns a tuple with the NotifyOnChangeEvent field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *StaticSecretDetailsInfo) GetNotifyOnChangeEventOk() (*bool, bool) {
	if o == nil || o.NotifyOnChangeEvent == nil {
		return nil, false
	}
	return o.NotifyOnChangeEvent, true
}

// HasNotifyOnChangeEvent returns a boolean if a field has been set.
func (o *StaticSecretDetailsInfo) HasNotifyOnChangeEvent() bool {
	if o != nil && o.NotifyOnChangeEvent != nil {
		return true
	}

	return false
}

// SetNotifyOnChangeEvent gets a reference to the given bool and assigns it to the NotifyOnChangeEvent field.
func (o *StaticSecretDetailsInfo) SetNotifyOnChangeEvent(v bool) {
	o.NotifyOnChangeEvent = &v
}

// GetUsername returns the Username field value if set, zero value otherwise.
func (o *StaticSecretDetailsInfo) GetUsername() string {
	if o == nil || o.Username == nil {
		var ret string
		return ret
	}
	return *o.Username
}

// GetUsernameOk returns a tuple with the Username field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *StaticSecretDetailsInfo) GetUsernameOk() (*string, bool) {
	if o == nil || o.Username == nil {
		return nil, false
	}
	return o.Username, true
}

// HasUsername returns a boolean if a field has been set.
func (o *StaticSecretDetailsInfo) HasUsername() bool {
	if o != nil && o.Username != nil {
		return true
	}

	return false
}

// SetUsername gets a reference to the given string and assigns it to the Username field.
func (o *StaticSecretDetailsInfo) SetUsername(v string) {
	o.Username = &v
}

// GetWebsite returns the Website field value if set, zero value otherwise.
func (o *StaticSecretDetailsInfo) GetWebsite() string {
	if o == nil || o.Website == nil {
		var ret string
		return ret
	}
	return *o.Website
}

// GetWebsiteOk returns a tuple with the Website field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *StaticSecretDetailsInfo) GetWebsiteOk() (*string, bool) {
	if o == nil || o.Website == nil {
		return nil, false
	}
	return o.Website, true
}

// HasWebsite returns a boolean if a field has been set.
func (o *StaticSecretDetailsInfo) HasWebsite() bool {
	if o != nil && o.Website != nil {
		return true
	}

	return false
}

// SetWebsite gets a reference to the given string and assigns it to the Website field.
func (o *StaticSecretDetailsInfo) SetWebsite(v string) {
	o.Website = &v
}

// GetWebsites returns the Websites field value if set, zero value otherwise.
func (o *StaticSecretDetailsInfo) GetWebsites() []string {
	if o == nil || o.Websites == nil {
		var ret []string
		return ret
	}
	return *o.Websites
}

// GetWebsitesOk returns a tuple with the Websites field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *StaticSecretDetailsInfo) GetWebsitesOk() (*[]string, bool) {
	if o == nil || o.Websites == nil {
		return nil, false
	}
	return o.Websites, true
}

// HasWebsites returns a boolean if a field has been set.
func (o *StaticSecretDetailsInfo) HasWebsites() bool {
	if o != nil && o.Websites != nil {
		return true
	}

	return false
}

// SetWebsites gets a reference to the given []string and assigns it to the Websites field.
func (o *StaticSecretDetailsInfo) SetWebsites(v []string) {
	o.Websites = &v
}

func (o StaticSecretDetailsInfo) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Format != nil {
		toSerialize["format"] = o.Format
	}
	if o.MaxVersions != nil {
		toSerialize["max_versions"] = o.MaxVersions
	}
	if o.NotifyOnChangeEvent != nil {
		toSerialize["notify_on_change_event"] = o.NotifyOnChangeEvent
	}
	if o.Username != nil {
		toSerialize["username"] = o.Username
	}
	if o.Website != nil {
		toSerialize["website"] = o.Website
	}
	if o.Websites != nil {
		toSerialize["websites"] = o.Websites
	}
	return json.Marshal(toSerialize)
}

type NullableStaticSecretDetailsInfo struct {
	value *StaticSecretDetailsInfo
	isSet bool
}

func (v NullableStaticSecretDetailsInfo) Get() *StaticSecretDetailsInfo {
	return v.value
}

func (v *NullableStaticSecretDetailsInfo) Set(val *StaticSecretDetailsInfo) {
	v.value = val
	v.isSet = true
}

func (v NullableStaticSecretDetailsInfo) IsSet() bool {
	return v.isSet
}

func (v *NullableStaticSecretDetailsInfo) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableStaticSecretDetailsInfo(val *StaticSecretDetailsInfo) *NullableStaticSecretDetailsInfo {
	return &NullableStaticSecretDetailsInfo{value: val, isSet: true}
}

func (v NullableStaticSecretDetailsInfo) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableStaticSecretDetailsInfo) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


