/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// Hmac struct for Hmac
type Hmac struct {
	// The display id of the key to use in the encryption process
	DisplayId *string `json:"display-id,omitempty"`
	// Hash function [sha-256,sha-512]
	HashFunction *string `json:"hash-function,omitempty"`
	// Select default assumed format for any plaintext input. Currently supported options: [base64]
	InputFormat *string `json:"input-format,omitempty"`
	// The item id of the key to use in the encryption process
	ItemId *int64 `json:"item-id,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of the key to use in the encryption process
	KeyName string `json:"key-name"`
	// Data to perform hmac on
	Plaintext *string `json:"plaintext,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewHmac instantiates a new Hmac object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewHmac(keyName string, ) *Hmac {
	this := Hmac{}
	var hashFunction string = "sha-256"
	this.HashFunction = &hashFunction
	var json bool = false
	this.Json = &json
	this.KeyName = keyName
	return &this
}

// NewHmacWithDefaults instantiates a new Hmac object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewHmacWithDefaults() *Hmac {
	this := Hmac{}
	var hashFunction string = "sha-256"
	this.HashFunction = &hashFunction
	var json bool = false
	this.Json = &json
	return &this
}

// GetDisplayId returns the DisplayId field value if set, zero value otherwise.
func (o *Hmac) GetDisplayId() string {
	if o == nil || o.DisplayId == nil {
		var ret string
		return ret
	}
	return *o.DisplayId
}

// GetDisplayIdOk returns a tuple with the DisplayId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Hmac) GetDisplayIdOk() (*string, bool) {
	if o == nil || o.DisplayId == nil {
		return nil, false
	}
	return o.DisplayId, true
}

// HasDisplayId returns a boolean if a field has been set.
func (o *Hmac) HasDisplayId() bool {
	if o != nil && o.DisplayId != nil {
		return true
	}

	return false
}

// SetDisplayId gets a reference to the given string and assigns it to the DisplayId field.
func (o *Hmac) SetDisplayId(v string) {
	o.DisplayId = &v
}

// GetHashFunction returns the HashFunction field value if set, zero value otherwise.
func (o *Hmac) GetHashFunction() string {
	if o == nil || o.HashFunction == nil {
		var ret string
		return ret
	}
	return *o.HashFunction
}

// GetHashFunctionOk returns a tuple with the HashFunction field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Hmac) GetHashFunctionOk() (*string, bool) {
	if o == nil || o.HashFunction == nil {
		return nil, false
	}
	return o.HashFunction, true
}

// HasHashFunction returns a boolean if a field has been set.
func (o *Hmac) HasHashFunction() bool {
	if o != nil && o.HashFunction != nil {
		return true
	}

	return false
}

// SetHashFunction gets a reference to the given string and assigns it to the HashFunction field.
func (o *Hmac) SetHashFunction(v string) {
	o.HashFunction = &v
}

// GetInputFormat returns the InputFormat field value if set, zero value otherwise.
func (o *Hmac) GetInputFormat() string {
	if o == nil || o.InputFormat == nil {
		var ret string
		return ret
	}
	return *o.InputFormat
}

// GetInputFormatOk returns a tuple with the InputFormat field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Hmac) GetInputFormatOk() (*string, bool) {
	if o == nil || o.InputFormat == nil {
		return nil, false
	}
	return o.InputFormat, true
}

// HasInputFormat returns a boolean if a field has been set.
func (o *Hmac) HasInputFormat() bool {
	if o != nil && o.InputFormat != nil {
		return true
	}

	return false
}

// SetInputFormat gets a reference to the given string and assigns it to the InputFormat field.
func (o *Hmac) SetInputFormat(v string) {
	o.InputFormat = &v
}

// GetItemId returns the ItemId field value if set, zero value otherwise.
func (o *Hmac) GetItemId() int64 {
	if o == nil || o.ItemId == nil {
		var ret int64
		return ret
	}
	return *o.ItemId
}

// GetItemIdOk returns a tuple with the ItemId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Hmac) GetItemIdOk() (*int64, bool) {
	if o == nil || o.ItemId == nil {
		return nil, false
	}
	return o.ItemId, true
}

// HasItemId returns a boolean if a field has been set.
func (o *Hmac) HasItemId() bool {
	if o != nil && o.ItemId != nil {
		return true
	}

	return false
}

// SetItemId gets a reference to the given int64 and assigns it to the ItemId field.
func (o *Hmac) SetItemId(v int64) {
	o.ItemId = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *Hmac) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Hmac) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *Hmac) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *Hmac) SetJson(v bool) {
	o.Json = &v
}

// GetKeyName returns the KeyName field value
func (o *Hmac) GetKeyName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.KeyName
}

// GetKeyNameOk returns a tuple with the KeyName field value
// and a boolean to check if the value has been set.
func (o *Hmac) GetKeyNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.KeyName, true
}

// SetKeyName sets field value
func (o *Hmac) SetKeyName(v string) {
	o.KeyName = v
}

// GetPlaintext returns the Plaintext field value if set, zero value otherwise.
func (o *Hmac) GetPlaintext() string {
	if o == nil || o.Plaintext == nil {
		var ret string
		return ret
	}
	return *o.Plaintext
}

// GetPlaintextOk returns a tuple with the Plaintext field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Hmac) GetPlaintextOk() (*string, bool) {
	if o == nil || o.Plaintext == nil {
		return nil, false
	}
	return o.Plaintext, true
}

// HasPlaintext returns a boolean if a field has been set.
func (o *Hmac) HasPlaintext() bool {
	if o != nil && o.Plaintext != nil {
		return true
	}

	return false
}

// SetPlaintext gets a reference to the given string and assigns it to the Plaintext field.
func (o *Hmac) SetPlaintext(v string) {
	o.Plaintext = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *Hmac) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Hmac) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *Hmac) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *Hmac) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *Hmac) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *Hmac) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *Hmac) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *Hmac) SetUidToken(v string) {
	o.UidToken = &v
}

func (o Hmac) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DisplayId != nil {
		toSerialize["display-id"] = o.DisplayId
	}
	if o.HashFunction != nil {
		toSerialize["hash-function"] = o.HashFunction
	}
	if o.InputFormat != nil {
		toSerialize["input-format"] = o.InputFormat
	}
	if o.ItemId != nil {
		toSerialize["item-id"] = o.ItemId
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["key-name"] = o.KeyName
	}
	if o.Plaintext != nil {
		toSerialize["plaintext"] = o.Plaintext
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableHmac struct {
	value *Hmac
	isSet bool
}

func (v NullableHmac) Get() *Hmac {
	return v.value
}

func (v *NullableHmac) Set(val *Hmac) {
	v.value = val
	v.isSet = true
}

func (v NullableHmac) IsSet() bool {
	return v.isSet
}

func (v *NullableHmac) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableHmac(val *Hmac) *NullableHmac {
	return &NullableHmac{value: val, isSet: true}
}

func (v NullableHmac) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableHmac) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


