/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GetLastUserEventStatus struct for GetLastUserEventStatus
type GetLastUserEventStatus struct {
	EventSource *string `json:"event-source,omitempty"`
	EventType string `json:"event-type"`
	// Event item name
	ItemName string `json:"item-name"`
	// Event item type can be either \"target\" or type of item eg \"static_secret\"/\"dynamic_secret\" To get type of some item run `akeyless describe-item -n {ITEM_NAME} --jq-expression .item_type`
	ItemType string `json:"item-type"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The time back to search the event, for example if the value is \"5m\" we will return the last user event issued in the last 5 minutes. By default, we will search without any time boundary.
	TimeBack *string `json:"time-back,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGetLastUserEventStatus instantiates a new GetLastUserEventStatus object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGetLastUserEventStatus(eventType string, itemName string, itemType string, ) *GetLastUserEventStatus {
	this := GetLastUserEventStatus{}
	this.EventType = eventType
	this.ItemName = itemName
	this.ItemType = itemType
	var json bool = false
	this.Json = &json
	return &this
}

// NewGetLastUserEventStatusWithDefaults instantiates a new GetLastUserEventStatus object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGetLastUserEventStatusWithDefaults() *GetLastUserEventStatus {
	this := GetLastUserEventStatus{}
	var json bool = false
	this.Json = &json
	return &this
}

// GetEventSource returns the EventSource field value if set, zero value otherwise.
func (o *GetLastUserEventStatus) GetEventSource() string {
	if o == nil || o.EventSource == nil {
		var ret string
		return ret
	}
	return *o.EventSource
}

// GetEventSourceOk returns a tuple with the EventSource field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetLastUserEventStatus) GetEventSourceOk() (*string, bool) {
	if o == nil || o.EventSource == nil {
		return nil, false
	}
	return o.EventSource, true
}

// HasEventSource returns a boolean if a field has been set.
func (o *GetLastUserEventStatus) HasEventSource() bool {
	if o != nil && o.EventSource != nil {
		return true
	}

	return false
}

// SetEventSource gets a reference to the given string and assigns it to the EventSource field.
func (o *GetLastUserEventStatus) SetEventSource(v string) {
	o.EventSource = &v
}

// GetEventType returns the EventType field value
func (o *GetLastUserEventStatus) GetEventType() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.EventType
}

// GetEventTypeOk returns a tuple with the EventType field value
// and a boolean to check if the value has been set.
func (o *GetLastUserEventStatus) GetEventTypeOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.EventType, true
}

// SetEventType sets field value
func (o *GetLastUserEventStatus) SetEventType(v string) {
	o.EventType = v
}

// GetItemName returns the ItemName field value
func (o *GetLastUserEventStatus) GetItemName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ItemName
}

// GetItemNameOk returns a tuple with the ItemName field value
// and a boolean to check if the value has been set.
func (o *GetLastUserEventStatus) GetItemNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ItemName, true
}

// SetItemName sets field value
func (o *GetLastUserEventStatus) SetItemName(v string) {
	o.ItemName = v
}

// GetItemType returns the ItemType field value
func (o *GetLastUserEventStatus) GetItemType() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.ItemType
}

// GetItemTypeOk returns a tuple with the ItemType field value
// and a boolean to check if the value has been set.
func (o *GetLastUserEventStatus) GetItemTypeOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.ItemType, true
}

// SetItemType sets field value
func (o *GetLastUserEventStatus) SetItemType(v string) {
	o.ItemType = v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GetLastUserEventStatus) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetLastUserEventStatus) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GetLastUserEventStatus) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GetLastUserEventStatus) SetJson(v bool) {
	o.Json = &v
}

// GetTimeBack returns the TimeBack field value if set, zero value otherwise.
func (o *GetLastUserEventStatus) GetTimeBack() string {
	if o == nil || o.TimeBack == nil {
		var ret string
		return ret
	}
	return *o.TimeBack
}

// GetTimeBackOk returns a tuple with the TimeBack field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetLastUserEventStatus) GetTimeBackOk() (*string, bool) {
	if o == nil || o.TimeBack == nil {
		return nil, false
	}
	return o.TimeBack, true
}

// HasTimeBack returns a boolean if a field has been set.
func (o *GetLastUserEventStatus) HasTimeBack() bool {
	if o != nil && o.TimeBack != nil {
		return true
	}

	return false
}

// SetTimeBack gets a reference to the given string and assigns it to the TimeBack field.
func (o *GetLastUserEventStatus) SetTimeBack(v string) {
	o.TimeBack = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GetLastUserEventStatus) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetLastUserEventStatus) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GetLastUserEventStatus) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GetLastUserEventStatus) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GetLastUserEventStatus) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GetLastUserEventStatus) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GetLastUserEventStatus) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GetLastUserEventStatus) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GetLastUserEventStatus) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.EventSource != nil {
		toSerialize["event-source"] = o.EventSource
	}
	if true {
		toSerialize["event-type"] = o.EventType
	}
	if true {
		toSerialize["item-name"] = o.ItemName
	}
	if true {
		toSerialize["item-type"] = o.ItemType
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.TimeBack != nil {
		toSerialize["time-back"] = o.TimeBack
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGetLastUserEventStatus struct {
	value *GetLastUserEventStatus
	isSet bool
}

func (v NullableGetLastUserEventStatus) Get() *GetLastUserEventStatus {
	return v.value
}

func (v *NullableGetLastUserEventStatus) Set(val *GetLastUserEventStatus) {
	v.value = val
	v.isSet = true
}

func (v NullableGetLastUserEventStatus) IsSet() bool {
	return v.isSet
}

func (v *NullableGetLastUserEventStatus) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGetLastUserEventStatus(val *GetLastUserEventStatus) *NullableGetLastUserEventStatus {
	return &NullableGetLastUserEventStatus{value: val, isSet: true}
}

func (v NullableGetLastUserEventStatus) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGetLastUserEventStatus) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


