/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GatewayUpdateCache gatewayUpdateCache is a command that updates cache settings
type GatewayUpdateCache struct {
	// Secure backup interval in minutes. To ensure service continuity in case of power cycle and network outage secrets will be backed up periodically per backup interval
	BackupInterval *string `json:"backup-interval,omitempty"`
	// Enable cache [true/false]
	EnableCache *string `json:"enable-cache,omitempty"`
	// Enable proactive caching [true/false]
	EnableProactive *string `json:"enable-proactive,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// When using Cache or/and Proactive Cache, additional secrets will be fetched upon requesting a secret, based on the requestor's access policy. Define minimum fetching interval to avoid over fetching in a given time frame
	MinimumFetchInterval *string `json:"minimum-fetch-interval,omitempty"`
	// Stale timeout in minutes, cache entries which are not accessed within timeout will be removed from cache
	StaleTimeout *string `json:"stale-timeout,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGatewayUpdateCache instantiates a new GatewayUpdateCache object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGatewayUpdateCache() *GatewayUpdateCache {
	this := GatewayUpdateCache{}
	var backupInterval string = "1"
	this.BackupInterval = &backupInterval
	var json bool = false
	this.Json = &json
	var minimumFetchInterval string = "5"
	this.MinimumFetchInterval = &minimumFetchInterval
	var staleTimeout string = "60"
	this.StaleTimeout = &staleTimeout
	return &this
}

// NewGatewayUpdateCacheWithDefaults instantiates a new GatewayUpdateCache object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGatewayUpdateCacheWithDefaults() *GatewayUpdateCache {
	this := GatewayUpdateCache{}
	var backupInterval string = "1"
	this.BackupInterval = &backupInterval
	var json bool = false
	this.Json = &json
	var minimumFetchInterval string = "5"
	this.MinimumFetchInterval = &minimumFetchInterval
	var staleTimeout string = "60"
	this.StaleTimeout = &staleTimeout
	return &this
}

// GetBackupInterval returns the BackupInterval field value if set, zero value otherwise.
func (o *GatewayUpdateCache) GetBackupInterval() string {
	if o == nil || o.BackupInterval == nil {
		var ret string
		return ret
	}
	return *o.BackupInterval
}

// GetBackupIntervalOk returns a tuple with the BackupInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateCache) GetBackupIntervalOk() (*string, bool) {
	if o == nil || o.BackupInterval == nil {
		return nil, false
	}
	return o.BackupInterval, true
}

// HasBackupInterval returns a boolean if a field has been set.
func (o *GatewayUpdateCache) HasBackupInterval() bool {
	if o != nil && o.BackupInterval != nil {
		return true
	}

	return false
}

// SetBackupInterval gets a reference to the given string and assigns it to the BackupInterval field.
func (o *GatewayUpdateCache) SetBackupInterval(v string) {
	o.BackupInterval = &v
}

// GetEnableCache returns the EnableCache field value if set, zero value otherwise.
func (o *GatewayUpdateCache) GetEnableCache() string {
	if o == nil || o.EnableCache == nil {
		var ret string
		return ret
	}
	return *o.EnableCache
}

// GetEnableCacheOk returns a tuple with the EnableCache field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateCache) GetEnableCacheOk() (*string, bool) {
	if o == nil || o.EnableCache == nil {
		return nil, false
	}
	return o.EnableCache, true
}

// HasEnableCache returns a boolean if a field has been set.
func (o *GatewayUpdateCache) HasEnableCache() bool {
	if o != nil && o.EnableCache != nil {
		return true
	}

	return false
}

// SetEnableCache gets a reference to the given string and assigns it to the EnableCache field.
func (o *GatewayUpdateCache) SetEnableCache(v string) {
	o.EnableCache = &v
}

// GetEnableProactive returns the EnableProactive field value if set, zero value otherwise.
func (o *GatewayUpdateCache) GetEnableProactive() string {
	if o == nil || o.EnableProactive == nil {
		var ret string
		return ret
	}
	return *o.EnableProactive
}

// GetEnableProactiveOk returns a tuple with the EnableProactive field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateCache) GetEnableProactiveOk() (*string, bool) {
	if o == nil || o.EnableProactive == nil {
		return nil, false
	}
	return o.EnableProactive, true
}

// HasEnableProactive returns a boolean if a field has been set.
func (o *GatewayUpdateCache) HasEnableProactive() bool {
	if o != nil && o.EnableProactive != nil {
		return true
	}

	return false
}

// SetEnableProactive gets a reference to the given string and assigns it to the EnableProactive field.
func (o *GatewayUpdateCache) SetEnableProactive(v string) {
	o.EnableProactive = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GatewayUpdateCache) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateCache) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GatewayUpdateCache) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GatewayUpdateCache) SetJson(v bool) {
	o.Json = &v
}

// GetMinimumFetchInterval returns the MinimumFetchInterval field value if set, zero value otherwise.
func (o *GatewayUpdateCache) GetMinimumFetchInterval() string {
	if o == nil || o.MinimumFetchInterval == nil {
		var ret string
		return ret
	}
	return *o.MinimumFetchInterval
}

// GetMinimumFetchIntervalOk returns a tuple with the MinimumFetchInterval field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateCache) GetMinimumFetchIntervalOk() (*string, bool) {
	if o == nil || o.MinimumFetchInterval == nil {
		return nil, false
	}
	return o.MinimumFetchInterval, true
}

// HasMinimumFetchInterval returns a boolean if a field has been set.
func (o *GatewayUpdateCache) HasMinimumFetchInterval() bool {
	if o != nil && o.MinimumFetchInterval != nil {
		return true
	}

	return false
}

// SetMinimumFetchInterval gets a reference to the given string and assigns it to the MinimumFetchInterval field.
func (o *GatewayUpdateCache) SetMinimumFetchInterval(v string) {
	o.MinimumFetchInterval = &v
}

// GetStaleTimeout returns the StaleTimeout field value if set, zero value otherwise.
func (o *GatewayUpdateCache) GetStaleTimeout() string {
	if o == nil || o.StaleTimeout == nil {
		var ret string
		return ret
	}
	return *o.StaleTimeout
}

// GetStaleTimeoutOk returns a tuple with the StaleTimeout field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateCache) GetStaleTimeoutOk() (*string, bool) {
	if o == nil || o.StaleTimeout == nil {
		return nil, false
	}
	return o.StaleTimeout, true
}

// HasStaleTimeout returns a boolean if a field has been set.
func (o *GatewayUpdateCache) HasStaleTimeout() bool {
	if o != nil && o.StaleTimeout != nil {
		return true
	}

	return false
}

// SetStaleTimeout gets a reference to the given string and assigns it to the StaleTimeout field.
func (o *GatewayUpdateCache) SetStaleTimeout(v string) {
	o.StaleTimeout = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GatewayUpdateCache) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateCache) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GatewayUpdateCache) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GatewayUpdateCache) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GatewayUpdateCache) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayUpdateCache) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GatewayUpdateCache) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GatewayUpdateCache) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GatewayUpdateCache) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.BackupInterval != nil {
		toSerialize["backup-interval"] = o.BackupInterval
	}
	if o.EnableCache != nil {
		toSerialize["enable-cache"] = o.EnableCache
	}
	if o.EnableProactive != nil {
		toSerialize["enable-proactive"] = o.EnableProactive
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.MinimumFetchInterval != nil {
		toSerialize["minimum-fetch-interval"] = o.MinimumFetchInterval
	}
	if o.StaleTimeout != nil {
		toSerialize["stale-timeout"] = o.StaleTimeout
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGatewayUpdateCache struct {
	value *GatewayUpdateCache
	isSet bool
}

func (v NullableGatewayUpdateCache) Get() *GatewayUpdateCache {
	return v.value
}

func (v *NullableGatewayUpdateCache) Set(val *GatewayUpdateCache) {
	v.value = val
	v.isSet = true
}

func (v NullableGatewayUpdateCache) IsSet() bool {
	return v.isSet
}

func (v *NullableGatewayUpdateCache) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGatewayUpdateCache(val *GatewayUpdateCache) *NullableGatewayUpdateCache {
	return &NullableGatewayUpdateCache{value: val, isSet: true}
}

func (v NullableGatewayUpdateCache) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGatewayUpdateCache) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


