/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// GatewayAddAllowedManagementAccess gatewayAddAllowedManagementAccess is a command that adds sub-admins
type GatewayAddAllowedManagementAccess struct {
	AllowGwApi *bool `json:"allow-gw-api,omitempty"`
	AllowGwLogin *bool `json:"allow-gw-login,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// SubAdmins to add
	SubAdminAccessId string `json:"sub-admin-access-id"`
	// key/val of sub claims, e.g group=admins,developers
	SubClaims *map[string]string `json:"sub-claims,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewGatewayAddAllowedManagementAccess instantiates a new GatewayAddAllowedManagementAccess object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewGatewayAddAllowedManagementAccess(subAdminAccessId string, ) *GatewayAddAllowedManagementAccess {
	this := GatewayAddAllowedManagementAccess{}
	this.SubAdminAccessId = subAdminAccessId
	return &this
}

// NewGatewayAddAllowedManagementAccessWithDefaults instantiates a new GatewayAddAllowedManagementAccess object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewGatewayAddAllowedManagementAccessWithDefaults() *GatewayAddAllowedManagementAccess {
	this := GatewayAddAllowedManagementAccess{}
	return &this
}

// GetAllowGwApi returns the AllowGwApi field value if set, zero value otherwise.
func (o *GatewayAddAllowedManagementAccess) GetAllowGwApi() bool {
	if o == nil || o.AllowGwApi == nil {
		var ret bool
		return ret
	}
	return *o.AllowGwApi
}

// GetAllowGwApiOk returns a tuple with the AllowGwApi field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayAddAllowedManagementAccess) GetAllowGwApiOk() (*bool, bool) {
	if o == nil || o.AllowGwApi == nil {
		return nil, false
	}
	return o.AllowGwApi, true
}

// HasAllowGwApi returns a boolean if a field has been set.
func (o *GatewayAddAllowedManagementAccess) HasAllowGwApi() bool {
	if o != nil && o.AllowGwApi != nil {
		return true
	}

	return false
}

// SetAllowGwApi gets a reference to the given bool and assigns it to the AllowGwApi field.
func (o *GatewayAddAllowedManagementAccess) SetAllowGwApi(v bool) {
	o.AllowGwApi = &v
}

// GetAllowGwLogin returns the AllowGwLogin field value if set, zero value otherwise.
func (o *GatewayAddAllowedManagementAccess) GetAllowGwLogin() bool {
	if o == nil || o.AllowGwLogin == nil {
		var ret bool
		return ret
	}
	return *o.AllowGwLogin
}

// GetAllowGwLoginOk returns a tuple with the AllowGwLogin field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayAddAllowedManagementAccess) GetAllowGwLoginOk() (*bool, bool) {
	if o == nil || o.AllowGwLogin == nil {
		return nil, false
	}
	return o.AllowGwLogin, true
}

// HasAllowGwLogin returns a boolean if a field has been set.
func (o *GatewayAddAllowedManagementAccess) HasAllowGwLogin() bool {
	if o != nil && o.AllowGwLogin != nil {
		return true
	}

	return false
}

// SetAllowGwLogin gets a reference to the given bool and assigns it to the AllowGwLogin field.
func (o *GatewayAddAllowedManagementAccess) SetAllowGwLogin(v bool) {
	o.AllowGwLogin = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *GatewayAddAllowedManagementAccess) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayAddAllowedManagementAccess) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *GatewayAddAllowedManagementAccess) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *GatewayAddAllowedManagementAccess) SetJson(v bool) {
	o.Json = &v
}

// GetSubAdminAccessId returns the SubAdminAccessId field value
func (o *GatewayAddAllowedManagementAccess) GetSubAdminAccessId() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.SubAdminAccessId
}

// GetSubAdminAccessIdOk returns a tuple with the SubAdminAccessId field value
// and a boolean to check if the value has been set.
func (o *GatewayAddAllowedManagementAccess) GetSubAdminAccessIdOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.SubAdminAccessId, true
}

// SetSubAdminAccessId sets field value
func (o *GatewayAddAllowedManagementAccess) SetSubAdminAccessId(v string) {
	o.SubAdminAccessId = v
}

// GetSubClaims returns the SubClaims field value if set, zero value otherwise.
func (o *GatewayAddAllowedManagementAccess) GetSubClaims() map[string]string {
	if o == nil || o.SubClaims == nil {
		var ret map[string]string
		return ret
	}
	return *o.SubClaims
}

// GetSubClaimsOk returns a tuple with the SubClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayAddAllowedManagementAccess) GetSubClaimsOk() (*map[string]string, bool) {
	if o == nil || o.SubClaims == nil {
		return nil, false
	}
	return o.SubClaims, true
}

// HasSubClaims returns a boolean if a field has been set.
func (o *GatewayAddAllowedManagementAccess) HasSubClaims() bool {
	if o != nil && o.SubClaims != nil {
		return true
	}

	return false
}

// SetSubClaims gets a reference to the given map[string]string and assigns it to the SubClaims field.
func (o *GatewayAddAllowedManagementAccess) SetSubClaims(v map[string]string) {
	o.SubClaims = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *GatewayAddAllowedManagementAccess) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayAddAllowedManagementAccess) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *GatewayAddAllowedManagementAccess) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *GatewayAddAllowedManagementAccess) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *GatewayAddAllowedManagementAccess) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *GatewayAddAllowedManagementAccess) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *GatewayAddAllowedManagementAccess) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *GatewayAddAllowedManagementAccess) SetUidToken(v string) {
	o.UidToken = &v
}

func (o GatewayAddAllowedManagementAccess) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AllowGwApi != nil {
		toSerialize["allow-gw-api"] = o.AllowGwApi
	}
	if o.AllowGwLogin != nil {
		toSerialize["allow-gw-login"] = o.AllowGwLogin
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["sub-admin-access-id"] = o.SubAdminAccessId
	}
	if o.SubClaims != nil {
		toSerialize["sub-claims"] = o.SubClaims
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableGatewayAddAllowedManagementAccess struct {
	value *GatewayAddAllowedManagementAccess
	isSet bool
}

func (v NullableGatewayAddAllowedManagementAccess) Get() *GatewayAddAllowedManagementAccess {
	return v.value
}

func (v *NullableGatewayAddAllowedManagementAccess) Set(val *GatewayAddAllowedManagementAccess) {
	v.value = val
	v.isSet = true
}

func (v NullableGatewayAddAllowedManagementAccess) IsSet() bool {
	return v.isSet
}

func (v *NullableGatewayAddAllowedManagementAccess) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableGatewayAddAllowedManagementAccess(val *GatewayAddAllowedManagementAccess) *NullableGatewayAddAllowedManagementAccess {
	return &NullableGatewayAddAllowedManagementAccess{value: val, isSet: true}
}

func (v NullableGatewayAddAllowedManagementAccess) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableGatewayAddAllowedManagementAccess) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


