/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DynamicSecretUpdateGitlab dynamicSecretUpdateGitlab is a command that updates gitlab dynamic secret
type DynamicSecretUpdateGitlab struct {
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Gitlab access token
	GitlabAccessToken *string `json:"gitlab-access-token,omitempty"`
	// Gitlab access token type [project,group]
	GitlabAccessType string `json:"gitlab-access-type"`
	// Gitlab tls certificate (base64 encoded)
	GitlabCertificate *string `json:"gitlab-certificate,omitempty"`
	// Gitlab role
	GitlabRole *string `json:"gitlab-role,omitempty"`
	// Comma-separated list of access token scopes to grant
	GitlabTokenScopes string `json:"gitlab-token-scopes"`
	// Gitlab base url
	GitlabUrl *string `json:"gitlab-url,omitempty"`
	// Gitlab group name, required for access-type=group
	GroupName *string `json:"group-name,omitempty"`
	// Gitlab project name, required for access-type=project
	InstallationOrganization *string `json:"installation-organization,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Dynamic secret name
	Name string `json:"name"`
	// Dynamic secret name
	NewName *string `json:"new-name,omitempty"`
	// Add tags attached to this object
	Tags *[]string `json:"tags,omitempty"`
	// Target name
	TargetName *string `json:"target-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// Access Token TTL
	Ttl *string `json:"ttl,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewDynamicSecretUpdateGitlab instantiates a new DynamicSecretUpdateGitlab object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDynamicSecretUpdateGitlab(gitlabAccessType string, gitlabTokenScopes string, name string, ) *DynamicSecretUpdateGitlab {
	this := DynamicSecretUpdateGitlab{}
	this.GitlabAccessType = gitlabAccessType
	this.GitlabTokenScopes = gitlabTokenScopes
	var gitlabUrl string = "https://gitlab.com/"
	this.GitlabUrl = &gitlabUrl
	var json bool = false
	this.Json = &json
	this.Name = name
	return &this
}

// NewDynamicSecretUpdateGitlabWithDefaults instantiates a new DynamicSecretUpdateGitlab object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDynamicSecretUpdateGitlabWithDefaults() *DynamicSecretUpdateGitlab {
	this := DynamicSecretUpdateGitlab{}
	var gitlabUrl string = "https://gitlab.com/"
	this.GitlabUrl = &gitlabUrl
	var json bool = false
	this.Json = &json
	return &this
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *DynamicSecretUpdateGitlab) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *DynamicSecretUpdateGitlab) SetDescription(v string) {
	o.Description = &v
}

// GetGitlabAccessToken returns the GitlabAccessToken field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetGitlabAccessToken() string {
	if o == nil || o.GitlabAccessToken == nil {
		var ret string
		return ret
	}
	return *o.GitlabAccessToken
}

// GetGitlabAccessTokenOk returns a tuple with the GitlabAccessToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetGitlabAccessTokenOk() (*string, bool) {
	if o == nil || o.GitlabAccessToken == nil {
		return nil, false
	}
	return o.GitlabAccessToken, true
}

// HasGitlabAccessToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasGitlabAccessToken() bool {
	if o != nil && o.GitlabAccessToken != nil {
		return true
	}

	return false
}

// SetGitlabAccessToken gets a reference to the given string and assigns it to the GitlabAccessToken field.
func (o *DynamicSecretUpdateGitlab) SetGitlabAccessToken(v string) {
	o.GitlabAccessToken = &v
}

// GetGitlabAccessType returns the GitlabAccessType field value
func (o *DynamicSecretUpdateGitlab) GetGitlabAccessType() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.GitlabAccessType
}

// GetGitlabAccessTypeOk returns a tuple with the GitlabAccessType field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetGitlabAccessTypeOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.GitlabAccessType, true
}

// SetGitlabAccessType sets field value
func (o *DynamicSecretUpdateGitlab) SetGitlabAccessType(v string) {
	o.GitlabAccessType = v
}

// GetGitlabCertificate returns the GitlabCertificate field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetGitlabCertificate() string {
	if o == nil || o.GitlabCertificate == nil {
		var ret string
		return ret
	}
	return *o.GitlabCertificate
}

// GetGitlabCertificateOk returns a tuple with the GitlabCertificate field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetGitlabCertificateOk() (*string, bool) {
	if o == nil || o.GitlabCertificate == nil {
		return nil, false
	}
	return o.GitlabCertificate, true
}

// HasGitlabCertificate returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasGitlabCertificate() bool {
	if o != nil && o.GitlabCertificate != nil {
		return true
	}

	return false
}

// SetGitlabCertificate gets a reference to the given string and assigns it to the GitlabCertificate field.
func (o *DynamicSecretUpdateGitlab) SetGitlabCertificate(v string) {
	o.GitlabCertificate = &v
}

// GetGitlabRole returns the GitlabRole field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetGitlabRole() string {
	if o == nil || o.GitlabRole == nil {
		var ret string
		return ret
	}
	return *o.GitlabRole
}

// GetGitlabRoleOk returns a tuple with the GitlabRole field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetGitlabRoleOk() (*string, bool) {
	if o == nil || o.GitlabRole == nil {
		return nil, false
	}
	return o.GitlabRole, true
}

// HasGitlabRole returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasGitlabRole() bool {
	if o != nil && o.GitlabRole != nil {
		return true
	}

	return false
}

// SetGitlabRole gets a reference to the given string and assigns it to the GitlabRole field.
func (o *DynamicSecretUpdateGitlab) SetGitlabRole(v string) {
	o.GitlabRole = &v
}

// GetGitlabTokenScopes returns the GitlabTokenScopes field value
func (o *DynamicSecretUpdateGitlab) GetGitlabTokenScopes() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.GitlabTokenScopes
}

// GetGitlabTokenScopesOk returns a tuple with the GitlabTokenScopes field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetGitlabTokenScopesOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.GitlabTokenScopes, true
}

// SetGitlabTokenScopes sets field value
func (o *DynamicSecretUpdateGitlab) SetGitlabTokenScopes(v string) {
	o.GitlabTokenScopes = v
}

// GetGitlabUrl returns the GitlabUrl field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetGitlabUrl() string {
	if o == nil || o.GitlabUrl == nil {
		var ret string
		return ret
	}
	return *o.GitlabUrl
}

// GetGitlabUrlOk returns a tuple with the GitlabUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetGitlabUrlOk() (*string, bool) {
	if o == nil || o.GitlabUrl == nil {
		return nil, false
	}
	return o.GitlabUrl, true
}

// HasGitlabUrl returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasGitlabUrl() bool {
	if o != nil && o.GitlabUrl != nil {
		return true
	}

	return false
}

// SetGitlabUrl gets a reference to the given string and assigns it to the GitlabUrl field.
func (o *DynamicSecretUpdateGitlab) SetGitlabUrl(v string) {
	o.GitlabUrl = &v
}

// GetGroupName returns the GroupName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetGroupName() string {
	if o == nil || o.GroupName == nil {
		var ret string
		return ret
	}
	return *o.GroupName
}

// GetGroupNameOk returns a tuple with the GroupName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetGroupNameOk() (*string, bool) {
	if o == nil || o.GroupName == nil {
		return nil, false
	}
	return o.GroupName, true
}

// HasGroupName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasGroupName() bool {
	if o != nil && o.GroupName != nil {
		return true
	}

	return false
}

// SetGroupName gets a reference to the given string and assigns it to the GroupName field.
func (o *DynamicSecretUpdateGitlab) SetGroupName(v string) {
	o.GroupName = &v
}

// GetInstallationOrganization returns the InstallationOrganization field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetInstallationOrganization() string {
	if o == nil || o.InstallationOrganization == nil {
		var ret string
		return ret
	}
	return *o.InstallationOrganization
}

// GetInstallationOrganizationOk returns a tuple with the InstallationOrganization field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetInstallationOrganizationOk() (*string, bool) {
	if o == nil || o.InstallationOrganization == nil {
		return nil, false
	}
	return o.InstallationOrganization, true
}

// HasInstallationOrganization returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasInstallationOrganization() bool {
	if o != nil && o.InstallationOrganization != nil {
		return true
	}

	return false
}

// SetInstallationOrganization gets a reference to the given string and assigns it to the InstallationOrganization field.
func (o *DynamicSecretUpdateGitlab) SetInstallationOrganization(v string) {
	o.InstallationOrganization = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DynamicSecretUpdateGitlab) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *DynamicSecretUpdateGitlab) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *DynamicSecretUpdateGitlab) SetName(v string) {
	o.Name = v
}

// GetNewName returns the NewName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetNewName() string {
	if o == nil || o.NewName == nil {
		var ret string
		return ret
	}
	return *o.NewName
}

// GetNewNameOk returns a tuple with the NewName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetNewNameOk() (*string, bool) {
	if o == nil || o.NewName == nil {
		return nil, false
	}
	return o.NewName, true
}

// HasNewName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasNewName() bool {
	if o != nil && o.NewName != nil {
		return true
	}

	return false
}

// SetNewName gets a reference to the given string and assigns it to the NewName field.
func (o *DynamicSecretUpdateGitlab) SetNewName(v string) {
	o.NewName = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *DynamicSecretUpdateGitlab) SetTags(v []string) {
	o.Tags = &v
}

// GetTargetName returns the TargetName field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetTargetName() string {
	if o == nil || o.TargetName == nil {
		var ret string
		return ret
	}
	return *o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetTargetNameOk() (*string, bool) {
	if o == nil || o.TargetName == nil {
		return nil, false
	}
	return o.TargetName, true
}

// HasTargetName returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasTargetName() bool {
	if o != nil && o.TargetName != nil {
		return true
	}

	return false
}

// SetTargetName gets a reference to the given string and assigns it to the TargetName field.
func (o *DynamicSecretUpdateGitlab) SetTargetName(v string) {
	o.TargetName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DynamicSecretUpdateGitlab) SetToken(v string) {
	o.Token = &v
}

// GetTtl returns the Ttl field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetTtl() string {
	if o == nil || o.Ttl == nil {
		var ret string
		return ret
	}
	return *o.Ttl
}

// GetTtlOk returns a tuple with the Ttl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetTtlOk() (*string, bool) {
	if o == nil || o.Ttl == nil {
		return nil, false
	}
	return o.Ttl, true
}

// HasTtl returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasTtl() bool {
	if o != nil && o.Ttl != nil {
		return true
	}

	return false
}

// SetTtl gets a reference to the given string and assigns it to the Ttl field.
func (o *DynamicSecretUpdateGitlab) SetTtl(v string) {
	o.Ttl = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DynamicSecretUpdateGitlab) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretUpdateGitlab) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DynamicSecretUpdateGitlab) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DynamicSecretUpdateGitlab) SetUidToken(v string) {
	o.UidToken = &v
}

func (o DynamicSecretUpdateGitlab) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.GitlabAccessToken != nil {
		toSerialize["gitlab-access-token"] = o.GitlabAccessToken
	}
	if true {
		toSerialize["gitlab-access-type"] = o.GitlabAccessType
	}
	if o.GitlabCertificate != nil {
		toSerialize["gitlab-certificate"] = o.GitlabCertificate
	}
	if o.GitlabRole != nil {
		toSerialize["gitlab-role"] = o.GitlabRole
	}
	if true {
		toSerialize["gitlab-token-scopes"] = o.GitlabTokenScopes
	}
	if o.GitlabUrl != nil {
		toSerialize["gitlab-url"] = o.GitlabUrl
	}
	if o.GroupName != nil {
		toSerialize["group-name"] = o.GroupName
	}
	if o.InstallationOrganization != nil {
		toSerialize["installation-organization"] = o.InstallationOrganization
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.NewName != nil {
		toSerialize["new-name"] = o.NewName
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.TargetName != nil {
		toSerialize["target-name"] = o.TargetName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.Ttl != nil {
		toSerialize["ttl"] = o.Ttl
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableDynamicSecretUpdateGitlab struct {
	value *DynamicSecretUpdateGitlab
	isSet bool
}

func (v NullableDynamicSecretUpdateGitlab) Get() *DynamicSecretUpdateGitlab {
	return v.value
}

func (v *NullableDynamicSecretUpdateGitlab) Set(val *DynamicSecretUpdateGitlab) {
	v.value = val
	v.isSet = true
}

func (v NullableDynamicSecretUpdateGitlab) IsSet() bool {
	return v.isSet
}

func (v *NullableDynamicSecretUpdateGitlab) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDynamicSecretUpdateGitlab(val *DynamicSecretUpdateGitlab) *NullableDynamicSecretUpdateGitlab {
	return &NullableDynamicSecretUpdateGitlab{value: val, isSet: true}
}

func (v NullableDynamicSecretUpdateGitlab) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDynamicSecretUpdateGitlab) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


