/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// DynamicSecretCreateOracleDb dynamicSecretCreateOracleDb is a command that creates oracle db dynamic secret
type DynamicSecretCreateOracleDb struct {
	// (Optional) DB server certificates
	DbServerCertificates *string `json:"db-server-certificates,omitempty"`
	// (Optional) Server name for certificate verification
	DbServerName *string `json:"db-server-name,omitempty"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Description of the object
	Description *string `json:"description,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Dynamic secret name
	Name string `json:"name"`
	// Oracle Host
	OracleHost *string `json:"oracle-host,omitempty"`
	// Oracle Password
	OraclePassword *string `json:"oracle-password,omitempty"`
	// Oracle Port
	OraclePort *string `json:"oracle-port,omitempty"`
	// Oracle Revocation statements
	OracleRevocationStatements *string `json:"oracle-revocation-statements,omitempty"`
	// Oracle Creation statements
	OracleScreationStatements *string `json:"oracle-screation-statements,omitempty"`
	// Oracle DB Name
	OracleServiceName *string `json:"oracle-service-name,omitempty"`
	// Oracle Username
	OracleUsername *string `json:"oracle-username,omitempty"`
	// The length of the password to be generated
	PasswordLength *string `json:"password-length,omitempty"`
	// Dynamic producer encryption key
	ProducerEncryptionKeyName *string `json:"producer-encryption-key-name,omitempty"`
	// Path to the SSH Certificate Issuer for your Akeyless Bastion
	SecureAccessBastionIssuer *string `json:"secure-access-bastion-issuer,omitempty"`
	// Enable/Disable secure remote access [true/false]
	SecureAccessEnable *string `json:"secure-access-enable,omitempty"`
	// Target DB servers for connections (In case of Linked Target association, host(s) will inherit Linked Target hosts)
	SecureAccessHost *[]string `json:"secure-access-host,omitempty"`
	// Enable Web Secure Remote Access
	SecureAccessWeb *bool `json:"secure-access-web,omitempty"`
	// Add tags attached to this object
	Tags *[]string `json:"tags,omitempty"`
	// Target name
	TargetName *string `json:"target-name,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// User TTL
	UserTtl *string `json:"user-ttl,omitempty"`
}

// NewDynamicSecretCreateOracleDb instantiates a new DynamicSecretCreateOracleDb object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDynamicSecretCreateOracleDb(name string, ) *DynamicSecretCreateOracleDb {
	this := DynamicSecretCreateOracleDb{}
	var json bool = false
	this.Json = &json
	this.Name = name
	var oracleHost string = "127.0.0.1"
	this.OracleHost = &oracleHost
	var oraclePort string = "1521"
	this.OraclePort = &oraclePort
	var secureAccessEnable string = "false"
	this.SecureAccessEnable = &secureAccessEnable
	var secureAccessWeb bool = false
	this.SecureAccessWeb = &secureAccessWeb
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// NewDynamicSecretCreateOracleDbWithDefaults instantiates a new DynamicSecretCreateOracleDb object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDynamicSecretCreateOracleDbWithDefaults() *DynamicSecretCreateOracleDb {
	this := DynamicSecretCreateOracleDb{}
	var json bool = false
	this.Json = &json
	var oracleHost string = "127.0.0.1"
	this.OracleHost = &oracleHost
	var oraclePort string = "1521"
	this.OraclePort = &oraclePort
	var secureAccessEnable string = "false"
	this.SecureAccessEnable = &secureAccessEnable
	var secureAccessWeb bool = false
	this.SecureAccessWeb = &secureAccessWeb
	var userTtl string = "60m"
	this.UserTtl = &userTtl
	return &this
}

// GetDbServerCertificates returns the DbServerCertificates field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetDbServerCertificates() string {
	if o == nil || o.DbServerCertificates == nil {
		var ret string
		return ret
	}
	return *o.DbServerCertificates
}

// GetDbServerCertificatesOk returns a tuple with the DbServerCertificates field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetDbServerCertificatesOk() (*string, bool) {
	if o == nil || o.DbServerCertificates == nil {
		return nil, false
	}
	return o.DbServerCertificates, true
}

// HasDbServerCertificates returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasDbServerCertificates() bool {
	if o != nil && o.DbServerCertificates != nil {
		return true
	}

	return false
}

// SetDbServerCertificates gets a reference to the given string and assigns it to the DbServerCertificates field.
func (o *DynamicSecretCreateOracleDb) SetDbServerCertificates(v string) {
	o.DbServerCertificates = &v
}

// GetDbServerName returns the DbServerName field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetDbServerName() string {
	if o == nil || o.DbServerName == nil {
		var ret string
		return ret
	}
	return *o.DbServerName
}

// GetDbServerNameOk returns a tuple with the DbServerName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetDbServerNameOk() (*string, bool) {
	if o == nil || o.DbServerName == nil {
		return nil, false
	}
	return o.DbServerName, true
}

// HasDbServerName returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasDbServerName() bool {
	if o != nil && o.DbServerName != nil {
		return true
	}

	return false
}

// SetDbServerName gets a reference to the given string and assigns it to the DbServerName field.
func (o *DynamicSecretCreateOracleDb) SetDbServerName(v string) {
	o.DbServerName = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *DynamicSecretCreateOracleDb) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *DynamicSecretCreateOracleDb) SetDescription(v string) {
	o.Description = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *DynamicSecretCreateOracleDb) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *DynamicSecretCreateOracleDb) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *DynamicSecretCreateOracleDb) SetName(v string) {
	o.Name = v
}

// GetOracleHost returns the OracleHost field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetOracleHost() string {
	if o == nil || o.OracleHost == nil {
		var ret string
		return ret
	}
	return *o.OracleHost
}

// GetOracleHostOk returns a tuple with the OracleHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetOracleHostOk() (*string, bool) {
	if o == nil || o.OracleHost == nil {
		return nil, false
	}
	return o.OracleHost, true
}

// HasOracleHost returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasOracleHost() bool {
	if o != nil && o.OracleHost != nil {
		return true
	}

	return false
}

// SetOracleHost gets a reference to the given string and assigns it to the OracleHost field.
func (o *DynamicSecretCreateOracleDb) SetOracleHost(v string) {
	o.OracleHost = &v
}

// GetOraclePassword returns the OraclePassword field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetOraclePassword() string {
	if o == nil || o.OraclePassword == nil {
		var ret string
		return ret
	}
	return *o.OraclePassword
}

// GetOraclePasswordOk returns a tuple with the OraclePassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetOraclePasswordOk() (*string, bool) {
	if o == nil || o.OraclePassword == nil {
		return nil, false
	}
	return o.OraclePassword, true
}

// HasOraclePassword returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasOraclePassword() bool {
	if o != nil && o.OraclePassword != nil {
		return true
	}

	return false
}

// SetOraclePassword gets a reference to the given string and assigns it to the OraclePassword field.
func (o *DynamicSecretCreateOracleDb) SetOraclePassword(v string) {
	o.OraclePassword = &v
}

// GetOraclePort returns the OraclePort field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetOraclePort() string {
	if o == nil || o.OraclePort == nil {
		var ret string
		return ret
	}
	return *o.OraclePort
}

// GetOraclePortOk returns a tuple with the OraclePort field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetOraclePortOk() (*string, bool) {
	if o == nil || o.OraclePort == nil {
		return nil, false
	}
	return o.OraclePort, true
}

// HasOraclePort returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasOraclePort() bool {
	if o != nil && o.OraclePort != nil {
		return true
	}

	return false
}

// SetOraclePort gets a reference to the given string and assigns it to the OraclePort field.
func (o *DynamicSecretCreateOracleDb) SetOraclePort(v string) {
	o.OraclePort = &v
}

// GetOracleRevocationStatements returns the OracleRevocationStatements field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetOracleRevocationStatements() string {
	if o == nil || o.OracleRevocationStatements == nil {
		var ret string
		return ret
	}
	return *o.OracleRevocationStatements
}

// GetOracleRevocationStatementsOk returns a tuple with the OracleRevocationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetOracleRevocationStatementsOk() (*string, bool) {
	if o == nil || o.OracleRevocationStatements == nil {
		return nil, false
	}
	return o.OracleRevocationStatements, true
}

// HasOracleRevocationStatements returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasOracleRevocationStatements() bool {
	if o != nil && o.OracleRevocationStatements != nil {
		return true
	}

	return false
}

// SetOracleRevocationStatements gets a reference to the given string and assigns it to the OracleRevocationStatements field.
func (o *DynamicSecretCreateOracleDb) SetOracleRevocationStatements(v string) {
	o.OracleRevocationStatements = &v
}

// GetOracleScreationStatements returns the OracleScreationStatements field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetOracleScreationStatements() string {
	if o == nil || o.OracleScreationStatements == nil {
		var ret string
		return ret
	}
	return *o.OracleScreationStatements
}

// GetOracleScreationStatementsOk returns a tuple with the OracleScreationStatements field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetOracleScreationStatementsOk() (*string, bool) {
	if o == nil || o.OracleScreationStatements == nil {
		return nil, false
	}
	return o.OracleScreationStatements, true
}

// HasOracleScreationStatements returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasOracleScreationStatements() bool {
	if o != nil && o.OracleScreationStatements != nil {
		return true
	}

	return false
}

// SetOracleScreationStatements gets a reference to the given string and assigns it to the OracleScreationStatements field.
func (o *DynamicSecretCreateOracleDb) SetOracleScreationStatements(v string) {
	o.OracleScreationStatements = &v
}

// GetOracleServiceName returns the OracleServiceName field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetOracleServiceName() string {
	if o == nil || o.OracleServiceName == nil {
		var ret string
		return ret
	}
	return *o.OracleServiceName
}

// GetOracleServiceNameOk returns a tuple with the OracleServiceName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetOracleServiceNameOk() (*string, bool) {
	if o == nil || o.OracleServiceName == nil {
		return nil, false
	}
	return o.OracleServiceName, true
}

// HasOracleServiceName returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasOracleServiceName() bool {
	if o != nil && o.OracleServiceName != nil {
		return true
	}

	return false
}

// SetOracleServiceName gets a reference to the given string and assigns it to the OracleServiceName field.
func (o *DynamicSecretCreateOracleDb) SetOracleServiceName(v string) {
	o.OracleServiceName = &v
}

// GetOracleUsername returns the OracleUsername field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetOracleUsername() string {
	if o == nil || o.OracleUsername == nil {
		var ret string
		return ret
	}
	return *o.OracleUsername
}

// GetOracleUsernameOk returns a tuple with the OracleUsername field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetOracleUsernameOk() (*string, bool) {
	if o == nil || o.OracleUsername == nil {
		return nil, false
	}
	return o.OracleUsername, true
}

// HasOracleUsername returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasOracleUsername() bool {
	if o != nil && o.OracleUsername != nil {
		return true
	}

	return false
}

// SetOracleUsername gets a reference to the given string and assigns it to the OracleUsername field.
func (o *DynamicSecretCreateOracleDb) SetOracleUsername(v string) {
	o.OracleUsername = &v
}

// GetPasswordLength returns the PasswordLength field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetPasswordLength() string {
	if o == nil || o.PasswordLength == nil {
		var ret string
		return ret
	}
	return *o.PasswordLength
}

// GetPasswordLengthOk returns a tuple with the PasswordLength field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetPasswordLengthOk() (*string, bool) {
	if o == nil || o.PasswordLength == nil {
		return nil, false
	}
	return o.PasswordLength, true
}

// HasPasswordLength returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasPasswordLength() bool {
	if o != nil && o.PasswordLength != nil {
		return true
	}

	return false
}

// SetPasswordLength gets a reference to the given string and assigns it to the PasswordLength field.
func (o *DynamicSecretCreateOracleDb) SetPasswordLength(v string) {
	o.PasswordLength = &v
}

// GetProducerEncryptionKeyName returns the ProducerEncryptionKeyName field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetProducerEncryptionKeyName() string {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		var ret string
		return ret
	}
	return *o.ProducerEncryptionKeyName
}

// GetProducerEncryptionKeyNameOk returns a tuple with the ProducerEncryptionKeyName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetProducerEncryptionKeyNameOk() (*string, bool) {
	if o == nil || o.ProducerEncryptionKeyName == nil {
		return nil, false
	}
	return o.ProducerEncryptionKeyName, true
}

// HasProducerEncryptionKeyName returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasProducerEncryptionKeyName() bool {
	if o != nil && o.ProducerEncryptionKeyName != nil {
		return true
	}

	return false
}

// SetProducerEncryptionKeyName gets a reference to the given string and assigns it to the ProducerEncryptionKeyName field.
func (o *DynamicSecretCreateOracleDb) SetProducerEncryptionKeyName(v string) {
	o.ProducerEncryptionKeyName = &v
}

// GetSecureAccessBastionIssuer returns the SecureAccessBastionIssuer field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetSecureAccessBastionIssuer() string {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessBastionIssuer
}

// GetSecureAccessBastionIssuerOk returns a tuple with the SecureAccessBastionIssuer field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetSecureAccessBastionIssuerOk() (*string, bool) {
	if o == nil || o.SecureAccessBastionIssuer == nil {
		return nil, false
	}
	return o.SecureAccessBastionIssuer, true
}

// HasSecureAccessBastionIssuer returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasSecureAccessBastionIssuer() bool {
	if o != nil && o.SecureAccessBastionIssuer != nil {
		return true
	}

	return false
}

// SetSecureAccessBastionIssuer gets a reference to the given string and assigns it to the SecureAccessBastionIssuer field.
func (o *DynamicSecretCreateOracleDb) SetSecureAccessBastionIssuer(v string) {
	o.SecureAccessBastionIssuer = &v
}

// GetSecureAccessEnable returns the SecureAccessEnable field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetSecureAccessEnable() string {
	if o == nil || o.SecureAccessEnable == nil {
		var ret string
		return ret
	}
	return *o.SecureAccessEnable
}

// GetSecureAccessEnableOk returns a tuple with the SecureAccessEnable field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetSecureAccessEnableOk() (*string, bool) {
	if o == nil || o.SecureAccessEnable == nil {
		return nil, false
	}
	return o.SecureAccessEnable, true
}

// HasSecureAccessEnable returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasSecureAccessEnable() bool {
	if o != nil && o.SecureAccessEnable != nil {
		return true
	}

	return false
}

// SetSecureAccessEnable gets a reference to the given string and assigns it to the SecureAccessEnable field.
func (o *DynamicSecretCreateOracleDb) SetSecureAccessEnable(v string) {
	o.SecureAccessEnable = &v
}

// GetSecureAccessHost returns the SecureAccessHost field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetSecureAccessHost() []string {
	if o == nil || o.SecureAccessHost == nil {
		var ret []string
		return ret
	}
	return *o.SecureAccessHost
}

// GetSecureAccessHostOk returns a tuple with the SecureAccessHost field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetSecureAccessHostOk() (*[]string, bool) {
	if o == nil || o.SecureAccessHost == nil {
		return nil, false
	}
	return o.SecureAccessHost, true
}

// HasSecureAccessHost returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasSecureAccessHost() bool {
	if o != nil && o.SecureAccessHost != nil {
		return true
	}

	return false
}

// SetSecureAccessHost gets a reference to the given []string and assigns it to the SecureAccessHost field.
func (o *DynamicSecretCreateOracleDb) SetSecureAccessHost(v []string) {
	o.SecureAccessHost = &v
}

// GetSecureAccessWeb returns the SecureAccessWeb field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetSecureAccessWeb() bool {
	if o == nil || o.SecureAccessWeb == nil {
		var ret bool
		return ret
	}
	return *o.SecureAccessWeb
}

// GetSecureAccessWebOk returns a tuple with the SecureAccessWeb field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetSecureAccessWebOk() (*bool, bool) {
	if o == nil || o.SecureAccessWeb == nil {
		return nil, false
	}
	return o.SecureAccessWeb, true
}

// HasSecureAccessWeb returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasSecureAccessWeb() bool {
	if o != nil && o.SecureAccessWeb != nil {
		return true
	}

	return false
}

// SetSecureAccessWeb gets a reference to the given bool and assigns it to the SecureAccessWeb field.
func (o *DynamicSecretCreateOracleDb) SetSecureAccessWeb(v bool) {
	o.SecureAccessWeb = &v
}

// GetTags returns the Tags field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetTags() []string {
	if o == nil || o.Tags == nil {
		var ret []string
		return ret
	}
	return *o.Tags
}

// GetTagsOk returns a tuple with the Tags field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetTagsOk() (*[]string, bool) {
	if o == nil || o.Tags == nil {
		return nil, false
	}
	return o.Tags, true
}

// HasTags returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasTags() bool {
	if o != nil && o.Tags != nil {
		return true
	}

	return false
}

// SetTags gets a reference to the given []string and assigns it to the Tags field.
func (o *DynamicSecretCreateOracleDb) SetTags(v []string) {
	o.Tags = &v
}

// GetTargetName returns the TargetName field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetTargetName() string {
	if o == nil || o.TargetName == nil {
		var ret string
		return ret
	}
	return *o.TargetName
}

// GetTargetNameOk returns a tuple with the TargetName field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetTargetNameOk() (*string, bool) {
	if o == nil || o.TargetName == nil {
		return nil, false
	}
	return o.TargetName, true
}

// HasTargetName returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasTargetName() bool {
	if o != nil && o.TargetName != nil {
		return true
	}

	return false
}

// SetTargetName gets a reference to the given string and assigns it to the TargetName field.
func (o *DynamicSecretCreateOracleDb) SetTargetName(v string) {
	o.TargetName = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *DynamicSecretCreateOracleDb) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *DynamicSecretCreateOracleDb) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUserTtl returns the UserTtl field value if set, zero value otherwise.
func (o *DynamicSecretCreateOracleDb) GetUserTtl() string {
	if o == nil || o.UserTtl == nil {
		var ret string
		return ret
	}
	return *o.UserTtl
}

// GetUserTtlOk returns a tuple with the UserTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DynamicSecretCreateOracleDb) GetUserTtlOk() (*string, bool) {
	if o == nil || o.UserTtl == nil {
		return nil, false
	}
	return o.UserTtl, true
}

// HasUserTtl returns a boolean if a field has been set.
func (o *DynamicSecretCreateOracleDb) HasUserTtl() bool {
	if o != nil && o.UserTtl != nil {
		return true
	}

	return false
}

// SetUserTtl gets a reference to the given string and assigns it to the UserTtl field.
func (o *DynamicSecretCreateOracleDb) SetUserTtl(v string) {
	o.UserTtl = &v
}

func (o DynamicSecretCreateOracleDb) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.DbServerCertificates != nil {
		toSerialize["db-server-certificates"] = o.DbServerCertificates
	}
	if o.DbServerName != nil {
		toSerialize["db-server-name"] = o.DbServerName
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.OracleHost != nil {
		toSerialize["oracle-host"] = o.OracleHost
	}
	if o.OraclePassword != nil {
		toSerialize["oracle-password"] = o.OraclePassword
	}
	if o.OraclePort != nil {
		toSerialize["oracle-port"] = o.OraclePort
	}
	if o.OracleRevocationStatements != nil {
		toSerialize["oracle-revocation-statements"] = o.OracleRevocationStatements
	}
	if o.OracleScreationStatements != nil {
		toSerialize["oracle-screation-statements"] = o.OracleScreationStatements
	}
	if o.OracleServiceName != nil {
		toSerialize["oracle-service-name"] = o.OracleServiceName
	}
	if o.OracleUsername != nil {
		toSerialize["oracle-username"] = o.OracleUsername
	}
	if o.PasswordLength != nil {
		toSerialize["password-length"] = o.PasswordLength
	}
	if o.ProducerEncryptionKeyName != nil {
		toSerialize["producer-encryption-key-name"] = o.ProducerEncryptionKeyName
	}
	if o.SecureAccessBastionIssuer != nil {
		toSerialize["secure-access-bastion-issuer"] = o.SecureAccessBastionIssuer
	}
	if o.SecureAccessEnable != nil {
		toSerialize["secure-access-enable"] = o.SecureAccessEnable
	}
	if o.SecureAccessHost != nil {
		toSerialize["secure-access-host"] = o.SecureAccessHost
	}
	if o.SecureAccessWeb != nil {
		toSerialize["secure-access-web"] = o.SecureAccessWeb
	}
	if o.Tags != nil {
		toSerialize["tags"] = o.Tags
	}
	if o.TargetName != nil {
		toSerialize["target-name"] = o.TargetName
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UserTtl != nil {
		toSerialize["user-ttl"] = o.UserTtl
	}
	return json.Marshal(toSerialize)
}

type NullableDynamicSecretCreateOracleDb struct {
	value *DynamicSecretCreateOracleDb
	isSet bool
}

func (v NullableDynamicSecretCreateOracleDb) Get() *DynamicSecretCreateOracleDb {
	return v.value
}

func (v *NullableDynamicSecretCreateOracleDb) Set(val *DynamicSecretCreateOracleDb) {
	v.value = val
	v.isSet = true
}

func (v NullableDynamicSecretCreateOracleDb) IsSet() bool {
	return v.isSet
}

func (v *NullableDynamicSecretCreateOracleDb) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDynamicSecretCreateOracleDb(val *DynamicSecretCreateOracleDb) *NullableDynamicSecretCreateOracleDb {
	return &NullableDynamicSecretCreateOracleDb{value: val, isSet: true}
}

func (v NullableDynamicSecretCreateOracleDb) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDynamicSecretCreateOracleDb) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


