/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// AuthMethodCreateKerberos authMethodCreateKerberos is a command that creates a new auth method that will be able to authenticate using Kerberos
type AuthMethodCreateKerberos struct {
	// Access expiration date in Unix timestamp (select 0 for access without expiry date)
	AccessExpires *int64 `json:"access-expires,omitempty"`
	// Subclaims to include in audit logs, e.g \"--audit-logs-claims email --audit-logs-claims username\"
	AuditLogsClaims *[]string `json:"audit-logs-claims,omitempty"`
	BindDn *string `json:"bind-dn,omitempty"`
	BindDnPassword *string `json:"bind-dn-password,omitempty"`
	// A CIDR whitelist with the IPs that the access is restricted to
	BoundIps *[]string `json:"bound-ips,omitempty"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Auth Method description
	Description *string `json:"description,omitempty"`
	// if true: enforce role-association must include sub claims
	ForceSubClaims *bool `json:"force-sub-claims,omitempty"`
	GroupAttr *string `json:"group-attr,omitempty"`
	GroupDn *string `json:"group-dn,omitempty"`
	GroupFilter *string `json:"group-filter,omitempty"`
	// A CIDR whitelist with the GW IPs that the access is restricted to
	GwBoundIps *[]string `json:"gw-bound-ips,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Jwt TTL
	JwtTtl *int64 `json:"jwt-ttl,omitempty"`
	KeytabFileData *string `json:"keytab-file-data,omitempty"`
	KeytabFilePath *string `json:"keytab-file-path,omitempty"`
	Krb5ConfData *string `json:"krb5-conf-data,omitempty"`
	Krb5ConfPath *string `json:"krb5-conf-path,omitempty"`
	LdapAnonymousSearch *bool `json:"ldap-anonymous-search,omitempty"`
	LdapCaCert *string `json:"ldap-ca-cert,omitempty"`
	LdapUrl *string `json:"ldap-url,omitempty"`
	// Auth Method name
	Name string `json:"name"`
	// Choose the relevant product type for the auth method [sm, sra, pm, dp, ca]
	ProductType *[]string `json:"product-type,omitempty"`
	// A list of additional sub claims delimiters (relevant only for SAML, OIDC, OAuth2/JWT)
	SubclaimsDelimiters *[]string `json:"subclaims-delimiters,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// A unique identifier (ID) value which is a \"sub claim\" name that contains details uniquely identifying that resource. This \"sub claim\" is used to distinguish between different identities.
	UniqueIdentifier *string `json:"unique-identifier,omitempty"`
	UserAttribute *string `json:"user-attribute,omitempty"`
	UserDn *string `json:"user-dn,omitempty"`
}

// NewAuthMethodCreateKerberos instantiates a new AuthMethodCreateKerberos object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAuthMethodCreateKerberos(name string, ) *AuthMethodCreateKerberos {
	this := AuthMethodCreateKerberos{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	var json bool = false
	this.Json = &json
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	this.Name = name
	return &this
}

// NewAuthMethodCreateKerberosWithDefaults instantiates a new AuthMethodCreateKerberos object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAuthMethodCreateKerberosWithDefaults() *AuthMethodCreateKerberos {
	this := AuthMethodCreateKerberos{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	var json bool = false
	this.Json = &json
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	return &this
}

// GetAccessExpires returns the AccessExpires field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetAccessExpires() int64 {
	if o == nil || o.AccessExpires == nil {
		var ret int64
		return ret
	}
	return *o.AccessExpires
}

// GetAccessExpiresOk returns a tuple with the AccessExpires field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetAccessExpiresOk() (*int64, bool) {
	if o == nil || o.AccessExpires == nil {
		return nil, false
	}
	return o.AccessExpires, true
}

// HasAccessExpires returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasAccessExpires() bool {
	if o != nil && o.AccessExpires != nil {
		return true
	}

	return false
}

// SetAccessExpires gets a reference to the given int64 and assigns it to the AccessExpires field.
func (o *AuthMethodCreateKerberos) SetAccessExpires(v int64) {
	o.AccessExpires = &v
}

// GetAuditLogsClaims returns the AuditLogsClaims field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetAuditLogsClaims() []string {
	if o == nil || o.AuditLogsClaims == nil {
		var ret []string
		return ret
	}
	return *o.AuditLogsClaims
}

// GetAuditLogsClaimsOk returns a tuple with the AuditLogsClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetAuditLogsClaimsOk() (*[]string, bool) {
	if o == nil || o.AuditLogsClaims == nil {
		return nil, false
	}
	return o.AuditLogsClaims, true
}

// HasAuditLogsClaims returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasAuditLogsClaims() bool {
	if o != nil && o.AuditLogsClaims != nil {
		return true
	}

	return false
}

// SetAuditLogsClaims gets a reference to the given []string and assigns it to the AuditLogsClaims field.
func (o *AuthMethodCreateKerberos) SetAuditLogsClaims(v []string) {
	o.AuditLogsClaims = &v
}

// GetBindDn returns the BindDn field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetBindDn() string {
	if o == nil || o.BindDn == nil {
		var ret string
		return ret
	}
	return *o.BindDn
}

// GetBindDnOk returns a tuple with the BindDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetBindDnOk() (*string, bool) {
	if o == nil || o.BindDn == nil {
		return nil, false
	}
	return o.BindDn, true
}

// HasBindDn returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasBindDn() bool {
	if o != nil && o.BindDn != nil {
		return true
	}

	return false
}

// SetBindDn gets a reference to the given string and assigns it to the BindDn field.
func (o *AuthMethodCreateKerberos) SetBindDn(v string) {
	o.BindDn = &v
}

// GetBindDnPassword returns the BindDnPassword field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetBindDnPassword() string {
	if o == nil || o.BindDnPassword == nil {
		var ret string
		return ret
	}
	return *o.BindDnPassword
}

// GetBindDnPasswordOk returns a tuple with the BindDnPassword field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetBindDnPasswordOk() (*string, bool) {
	if o == nil || o.BindDnPassword == nil {
		return nil, false
	}
	return o.BindDnPassword, true
}

// HasBindDnPassword returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasBindDnPassword() bool {
	if o != nil && o.BindDnPassword != nil {
		return true
	}

	return false
}

// SetBindDnPassword gets a reference to the given string and assigns it to the BindDnPassword field.
func (o *AuthMethodCreateKerberos) SetBindDnPassword(v string) {
	o.BindDnPassword = &v
}

// GetBoundIps returns the BoundIps field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetBoundIps() []string {
	if o == nil || o.BoundIps == nil {
		var ret []string
		return ret
	}
	return *o.BoundIps
}

// GetBoundIpsOk returns a tuple with the BoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetBoundIpsOk() (*[]string, bool) {
	if o == nil || o.BoundIps == nil {
		return nil, false
	}
	return o.BoundIps, true
}

// HasBoundIps returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasBoundIps() bool {
	if o != nil && o.BoundIps != nil {
		return true
	}

	return false
}

// SetBoundIps gets a reference to the given []string and assigns it to the BoundIps field.
func (o *AuthMethodCreateKerberos) SetBoundIps(v []string) {
	o.BoundIps = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *AuthMethodCreateKerberos) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *AuthMethodCreateKerberos) SetDescription(v string) {
	o.Description = &v
}

// GetForceSubClaims returns the ForceSubClaims field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetForceSubClaims() bool {
	if o == nil || o.ForceSubClaims == nil {
		var ret bool
		return ret
	}
	return *o.ForceSubClaims
}

// GetForceSubClaimsOk returns a tuple with the ForceSubClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetForceSubClaimsOk() (*bool, bool) {
	if o == nil || o.ForceSubClaims == nil {
		return nil, false
	}
	return o.ForceSubClaims, true
}

// HasForceSubClaims returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasForceSubClaims() bool {
	if o != nil && o.ForceSubClaims != nil {
		return true
	}

	return false
}

// SetForceSubClaims gets a reference to the given bool and assigns it to the ForceSubClaims field.
func (o *AuthMethodCreateKerberos) SetForceSubClaims(v bool) {
	o.ForceSubClaims = &v
}

// GetGroupAttr returns the GroupAttr field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetGroupAttr() string {
	if o == nil || o.GroupAttr == nil {
		var ret string
		return ret
	}
	return *o.GroupAttr
}

// GetGroupAttrOk returns a tuple with the GroupAttr field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetGroupAttrOk() (*string, bool) {
	if o == nil || o.GroupAttr == nil {
		return nil, false
	}
	return o.GroupAttr, true
}

// HasGroupAttr returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasGroupAttr() bool {
	if o != nil && o.GroupAttr != nil {
		return true
	}

	return false
}

// SetGroupAttr gets a reference to the given string and assigns it to the GroupAttr field.
func (o *AuthMethodCreateKerberos) SetGroupAttr(v string) {
	o.GroupAttr = &v
}

// GetGroupDn returns the GroupDn field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetGroupDn() string {
	if o == nil || o.GroupDn == nil {
		var ret string
		return ret
	}
	return *o.GroupDn
}

// GetGroupDnOk returns a tuple with the GroupDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetGroupDnOk() (*string, bool) {
	if o == nil || o.GroupDn == nil {
		return nil, false
	}
	return o.GroupDn, true
}

// HasGroupDn returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasGroupDn() bool {
	if o != nil && o.GroupDn != nil {
		return true
	}

	return false
}

// SetGroupDn gets a reference to the given string and assigns it to the GroupDn field.
func (o *AuthMethodCreateKerberos) SetGroupDn(v string) {
	o.GroupDn = &v
}

// GetGroupFilter returns the GroupFilter field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetGroupFilter() string {
	if o == nil || o.GroupFilter == nil {
		var ret string
		return ret
	}
	return *o.GroupFilter
}

// GetGroupFilterOk returns a tuple with the GroupFilter field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetGroupFilterOk() (*string, bool) {
	if o == nil || o.GroupFilter == nil {
		return nil, false
	}
	return o.GroupFilter, true
}

// HasGroupFilter returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasGroupFilter() bool {
	if o != nil && o.GroupFilter != nil {
		return true
	}

	return false
}

// SetGroupFilter gets a reference to the given string and assigns it to the GroupFilter field.
func (o *AuthMethodCreateKerberos) SetGroupFilter(v string) {
	o.GroupFilter = &v
}

// GetGwBoundIps returns the GwBoundIps field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetGwBoundIps() []string {
	if o == nil || o.GwBoundIps == nil {
		var ret []string
		return ret
	}
	return *o.GwBoundIps
}

// GetGwBoundIpsOk returns a tuple with the GwBoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetGwBoundIpsOk() (*[]string, bool) {
	if o == nil || o.GwBoundIps == nil {
		return nil, false
	}
	return o.GwBoundIps, true
}

// HasGwBoundIps returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasGwBoundIps() bool {
	if o != nil && o.GwBoundIps != nil {
		return true
	}

	return false
}

// SetGwBoundIps gets a reference to the given []string and assigns it to the GwBoundIps field.
func (o *AuthMethodCreateKerberos) SetGwBoundIps(v []string) {
	o.GwBoundIps = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *AuthMethodCreateKerberos) SetJson(v bool) {
	o.Json = &v
}

// GetJwtTtl returns the JwtTtl field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetJwtTtl() int64 {
	if o == nil || o.JwtTtl == nil {
		var ret int64
		return ret
	}
	return *o.JwtTtl
}

// GetJwtTtlOk returns a tuple with the JwtTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetJwtTtlOk() (*int64, bool) {
	if o == nil || o.JwtTtl == nil {
		return nil, false
	}
	return o.JwtTtl, true
}

// HasJwtTtl returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasJwtTtl() bool {
	if o != nil && o.JwtTtl != nil {
		return true
	}

	return false
}

// SetJwtTtl gets a reference to the given int64 and assigns it to the JwtTtl field.
func (o *AuthMethodCreateKerberos) SetJwtTtl(v int64) {
	o.JwtTtl = &v
}

// GetKeytabFileData returns the KeytabFileData field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetKeytabFileData() string {
	if o == nil || o.KeytabFileData == nil {
		var ret string
		return ret
	}
	return *o.KeytabFileData
}

// GetKeytabFileDataOk returns a tuple with the KeytabFileData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetKeytabFileDataOk() (*string, bool) {
	if o == nil || o.KeytabFileData == nil {
		return nil, false
	}
	return o.KeytabFileData, true
}

// HasKeytabFileData returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasKeytabFileData() bool {
	if o != nil && o.KeytabFileData != nil {
		return true
	}

	return false
}

// SetKeytabFileData gets a reference to the given string and assigns it to the KeytabFileData field.
func (o *AuthMethodCreateKerberos) SetKeytabFileData(v string) {
	o.KeytabFileData = &v
}

// GetKeytabFilePath returns the KeytabFilePath field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetKeytabFilePath() string {
	if o == nil || o.KeytabFilePath == nil {
		var ret string
		return ret
	}
	return *o.KeytabFilePath
}

// GetKeytabFilePathOk returns a tuple with the KeytabFilePath field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetKeytabFilePathOk() (*string, bool) {
	if o == nil || o.KeytabFilePath == nil {
		return nil, false
	}
	return o.KeytabFilePath, true
}

// HasKeytabFilePath returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasKeytabFilePath() bool {
	if o != nil && o.KeytabFilePath != nil {
		return true
	}

	return false
}

// SetKeytabFilePath gets a reference to the given string and assigns it to the KeytabFilePath field.
func (o *AuthMethodCreateKerberos) SetKeytabFilePath(v string) {
	o.KeytabFilePath = &v
}

// GetKrb5ConfData returns the Krb5ConfData field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetKrb5ConfData() string {
	if o == nil || o.Krb5ConfData == nil {
		var ret string
		return ret
	}
	return *o.Krb5ConfData
}

// GetKrb5ConfDataOk returns a tuple with the Krb5ConfData field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetKrb5ConfDataOk() (*string, bool) {
	if o == nil || o.Krb5ConfData == nil {
		return nil, false
	}
	return o.Krb5ConfData, true
}

// HasKrb5ConfData returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasKrb5ConfData() bool {
	if o != nil && o.Krb5ConfData != nil {
		return true
	}

	return false
}

// SetKrb5ConfData gets a reference to the given string and assigns it to the Krb5ConfData field.
func (o *AuthMethodCreateKerberos) SetKrb5ConfData(v string) {
	o.Krb5ConfData = &v
}

// GetKrb5ConfPath returns the Krb5ConfPath field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetKrb5ConfPath() string {
	if o == nil || o.Krb5ConfPath == nil {
		var ret string
		return ret
	}
	return *o.Krb5ConfPath
}

// GetKrb5ConfPathOk returns a tuple with the Krb5ConfPath field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetKrb5ConfPathOk() (*string, bool) {
	if o == nil || o.Krb5ConfPath == nil {
		return nil, false
	}
	return o.Krb5ConfPath, true
}

// HasKrb5ConfPath returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasKrb5ConfPath() bool {
	if o != nil && o.Krb5ConfPath != nil {
		return true
	}

	return false
}

// SetKrb5ConfPath gets a reference to the given string and assigns it to the Krb5ConfPath field.
func (o *AuthMethodCreateKerberos) SetKrb5ConfPath(v string) {
	o.Krb5ConfPath = &v
}

// GetLdapAnonymousSearch returns the LdapAnonymousSearch field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetLdapAnonymousSearch() bool {
	if o == nil || o.LdapAnonymousSearch == nil {
		var ret bool
		return ret
	}
	return *o.LdapAnonymousSearch
}

// GetLdapAnonymousSearchOk returns a tuple with the LdapAnonymousSearch field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetLdapAnonymousSearchOk() (*bool, bool) {
	if o == nil || o.LdapAnonymousSearch == nil {
		return nil, false
	}
	return o.LdapAnonymousSearch, true
}

// HasLdapAnonymousSearch returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasLdapAnonymousSearch() bool {
	if o != nil && o.LdapAnonymousSearch != nil {
		return true
	}

	return false
}

// SetLdapAnonymousSearch gets a reference to the given bool and assigns it to the LdapAnonymousSearch field.
func (o *AuthMethodCreateKerberos) SetLdapAnonymousSearch(v bool) {
	o.LdapAnonymousSearch = &v
}

// GetLdapCaCert returns the LdapCaCert field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetLdapCaCert() string {
	if o == nil || o.LdapCaCert == nil {
		var ret string
		return ret
	}
	return *o.LdapCaCert
}

// GetLdapCaCertOk returns a tuple with the LdapCaCert field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetLdapCaCertOk() (*string, bool) {
	if o == nil || o.LdapCaCert == nil {
		return nil, false
	}
	return o.LdapCaCert, true
}

// HasLdapCaCert returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasLdapCaCert() bool {
	if o != nil && o.LdapCaCert != nil {
		return true
	}

	return false
}

// SetLdapCaCert gets a reference to the given string and assigns it to the LdapCaCert field.
func (o *AuthMethodCreateKerberos) SetLdapCaCert(v string) {
	o.LdapCaCert = &v
}

// GetLdapUrl returns the LdapUrl field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetLdapUrl() string {
	if o == nil || o.LdapUrl == nil {
		var ret string
		return ret
	}
	return *o.LdapUrl
}

// GetLdapUrlOk returns a tuple with the LdapUrl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetLdapUrlOk() (*string, bool) {
	if o == nil || o.LdapUrl == nil {
		return nil, false
	}
	return o.LdapUrl, true
}

// HasLdapUrl returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasLdapUrl() bool {
	if o != nil && o.LdapUrl != nil {
		return true
	}

	return false
}

// SetLdapUrl gets a reference to the given string and assigns it to the LdapUrl field.
func (o *AuthMethodCreateKerberos) SetLdapUrl(v string) {
	o.LdapUrl = &v
}

// GetName returns the Name field value
func (o *AuthMethodCreateKerberos) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *AuthMethodCreateKerberos) SetName(v string) {
	o.Name = v
}

// GetProductType returns the ProductType field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetProductType() []string {
	if o == nil || o.ProductType == nil {
		var ret []string
		return ret
	}
	return *o.ProductType
}

// GetProductTypeOk returns a tuple with the ProductType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetProductTypeOk() (*[]string, bool) {
	if o == nil || o.ProductType == nil {
		return nil, false
	}
	return o.ProductType, true
}

// HasProductType returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasProductType() bool {
	if o != nil && o.ProductType != nil {
		return true
	}

	return false
}

// SetProductType gets a reference to the given []string and assigns it to the ProductType field.
func (o *AuthMethodCreateKerberos) SetProductType(v []string) {
	o.ProductType = &v
}

// GetSubclaimsDelimiters returns the SubclaimsDelimiters field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetSubclaimsDelimiters() []string {
	if o == nil || o.SubclaimsDelimiters == nil {
		var ret []string
		return ret
	}
	return *o.SubclaimsDelimiters
}

// GetSubclaimsDelimitersOk returns a tuple with the SubclaimsDelimiters field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetSubclaimsDelimitersOk() (*[]string, bool) {
	if o == nil || o.SubclaimsDelimiters == nil {
		return nil, false
	}
	return o.SubclaimsDelimiters, true
}

// HasSubclaimsDelimiters returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasSubclaimsDelimiters() bool {
	if o != nil && o.SubclaimsDelimiters != nil {
		return true
	}

	return false
}

// SetSubclaimsDelimiters gets a reference to the given []string and assigns it to the SubclaimsDelimiters field.
func (o *AuthMethodCreateKerberos) SetSubclaimsDelimiters(v []string) {
	o.SubclaimsDelimiters = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *AuthMethodCreateKerberos) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *AuthMethodCreateKerberos) SetUidToken(v string) {
	o.UidToken = &v
}

// GetUniqueIdentifier returns the UniqueIdentifier field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetUniqueIdentifier() string {
	if o == nil || o.UniqueIdentifier == nil {
		var ret string
		return ret
	}
	return *o.UniqueIdentifier
}

// GetUniqueIdentifierOk returns a tuple with the UniqueIdentifier field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetUniqueIdentifierOk() (*string, bool) {
	if o == nil || o.UniqueIdentifier == nil {
		return nil, false
	}
	return o.UniqueIdentifier, true
}

// HasUniqueIdentifier returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasUniqueIdentifier() bool {
	if o != nil && o.UniqueIdentifier != nil {
		return true
	}

	return false
}

// SetUniqueIdentifier gets a reference to the given string and assigns it to the UniqueIdentifier field.
func (o *AuthMethodCreateKerberos) SetUniqueIdentifier(v string) {
	o.UniqueIdentifier = &v
}

// GetUserAttribute returns the UserAttribute field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetUserAttribute() string {
	if o == nil || o.UserAttribute == nil {
		var ret string
		return ret
	}
	return *o.UserAttribute
}

// GetUserAttributeOk returns a tuple with the UserAttribute field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetUserAttributeOk() (*string, bool) {
	if o == nil || o.UserAttribute == nil {
		return nil, false
	}
	return o.UserAttribute, true
}

// HasUserAttribute returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasUserAttribute() bool {
	if o != nil && o.UserAttribute != nil {
		return true
	}

	return false
}

// SetUserAttribute gets a reference to the given string and assigns it to the UserAttribute field.
func (o *AuthMethodCreateKerberos) SetUserAttribute(v string) {
	o.UserAttribute = &v
}

// GetUserDn returns the UserDn field value if set, zero value otherwise.
func (o *AuthMethodCreateKerberos) GetUserDn() string {
	if o == nil || o.UserDn == nil {
		var ret string
		return ret
	}
	return *o.UserDn
}

// GetUserDnOk returns a tuple with the UserDn field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *AuthMethodCreateKerberos) GetUserDnOk() (*string, bool) {
	if o == nil || o.UserDn == nil {
		return nil, false
	}
	return o.UserDn, true
}

// HasUserDn returns a boolean if a field has been set.
func (o *AuthMethodCreateKerberos) HasUserDn() bool {
	if o != nil && o.UserDn != nil {
		return true
	}

	return false
}

// SetUserDn gets a reference to the given string and assigns it to the UserDn field.
func (o *AuthMethodCreateKerberos) SetUserDn(v string) {
	o.UserDn = &v
}

func (o AuthMethodCreateKerberos) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessExpires != nil {
		toSerialize["access-expires"] = o.AccessExpires
	}
	if o.AuditLogsClaims != nil {
		toSerialize["audit-logs-claims"] = o.AuditLogsClaims
	}
	if o.BindDn != nil {
		toSerialize["bind-dn"] = o.BindDn
	}
	if o.BindDnPassword != nil {
		toSerialize["bind-dn-password"] = o.BindDnPassword
	}
	if o.BoundIps != nil {
		toSerialize["bound-ips"] = o.BoundIps
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.ForceSubClaims != nil {
		toSerialize["force-sub-claims"] = o.ForceSubClaims
	}
	if o.GroupAttr != nil {
		toSerialize["group-attr"] = o.GroupAttr
	}
	if o.GroupDn != nil {
		toSerialize["group-dn"] = o.GroupDn
	}
	if o.GroupFilter != nil {
		toSerialize["group-filter"] = o.GroupFilter
	}
	if o.GwBoundIps != nil {
		toSerialize["gw-bound-ips"] = o.GwBoundIps
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.JwtTtl != nil {
		toSerialize["jwt-ttl"] = o.JwtTtl
	}
	if o.KeytabFileData != nil {
		toSerialize["keytab-file-data"] = o.KeytabFileData
	}
	if o.KeytabFilePath != nil {
		toSerialize["keytab-file-path"] = o.KeytabFilePath
	}
	if o.Krb5ConfData != nil {
		toSerialize["krb5-conf-data"] = o.Krb5ConfData
	}
	if o.Krb5ConfPath != nil {
		toSerialize["krb5-conf-path"] = o.Krb5ConfPath
	}
	if o.LdapAnonymousSearch != nil {
		toSerialize["ldap-anonymous-search"] = o.LdapAnonymousSearch
	}
	if o.LdapCaCert != nil {
		toSerialize["ldap-ca-cert"] = o.LdapCaCert
	}
	if o.LdapUrl != nil {
		toSerialize["ldap-url"] = o.LdapUrl
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.ProductType != nil {
		toSerialize["product-type"] = o.ProductType
	}
	if o.SubclaimsDelimiters != nil {
		toSerialize["subclaims-delimiters"] = o.SubclaimsDelimiters
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if o.UniqueIdentifier != nil {
		toSerialize["unique-identifier"] = o.UniqueIdentifier
	}
	if o.UserAttribute != nil {
		toSerialize["user-attribute"] = o.UserAttribute
	}
	if o.UserDn != nil {
		toSerialize["user-dn"] = o.UserDn
	}
	return json.Marshal(toSerialize)
}

type NullableAuthMethodCreateKerberos struct {
	value *AuthMethodCreateKerberos
	isSet bool
}

func (v NullableAuthMethodCreateKerberos) Get() *AuthMethodCreateKerberos {
	return v.value
}

func (v *NullableAuthMethodCreateKerberos) Set(val *AuthMethodCreateKerberos) {
	v.value = val
	v.isSet = true
}

func (v NullableAuthMethodCreateKerberos) IsSet() bool {
	return v.isSet
}

func (v *NullableAuthMethodCreateKerberos) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAuthMethodCreateKerberos(val *AuthMethodCreateKerberos) *NullableAuthMethodCreateKerberos {
	return &NullableAuthMethodCreateKerberos{value: val, isSet: true}
}

func (v NullableAuthMethodCreateKerberos) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAuthMethodCreateKerberos) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


