;; Tests for f32x4 arithmetic operations on major boundary values and all special values.


(module
  (func (export "f32x4.add") (param v128 v128) (result v128) (f32x4.add (local.get 0) (local.get 1)))
  (func (export "f32x4.sub") (param v128 v128) (result v128) (f32x4.sub (local.get 0) (local.get 1)))
  (func (export "f32x4.mul") (param v128 v128) (result v128) (f32x4.mul (local.get 0) (local.get 1)))
  (func (export "f32x4.div") (param v128 v128) (result v128) (f32x4.div (local.get 0) (local.get 1)))
  (func (export "f32x4.neg") (param v128) (result v128) (f32x4.neg (local.get 0)))
  (func (export "f32x4.sqrt") (param v128) (result v128) (f32x4.sqrt (local.get 0)))
)

(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-148 0x1.0000000000000p-148 0x1.0000000000000p-148 0x1.0000000000000p-148))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000020000000p-126 0x1.0000020000000p-126 0x1.0000020000000p-126 0x1.0000020000000p-126))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.fffffc0000000p-127 -0x1.fffffc0000000p-127 -0x1.fffffc0000000p-127 -0x1.fffffc0000000p-127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-148 -0x1.0000000000000p-148 -0x1.0000000000000p-148 -0x1.0000000000000p-148))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.fffffc0000000p-127 0x1.fffffc0000000p-127 0x1.fffffc0000000p-127 0x1.fffffc0000000p-127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000020000000p-126 -0x1.0000020000000p-126 -0x1.0000020000000p-126 -0x1.0000020000000p-126))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000020000000p-126 0x1.0000020000000p-126 0x1.0000020000000p-126 0x1.0000020000000p-126))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.fffffc0000000p-127 0x1.fffffc0000000p-127 0x1.fffffc0000000p-127 0x1.fffffc0000000p-127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-125 0x1.0000000000000p-125 0x1.0000000000000p-125 0x1.0000000000000p-125))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.fffffc0000000p-127 -0x1.fffffc0000000p-127 -0x1.fffffc0000000p-127 -0x1.fffffc0000000p-127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000020000000p-126 -0x1.0000020000000p-126 -0x1.0000020000000p-126 -0x1.0000020000000p-126))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-125 -0x1.0000000000000p-125 -0x1.0000000000000p-125 -0x1.0000000000000p-125))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.8000000000000p+0 0x1.8000000000000p+0 0x1.8000000000000p+0 0x1.8000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.b21fb60000000p+2 0x1.b21fb60000000p+2 0x1.b21fb60000000p+2 0x1.b21fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.721fb60000000p+2 -0x1.721fb60000000p+2 -0x1.721fb60000000p+2 -0x1.721fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.8000000000000p+0 -0x1.8000000000000p+0 -0x1.8000000000000p+0 -0x1.8000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.721fb60000000p+2 0x1.721fb60000000p+2 0x1.721fb60000000p+2 0x1.721fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.b21fb60000000p+2 -0x1.b21fb60000000p+2 -0x1.b21fb60000000p+2 -0x1.b21fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.8000000000000p+0 0x1.8000000000000p+0 0x1.8000000000000p+0 0x1.8000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+1 0x1.0000000000000p+1 0x1.0000000000000p+1 0x1.0000000000000p+1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.d21fb60000000p+2 0x1.d21fb60000000p+2 0x1.d21fb60000000p+2 0x1.d21fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.521fb60000000p+2 -0x1.521fb60000000p+2 -0x1.521fb60000000p+2 -0x1.521fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.8000000000000p+0 -0x1.8000000000000p+0 -0x1.8000000000000p+0 -0x1.8000000000000p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+1 -0x1.0000000000000p+1 -0x1.0000000000000p+1 -0x1.0000000000000p+1))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.521fb60000000p+2 0x1.521fb60000000p+2 0x1.521fb60000000p+2 0x1.521fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.d21fb60000000p+2 -0x1.d21fb60000000p+2 -0x1.d21fb60000000p+2 -0x1.d21fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.b21fb60000000p+2 0x1.b21fb60000000p+2 0x1.b21fb60000000p+2 0x1.b21fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.721fb60000000p+2 0x1.721fb60000000p+2 0x1.721fb60000000p+2 0x1.721fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.d21fb60000000p+2 0x1.d21fb60000000p+2 0x1.d21fb60000000p+2 0x1.d21fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.521fb60000000p+2 0x1.521fb60000000p+2 0x1.521fb60000000p+2 0x1.521fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+3 0x1.921fb60000000p+3 0x1.921fb60000000p+3 0x1.921fb60000000p+3))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.721fb60000000p+2 -0x1.721fb60000000p+2 -0x1.721fb60000000p+2 -0x1.721fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.b21fb60000000p+2 -0x1.b21fb60000000p+2 -0x1.b21fb60000000p+2 -0x1.b21fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.521fb60000000p+2 -0x1.521fb60000000p+2 -0x1.521fb60000000p+2 -0x1.521fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.d21fb60000000p+2 -0x1.d21fb60000000p+2 -0x1.d21fb60000000p+2 -0x1.d21fb60000000p+2))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+3 -0x1.921fb60000000p+3 -0x1.921fb60000000p+3 -0x1.921fb60000000p+3))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                   (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                   (v128.const f32x4 246913578.0 246913578.0 246913578.0 246913578.0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 2.46913578e+27 2.46913578e+27 2.46913578e+27 2.46913578e+27))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                   (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                   (v128.const f32x4 2.46913578e+27 2.46913578e+27 2.46913578e+27 2.46913578e+27))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 2.46913578e-11 2.46913578e-11 2.46913578e-11 2.46913578e-11))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                   (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                   (v128.const f32x4 246913578.0 246913578.0 246913578.0 246913578.0))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 2.46913578e+27 2.46913578e+27 2.46913578e+27 2.46913578e+27))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 2.46913578e+27 2.46913578e+27 2.46913578e+27 2.46913578e+27))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                   (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                   (v128.const f32x4 2.46913578e-11 2.46913578e-11 2.46913578e-11 2.46913578e-11))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                   (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                   (v128.const f32x4 246913578.02469134 246913578.02469134 246913578.02469134 246913578.02469134))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                   (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                   (v128.const f32x4 2.4691357802469137e+27 2.4691357802469137e+27 2.4691357802469137e+27 2.4691357802469137e+27))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                   (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                   (v128.const f32x4 2.4691357802469137e+27 2.4691357802469137e+27 2.4691357802469137e+27 2.4691357802469137e+27))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                   (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                   (v128.const f32x4 2.4691357802469137e-11 2.4691357802469137e-11 2.4691357802469137e-11 2.4691357802469137e-11))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                   (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                   (v128.const f32x4 0x1.23456789abcdfp+57 0x1.23456789abcdfp+57 0x1.23456789abcdfp+57 0x1.23456789abcdfp+57))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                   (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                   (v128.const f32x4 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                   (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                   (v128.const f32x4 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                   (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                   (v128.const f32x4 0x1.23456789abcdfp+38 0x1.23456789abcdfp+38 0x1.23456789abcdfp+38 0x1.23456789abcdfp+38))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                   (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                   (v128.const f32x4 0x1.23456789abcdfp+57 0x1.23456789abcdfp+57 0x1.23456789abcdfp+57 0x1.23456789abcdfp+57))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                   (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                   (v128.const f32x4 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                   (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                   (v128.const f32x4 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                   (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                   (v128.const f32x4 0x1.23456789abcdfp+38 0x1.23456789abcdfp+38 0x1.23456789abcdfp+38 0x1.23456789abcdfp+38))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                   (v128.const f32x4 0x1.23456789abcdfp+57 0x1.23456789abcdfp+57 0x1.23456789abcdfp+57 0x1.23456789abcdfp+57))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                   (v128.const f32x4 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                   (v128.const f32x4 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76 0x1.23456789abcdfp+76))
(assert_return (invoke "f32x4.add" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                   (v128.const f32x4 0x1.23456789abcdfp+38 0x1.23456789abcdfp+38 0x1.23456789abcdfp+38 0x1.23456789abcdfp+38))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-148 0x1.0000000000000p-148 0x1.0000000000000p-148 0x1.0000000000000p-148))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.fffffc0000000p-127 -0x1.fffffc0000000p-127 -0x1.fffffc0000000p-127 -0x1.fffffc0000000p-127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000020000000p-126 0x1.0000020000000p-126 0x1.0000020000000p-126 0x1.0000020000000p-126))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-148 -0x1.0000000000000p-148 -0x1.0000000000000p-148 -0x1.0000000000000p-148))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000020000000p-126 -0x1.0000020000000p-126 -0x1.0000020000000p-126 -0x1.0000020000000p-126))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.fffffc0000000p-127 0x1.fffffc0000000p-127 0x1.fffffc0000000p-127 0x1.fffffc0000000p-127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.fffffc0000000p-127 0x1.fffffc0000000p-127 0x1.fffffc0000000p-127 0x1.fffffc0000000p-127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000020000000p-126 0x1.0000020000000p-126 0x1.0000020000000p-126 0x1.0000020000000p-126))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-125 0x1.0000000000000p-125 0x1.0000000000000p-125 0x1.0000000000000p-125))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000020000000p-126 -0x1.0000020000000p-126 -0x1.0000020000000p-126 -0x1.0000020000000p-126))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.fffffc0000000p-127 -0x1.fffffc0000000p-127 -0x1.fffffc0000000p-127 -0x1.fffffc0000000p-127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-125 -0x1.0000000000000p-125 -0x1.0000000000000p-125 -0x1.0000000000000p-125))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.8000000000000p+0 0x1.8000000000000p+0 0x1.8000000000000p+0 0x1.8000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.721fb60000000p+2 -0x1.721fb60000000p+2 -0x1.721fb60000000p+2 -0x1.721fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.b21fb60000000p+2 0x1.b21fb60000000p+2 0x1.b21fb60000000p+2 0x1.b21fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.8000000000000p+0 -0x1.8000000000000p+0 -0x1.8000000000000p+0 -0x1.8000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.b21fb60000000p+2 -0x1.b21fb60000000p+2 -0x1.b21fb60000000p+2 -0x1.b21fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.721fb60000000p+2 0x1.721fb60000000p+2 0x1.721fb60000000p+2 0x1.721fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.8000000000000p+0 0x1.8000000000000p+0 0x1.8000000000000p+0 0x1.8000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+1 0x1.0000000000000p+1 0x1.0000000000000p+1 0x1.0000000000000p+1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.521fb60000000p+2 -0x1.521fb60000000p+2 -0x1.521fb60000000p+2 -0x1.521fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.d21fb60000000p+2 0x1.d21fb60000000p+2 0x1.d21fb60000000p+2 0x1.d21fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.8000000000000p+0 -0x1.8000000000000p+0 -0x1.8000000000000p+0 -0x1.8000000000000p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+1 -0x1.0000000000000p+1 -0x1.0000000000000p+1 -0x1.0000000000000p+1))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.d21fb60000000p+2 -0x1.d21fb60000000p+2 -0x1.d21fb60000000p+2 -0x1.d21fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.521fb60000000p+2 0x1.521fb60000000p+2 0x1.521fb60000000p+2 0x1.521fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.721fb60000000p+2 0x1.721fb60000000p+2 0x1.721fb60000000p+2 0x1.721fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.b21fb60000000p+2 0x1.b21fb60000000p+2 0x1.b21fb60000000p+2 0x1.b21fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.521fb60000000p+2 0x1.521fb60000000p+2 0x1.521fb60000000p+2 0x1.521fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.d21fb60000000p+2 0x1.d21fb60000000p+2 0x1.d21fb60000000p+2 0x1.d21fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+3 0x1.921fb60000000p+3 0x1.921fb60000000p+3 0x1.921fb60000000p+3))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.b21fb60000000p+2 -0x1.b21fb60000000p+2 -0x1.b21fb60000000p+2 -0x1.b21fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.721fb60000000p+2 -0x1.721fb60000000p+2 -0x1.721fb60000000p+2 -0x1.721fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.d21fb60000000p+2 -0x1.d21fb60000000p+2 -0x1.d21fb60000000p+2 -0x1.d21fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.521fb60000000p+2 -0x1.521fb60000000p+2 -0x1.521fb60000000p+2 -0x1.521fb60000000p+2))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+3 -0x1.921fb60000000p+3 -0x1.921fb60000000p+3 -0x1.921fb60000000p+3))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                   (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                   (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                   (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                   (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                   (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                   (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                   (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                   (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                   (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                   (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                   (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                   (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                   (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                   (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                   (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                   (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                   (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                   (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                   (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                   (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                   (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                   (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                   (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                   (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sub" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-298 0x1.0000000000000p-298 0x1.0000000000000p-298 0x1.0000000000000p-298))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-298 -0x1.0000000000000p-298 -0x1.0000000000000p-298 -0x1.0000000000000p-298))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-275 0x1.0000000000000p-275 0x1.0000000000000p-275 0x1.0000000000000p-275))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-275 -0x1.0000000000000p-275 -0x1.0000000000000p-275 -0x1.0000000000000p-275))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-150 0x1.0000000000000p-150 0x1.0000000000000p-150 0x1.0000000000000p-150))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-150 -0x1.0000000000000p-150 -0x1.0000000000000p-150 -0x1.0000000000000p-150))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p-147 0x1.921fb60000000p-147 0x1.921fb60000000p-147 0x1.921fb60000000p-147))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p-147 -0x1.921fb60000000p-147 -0x1.921fb60000000p-147 -0x1.921fb60000000p-147))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p-22 0x1.fffffe0000000p-22 0x1.fffffe0000000p-22 0x1.fffffe0000000p-22))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p-22 -0x1.fffffe0000000p-22 -0x1.fffffe0000000p-22 -0x1.fffffe0000000p-22))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-298 -0x1.0000000000000p-298 -0x1.0000000000000p-298 -0x1.0000000000000p-298))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-298 0x1.0000000000000p-298 0x1.0000000000000p-298 0x1.0000000000000p-298))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-275 -0x1.0000000000000p-275 -0x1.0000000000000p-275 -0x1.0000000000000p-275))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-275 0x1.0000000000000p-275 0x1.0000000000000p-275 0x1.0000000000000p-275))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-150 -0x1.0000000000000p-150 -0x1.0000000000000p-150 -0x1.0000000000000p-150))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-150 0x1.0000000000000p-150 0x1.0000000000000p-150 0x1.0000000000000p-150))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p-147 -0x1.921fb60000000p-147 -0x1.921fb60000000p-147 -0x1.921fb60000000p-147))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p-147 0x1.921fb60000000p-147 0x1.921fb60000000p-147 0x1.921fb60000000p-147))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p-22 -0x1.fffffe0000000p-22 -0x1.fffffe0000000p-22 -0x1.fffffe0000000p-22))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p-22 0x1.fffffe0000000p-22 0x1.fffffe0000000p-22 0x1.fffffe0000000p-22))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-275 0x1.0000000000000p-275 0x1.0000000000000p-275 0x1.0000000000000p-275))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-275 -0x1.0000000000000p-275 -0x1.0000000000000p-275 -0x1.0000000000000p-275))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-252 0x1.0000000000000p-252 0x1.0000000000000p-252 0x1.0000000000000p-252))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-252 -0x1.0000000000000p-252 -0x1.0000000000000p-252 -0x1.0000000000000p-252))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-127 0x1.0000000000000p-127 0x1.0000000000000p-127 0x1.0000000000000p-127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-127 -0x1.0000000000000p-127 -0x1.0000000000000p-127 -0x1.0000000000000p-127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p-124 0x1.921fb60000000p-124 0x1.921fb60000000p-124 0x1.921fb60000000p-124))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p-124 -0x1.921fb60000000p-124 -0x1.921fb60000000p-124 -0x1.921fb60000000p-124))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+1 0x1.fffffe0000000p+1 0x1.fffffe0000000p+1 0x1.fffffe0000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+1 -0x1.fffffe0000000p+1 -0x1.fffffe0000000p+1 -0x1.fffffe0000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-275 -0x1.0000000000000p-275 -0x1.0000000000000p-275 -0x1.0000000000000p-275))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-275 0x1.0000000000000p-275 0x1.0000000000000p-275 0x1.0000000000000p-275))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-252 -0x1.0000000000000p-252 -0x1.0000000000000p-252 -0x1.0000000000000p-252))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-252 0x1.0000000000000p-252 0x1.0000000000000p-252 0x1.0000000000000p-252))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-127 -0x1.0000000000000p-127 -0x1.0000000000000p-127 -0x1.0000000000000p-127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-127 0x1.0000000000000p-127 0x1.0000000000000p-127 0x1.0000000000000p-127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p-124 -0x1.921fb60000000p-124 -0x1.921fb60000000p-124 -0x1.921fb60000000p-124))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p-124 0x1.921fb60000000p-124 0x1.921fb60000000p-124 0x1.921fb60000000p-124))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+1 -0x1.fffffe0000000p+1 -0x1.fffffe0000000p+1 -0x1.fffffe0000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+1 0x1.fffffe0000000p+1 0x1.fffffe0000000p+1 0x1.fffffe0000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-150 0x1.0000000000000p-150 0x1.0000000000000p-150 0x1.0000000000000p-150))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-150 -0x1.0000000000000p-150 -0x1.0000000000000p-150 -0x1.0000000000000p-150))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-127 0x1.0000000000000p-127 0x1.0000000000000p-127 0x1.0000000000000p-127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-127 -0x1.0000000000000p-127 -0x1.0000000000000p-127 -0x1.0000000000000p-127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-2 0x1.0000000000000p-2 0x1.0000000000000p-2 0x1.0000000000000p-2))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-2 -0x1.0000000000000p-2 -0x1.0000000000000p-2 -0x1.0000000000000p-2))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+1 0x1.921fb60000000p+1 0x1.921fb60000000p+1 0x1.921fb60000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+1 -0x1.921fb60000000p+1 -0x1.921fb60000000p+1 -0x1.921fb60000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+126 0x1.fffffe0000000p+126 0x1.fffffe0000000p+126 0x1.fffffe0000000p+126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+126 -0x1.fffffe0000000p+126 -0x1.fffffe0000000p+126 -0x1.fffffe0000000p+126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-150 -0x1.0000000000000p-150 -0x1.0000000000000p-150 -0x1.0000000000000p-150))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-150 0x1.0000000000000p-150 0x1.0000000000000p-150 0x1.0000000000000p-150))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-127 -0x1.0000000000000p-127 -0x1.0000000000000p-127 -0x1.0000000000000p-127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-127 0x1.0000000000000p-127 0x1.0000000000000p-127 0x1.0000000000000p-127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-2 -0x1.0000000000000p-2 -0x1.0000000000000p-2 -0x1.0000000000000p-2))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-2 0x1.0000000000000p-2 0x1.0000000000000p-2 0x1.0000000000000p-2))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+1 -0x1.921fb60000000p+1 -0x1.921fb60000000p+1 -0x1.921fb60000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+1 0x1.921fb60000000p+1 0x1.921fb60000000p+1 0x1.921fb60000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+126 -0x1.fffffe0000000p+126 -0x1.fffffe0000000p+126 -0x1.fffffe0000000p+126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+126 0x1.fffffe0000000p+126 0x1.fffffe0000000p+126 0x1.fffffe0000000p+126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.921fb60000000p-147 0x1.921fb60000000p-147 0x1.921fb60000000p-147 0x1.921fb60000000p-147))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.921fb60000000p-147 -0x1.921fb60000000p-147 -0x1.921fb60000000p-147 -0x1.921fb60000000p-147))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.921fb60000000p-124 0x1.921fb60000000p-124 0x1.921fb60000000p-124 0x1.921fb60000000p-124))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.921fb60000000p-124 -0x1.921fb60000000p-124 -0x1.921fb60000000p-124 -0x1.921fb60000000p-124))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.921fb60000000p+1 0x1.921fb60000000p+1 0x1.921fb60000000p+1 0x1.921fb60000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.921fb60000000p+1 -0x1.921fb60000000p+1 -0x1.921fb60000000p+1 -0x1.921fb60000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.3bd3cdc2cab20p+5 0x1.3bd3cdc2cab20p+5 0x1.3bd3cdc2cab20p+5 0x1.3bd3cdc2cab20p+5))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.3bd3cdc2cab20p+5 -0x1.3bd3cdc2cab20p+5 -0x1.3bd3cdc2cab20p+5 -0x1.3bd3cdc2cab20p+5))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.921fb60000000p-147 -0x1.921fb60000000p-147 -0x1.921fb60000000p-147 -0x1.921fb60000000p-147))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.921fb60000000p-147 0x1.921fb60000000p-147 0x1.921fb60000000p-147 0x1.921fb60000000p-147))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.921fb60000000p-124 -0x1.921fb60000000p-124 -0x1.921fb60000000p-124 -0x1.921fb60000000p-124))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.921fb60000000p-124 0x1.921fb60000000p-124 0x1.921fb60000000p-124 0x1.921fb60000000p-124))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.921fb60000000p+1 -0x1.921fb60000000p+1 -0x1.921fb60000000p+1 -0x1.921fb60000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.921fb60000000p+1 0x1.921fb60000000p+1 0x1.921fb60000000p+1 0x1.921fb60000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.3bd3cdc2cab20p+5 -0x1.3bd3cdc2cab20p+5 -0x1.3bd3cdc2cab20p+5 -0x1.3bd3cdc2cab20p+5))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.3bd3cdc2cab20p+5 0x1.3bd3cdc2cab20p+5 0x1.3bd3cdc2cab20p+5 0x1.3bd3cdc2cab20p+5))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.fffffe0000000p-22 0x1.fffffe0000000p-22 0x1.fffffe0000000p-22 0x1.fffffe0000000p-22))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.fffffe0000000p-22 -0x1.fffffe0000000p-22 -0x1.fffffe0000000p-22 -0x1.fffffe0000000p-22))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.fffffe0000000p+1 0x1.fffffe0000000p+1 0x1.fffffe0000000p+1 0x1.fffffe0000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.fffffe0000000p+1 -0x1.fffffe0000000p+1 -0x1.fffffe0000000p+1 -0x1.fffffe0000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.fffffe0000000p+126 0x1.fffffe0000000p+126 0x1.fffffe0000000p+126 0x1.fffffe0000000p+126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.fffffe0000000p+126 -0x1.fffffe0000000p+126 -0x1.fffffe0000000p+126 -0x1.fffffe0000000p+126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.fffffe0000000p-22 -0x1.fffffe0000000p-22 -0x1.fffffe0000000p-22 -0x1.fffffe0000000p-22))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.fffffe0000000p-22 0x1.fffffe0000000p-22 0x1.fffffe0000000p-22 0x1.fffffe0000000p-22))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.fffffe0000000p+1 -0x1.fffffe0000000p+1 -0x1.fffffe0000000p+1 -0x1.fffffe0000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.fffffe0000000p+1 0x1.fffffe0000000p+1 0x1.fffffe0000000p+1 0x1.fffffe0000000p+1))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.fffffe0000000p+126 -0x1.fffffe0000000p+126 -0x1.fffffe0000000p+126 -0x1.fffffe0000000p+126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.fffffe0000000p+126 0x1.fffffe0000000p+126 0x1.fffffe0000000p+126 0x1.fffffe0000000p+126))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                   (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                   (v128.const f32x4 1.5241579434344448e+16 1.5241579434344448e+16 1.5241579434344448e+16 1.5241579434344448e+16))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                   (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 1.5241579025420272e-22 1.5241579025420272e-22 1.5241579025420272e-22 1.5241579025420272e-22))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                   (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                   (v128.const f32x4 1.5241579434344448e+16 1.5241579434344448e+16 1.5241579434344448e+16 1.5241579434344448e+16))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                   (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                   (v128.const f32x4 1.5241579025420272e-22 1.5241579025420272e-22 1.5241579025420272e-22 1.5241579025420272e-22))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                   (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                   (v128.const f32x4 1.5241579434344448e+16 1.5241579434344448e+16 1.5241579434344448e+16 1.5241579434344448e+16))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                   (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                   (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                   (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                   (v128.const f32x4 1.5241579025420272e-22 1.5241579025420272e-22 1.5241579025420272e-22 1.5241579025420272e-22))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                   (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                   (v128.const f32x4 0x1.4b66de0000000p+112 0x1.4b66de0000000p+112 0x1.4b66de0000000p+112 0x1.4b66de0000000p+112))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                   (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                   (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                   (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                   (v128.const f32x4 0x1.4b66de0000000p+74 0x1.4b66de0000000p+74 0x1.4b66de0000000p+74 0x1.4b66de0000000p+74))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                   (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                   (v128.const f32x4 0x1.4b66de0000000p+112 0x1.4b66de0000000p+112 0x1.4b66de0000000p+112 0x1.4b66de0000000p+112))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                   (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                   (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                   (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                   (v128.const f32x4 0x1.4b66de0000000p+74 0x1.4b66de0000000p+74 0x1.4b66de0000000p+74 0x1.4b66de0000000p+74))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                   (v128.const f32x4 0x1.4b66de0000000p+112 0x1.4b66de0000000p+112 0x1.4b66de0000000p+112 0x1.4b66de0000000p+112))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.mul" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                   (v128.const f32x4 0x1.4b66de0000000p+74 0x1.4b66de0000000p+74 0x1.4b66de0000000p+74 0x1.4b66de0000000p+74))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-23 0x1.0000000000000p-23 0x1.0000000000000p-23 0x1.0000000000000p-23))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-23 -0x1.0000000000000p-23 -0x1.0000000000000p-23 -0x1.0000000000000p-23))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-148 0x1.0000000000000p-148 0x1.0000000000000p-148 0x1.0000000000000p-148))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-148 -0x1.0000000000000p-148 -0x1.0000000000000p-148 -0x1.0000000000000p-148))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.45f306446f9b4p-152 0x1.45f306446f9b4p-152 0x1.45f306446f9b4p-152 0x1.45f306446f9b4p-152))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.45f306446f9b4p-152 -0x1.45f306446f9b4p-152 -0x1.45f306446f9b4p-152 -0x1.45f306446f9b4p-152))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000010000010p-277 0x1.0000010000010p-277 0x1.0000010000010p-277 0x1.0000010000010p-277))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000010000010p-277 -0x1.0000010000010p-277 -0x1.0000010000010p-277 -0x1.0000010000010p-277))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-23 -0x1.0000000000000p-23 -0x1.0000000000000p-23 -0x1.0000000000000p-23))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-23 0x1.0000000000000p-23 0x1.0000000000000p-23 0x1.0000000000000p-23))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-148 -0x1.0000000000000p-148 -0x1.0000000000000p-148 -0x1.0000000000000p-148))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-148 0x1.0000000000000p-148 0x1.0000000000000p-148 0x1.0000000000000p-148))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.45f306446f9b4p-152 -0x1.45f306446f9b4p-152 -0x1.45f306446f9b4p-152 -0x1.45f306446f9b4p-152))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.45f306446f9b4p-152 0x1.45f306446f9b4p-152 0x1.45f306446f9b4p-152 0x1.45f306446f9b4p-152))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000010000010p-277 -0x1.0000010000010p-277 -0x1.0000010000010p-277 -0x1.0000010000010p-277))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000010000010p-277 0x1.0000010000010p-277 0x1.0000010000010p-277 0x1.0000010000010p-277))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p+23 0x1.0000000000000p+23 0x1.0000000000000p+23 0x1.0000000000000p+23))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p+23 -0x1.0000000000000p+23 -0x1.0000000000000p+23 -0x1.0000000000000p+23))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-125 0x1.0000000000000p-125 0x1.0000000000000p-125 0x1.0000000000000p-125))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-125 -0x1.0000000000000p-125 -0x1.0000000000000p-125 -0x1.0000000000000p-125))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.45f306446f9b4p-129 0x1.45f306446f9b4p-129 0x1.45f306446f9b4p-129 0x1.45f306446f9b4p-129))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.45f306446f9b4p-129 -0x1.45f306446f9b4p-129 -0x1.45f306446f9b4p-129 -0x1.45f306446f9b4p-129))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000010000010p-254 0x1.0000010000010p-254 0x1.0000010000010p-254 0x1.0000010000010p-254))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000010000010p-254 -0x1.0000010000010p-254 -0x1.0000010000010p-254 -0x1.0000010000010p-254))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p+23 -0x1.0000000000000p+23 -0x1.0000000000000p+23 -0x1.0000000000000p+23))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p+23 0x1.0000000000000p+23 0x1.0000000000000p+23 0x1.0000000000000p+23))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-125 -0x1.0000000000000p-125 -0x1.0000000000000p-125 -0x1.0000000000000p-125))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-125 0x1.0000000000000p-125 0x1.0000000000000p-125 0x1.0000000000000p-125))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.45f306446f9b4p-129 -0x1.45f306446f9b4p-129 -0x1.45f306446f9b4p-129 -0x1.45f306446f9b4p-129))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.45f306446f9b4p-129 0x1.45f306446f9b4p-129 0x1.45f306446f9b4p-129 0x1.45f306446f9b4p-129))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000010000010p-254 -0x1.0000010000010p-254 -0x1.0000010000010p-254 -0x1.0000010000010p-254))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000010000010p-254 0x1.0000010000010p-254 0x1.0000010000010p-254 0x1.0000010000010p-254))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p+125 0x1.0000000000000p+125 0x1.0000000000000p+125 0x1.0000000000000p+125))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p+125 -0x1.0000000000000p+125 -0x1.0000000000000p+125 -0x1.0000000000000p+125))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.45f306446f9b4p-4 0x1.45f306446f9b4p-4 0x1.45f306446f9b4p-4 0x1.45f306446f9b4p-4))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.45f306446f9b4p-4 -0x1.45f306446f9b4p-4 -0x1.45f306446f9b4p-4 -0x1.45f306446f9b4p-4))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000010000010p-129 0x1.0000010000010p-129 0x1.0000010000010p-129 0x1.0000010000010p-129))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000010000010p-129 -0x1.0000010000010p-129 -0x1.0000010000010p-129 -0x1.0000010000010p-129))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p+125 -0x1.0000000000000p+125 -0x1.0000000000000p+125 -0x1.0000000000000p+125))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p+125 0x1.0000000000000p+125 0x1.0000000000000p+125 0x1.0000000000000p+125))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.45f306446f9b4p-4 -0x1.45f306446f9b4p-4 -0x1.45f306446f9b4p-4 -0x1.45f306446f9b4p-4))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.45f306446f9b4p-4 0x1.45f306446f9b4p-4 0x1.45f306446f9b4p-4 0x1.45f306446f9b4p-4))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000010000010p-129 -0x1.0000010000010p-129 -0x1.0000010000010p-129 -0x1.0000010000010p-129))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000010000010p-129 0x1.0000010000010p-129 0x1.0000010000010p-129 0x1.0000010000010p-129))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p+126 0x1.0000000000000p+126 0x1.0000000000000p+126 0x1.0000000000000p+126))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p+126 -0x1.0000000000000p+126 -0x1.0000000000000p+126 -0x1.0000000000000p+126))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p+1 0x1.0000000000000p+1 0x1.0000000000000p+1 0x1.0000000000000p+1))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p+1 -0x1.0000000000000p+1 -0x1.0000000000000p+1 -0x1.0000000000000p+1))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.45f306446f9b4p-3 0x1.45f306446f9b4p-3 0x1.45f306446f9b4p-3 0x1.45f306446f9b4p-3))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.45f306446f9b4p-3 -0x1.45f306446f9b4p-3 -0x1.45f306446f9b4p-3 -0x1.45f306446f9b4p-3))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000010000010p-128 0x1.0000010000010p-128 0x1.0000010000010p-128 0x1.0000010000010p-128))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000010000010p-128 -0x1.0000010000010p-128 -0x1.0000010000010p-128 -0x1.0000010000010p-128))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p+126 -0x1.0000000000000p+126 -0x1.0000000000000p+126 -0x1.0000000000000p+126))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p+126 0x1.0000000000000p+126 0x1.0000000000000p+126 0x1.0000000000000p+126))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p+1 -0x1.0000000000000p+1 -0x1.0000000000000p+1 -0x1.0000000000000p+1))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p+1 0x1.0000000000000p+1 0x1.0000000000000p+1 0x1.0000000000000p+1))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.45f306446f9b4p-3 -0x1.45f306446f9b4p-3 -0x1.45f306446f9b4p-3 -0x1.45f306446f9b4p-3))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.45f306446f9b4p-3 0x1.45f306446f9b4p-3 0x1.45f306446f9b4p-3 0x1.45f306446f9b4p-3))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000010000010p-128 -0x1.0000010000010p-128 -0x1.0000010000010p-128 -0x1.0000010000010p-128))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000010000010p-128 0x1.0000010000010p-128 0x1.0000010000010p-128 0x1.0000010000010p-128))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 0x1.921fb60000000p+3 0x1.921fb60000000p+3 0x1.921fb60000000p+3 0x1.921fb60000000p+3))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -0x1.921fb60000000p+3 -0x1.921fb60000000p+3 -0x1.921fb60000000p+3 -0x1.921fb60000000p+3))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.921fb7921fb79p-126 0x1.921fb7921fb79p-126 0x1.921fb7921fb79p-126 0x1.921fb7921fb79p-126))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.921fb7921fb79p-126 -0x1.921fb7921fb79p-126 -0x1.921fb7921fb79p-126 -0x1.921fb7921fb79p-126))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.921fb60000000p+3 -0x1.921fb60000000p+3 -0x1.921fb60000000p+3 -0x1.921fb60000000p+3))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.921fb60000000p+3 0x1.921fb60000000p+3 0x1.921fb60000000p+3 0x1.921fb60000000p+3))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.921fb7921fb79p-126 -0x1.921fb7921fb79p-126 -0x1.921fb7921fb79p-126 -0x1.921fb7921fb79p-126))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.921fb7921fb79p-126 0x1.921fb7921fb79p-126 0x1.921fb7921fb79p-126 0x1.921fb7921fb79p-126))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.45f304fe7c950p+125 0x1.45f304fe7c950p+125 0x1.45f304fe7c950p+125 0x1.45f304fe7c950p+125))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.45f304fe7c950p+125 -0x1.45f304fe7c950p+125 -0x1.45f304fe7c950p+125 -0x1.45f304fe7c950p+125))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.45f304fe7c950p+125 -0x1.45f304fe7c950p+125 -0x1.45f304fe7c950p+125 -0x1.45f304fe7c950p+125))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.45f304fe7c950p+125 0x1.45f304fe7c950p+125 0x1.45f304fe7c950p+125 0x1.45f304fe7c950p+125))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan nan nan nan)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan -nan -nan -nan)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 inf inf inf inf)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -inf -inf -inf -inf)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000)
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789)
                                   (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019)
                                   (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019)
                                   (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019)
                                   (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.)
                                   (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019)
                                   (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019)
                                   (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019)
                                   (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789)
                                   (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019)
                                   (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019)
                                   (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019)
                                   (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                   (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF)
                                   (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019)
                                   (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019)
                                   (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019)
                                   (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.)
                                   (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019)
                                   (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019)
                                   (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019)
                                   (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.div" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019)
                                   (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                    (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                    (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                    (v128.const f32x4 0x1.6a09e667f3bcdp-75 0x1.6a09e667f3bcdp-75 0x1.6a09e667f3bcdp-75 0x1.6a09e667f3bcdp-75))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                    (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                    (v128.const f32x4 0x1.0000000000000p-63 0x1.0000000000000p-63 0x1.0000000000000p-63 0x1.0000000000000p-63))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                    (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                    (v128.const f32x4 0x1.6a09e667f3bcdp-1 0x1.6a09e667f3bcdp-1 0x1.6a09e667f3bcdp-1 0x1.6a09e667f3bcdp-1))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                    (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                    (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                    (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                    (v128.const f32x4 0x1.40d9324a48138p+1 0x1.40d9324a48138p+1 0x1.40d9324a48138p+1 0x1.40d9324a48138p+1))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                    (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                    (v128.const f32x4 0x1.fffffeffffffcp+63 0x1.fffffeffffffcp+63 0x1.fffffeffffffcp+63 0x1.fffffeffffffcp+63))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                    (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 inf inf inf inf))
                                    (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 -inf -inf -inf -inf))
                                    (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 nan nan nan nan))
                                    (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 -nan -nan -nan -nan))
                                    (v128.const f32x4 nan:canonical nan:canonical nan:canonical nan:canonical))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                    (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                    (v128.const f32x4 nan:arithmetic nan:arithmetic nan:arithmetic nan:arithmetic))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                    (v128.const f32x4 11111.111060555555 11111.111060555555 11111.111060555555 11111.111060555555))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                    (v128.const f32x4 35136418286444.62 35136418286444.62 35136418286444.62 35136418286444.62))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                    (v128.const f32x4 35136418286444.62 35136418286444.62 35136418286444.62 35136418286444.62))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                    (v128.const f32x4 3.5136418286444623e-06 3.5136418286444623e-06 3.5136418286444623e-06 3.5136418286444623e-06))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                    (v128.const f32x4 11111.111060555555 11111.111060555555 11111.111060555555 11111.111060555555))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                    (v128.const f32x4 35136418286444.62 35136418286444.62 35136418286444.62 35136418286444.62))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                    (v128.const f32x4 35136418286444.62 35136418286444.62 35136418286444.62 35136418286444.62))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                    (v128.const f32x4 3.5136418286444623e-06 3.5136418286444623e-06 3.5136418286444623e-06 3.5136418286444623e-06))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                    (v128.const f32x4 11111.11106111111 11111.11106111111 11111.11106111111 11111.11106111111))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                    (v128.const f32x4 35136418288201.445 35136418288201.445 35136418288201.445 35136418288201.445))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                    (v128.const f32x4 35136418288201.445 35136418288201.445 35136418288201.445 35136418288201.445))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                    (v128.const f32x4 3.513641828820144e-06 3.513641828820144e-06 3.513641828820144e-06 3.513641828820144e-06))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                    (v128.const f32x4 0x1.1111111111111p+28 0x1.1111111111111p+28 0x1.1111111111111p+28 0x1.1111111111111p+28))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                    (v128.const f32x4 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                    (v128.const f32x4 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                    (v128.const f32x4 0x1.822cb17ff2eb8p+18 0x1.822cb17ff2eb8p+18 0x1.822cb17ff2eb8p+18 0x1.822cb17ff2eb8p+18))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                    (v128.const f32x4 0x1.1111111111111p+28 0x1.1111111111111p+28 0x1.1111111111111p+28 0x1.1111111111111p+28))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                    (v128.const f32x4 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                    (v128.const f32x4 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                    (v128.const f32x4 0x1.822cb17ff2eb8p+18 0x1.822cb17ff2eb8p+18 0x1.822cb17ff2eb8p+18 0x1.822cb17ff2eb8p+18))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                    (v128.const f32x4 0x1.1111111111111p+28 0x1.1111111111111p+28 0x1.1111111111111p+28 0x1.1111111111111p+28))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                    (v128.const f32x4 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                    (v128.const f32x4 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37 0x1.822cb17ff2eb8p+37))
(assert_return (invoke "f32x4.sqrt" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                    (v128.const f32x4 0x1.822cb17ff2eb8p+18 0x1.822cb17ff2eb8p+18 0x1.822cb17ff2eb8p+18 0x1.822cb17ff2eb8p+18))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x0p+0 0x0p+0 0x0p+0 0x0p+0))
                                   (v128.const f32x4 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0 -0x0.0p+0))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 -0x0p+0 -0x0p+0 -0x0p+0 -0x0p+0))
                                   (v128.const f32x4 0x0.0p+0 0x0.0p+0 0x0.0p+0 0x0.0p+0))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                   (v128.const f32x4 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149 -0x1.0000000000000p-149))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                   (v128.const f32x4 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149 0x1.0000000000000p-149))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x1p-126 0x1p-126 0x1p-126 0x1p-126))
                                   (v128.const f32x4 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126 -0x1.0000000000000p-126))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 -0x1p-126 -0x1p-126 -0x1p-126 -0x1p-126))
                                   (v128.const f32x4 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126 0x1.0000000000000p-126))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x1p-1 0x1p-1 0x1p-1 0x1p-1))
                                   (v128.const f32x4 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1 -0x1.0000000000000p-1))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 -0x1p-1 -0x1p-1 -0x1p-1 -0x1p-1))
                                   (v128.const f32x4 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1 0x1.0000000000000p-1))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x1p+0 0x1p+0 0x1p+0 0x1p+0))
                                   (v128.const f32x4 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0 -0x1.0000000000000p+0))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 -0x1p+0 -0x1p+0 -0x1p+0 -0x1p+0))
                                   (v128.const f32x4 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0 0x1.0000000000000p+0))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2 0x1.921fb6p+2))
                                   (v128.const f32x4 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2 -0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2 -0x1.921fb6p+2))
                                   (v128.const f32x4 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2 0x1.921fb60000000p+2))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                   (v128.const f32x4 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127 -0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                   (v128.const f32x4 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127 0x1.fffffe0000000p+127))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 inf inf inf inf))
                                   (v128.const f32x4 -inf -inf -inf -inf))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 -inf -inf -inf -inf))
                                   (v128.const f32x4 inf inf inf inf))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 nan nan nan nan))
                                   (v128.const f32x4 -nan -nan -nan -nan))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 -nan -nan -nan -nan))
                                   (v128.const f32x4 nan nan nan nan))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                   (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                   (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0123456789 0123456789 0123456789 0123456789))
                                   (v128.const f32x4 -123456789.0 -123456789.0 -123456789.0 -123456789.0))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0123456789e019 0123456789e019 0123456789e019 0123456789e019))
                                   (v128.const f32x4 -1.23456789e+27 -1.23456789e+27 -1.23456789e+27 -1.23456789e+27))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0123456789e+019 0123456789e+019 0123456789e+019 0123456789e+019))
                                   (v128.const f32x4 -1.23456789e+27 -1.23456789e+27 -1.23456789e+27 -1.23456789e+27))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0123456789e-019 0123456789e-019 0123456789e-019 0123456789e-019))
                                   (v128.const f32x4 -1.23456789e-11 -1.23456789e-11 -1.23456789e-11 -1.23456789e-11))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0123456789. 0123456789. 0123456789. 0123456789.))
                                   (v128.const f32x4 -123456789.0 -123456789.0 -123456789.0 -123456789.0))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0123456789.e019 0123456789.e019 0123456789.e019 0123456789.e019))
                                   (v128.const f32x4 -1.23456789e+27 -1.23456789e+27 -1.23456789e+27 -1.23456789e+27))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0123456789.e+019 0123456789.e+019 0123456789.e+019 0123456789.e+019))
                                   (v128.const f32x4 -1.23456789e+27 -1.23456789e+27 -1.23456789e+27 -1.23456789e+27))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0123456789.e-019 0123456789.e-019 0123456789.e-019 0123456789.e-019))
                                   (v128.const f32x4 -1.23456789e-11 -1.23456789e-11 -1.23456789e-11 -1.23456789e-11))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789 0123456789.0123456789))
                                   (v128.const f32x4 -123456789.01234567 -123456789.01234567 -123456789.01234567 -123456789.01234567))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019 0123456789.0123456789e019))
                                   (v128.const f32x4 -1.2345678901234569e+27 -1.2345678901234569e+27 -1.2345678901234569e+27 -1.2345678901234569e+27))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019 0123456789.0123456789e+019))
                                   (v128.const f32x4 -1.2345678901234569e+27 -1.2345678901234569e+27 -1.2345678901234569e+27 -1.2345678901234569e+27))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019 0123456789.0123456789e-019))
                                   (v128.const f32x4 -1.2345678901234568e-11 -1.2345678901234568e-11 -1.2345678901234568e-11 -1.2345678901234568e-11))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF 0x0123456789ABCDEF))
                                   (v128.const f32x4 -0x1.23456789abcdfp+56 -0x1.23456789abcdfp+56 -0x1.23456789abcdfp+56 -0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019 0x0123456789ABCDEFp019))
                                   (v128.const f32x4 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019 0x0123456789ABCDEFp+019))
                                   (v128.const f32x4 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019 0x0123456789ABCDEFp-019))
                                   (v128.const f32x4 -0x1.23456789abcdfp+37 -0x1.23456789abcdfp+37 -0x1.23456789abcdfp+37 -0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF. 0x0123456789ABCDEF.))
                                   (v128.const f32x4 -0x1.23456789abcdfp+56 -0x1.23456789abcdfp+56 -0x1.23456789abcdfp+56 -0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019 0x0123456789ABCDEF.p019))
                                   (v128.const f32x4 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019 0x0123456789ABCDEF.p+019))
                                   (v128.const f32x4 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019 0x0123456789ABCDEF.p-019))
                                   (v128.const f32x4 -0x1.23456789abcdfp+37 -0x1.23456789abcdfp+37 -0x1.23456789abcdfp+37 -0x1.23456789abcdfp+37))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF 0x0123456789ABCDEF.019aF))
                                   (v128.const f32x4 -0x1.23456789abcdfp+56 -0x1.23456789abcdfp+56 -0x1.23456789abcdfp+56 -0x1.23456789abcdfp+56))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019 0x0123456789ABCDEF.019aFp019))
                                   (v128.const f32x4 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019 0x0123456789ABCDEF.019aFp+019))
                                   (v128.const f32x4 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75 -0x1.23456789abcdfp+75))
(assert_return (invoke "f32x4.neg" (v128.const f32x4 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019 0x0123456789ABCDEF.019aFp-019))
                                   (v128.const f32x4 -0x1.23456789abcdfp+37 -0x1.23456789abcdfp+37 -0x1.23456789abcdfp+37 -0x1.23456789abcdfp+37))


;; Mixed f32x4 tests when some lanes are NaNs
(module

  (func (export "f32x4_sqrt_arith") (result v128)
    (f32x4.sqrt (v128.const f32x4 nan:0x200000 -nan:0x200000 16.0 25.0)))
  (func (export "f32x4_sqrt_canon") (result v128)
    (f32x4.sqrt (v128.const f32x4 -1.0 nan 4.0 9.0)))
  (func (export "f32x4_sqrt_mixed") (result v128)
    (f32x4.sqrt (v128.const f32x4 -inf nan:0x200000 36.0 49.0)))
)

(assert_return (invoke "f32x4_sqrt_arith") (v128.const f32x4 nan:arithmetic nan:arithmetic 4.0 5.0))
(assert_return (invoke "f32x4_sqrt_canon") (v128.const f32x4 nan:canonical nan:canonical 2.0 3.0))
(assert_return (invoke "f32x4_sqrt_mixed") (v128.const f32x4 nan:canonical nan:arithmetic 6.0 7.0))

;; type check
(assert_invalid (module (func (result v128) (f32x4.neg (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.sqrt (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.add (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.sub (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.mul (i32.const 0) (f32.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.div (i32.const 0) (f32.const 0.0)))) "type mismatch")

;; Test operation with empty argument

(assert_invalid
  (module
    (func $f32x4.neg-arg-empty (result v128)
      (f32x4.neg)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.sqrt-arg-empty (result v128)
      (f32x4.sqrt)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.add-1st-arg-empty (result v128)
      (f32x4.add (v128.const f32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.add-arg-empty (result v128)
      (f32x4.add)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.sub-1st-arg-empty (result v128)
      (f32x4.sub (v128.const f32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.sub-arg-empty (result v128)
      (f32x4.sub)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.mul-1st-arg-empty (result v128)
      (f32x4.mul (v128.const f32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.mul-arg-empty (result v128)
      (f32x4.mul)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.div-1st-arg-empty (result v128)
      (f32x4.div (v128.const f32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.div-arg-empty (result v128)
      (f32x4.div)
    )
  )
  "type mismatch"
)

;; combination
(module
  (func (export "add-sub") (param v128 v128 v128) (result v128)
    (f32x4.add (f32x4.sub (local.get 0) (local.get 1))(local.get 2)))
  (func (export "div-add") (param v128 v128 v128) (result v128)
    (f32x4.div (f32x4.add (local.get 0) (local.get 1))(local.get 2)))
  (func (export "div-mul") (param v128 v128 v128) (result v128)
    (f32x4.div (f32x4.mul (local.get 0) (local.get 1))(local.get 2)))
  (func (export "div-sub") (param v128 v128 v128) (result v128)
    (f32x4.div (f32x4.sub (local.get 0) (local.get 1))(local.get 2)))
  (func (export "mul-add") (param v128 v128 v128) (result v128)
    (f32x4.mul (f32x4.add (local.get 0) (local.get 1))(local.get 2)))
  (func (export "mul-div") (param v128 v128 v128) (result v128)
    (f32x4.mul (f32x4.div (local.get 0) (local.get 1))(local.get 2)))
  (func (export "mul-sub") (param v128 v128 v128) (result v128)
    (f32x4.mul (f32x4.sub (local.get 0) (local.get 1))(local.get 2)))
  (func (export "sub-add") (param v128 v128 v128) (result v128)
    (f32x4.sub (f32x4.add (local.get 0) (local.get 1))(local.get 2)))
  (func (export "add-neg") (param v128 v128) (result v128)
    (f32x4.add (f32x4.neg (local.get 0)) (local.get 1)))
  (func (export "add-sqrt") (param v128 v128) (result v128)
    (f32x4.add (f32x4.sqrt (local.get 0)) (local.get 1)))
  (func (export "div-neg") (param v128 v128) (result v128)
    (f32x4.div (f32x4.neg (local.get 0)) (local.get 1)))
  (func (export "div-sqrt") (param v128 v128) (result v128)
    (f32x4.div (f32x4.sqrt (local.get 0)) (local.get 1)))
  (func (export "mul-neg") (param v128 v128) (result v128)
    (f32x4.mul (f32x4.neg (local.get 0)) (local.get 1)))
  (func (export "mul-sqrt") (param v128 v128) (result v128)
    (f32x4.mul (f32x4.sqrt (local.get 0)) (local.get 1)))
  (func (export "sub-neg") (param v128 v128) (result v128)
    (f32x4.sub (f32x4.neg (local.get 0)) (local.get 1)))
  (func (export "sub-sqrt") (param v128 v128) (result v128)
    (f32x4.sub (f32x4.sqrt (local.get 0)) (local.get 1)))
)

(assert_return (invoke "add-sub" (v128.const f32x4 1.125 1.125 1.125 1.125)
                                 (v128.const f32x4 0.25 0.25 0.25 0.25)
                                 (v128.const f32x4 0.125 0.125 0.125 0.125))
                                 (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "div-add" (v128.const f32x4 1.125 1.125 1.125 1.125)
                                 (v128.const f32x4 0.125 0.125 0.125 0.125)
                                 (v128.const f32x4 0.25 0.25 0.25 0.25))
                                 (v128.const f32x4 5.0 5.0 5.0 5.0))
(assert_return (invoke "div-mul" (v128.const f32x4 1.125 1.125 1.125 1.125)
                                 (v128.const f32x4 4 4 4 4)
                                 (v128.const f32x4 0.25 0.25 0.25 0.25))
                                 (v128.const f32x4 18.0 18.0 18.0 18.0))
(assert_return (invoke "div-sub" (v128.const f32x4 1.125 1.125 1.125 1.125)
                                 (v128.const f32x4 0.125 0.125 0.125 0.125)
                                 (v128.const f32x4 0.25 0.25 0.25 0.25))
                                 (v128.const f32x4 4.0 4.0 4.0 4.0))
(assert_return (invoke "mul-add" (v128.const f32x4 1.25 1.25 1.25 1.25)
                                 (v128.const f32x4 0.25 0.25 0.25 0.25)
                                 (v128.const f32x4 0.25 0.25 0.25 0.25))
                                 (v128.const f32x4 0.375 0.375 0.375 0.375))
(assert_return (invoke "mul-div" (v128.const f32x4 1.125 1.125 1.125 1.125)
                                 (v128.const f32x4 0.125 0.125 0.125 0.125)
                                 (v128.const f32x4 0.25 0.25 0.25 0.25))
                                 (v128.const f32x4 2.25 2.25 2.25 2.25))
(assert_return (invoke "mul-sub" (v128.const f32x4 1.125 1.125 1.125 1.125)
                                 (v128.const f32x4 0.125 0.125 0.125 0.125)
                                 (v128.const f32x4 0.25 0.25 0.25 0.25))
                                 (v128.const f32x4 0.25 0.25 0.25 0.25))
(assert_return (invoke "sub-add" (v128.const f32x4 1.125 1.125 1.125 1.125)
                                 (v128.const f32x4 0.25 0.25 0.25 0.25)
                                 (v128.const f32x4 0.125 0.125 0.125 0.125))
                                 (v128.const f32x4 1.25 1.25 1.25 1.25))
(assert_return (invoke "add-neg" (v128.const f32x4 1.125 1.125 1.125 1.125)
                                 (v128.const f32x4 0.125 0.125 0.125 0.125))
                                 (v128.const f32x4 -1.0 -1.0 -1.0 -1.0))
(assert_return (invoke "add-sqrt" (v128.const f32x4 2.25 2.25 2.25 2.25)
                                  (v128.const f32x4 0.25 0.25 0.25 0.25))
                                  (v128.const f32x4 1.75 1.75 1.75 1.75))
(assert_return (invoke "div-neg" (v128.const f32x4 1.5 1.5 1.5 1.5)
                                 (v128.const f32x4 0.25 0.25 0.25 0.25))
                                 (v128.const f32x4 -6 -6 -6 -6))
(assert_return (invoke "div-sqrt" (v128.const f32x4 2.25 2.25 2.25 2.25)
                                  (v128.const f32x4 0.25 0.25 0.25 0.25))
                                  (v128.const f32x4 6 6 6 6))
(assert_return (invoke "mul-neg" (v128.const f32x4 1.5 1.5 1.5 1.5)
                                 (v128.const f32x4 0.25 0.25 0.25 0.25))
                                 (v128.const f32x4 -0.375 -0.375 -0.375 -0.375))
(assert_return (invoke "mul-sqrt" (v128.const f32x4 2.25 2.25 2.25 2.25)
                                  (v128.const f32x4 0.25 0.25 0.25 0.25))
                                  (v128.const f32x4 0.375 0.375 0.375 0.375))
(assert_return (invoke "sub-neg" (v128.const f32x4 1.125 1.125 1.125 1.125)
                                 (v128.const f32x4 0.125 0.125 0.125 0.125))
                                 (v128.const f32x4 -1.25 -1.25 -1.25 -1.25))
(assert_return (invoke "sub-sqrt" (v128.const f32x4 2.25 2.25 2.25 2.25)
                                  (v128.const f32x4 0.25 0.25 0.25 0.25))
                                  (v128.const f32x4 1.25 1.25 1.25 1.25))