// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Definitions for configuring Tink runtime environment.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v3.21.12
// source: config.proto

package config_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An entry that describes a key type to be used with Tink library,
// specifying the corresponding primitive, key manager, and deprecation status.
// All fields are required.
//
// Deprecated: Marked as deprecated in config.proto.
type KeyTypeEntry struct {
	state             protoimpl.MessageState `protogen:"open.v1"`
	PrimitiveName     string                 `protobuf:"bytes,1,opt,name=primitive_name,json=primitiveName,proto3" json:"primitive_name,omitempty"`                // E.g. “Aead”, “Mac”, ... (case-insensitive)
	TypeUrl           string                 `protobuf:"bytes,2,opt,name=type_url,json=typeUrl,proto3" json:"type_url,omitempty"`                                  // Name of the key type.
	KeyManagerVersion uint32                 `protobuf:"varint,3,opt,name=key_manager_version,json=keyManagerVersion,proto3" json:"key_manager_version,omitempty"` // Minimum required version of key manager.
	NewKeyAllowed     bool                   `protobuf:"varint,4,opt,name=new_key_allowed,json=newKeyAllowed,proto3" json:"new_key_allowed,omitempty"`             // Can the key manager create new keys?
	CatalogueName     string                 `protobuf:"bytes,5,opt,name=catalogue_name,json=catalogueName,proto3" json:"catalogue_name,omitempty"`                // Catalogue to be queried for key manager,
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *KeyTypeEntry) Reset() {
	*x = KeyTypeEntry{}
	mi := &file_config_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *KeyTypeEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*KeyTypeEntry) ProtoMessage() {}

func (x *KeyTypeEntry) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use KeyTypeEntry.ProtoReflect.Descriptor instead.
func (*KeyTypeEntry) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{0}
}

func (x *KeyTypeEntry) GetPrimitiveName() string {
	if x != nil {
		return x.PrimitiveName
	}
	return ""
}

func (x *KeyTypeEntry) GetTypeUrl() string {
	if x != nil {
		return x.TypeUrl
	}
	return ""
}

func (x *KeyTypeEntry) GetKeyManagerVersion() uint32 {
	if x != nil {
		return x.KeyManagerVersion
	}
	return 0
}

func (x *KeyTypeEntry) GetNewKeyAllowed() bool {
	if x != nil {
		return x.NewKeyAllowed
	}
	return false
}

func (x *KeyTypeEntry) GetCatalogueName() string {
	if x != nil {
		return x.CatalogueName
	}
	return ""
}

// A complete configuration of Tink library: a list of key types
// to be available via the Registry after initialization.
// All fields are required.
//
// Deprecated: Marked as deprecated in config.proto.
type RegistryConfig struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	ConfigName    string                 `protobuf:"bytes,1,opt,name=config_name,json=configName,proto3" json:"config_name,omitempty"`
	Entry         []*KeyTypeEntry        `protobuf:"bytes,2,rep,name=entry,proto3" json:"entry,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RegistryConfig) Reset() {
	*x = RegistryConfig{}
	mi := &file_config_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegistryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegistryConfig) ProtoMessage() {}

func (x *RegistryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_config_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegistryConfig.ProtoReflect.Descriptor instead.
func (*RegistryConfig) Descriptor() ([]byte, []int) {
	return file_config_proto_rawDescGZIP(), []int{1}
}

func (x *RegistryConfig) GetConfigName() string {
	if x != nil {
		return x.ConfigName
	}
	return ""
}

func (x *RegistryConfig) GetEntry() []*KeyTypeEntry {
	if x != nil {
		return x.Entry
	}
	return nil
}

var File_config_proto protoreflect.FileDescriptor

const file_config_proto_rawDesc = "" +
	"\n" +
	"\fconfig.proto\x12\x12google.crypto.tink\"\xd3\x01\n" +
	"\fKeyTypeEntry\x12%\n" +
	"\x0eprimitive_name\x18\x01 \x01(\tR\rprimitiveName\x12\x19\n" +
	"\btype_url\x18\x02 \x01(\tR\atypeUrl\x12.\n" +
	"\x13key_manager_version\x18\x03 \x01(\rR\x11keyManagerVersion\x12&\n" +
	"\x0fnew_key_allowed\x18\x04 \x01(\bR\rnewKeyAllowed\x12%\n" +
	"\x0ecatalogue_name\x18\x05 \x01(\tR\rcatalogueName:\x02\x18\x01\"m\n" +
	"\x0eRegistryConfig\x12\x1f\n" +
	"\vconfig_name\x18\x01 \x01(\tR\n" +
	"configName\x126\n" +
	"\x05entry\x18\x02 \x03(\v2 .google.crypto.tink.KeyTypeEntryR\x05entry:\x02\x18\x01BY\n" +
	"\x1ccom.google.crypto.tink.protoP\x01Z7github.com/tink-crypto/tink-go/v2/proto/config_go_protob\x06proto3"

var (
	file_config_proto_rawDescOnce sync.Once
	file_config_proto_rawDescData []byte
)

func file_config_proto_rawDescGZIP() []byte {
	file_config_proto_rawDescOnce.Do(func() {
		file_config_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_config_proto_rawDesc), len(file_config_proto_rawDesc)))
	})
	return file_config_proto_rawDescData
}

var file_config_proto_msgTypes = make([]protoimpl.MessageInfo, 2)
var file_config_proto_goTypes = []any{
	(*KeyTypeEntry)(nil),   // 0: google.crypto.tink.KeyTypeEntry
	(*RegistryConfig)(nil), // 1: google.crypto.tink.RegistryConfig
}
var file_config_proto_depIdxs = []int32{
	0, // 0: google.crypto.tink.RegistryConfig.entry:type_name -> google.crypto.tink.KeyTypeEntry
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_config_proto_init() }
func file_config_proto_init() {
	if File_config_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_config_proto_rawDesc), len(file_config_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   2,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_config_proto_goTypes,
		DependencyIndexes: file_config_proto_depIdxs,
		MessageInfos:      file_config_proto_msgTypes,
	}.Build()
	File_config_proto = out.File
	file_config_proto_goTypes = nil
	file_config_proto_depIdxs = nil
}
