package metrics

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// Client is the monitor Management Client
type Client struct {
	BaseClient
}

// NewClient creates an instance of the Client client.
func NewClient(subscriptionID string) Client {
	return NewClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewClientWithBaseURI creates an instance of the Client client using a custom endpoint.  Use this when interacting
// with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewClientWithBaseURI(baseURI string, subscriptionID string) Client {
	return Client{NewWithBaseURI(baseURI, subscriptionID)}
}

// List **Lists the metric values for a resource**.
// Parameters:
// resourceURI - the identifier of the resource.
// timespan - the timespan of the query. It is a string with the following format
// 'startDateTime_ISO/endDateTime_ISO'.
// interval - the interval (i.e. timegrain) of the query.
// metricnames - the names of the metrics (comma separated) to retrieve.
// aggregation - the list of aggregation types (comma separated) to retrieve.
// top - the maximum number of records to retrieve.
// Valid only if $filter is specified.
// Defaults to 10.
// orderby - the aggregation to use for sorting results and the direction of the sort.
// Only one order can be specified.
// Examples: sum asc.
// filter - the **$filter** is used to reduce the set of metric data returned.<br>Example:<br>Metric contains
// metadata A, B and C.<br>- Return all time series of C where A = a1 and B = b1 or b2<br>**$filter=A eq ‘a1’
// and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**<br>- Invalid variant:<br>**$filter=A eq ‘a1’ and B eq ‘b1’ and C
// eq ‘*’ or B = ‘b2’**<br>This is invalid because the logical or operator cannot separate two different
// metadata names.<br>- Return all time series where A = a1, B = b1 and C = c1:<br>**$filter=A eq ‘a1’ and B eq
// ‘b1’ and C eq ‘c1’**<br>- Return all time series where A = a1<br>**$filter=A eq ‘a1’ and B eq ‘*’ and C eq
// ‘*’**.
// resultType - reduces the set of data collected. The syntax allowed depends on the operation. See the
// operation's description for details.
// metricnamespace - metric namespace where the metrics you want reside.
// autoAdjustTimegrain - when set to true, if the timespan passed in is not supported by this metric, the API
// will return the result using the closest supported timespan. When set to false, an error is returned for
// invalid timespan parameters. Defaults to false.
// validateDimensions - when set to false, invalid filter parameter values will be ignored. When set to true,
// an error is returned for invalid filter parameters. Defaults to true.
func (client Client) List(ctx context.Context, resourceURI string, timespan string, interval *string, metricnames string, aggregation string, top *int32, orderby string, filter string, resultType ResultType, metricnamespace string, autoAdjustTimegrain *bool, validateDimensions *bool) (result Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.List")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListPreparer(ctx, resourceURI, timespan, interval, metricnames, aggregation, top, orderby, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.Client", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "metrics.Client", "List", resp, "Failure sending request")
		return
	}

	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.Client", "List", resp, "Failure responding to request")
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client Client) ListPreparer(ctx context.Context, resourceURI string, timespan string, interval *string, metricnames string, aggregation string, top *int32, orderby string, filter string, resultType ResultType, metricnamespace string, autoAdjustTimegrain *bool, validateDimensions *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceUri": resourceURI,
	}

	const APIVersion = "2021-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(timespan) > 0 {
		queryParameters["timespan"] = autorest.Encode("query", timespan)
	}
	if interval != nil {
		queryParameters["interval"] = autorest.Encode("query", *interval)
	}
	if len(metricnames) > 0 {
		queryParameters["metricnames"] = autorest.Encode("query", metricnames)
	}
	if len(aggregation) > 0 {
		queryParameters["aggregation"] = autorest.Encode("query", aggregation)
	}
	if top != nil {
		queryParameters["top"] = autorest.Encode("query", *top)
	}
	if len(orderby) > 0 {
		queryParameters["orderby"] = autorest.Encode("query", orderby)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(string(resultType)) > 0 {
		queryParameters["resultType"] = autorest.Encode("query", resultType)
	}
	if len(metricnamespace) > 0 {
		queryParameters["metricnamespace"] = autorest.Encode("query", metricnamespace)
	}
	if autoAdjustTimegrain != nil {
		queryParameters["AutoAdjustTimegrain"] = autorest.Encode("query", *autoAdjustTimegrain)
	}
	if validateDimensions != nil {
		queryParameters["ValidateDimensions"] = autorest.Encode("query", *validateDimensions)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceUri}/providers/Microsoft.Insights/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client Client) ListResponder(resp *http.Response) (result Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAtSubscriptionScope **Lists the metric data for a subscription**.
// Parameters:
// region - the region where the metrics you want reside.
// timespan - the timespan of the query. It is a string with the following format
// 'startDateTime_ISO/endDateTime_ISO'.
// interval - the interval (i.e. timegrain) of the query.
// metricnames - the names of the metrics (comma separated) to retrieve.
// aggregation - the list of aggregation types (comma separated) to retrieve.
// top - the maximum number of records to retrieve.
// Valid only if $filter is specified.
// Defaults to 10.
// orderby - the aggregation to use for sorting results and the direction of the sort.
// Only one order can be specified.
// Examples: sum asc.
// filter - the **$filter** is used to reduce the set of metric data returned.<br>Example:<br>Metric contains
// metadata A, B and C.<br>- Return all time series of C where A = a1 and B = b1 or b2<br>**$filter=A eq ‘a1’
// and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**<br>- Invalid variant:<br>**$filter=A eq ‘a1’ and B eq ‘b1’ and C
// eq ‘*’ or B = ‘b2’**<br>This is invalid because the logical or operator cannot separate two different
// metadata names.<br>- Return all time series where A = a1, B = b1 and C = c1:<br>**$filter=A eq ‘a1’ and B eq
// ‘b1’ and C eq ‘c1’**<br>- Return all time series where A = a1<br>**$filter=A eq ‘a1’ and B eq ‘*’ and C eq
// ‘*’**.
// resultType - reduces the set of data collected. The syntax allowed depends on the operation. See the
// operation's description for details.
// metricnamespace - metric namespace where the metrics you want reside.
// autoAdjustTimegrain - when set to true, if the timespan passed in is not supported by this metric, the API
// will return the result using the closest supported timespan. When set to false, an error is returned for
// invalid timespan parameters. Defaults to false.
// validateDimensions - when set to false, invalid filter parameter values will be ignored. When set to true,
// an error is returned for invalid filter parameters. Defaults to true.
func (client Client) ListAtSubscriptionScope(ctx context.Context, region string, timespan string, interval *string, metricnames string, aggregation string, top *int32, orderby string, filter string, resultType MetricResultType, metricnamespace string, autoAdjustTimegrain *bool, validateDimensions *bool) (result SubscriptionScopeMetricResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListAtSubscriptionScope")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("metrics.Client", "ListAtSubscriptionScope", err.Error())
	}

	req, err := client.ListAtSubscriptionScopePreparer(ctx, region, timespan, interval, metricnames, aggregation, top, orderby, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.Client", "ListAtSubscriptionScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAtSubscriptionScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "metrics.Client", "ListAtSubscriptionScope", resp, "Failure sending request")
		return
	}

	result, err = client.ListAtSubscriptionScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.Client", "ListAtSubscriptionScope", resp, "Failure responding to request")
		return
	}

	return
}

// ListAtSubscriptionScopePreparer prepares the ListAtSubscriptionScope request.
func (client Client) ListAtSubscriptionScopePreparer(ctx context.Context, region string, timespan string, interval *string, metricnames string, aggregation string, top *int32, orderby string, filter string, resultType MetricResultType, metricnamespace string, autoAdjustTimegrain *bool, validateDimensions *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"region":      autorest.Encode("query", region),
	}
	if len(timespan) > 0 {
		queryParameters["timespan"] = autorest.Encode("query", timespan)
	}
	if interval != nil {
		queryParameters["interval"] = autorest.Encode("query", *interval)
	}
	if len(metricnames) > 0 {
		queryParameters["metricnames"] = autorest.Encode("query", metricnames)
	}
	if len(aggregation) > 0 {
		queryParameters["aggregation"] = autorest.Encode("query", aggregation)
	}
	if top != nil {
		queryParameters["top"] = autorest.Encode("query", *top)
	}
	if len(orderby) > 0 {
		queryParameters["orderby"] = autorest.Encode("query", orderby)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(string(resultType)) > 0 {
		queryParameters["resultType"] = autorest.Encode("query", resultType)
	}
	if len(metricnamespace) > 0 {
		queryParameters["metricnamespace"] = autorest.Encode("query", metricnamespace)
	}
	if autoAdjustTimegrain != nil {
		queryParameters["AutoAdjustTimegrain"] = autorest.Encode("query", *autoAdjustTimegrain)
	}
	if validateDimensions != nil {
		queryParameters["ValidateDimensions"] = autorest.Encode("query", *validateDimensions)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Insights/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAtSubscriptionScopeSender sends the ListAtSubscriptionScope request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListAtSubscriptionScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListAtSubscriptionScopeResponder handles the response to the ListAtSubscriptionScope request. The method always
// closes the http.Response Body.
func (client Client) ListAtSubscriptionScopeResponder(resp *http.Response) (result SubscriptionScopeMetricResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListAtSubscriptionScopePost **Lists the metric data for a subscription**. Parameters can be specified on either
// query params or the body.
// Parameters:
// region - the region where the metrics you want reside.
// timespan - the timespan of the query. It is a string with the following format
// 'startDateTime_ISO/endDateTime_ISO'.
// interval - the interval (i.e. timegrain) of the query.
// metricnames - the names of the metrics (comma separated) to retrieve.
// aggregation - the list of aggregation types (comma separated) to retrieve.
// top - the maximum number of records to retrieve.
// Valid only if $filter is specified.
// Defaults to 10.
// orderby - the aggregation to use for sorting results and the direction of the sort.
// Only one order can be specified.
// Examples: sum asc.
// filter - the **$filter** is used to reduce the set of metric data returned.<br>Example:<br>Metric contains
// metadata A, B and C.<br>- Return all time series of C where A = a1 and B = b1 or b2<br>**$filter=A eq ‘a1’
// and B eq ‘b1’ or B eq ‘b2’ and C eq ‘*’**<br>- Invalid variant:<br>**$filter=A eq ‘a1’ and B eq ‘b1’ and C
// eq ‘*’ or B = ‘b2’**<br>This is invalid because the logical or operator cannot separate two different
// metadata names.<br>- Return all time series where A = a1, B = b1 and C = c1:<br>**$filter=A eq ‘a1’ and B eq
// ‘b1’ and C eq ‘c1’**<br>- Return all time series where A = a1<br>**$filter=A eq ‘a1’ and B eq ‘*’ and C eq
// ‘*’**.
// resultType - reduces the set of data collected. The syntax allowed depends on the operation. See the
// operation's description for details.
// metricnamespace - metric namespace where the metrics you want reside.
// autoAdjustTimegrain - when set to true, if the timespan passed in is not supported by this metric, the API
// will return the result using the closest supported timespan. When set to false, an error is returned for
// invalid timespan parameters. Defaults to false.
// validateDimensions - when set to false, invalid filter parameter values will be ignored. When set to true,
// an error is returned for invalid filter parameters. Defaults to true.
// body - parameters serialized in the body
func (client Client) ListAtSubscriptionScopePost(ctx context.Context, region string, timespan string, interval *string, metricnames string, aggregation string, top *int32, orderby string, filter string, resultType MetricResultType, metricnamespace string, autoAdjustTimegrain *bool, validateDimensions *bool, body *SubscriptionScopeMetricsRequestBodyParameters) (result SubscriptionScopeMetricResponse, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/Client.ListAtSubscriptionScopePost")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("metrics.Client", "ListAtSubscriptionScopePost", err.Error())
	}

	req, err := client.ListAtSubscriptionScopePostPreparer(ctx, region, timespan, interval, metricnames, aggregation, top, orderby, filter, resultType, metricnamespace, autoAdjustTimegrain, validateDimensions, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.Client", "ListAtSubscriptionScopePost", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAtSubscriptionScopePostSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "metrics.Client", "ListAtSubscriptionScopePost", resp, "Failure sending request")
		return
	}

	result, err = client.ListAtSubscriptionScopePostResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "metrics.Client", "ListAtSubscriptionScopePost", resp, "Failure responding to request")
		return
	}

	return
}

// ListAtSubscriptionScopePostPreparer prepares the ListAtSubscriptionScopePost request.
func (client Client) ListAtSubscriptionScopePostPreparer(ctx context.Context, region string, timespan string, interval *string, metricnames string, aggregation string, top *int32, orderby string, filter string, resultType MetricResultType, metricnamespace string, autoAdjustTimegrain *bool, validateDimensions *bool, body *SubscriptionScopeMetricsRequestBodyParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
		"region":      autorest.Encode("query", region),
	}
	if len(timespan) > 0 {
		queryParameters["timespan"] = autorest.Encode("query", timespan)
	}
	if interval != nil {
		queryParameters["interval"] = autorest.Encode("query", *interval)
	}
	if len(metricnames) > 0 {
		queryParameters["metricnames"] = autorest.Encode("query", metricnames)
	}
	if len(aggregation) > 0 {
		queryParameters["aggregation"] = autorest.Encode("query", aggregation)
	}
	if top != nil {
		queryParameters["top"] = autorest.Encode("query", *top)
	}
	if len(orderby) > 0 {
		queryParameters["orderby"] = autorest.Encode("query", orderby)
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(string(resultType)) > 0 {
		queryParameters["resultType"] = autorest.Encode("query", resultType)
	}
	if len(metricnamespace) > 0 {
		queryParameters["metricnamespace"] = autorest.Encode("query", metricnamespace)
	}
	if autoAdjustTimegrain != nil {
		queryParameters["AutoAdjustTimegrain"] = autorest.Encode("query", *autoAdjustTimegrain)
	}
	if validateDimensions != nil {
		queryParameters["ValidateDimensions"] = autorest.Encode("query", *validateDimensions)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Insights/metrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAtSubscriptionScopePostSender sends the ListAtSubscriptionScopePost request. The method will close the
// http.Response Body if it receives an error.
func (client Client) ListAtSubscriptionScopePostSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListAtSubscriptionScopePostResponder handles the response to the ListAtSubscriptionScopePost request. The method always
// closes the http.Response Body.
func (client Client) ListAtSubscriptionScopePostResponder(resp *http.Response) (result SubscriptionScopeMetricResponse, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
