package dataprotection

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ResourceGuardsClient is the open API 2.0 Specs for Azure Data Protection service
type ResourceGuardsClient struct {
	BaseClient
}

// NewResourceGuardsClient creates an instance of the ResourceGuardsClient client.
func NewResourceGuardsClient(subscriptionID string) ResourceGuardsClient {
	return NewResourceGuardsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewResourceGuardsClientWithBaseURI creates an instance of the ResourceGuardsClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewResourceGuardsClientWithBaseURI(baseURI string, subscriptionID string) ResourceGuardsClient {
	return ResourceGuardsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Delete sends the delete request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
// resourceGuardsName - the name of ResourceGuard
func (client ResourceGuardsClient) Delete(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, resourceGroupName, resourceGuardsName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ResourceGuardsClient) DeletePreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get sends the get request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
// resourceGuardsName - the name of ResourceGuard
func (client ResourceGuardsClient) Get(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result ResourceGuardResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, resourceGuardsName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client ResourceGuardsClient) GetPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetResponder(resp *http.Response) (result ResourceGuardResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetBackupSecurityPINRequestsObjects sends the get backup security pin requests objects request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
func (client ResourceGuardsClient) GetBackupSecurityPINRequestsObjects(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result DppBaseResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetBackupSecurityPINRequestsObjects")
		defer func() {
			sc := -1
			if result.dbrl.Response.Response != nil {
				sc = result.dbrl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getBackupSecurityPINRequestsObjectsNextResults
	req, err := client.GetBackupSecurityPINRequestsObjectsPreparer(ctx, resourceGroupName, resourceGuardsName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetBackupSecurityPINRequestsObjects", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetBackupSecurityPINRequestsObjectsSender(req)
	if err != nil {
		result.dbrl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetBackupSecurityPINRequestsObjects", resp, "Failure sending request")
		return
	}

	result.dbrl, err = client.GetBackupSecurityPINRequestsObjectsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetBackupSecurityPINRequestsObjects", resp, "Failure responding to request")
		return
	}
	if result.dbrl.hasNextLink() && result.dbrl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetBackupSecurityPINRequestsObjectsPreparer prepares the GetBackupSecurityPINRequestsObjects request.
func (client ResourceGuardsClient) GetBackupSecurityPINRequestsObjectsPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/getBackupSecurityPINRequests", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetBackupSecurityPINRequestsObjectsSender sends the GetBackupSecurityPINRequestsObjects request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetBackupSecurityPINRequestsObjectsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetBackupSecurityPINRequestsObjectsResponder handles the response to the GetBackupSecurityPINRequestsObjects request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetBackupSecurityPINRequestsObjectsResponder(resp *http.Response) (result DppBaseResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getBackupSecurityPINRequestsObjectsNextResults retrieves the next set of results, if any.
func (client ResourceGuardsClient) getBackupSecurityPINRequestsObjectsNextResults(ctx context.Context, lastResults DppBaseResourceList) (result DppBaseResourceList, err error) {
	req, err := lastResults.dppBaseResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getBackupSecurityPINRequestsObjectsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetBackupSecurityPINRequestsObjectsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getBackupSecurityPINRequestsObjectsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetBackupSecurityPINRequestsObjectsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getBackupSecurityPINRequestsObjectsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetBackupSecurityPINRequestsObjectsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ResourceGuardsClient) GetBackupSecurityPINRequestsObjectsComplete(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result DppBaseResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetBackupSecurityPINRequestsObjects")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetBackupSecurityPINRequestsObjects(ctx, resourceGroupName, resourceGuardsName)
	return
}

// GetDefaultBackupSecurityPINRequestsObject sends the get default backup security pin requests object request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
func (client ResourceGuardsClient) GetDefaultBackupSecurityPINRequestsObject(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string) (result DppBaseResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetDefaultBackupSecurityPINRequestsObject")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDefaultBackupSecurityPINRequestsObjectPreparer(ctx, resourceGroupName, resourceGuardsName, requestName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultBackupSecurityPINRequestsObject", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDefaultBackupSecurityPINRequestsObjectSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultBackupSecurityPINRequestsObject", resp, "Failure sending request")
		return
	}

	result, err = client.GetDefaultBackupSecurityPINRequestsObjectResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultBackupSecurityPINRequestsObject", resp, "Failure responding to request")
		return
	}

	return
}

// GetDefaultBackupSecurityPINRequestsObjectPreparer prepares the GetDefaultBackupSecurityPINRequestsObject request.
func (client ResourceGuardsClient) GetDefaultBackupSecurityPINRequestsObjectPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"requestName":        autorest.Encode("path", requestName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/getBackupSecurityPINRequests/{requestName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDefaultBackupSecurityPINRequestsObjectSender sends the GetDefaultBackupSecurityPINRequestsObject request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetDefaultBackupSecurityPINRequestsObjectSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDefaultBackupSecurityPINRequestsObjectResponder handles the response to the GetDefaultBackupSecurityPINRequestsObject request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetDefaultBackupSecurityPINRequestsObjectResponder(resp *http.Response) (result DppBaseResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDefaultDeleteProtectedItemRequestsObject sends the get default delete protected item requests object request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
func (client ResourceGuardsClient) GetDefaultDeleteProtectedItemRequestsObject(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string) (result DppBaseResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetDefaultDeleteProtectedItemRequestsObject")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDefaultDeleteProtectedItemRequestsObjectPreparer(ctx, resourceGroupName, resourceGuardsName, requestName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultDeleteProtectedItemRequestsObject", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDefaultDeleteProtectedItemRequestsObjectSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultDeleteProtectedItemRequestsObject", resp, "Failure sending request")
		return
	}

	result, err = client.GetDefaultDeleteProtectedItemRequestsObjectResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultDeleteProtectedItemRequestsObject", resp, "Failure responding to request")
		return
	}

	return
}

// GetDefaultDeleteProtectedItemRequestsObjectPreparer prepares the GetDefaultDeleteProtectedItemRequestsObject request.
func (client ResourceGuardsClient) GetDefaultDeleteProtectedItemRequestsObjectPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"requestName":        autorest.Encode("path", requestName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteProtectedItemRequests/{requestName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDefaultDeleteProtectedItemRequestsObjectSender sends the GetDefaultDeleteProtectedItemRequestsObject request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetDefaultDeleteProtectedItemRequestsObjectSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDefaultDeleteProtectedItemRequestsObjectResponder handles the response to the GetDefaultDeleteProtectedItemRequestsObject request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetDefaultDeleteProtectedItemRequestsObjectResponder(resp *http.Response) (result DppBaseResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDefaultDeleteResourceGuardProxyRequestsObject sends the get default delete resource guard proxy requests object
// request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
func (client ResourceGuardsClient) GetDefaultDeleteResourceGuardProxyRequestsObject(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string) (result DppBaseResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetDefaultDeleteResourceGuardProxyRequestsObject")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDefaultDeleteResourceGuardProxyRequestsObjectPreparer(ctx, resourceGroupName, resourceGuardsName, requestName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultDeleteResourceGuardProxyRequestsObject", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDefaultDeleteResourceGuardProxyRequestsObjectSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultDeleteResourceGuardProxyRequestsObject", resp, "Failure sending request")
		return
	}

	result, err = client.GetDefaultDeleteResourceGuardProxyRequestsObjectResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultDeleteResourceGuardProxyRequestsObject", resp, "Failure responding to request")
		return
	}

	return
}

// GetDefaultDeleteResourceGuardProxyRequestsObjectPreparer prepares the GetDefaultDeleteResourceGuardProxyRequestsObject request.
func (client ResourceGuardsClient) GetDefaultDeleteResourceGuardProxyRequestsObjectPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"requestName":        autorest.Encode("path", requestName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteResourceGuardProxyRequests/{requestName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDefaultDeleteResourceGuardProxyRequestsObjectSender sends the GetDefaultDeleteResourceGuardProxyRequestsObject request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetDefaultDeleteResourceGuardProxyRequestsObjectSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDefaultDeleteResourceGuardProxyRequestsObjectResponder handles the response to the GetDefaultDeleteResourceGuardProxyRequestsObject request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetDefaultDeleteResourceGuardProxyRequestsObjectResponder(resp *http.Response) (result DppBaseResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDefaultDisableSoftDeleteRequestsObject sends the get default disable soft delete requests object request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
func (client ResourceGuardsClient) GetDefaultDisableSoftDeleteRequestsObject(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string) (result DppBaseResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetDefaultDisableSoftDeleteRequestsObject")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDefaultDisableSoftDeleteRequestsObjectPreparer(ctx, resourceGroupName, resourceGuardsName, requestName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultDisableSoftDeleteRequestsObject", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDefaultDisableSoftDeleteRequestsObjectSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultDisableSoftDeleteRequestsObject", resp, "Failure sending request")
		return
	}

	result, err = client.GetDefaultDisableSoftDeleteRequestsObjectResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultDisableSoftDeleteRequestsObject", resp, "Failure responding to request")
		return
	}

	return
}

// GetDefaultDisableSoftDeleteRequestsObjectPreparer prepares the GetDefaultDisableSoftDeleteRequestsObject request.
func (client ResourceGuardsClient) GetDefaultDisableSoftDeleteRequestsObjectPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"requestName":        autorest.Encode("path", requestName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/disableSoftDeleteRequests/{requestName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDefaultDisableSoftDeleteRequestsObjectSender sends the GetDefaultDisableSoftDeleteRequestsObject request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetDefaultDisableSoftDeleteRequestsObjectSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDefaultDisableSoftDeleteRequestsObjectResponder handles the response to the GetDefaultDisableSoftDeleteRequestsObject request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetDefaultDisableSoftDeleteRequestsObjectResponder(resp *http.Response) (result DppBaseResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDefaultUpdateProtectedItemRequestsObject sends the get default update protected item requests object request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
func (client ResourceGuardsClient) GetDefaultUpdateProtectedItemRequestsObject(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string) (result DppBaseResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetDefaultUpdateProtectedItemRequestsObject")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDefaultUpdateProtectedItemRequestsObjectPreparer(ctx, resourceGroupName, resourceGuardsName, requestName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultUpdateProtectedItemRequestsObject", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDefaultUpdateProtectedItemRequestsObjectSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultUpdateProtectedItemRequestsObject", resp, "Failure sending request")
		return
	}

	result, err = client.GetDefaultUpdateProtectedItemRequestsObjectResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultUpdateProtectedItemRequestsObject", resp, "Failure responding to request")
		return
	}

	return
}

// GetDefaultUpdateProtectedItemRequestsObjectPreparer prepares the GetDefaultUpdateProtectedItemRequestsObject request.
func (client ResourceGuardsClient) GetDefaultUpdateProtectedItemRequestsObjectPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"requestName":        autorest.Encode("path", requestName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectedItemRequests/{requestName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDefaultUpdateProtectedItemRequestsObjectSender sends the GetDefaultUpdateProtectedItemRequestsObject request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetDefaultUpdateProtectedItemRequestsObjectSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDefaultUpdateProtectedItemRequestsObjectResponder handles the response to the GetDefaultUpdateProtectedItemRequestsObject request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetDefaultUpdateProtectedItemRequestsObjectResponder(resp *http.Response) (result DppBaseResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDefaultUpdateProtectionPolicyRequestsObject sends the get default update protection policy requests object
// request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
func (client ResourceGuardsClient) GetDefaultUpdateProtectionPolicyRequestsObject(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string) (result DppBaseResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetDefaultUpdateProtectionPolicyRequestsObject")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDefaultUpdateProtectionPolicyRequestsObjectPreparer(ctx, resourceGroupName, resourceGuardsName, requestName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultUpdateProtectionPolicyRequestsObject", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDefaultUpdateProtectionPolicyRequestsObjectSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultUpdateProtectionPolicyRequestsObject", resp, "Failure sending request")
		return
	}

	result, err = client.GetDefaultUpdateProtectionPolicyRequestsObjectResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDefaultUpdateProtectionPolicyRequestsObject", resp, "Failure responding to request")
		return
	}

	return
}

// GetDefaultUpdateProtectionPolicyRequestsObjectPreparer prepares the GetDefaultUpdateProtectionPolicyRequestsObject request.
func (client ResourceGuardsClient) GetDefaultUpdateProtectionPolicyRequestsObjectPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string, requestName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"requestName":        autorest.Encode("path", requestName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectionPolicyRequests/{requestName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDefaultUpdateProtectionPolicyRequestsObjectSender sends the GetDefaultUpdateProtectionPolicyRequestsObject request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetDefaultUpdateProtectionPolicyRequestsObjectSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDefaultUpdateProtectionPolicyRequestsObjectResponder handles the response to the GetDefaultUpdateProtectionPolicyRequestsObject request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetDefaultUpdateProtectionPolicyRequestsObjectResponder(resp *http.Response) (result DppBaseResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDeleteProtectedItemRequestsObjects sends the get delete protected item requests objects request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
func (client ResourceGuardsClient) GetDeleteProtectedItemRequestsObjects(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result DppBaseResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetDeleteProtectedItemRequestsObjects")
		defer func() {
			sc := -1
			if result.dbrl.Response.Response != nil {
				sc = result.dbrl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getDeleteProtectedItemRequestsObjectsNextResults
	req, err := client.GetDeleteProtectedItemRequestsObjectsPreparer(ctx, resourceGroupName, resourceGuardsName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDeleteProtectedItemRequestsObjects", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeleteProtectedItemRequestsObjectsSender(req)
	if err != nil {
		result.dbrl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDeleteProtectedItemRequestsObjects", resp, "Failure sending request")
		return
	}

	result.dbrl, err = client.GetDeleteProtectedItemRequestsObjectsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDeleteProtectedItemRequestsObjects", resp, "Failure responding to request")
		return
	}
	if result.dbrl.hasNextLink() && result.dbrl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetDeleteProtectedItemRequestsObjectsPreparer prepares the GetDeleteProtectedItemRequestsObjects request.
func (client ResourceGuardsClient) GetDeleteProtectedItemRequestsObjectsPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteProtectedItemRequests", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDeleteProtectedItemRequestsObjectsSender sends the GetDeleteProtectedItemRequestsObjects request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetDeleteProtectedItemRequestsObjectsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDeleteProtectedItemRequestsObjectsResponder handles the response to the GetDeleteProtectedItemRequestsObjects request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetDeleteProtectedItemRequestsObjectsResponder(resp *http.Response) (result DppBaseResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getDeleteProtectedItemRequestsObjectsNextResults retrieves the next set of results, if any.
func (client ResourceGuardsClient) getDeleteProtectedItemRequestsObjectsNextResults(ctx context.Context, lastResults DppBaseResourceList) (result DppBaseResourceList, err error) {
	req, err := lastResults.dppBaseResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getDeleteProtectedItemRequestsObjectsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetDeleteProtectedItemRequestsObjectsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getDeleteProtectedItemRequestsObjectsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetDeleteProtectedItemRequestsObjectsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getDeleteProtectedItemRequestsObjectsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetDeleteProtectedItemRequestsObjectsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ResourceGuardsClient) GetDeleteProtectedItemRequestsObjectsComplete(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result DppBaseResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetDeleteProtectedItemRequestsObjects")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetDeleteProtectedItemRequestsObjects(ctx, resourceGroupName, resourceGuardsName)
	return
}

// GetDeleteResourceGuardProxyRequestsObjects sends the get delete resource guard proxy requests objects request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
func (client ResourceGuardsClient) GetDeleteResourceGuardProxyRequestsObjects(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result DppBaseResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetDeleteResourceGuardProxyRequestsObjects")
		defer func() {
			sc := -1
			if result.dbrl.Response.Response != nil {
				sc = result.dbrl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getDeleteResourceGuardProxyRequestsObjectsNextResults
	req, err := client.GetDeleteResourceGuardProxyRequestsObjectsPreparer(ctx, resourceGroupName, resourceGuardsName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDeleteResourceGuardProxyRequestsObjects", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDeleteResourceGuardProxyRequestsObjectsSender(req)
	if err != nil {
		result.dbrl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDeleteResourceGuardProxyRequestsObjects", resp, "Failure sending request")
		return
	}

	result.dbrl, err = client.GetDeleteResourceGuardProxyRequestsObjectsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDeleteResourceGuardProxyRequestsObjects", resp, "Failure responding to request")
		return
	}
	if result.dbrl.hasNextLink() && result.dbrl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetDeleteResourceGuardProxyRequestsObjectsPreparer prepares the GetDeleteResourceGuardProxyRequestsObjects request.
func (client ResourceGuardsClient) GetDeleteResourceGuardProxyRequestsObjectsPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/deleteResourceGuardProxyRequests", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDeleteResourceGuardProxyRequestsObjectsSender sends the GetDeleteResourceGuardProxyRequestsObjects request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetDeleteResourceGuardProxyRequestsObjectsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDeleteResourceGuardProxyRequestsObjectsResponder handles the response to the GetDeleteResourceGuardProxyRequestsObjects request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetDeleteResourceGuardProxyRequestsObjectsResponder(resp *http.Response) (result DppBaseResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getDeleteResourceGuardProxyRequestsObjectsNextResults retrieves the next set of results, if any.
func (client ResourceGuardsClient) getDeleteResourceGuardProxyRequestsObjectsNextResults(ctx context.Context, lastResults DppBaseResourceList) (result DppBaseResourceList, err error) {
	req, err := lastResults.dppBaseResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getDeleteResourceGuardProxyRequestsObjectsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetDeleteResourceGuardProxyRequestsObjectsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getDeleteResourceGuardProxyRequestsObjectsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetDeleteResourceGuardProxyRequestsObjectsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getDeleteResourceGuardProxyRequestsObjectsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetDeleteResourceGuardProxyRequestsObjectsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ResourceGuardsClient) GetDeleteResourceGuardProxyRequestsObjectsComplete(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result DppBaseResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetDeleteResourceGuardProxyRequestsObjects")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetDeleteResourceGuardProxyRequestsObjects(ctx, resourceGroupName, resourceGuardsName)
	return
}

// GetDisableSoftDeleteRequestsObjects sends the get disable soft delete requests objects request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
func (client ResourceGuardsClient) GetDisableSoftDeleteRequestsObjects(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result DppBaseResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetDisableSoftDeleteRequestsObjects")
		defer func() {
			sc := -1
			if result.dbrl.Response.Response != nil {
				sc = result.dbrl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getDisableSoftDeleteRequestsObjectsNextResults
	req, err := client.GetDisableSoftDeleteRequestsObjectsPreparer(ctx, resourceGroupName, resourceGuardsName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDisableSoftDeleteRequestsObjects", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDisableSoftDeleteRequestsObjectsSender(req)
	if err != nil {
		result.dbrl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDisableSoftDeleteRequestsObjects", resp, "Failure sending request")
		return
	}

	result.dbrl, err = client.GetDisableSoftDeleteRequestsObjectsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetDisableSoftDeleteRequestsObjects", resp, "Failure responding to request")
		return
	}
	if result.dbrl.hasNextLink() && result.dbrl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetDisableSoftDeleteRequestsObjectsPreparer prepares the GetDisableSoftDeleteRequestsObjects request.
func (client ResourceGuardsClient) GetDisableSoftDeleteRequestsObjectsPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/disableSoftDeleteRequests", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDisableSoftDeleteRequestsObjectsSender sends the GetDisableSoftDeleteRequestsObjects request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetDisableSoftDeleteRequestsObjectsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetDisableSoftDeleteRequestsObjectsResponder handles the response to the GetDisableSoftDeleteRequestsObjects request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetDisableSoftDeleteRequestsObjectsResponder(resp *http.Response) (result DppBaseResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getDisableSoftDeleteRequestsObjectsNextResults retrieves the next set of results, if any.
func (client ResourceGuardsClient) getDisableSoftDeleteRequestsObjectsNextResults(ctx context.Context, lastResults DppBaseResourceList) (result DppBaseResourceList, err error) {
	req, err := lastResults.dppBaseResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getDisableSoftDeleteRequestsObjectsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetDisableSoftDeleteRequestsObjectsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getDisableSoftDeleteRequestsObjectsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetDisableSoftDeleteRequestsObjectsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getDisableSoftDeleteRequestsObjectsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetDisableSoftDeleteRequestsObjectsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ResourceGuardsClient) GetDisableSoftDeleteRequestsObjectsComplete(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result DppBaseResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetDisableSoftDeleteRequestsObjects")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetDisableSoftDeleteRequestsObjects(ctx, resourceGroupName, resourceGuardsName)
	return
}

// GetResourcesInResourceGroup sends the get resources in resource group request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
func (client ResourceGuardsClient) GetResourcesInResourceGroup(ctx context.Context, resourceGroupName string) (result ResourceGuardResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetResourcesInResourceGroup")
		defer func() {
			sc := -1
			if result.rgrl.Response.Response != nil {
				sc = result.rgrl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getResourcesInResourceGroupNextResults
	req, err := client.GetResourcesInResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetResourcesInResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetResourcesInResourceGroupSender(req)
	if err != nil {
		result.rgrl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetResourcesInResourceGroup", resp, "Failure sending request")
		return
	}

	result.rgrl, err = client.GetResourcesInResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetResourcesInResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.rgrl.hasNextLink() && result.rgrl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetResourcesInResourceGroupPreparer prepares the GetResourcesInResourceGroup request.
func (client ResourceGuardsClient) GetResourcesInResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetResourcesInResourceGroupSender sends the GetResourcesInResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetResourcesInResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResourcesInResourceGroupResponder handles the response to the GetResourcesInResourceGroup request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetResourcesInResourceGroupResponder(resp *http.Response) (result ResourceGuardResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getResourcesInResourceGroupNextResults retrieves the next set of results, if any.
func (client ResourceGuardsClient) getResourcesInResourceGroupNextResults(ctx context.Context, lastResults ResourceGuardResourceList) (result ResourceGuardResourceList, err error) {
	req, err := lastResults.resourceGuardResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getResourcesInResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetResourcesInResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getResourcesInResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetResourcesInResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getResourcesInResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetResourcesInResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client ResourceGuardsClient) GetResourcesInResourceGroupComplete(ctx context.Context, resourceGroupName string) (result ResourceGuardResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetResourcesInResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetResourcesInResourceGroup(ctx, resourceGroupName)
	return
}

// GetResourcesInSubscription sends the get resources in subscription request.
func (client ResourceGuardsClient) GetResourcesInSubscription(ctx context.Context) (result ResourceGuardResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetResourcesInSubscription")
		defer func() {
			sc := -1
			if result.rgrl.Response.Response != nil {
				sc = result.rgrl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getResourcesInSubscriptionNextResults
	req, err := client.GetResourcesInSubscriptionPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetResourcesInSubscription", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetResourcesInSubscriptionSender(req)
	if err != nil {
		result.rgrl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetResourcesInSubscription", resp, "Failure sending request")
		return
	}

	result.rgrl, err = client.GetResourcesInSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetResourcesInSubscription", resp, "Failure responding to request")
		return
	}
	if result.rgrl.hasNextLink() && result.rgrl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetResourcesInSubscriptionPreparer prepares the GetResourcesInSubscription request.
func (client ResourceGuardsClient) GetResourcesInSubscriptionPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.DataProtection/resourceGuards", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetResourcesInSubscriptionSender sends the GetResourcesInSubscription request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetResourcesInSubscriptionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResourcesInSubscriptionResponder handles the response to the GetResourcesInSubscription request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetResourcesInSubscriptionResponder(resp *http.Response) (result ResourceGuardResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getResourcesInSubscriptionNextResults retrieves the next set of results, if any.
func (client ResourceGuardsClient) getResourcesInSubscriptionNextResults(ctx context.Context, lastResults ResourceGuardResourceList) (result ResourceGuardResourceList, err error) {
	req, err := lastResults.resourceGuardResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getResourcesInSubscriptionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetResourcesInSubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getResourcesInSubscriptionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetResourcesInSubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getResourcesInSubscriptionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetResourcesInSubscriptionComplete enumerates all values, automatically crossing page boundaries as required.
func (client ResourceGuardsClient) GetResourcesInSubscriptionComplete(ctx context.Context) (result ResourceGuardResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetResourcesInSubscription")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetResourcesInSubscription(ctx)
	return
}

// GetUpdateProtectedItemRequestsObjects sends the get update protected item requests objects request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
func (client ResourceGuardsClient) GetUpdateProtectedItemRequestsObjects(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result DppBaseResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetUpdateProtectedItemRequestsObjects")
		defer func() {
			sc := -1
			if result.dbrl.Response.Response != nil {
				sc = result.dbrl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getUpdateProtectedItemRequestsObjectsNextResults
	req, err := client.GetUpdateProtectedItemRequestsObjectsPreparer(ctx, resourceGroupName, resourceGuardsName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetUpdateProtectedItemRequestsObjects", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetUpdateProtectedItemRequestsObjectsSender(req)
	if err != nil {
		result.dbrl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetUpdateProtectedItemRequestsObjects", resp, "Failure sending request")
		return
	}

	result.dbrl, err = client.GetUpdateProtectedItemRequestsObjectsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetUpdateProtectedItemRequestsObjects", resp, "Failure responding to request")
		return
	}
	if result.dbrl.hasNextLink() && result.dbrl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetUpdateProtectedItemRequestsObjectsPreparer prepares the GetUpdateProtectedItemRequestsObjects request.
func (client ResourceGuardsClient) GetUpdateProtectedItemRequestsObjectsPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectedItemRequests", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetUpdateProtectedItemRequestsObjectsSender sends the GetUpdateProtectedItemRequestsObjects request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetUpdateProtectedItemRequestsObjectsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetUpdateProtectedItemRequestsObjectsResponder handles the response to the GetUpdateProtectedItemRequestsObjects request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetUpdateProtectedItemRequestsObjectsResponder(resp *http.Response) (result DppBaseResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getUpdateProtectedItemRequestsObjectsNextResults retrieves the next set of results, if any.
func (client ResourceGuardsClient) getUpdateProtectedItemRequestsObjectsNextResults(ctx context.Context, lastResults DppBaseResourceList) (result DppBaseResourceList, err error) {
	req, err := lastResults.dppBaseResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getUpdateProtectedItemRequestsObjectsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetUpdateProtectedItemRequestsObjectsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getUpdateProtectedItemRequestsObjectsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetUpdateProtectedItemRequestsObjectsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getUpdateProtectedItemRequestsObjectsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetUpdateProtectedItemRequestsObjectsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ResourceGuardsClient) GetUpdateProtectedItemRequestsObjectsComplete(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result DppBaseResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetUpdateProtectedItemRequestsObjects")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetUpdateProtectedItemRequestsObjects(ctx, resourceGroupName, resourceGuardsName)
	return
}

// GetUpdateProtectionPolicyRequestsObjects sends the get update protection policy requests objects request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
func (client ResourceGuardsClient) GetUpdateProtectionPolicyRequestsObjects(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result DppBaseResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetUpdateProtectionPolicyRequestsObjects")
		defer func() {
			sc := -1
			if result.dbrl.Response.Response != nil {
				sc = result.dbrl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getUpdateProtectionPolicyRequestsObjectsNextResults
	req, err := client.GetUpdateProtectionPolicyRequestsObjectsPreparer(ctx, resourceGroupName, resourceGuardsName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetUpdateProtectionPolicyRequestsObjects", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetUpdateProtectionPolicyRequestsObjectsSender(req)
	if err != nil {
		result.dbrl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetUpdateProtectionPolicyRequestsObjects", resp, "Failure sending request")
		return
	}

	result.dbrl, err = client.GetUpdateProtectionPolicyRequestsObjectsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "GetUpdateProtectionPolicyRequestsObjects", resp, "Failure responding to request")
		return
	}
	if result.dbrl.hasNextLink() && result.dbrl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetUpdateProtectionPolicyRequestsObjectsPreparer prepares the GetUpdateProtectionPolicyRequestsObjects request.
func (client ResourceGuardsClient) GetUpdateProtectionPolicyRequestsObjectsPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}/updateProtectionPolicyRequests", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetUpdateProtectionPolicyRequestsObjectsSender sends the GetUpdateProtectionPolicyRequestsObjects request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) GetUpdateProtectionPolicyRequestsObjectsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetUpdateProtectionPolicyRequestsObjectsResponder handles the response to the GetUpdateProtectionPolicyRequestsObjects request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) GetUpdateProtectionPolicyRequestsObjectsResponder(resp *http.Response) (result DppBaseResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getUpdateProtectionPolicyRequestsObjectsNextResults retrieves the next set of results, if any.
func (client ResourceGuardsClient) getUpdateProtectionPolicyRequestsObjectsNextResults(ctx context.Context, lastResults DppBaseResourceList) (result DppBaseResourceList, err error) {
	req, err := lastResults.dppBaseResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getUpdateProtectionPolicyRequestsObjectsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetUpdateProtectionPolicyRequestsObjectsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getUpdateProtectionPolicyRequestsObjectsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetUpdateProtectionPolicyRequestsObjectsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "getUpdateProtectionPolicyRequestsObjectsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetUpdateProtectionPolicyRequestsObjectsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ResourceGuardsClient) GetUpdateProtectionPolicyRequestsObjectsComplete(ctx context.Context, resourceGroupName string, resourceGuardsName string) (result DppBaseResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.GetUpdateProtectionPolicyRequestsObjects")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetUpdateProtectionPolicyRequestsObjects(ctx, resourceGroupName, resourceGuardsName)
	return
}

// Patch sends the patch request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
// resourceGuardsName - the name of ResourceGuard
// parameters - request body for operation
func (client ResourceGuardsClient) Patch(ctx context.Context, resourceGroupName string, resourceGuardsName string, parameters PatchResourceRequestInput) (result ResourceGuardResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.Patch")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PatchPreparer(ctx, resourceGroupName, resourceGuardsName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "Patch", nil, "Failure preparing request")
		return
	}

	resp, err := client.PatchSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "Patch", resp, "Failure sending request")
		return
	}

	result, err = client.PatchResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "Patch", resp, "Failure responding to request")
		return
	}

	return
}

// PatchPreparer prepares the Patch request.
func (client ResourceGuardsClient) PatchPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string, parameters PatchResourceRequestInput) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PatchSender sends the Patch request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) PatchSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// PatchResponder handles the response to the Patch request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) PatchResponder(resp *http.Response) (result ResourceGuardResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Put sends the put request.
// Parameters:
// resourceGroupName - the name of the resource group where the backup vault is present.
// resourceGuardsName - the name of ResourceGuard
// parameters - request body for operation
func (client ResourceGuardsClient) Put(ctx context.Context, resourceGroupName string, resourceGuardsName string, parameters ResourceGuardResource) (result ResourceGuardResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardsClient.Put")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PutPreparer(ctx, resourceGroupName, resourceGuardsName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "Put", nil, "Failure preparing request")
		return
	}

	resp, err := client.PutSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "Put", resp, "Failure sending request")
		return
	}

	result, err = client.PutResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "dataprotection.ResourceGuardsClient", "Put", resp, "Failure responding to request")
		return
	}

	return
}

// PutPreparer prepares the Put request.
func (client ResourceGuardsClient) PutPreparer(ctx context.Context, resourceGroupName string, resourceGuardsName string, parameters ResourceGuardResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"resourceGuardsName": autorest.Encode("path", resourceGuardsName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataProtection/resourceGuards/{resourceGuardsName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PutSender sends the Put request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardsClient) PutSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// PutResponder handles the response to the Put request. The method always
// closes the http.Response Body.
func (client ResourceGuardsClient) PutResponder(resp *http.Response) (result ResourceGuardResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
