use super::*;

#[test]
#[rustfmt::skip]
fn test_sub_key_generation() {
    let key: [u8; 16] = [
        0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x04,
        0x00, 0x05, 0x00, 0x06, 0x00, 0x07, 0x00, 0x08,
    ];
    let enc_keys: [u16; 52] = [
        0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007, 0x0008,
        0x0400, 0x0600, 0x0800, 0x0a00, 0x0c00, 0x0e00, 0x1000, 0x0200,
        0x0010, 0x0014, 0x0018, 0x001c, 0x0020, 0x0004, 0x0008, 0x000c,
        0x2800, 0x3000, 0x3800, 0x4000, 0x0800, 0x1000, 0x1800, 0x2000,
        0x0070, 0x0080, 0x0010, 0x0020, 0x0030, 0x0040, 0x0050, 0x0060,
        0x0000, 0x2000, 0x4000, 0x6000, 0x8000, 0xa000, 0xc000, 0xe001,
        0x0080, 0x00c0, 0x0100, 0x0140,
    ];
    let dec_keys: [u16; 52] = [
        0xfe01, 0xff40, 0xff00, 0x659a, 0xc000, 0xe001, 0xfffd, 0x8000,
        0xa000, 0xcccc, 0x0000, 0x2000, 0xa556, 0xffb0, 0xffc0, 0x52ab,
        0x0010, 0x0020, 0x554b, 0xff90, 0xe000, 0xfe01, 0x0800, 0x1000,
        0x332d, 0xc800, 0xd000, 0xfffd, 0x0008, 0x000c, 0x4aab, 0xffe0,
        0xffe4, 0xc001, 0x0010, 0x0014, 0xaa96, 0xf000, 0xf200, 0xff81,
        0x0800, 0x0a00, 0x4925, 0xfc00, 0xfff8, 0x552b, 0x0005, 0x0006,
        0x0001, 0xfffe, 0xfffd, 0xc001,
    ];

    let idea = Idea::new_from_slice(&key).unwrap();

    assert_eq!(&idea.enc_keys[..], &enc_keys[..]);
    assert_eq!(&idea.dec_keys[..], &dec_keys[..]);
}
