#
#  equerybts.textproc.py  --  Text processing class for equerybts
#
#   Copyright (c) 2004 Akinori Hattori, All rights reserved.
#
#   Permission is hereby granted, free of charge, to any person obtaining a
#   copy of this software and associated documentation files (the "Software"),
#   to deal in the Software without restriction, including without limitation
#   the rights to use, copy, modify, merge, publish, distribute, sublicense,
#   and/or sell copies of the Software, and to permit persons to whom
#   the Software is furnished to do so, subject to the following conditions:
#
#   The above copyright notice and this permission notice shall be included in
#   all copies or substantial portions of the Software.
#
#   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
#   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
#   THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
#   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
#   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
#   OTHER DEALINGS IN THE SOFTWARE.
#
#  $Id: textproc.py 77 2004-01-29 14:29:31Z hattya $
#

class TextProc:

    def __init__(self):
        pass

    def join_aa_list(self, text):
        ret = ''

        if type(text) is str:
            ret = text

        else:
            if len(text) < 2:
                ret = text[0]

            else:
                tmp = ''

                for t in text[:len(text) - 1]:
                    tmp += t + ' '

                ret = tmp + text[len(text) - 1]

        return ret

    def wrap_text(self, width, indent, text):
        ret = ''
        tab = stab = ' ' * indent
        width -= indent

        if len(text) > width:
            for l in text.split('\n'):
                if l:
                    # string
                    if len(l) > width:
                        tmp = ''

                        for w in l.split(' '):
                            if len(tmp + w) < width:
                                tmp += w.strip() + ' '

                            else:
                                ret += tab + tmp + '\n'
                                tmp = ''
                                tmp += w + ' '

                        ret += stab + tmp + '\n'

                    else:
                        ret += tab + l + '\n'

                else:
                    # newline
                    ret += '\n'

        else:
            for t in text.split('\n'):
                ret += tab + t + '\n'

        return ret

    def abbreviate_text(self, width, text):
        ret = text

        if width - len(text) < 0:
            ret = text[:width - 3].rstrip()

            if len(ret) < width:
                dots = width - len(ret)
                ret += "." * dots

        return ret
