#
#  equerybts.querybts.py  --  Query bts classes for equerybts
#
#   Copyright (c) 2004 Akinori Hattori, All rights reserved.
#
#   Permission is hereby granted, free of charge, to any person obtaining a
#   copy of this software and associated documentation files (the "Software"),
#   to deal in the Software without restriction, including without limitation
#   the rights to use, copy, modify, merge, publish, distribute, sublicense,
#   and/or sell copies of the Software, and to permit persons to whom
#   the Software is furnished to do so, subject to the following conditions:
#
#   The above copyright notice and this permission notice shall be included in
#   all copies or substantial portions of the Software.
#
#   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
#   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
#   THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
#   OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
#   ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
#   OTHER DEALINGS IN THE SOFTWARE.
#
#  $Id: querybts.py 85 2004-03-03 16:03:14Z hattya $
#

import urllib
import parser.bugs as eparser

import exceptions as eexcept


class QueryBTS:

    def __init__(self, urlopener):
        self.bts    = 'http://bugs.gentoo.org/'
        self.number = self.bts + 'long_list.cgi'
        self.attach = self.bts + 'attachment.cgi'
        self.string = self.bts + 'buglist.cgi'
        urllib._urlopener = urlopener

    def from_number(self, number):
        params = urllib.urlencode({'buglist': number})

        try:
            bug = urllib.urlopen(self.number, params).read()

        except IOError:
            raise eexcept.URLOpenError, ('number', number)

        try:
            mparser = eparser.BugsParser()
            mparser.feed(bug)
            mparser.close()

        except:
            raise eexcept.BugParserError, ('', 'BugsParser')

        return mparser.fields, \
               mparser.comments, \
               mparser.links

    def from_attachment_id(self, number):
        params = urllib.urlencode({'id': number, 'action': 'view'})

        try:
            attach = urllib.urlopen(self.attach, params)

        except IOError:
            raise eexcept.URLOpenError, ('attachment', number)

        ctype = attach.info().getheader('Content-Type').split(';')
        csize = attach.info().getheader('Content-length')
        mime  = ctype[0]
        name  = ctype[1].split('=')[1].strip('"')

        return attach.read(), mime, name, csize

    def from_string(self, strings):
        buglist_index = {}
        params = ''
        query_opt = ['query_format=',
                     'short_desc_type=allwordssubstr',
                     'long_desc_type=allwordssubstr',
                     'bug_file_loc_type=allwordssubstr',
                     'bug_file_loc=',
                     'keywords_type=allwords',
                     'keywords=',
                     'bug_status=UNCONFIRMED',
                     'bug_status=NEW',
                     'bug_status=ASSIGNED',
                     'bug_status=REOPENED',
#                     'bug_status=RESOLVED',
                     'bug_status=VERIFIED',
#                     'bug_status=CLOSED',
                     'emailassigned_to1=1',
                     'emailtype1=substring',
                     'email1=',
                     'emailassigned_to2=1',
                     'emailreporter2=1',
                     'emailcc2=1',
                     'emailtype2=substring',
                     'email2=',
                     'bugidtype=include',
                     'bug_id=',
                     'changedin=',
                     'chfieldfrom=',
                     'chfieldto=Now',
                     'chfieldvalue=',
                     'field0-0-0=noop',
                     'type0-0-0=noop',
                     'value0-0-0=',
                     'ctype=csv']

        if len(strings) > 1:
            space = ' '
            short_desc = space.join(strings)
            query_opt.insert(4, 'long_desc=%s' % strings[0])

        else:
            short_desc = strings[0]
            query_opt.insert(4, 'long_desc=')

        query_opt.insert(2, 'short_desc=%s' % short_desc)

        for opt in query_opt:
            key, val = opt.split('=')
            params = params + urllib.urlencode({key: val}) + '&'

        params = params.rstrip('&')

        try:
            buglist = urllib.urlopen(self.string, params)

        except IOError:
            raise eexcept.URLOpenError, ('string', short_desc)

        buglist_tmp = []
        count = [0, 0]
        for line in buglist.readlines():
            count[0] += 1
            count[1] = 0

            columns = line.strip().split(',')

            if len(columns) > 9:
                tmp = columns[7]

                for s in columns[8:len(columns) - 1]:
                    tmp += ',' + s

                del columns[7:len(columns) - 1]
                columns.insert(len(columns) - 1, tmp)

            for column in columns[:len(columns) - 1]:
                column = column.strip('"')

                if count[0] == 1:
                    buglist_tmp.append([column])

                else:
                    buglist_tmp[count[1]].append(column)

                count[1] += 1

        for c in range(0, len(buglist_tmp)):
            buglist_index.update({buglist_tmp[c][0]: buglist_tmp[c][1:]})

        return buglist_index


class eQueryBTSURLopener(urllib.FancyURLopener):

    def __init__(self, pn, pv, *args):
        self.version = '%s/%s' % (pn, pv)
        urllib.FancyURLopener.__init__(self, *args)
