% Generated by roxygen2 (4.0.2): do not edit by hand
\name{html_fragment}
\alias{html_fragment}
\title{Convert to an HTML fragment.}
\usage{
html_fragment(number_sections = FALSE, fig_width = 7, fig_height = 5,
  fig_retina = if (!fig_caption) 2, fig_caption = FALSE, smart = TRUE,
  keep_md = FALSE, pandoc_args = NULL, ...)
}
\arguments{
\item{number_sections}{\code{TRUE} to number section headings}

\item{fig_width}{Default width (in inches) for figures}

\item{fig_height}{Default width (in inches) for figures}

\item{fig_retina}{Scaling to perform for retina displays (defaults to 2 when
\code{fig_caption} is \code{FALSE}, which currently works for all widely
used retina displays). Set to \code{NULL} to prevent retina scaling. Note
that this will always be \code{NULL} when \code{keep_md} is specified (this
is because \code{fig_retina} relies on outputting HTML directly into the
markdown document).}

\item{fig_caption}{\code{TRUE} to render figures with captions}

\item{smart}{Produce typographically correct output, converting straight
quotes to curly quotes, --- to em-dashes, -- to en-dashes, and ... to
ellipses.}

\item{keep_md}{Keep the markdown file generated by knitting.}

\item{pandoc_args}{Additional command line options to pass to pandoc}

\item{...}{Additional function arguments to pass to the base R Markdown HTML
  output formatter}
}
\value{
R Markdown output format to pass to \code{\link{render}}
}
\description{
An html fragment is suitable for inclusion into an external html paage.
See \code{\link{html_document}} for full details - this is a minor variation
that assumes you will include the output into an existing document (e.g.
a blog post).
}

