/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.element;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.omemo.element.OmemoKeyElement;

public abstract class OmemoHeaderElement
implements XmlElement {
    public static final String ELEMENT = "header";
    public static final String NAMESPACE = "eu.siacs.conversations.axolotl";
    public static final String ATTR_SID = "sid";
    public static final String ATTR_IV = "iv";
    private final int sid;
    private final List<OmemoKeyElement> keys;
    private final byte[] iv;

    public OmemoHeaderElement(int sid, List<OmemoKeyElement> keys, byte[] iv) {
        this.sid = sid;
        this.keys = keys;
        this.iv = iv;
    }

    public int getSid() {
        return this.sid;
    }

    public List<OmemoKeyElement> getKeys() {
        return new ArrayList<OmemoKeyElement>(this.keys);
    }

    public byte[] getIv() {
        return this.iv != null ? (byte[])this.iv.clone() : null;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingXmlEnvironment) {
        XmlStringBuilder sb = new XmlStringBuilder(this, enclosingXmlEnvironment);
        sb.attribute(ATTR_SID, this.getSid()).rightAngleBracket();
        for (OmemoKeyElement k : this.getKeys()) {
            sb.append(k);
        }
        sb.openElement(ATTR_IV).append(Base64.encodeToString(this.getIv())).closeElement(ATTR_IV);
        return sb.closeElement(this);
    }
}

